/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.File;
import tlc2.util.IntStack;
import util.Assert;
import util.BufferedDataInputStream;
import util.BufferedDataOutputStream;
import util.FileUtil;

public class SynchronousDiskIntStack
implements IntStack {
    public static final int BufSize = 0x800000;
    private static final int BufSizeMax = 0x10000000;
    private final int bufSize;
    private final String filePrefix;
    private long size = 0L;
    private int index = 0;
    private int hiPool = 0;
    private int[] buf;

    public SynchronousDiskIntStack(String diskdir, String name) {
        this(diskdir, name, 0x800000);
    }

    public SynchronousDiskIntStack(String diskdir, String name, int capacity) {
        capacity = Math.min(0x10000000, capacity);
        this.filePrefix = diskdir + FileUtil.separator + name;
        this.bufSize = capacity;
        this.buf = new int[capacity];
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void pushInt(int x) {
        if (this.index == this.bufSize) {
            try {
                File poolFile = new File(this.filePrefix + Integer.toString(this.hiPool));
                poolFile.deleteOnExit();
                BufferedDataOutputStream bdos = FileUtil.newBdFOS(false, poolFile);
                int len = this.buf.length;
                int i = 0;
                while (i < len) {
                    bdos.writeInt(this.buf[i]);
                    ++i;
                }
                bdos.close();
                ++this.hiPool;
                this.index = 0;
            }
            catch (Exception e) {
                Assert.fail(2175, new String[]{"stack", e.getMessage()});
            }
        }
        this.buf[this.index++] = x;
        ++this.size;
    }

    @Override
    public void pushLong(long x) {
        this.pushInt((int)(x & 0xFFFFFFFFL));
        this.pushInt((int)(x >>> 32));
    }

    @Override
    public int popInt() {
        if (this.index == 0 && this.hasPool()) {
            try {
                File poolFile = new File(this.filePrefix + Integer.toString(this.hiPool - 1));
                BufferedDataInputStream bdis = FileUtil.newBdFIS(false, poolFile);
                int len = this.buf.length;
                int i = 0;
                while (i < len) {
                    this.buf[i] = bdis.readInt();
                    ++i;
                }
                bdis.close();
                --this.hiPool;
                this.index = len;
            }
            catch (Exception e) {
                Assert.fail(2175, new String[]{"stack", e.getMessage()});
            }
        }
        --this.size;
        return this.buf[--this.index];
    }

    private boolean hasPool() {
        return this.hiPool >= 0;
    }

    @Override
    public long popLong() {
        long high = this.popInt();
        long low = this.popInt();
        return high << 32 | low & 0xFFFFFFFFL;
    }

    @Override
    public void reset() {
        this.size = 0L;
        this.index = 0;
        this.hiPool = 0;
    }
}

