/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import java.io.IOException;
import tlc2.TLCGlobals;
import tlc2.tool.FingerprintException;
import tlc2.tool.coverage.CostModel;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.IValueOutputStream;
import tlc2.value.Values;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.EnumerableValue;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;
import tlc2.value.impl.ValueExcept;
import tlc2.value.impl.ValueVec;
import util.Assert;

public class SetOfTuplesValue
extends EnumerableValue
implements Enumerable {
    public final Value[] sets;
    protected SetEnumValue tupleSet;

    public SetOfTuplesValue(Value[] sets) {
        this.sets = sets;
        this.tupleSet = null;
    }

    public SetOfTuplesValue(Value[] set, CostModel cm) {
        this(set);
        this.cm = cm;
    }

    public SetOfTuplesValue(Value val) {
        this(new Value[1]);
        this.sets[0] = val;
    }

    public SetOfTuplesValue(Value v1, Value v2) {
        this(new Value[2]);
        this.sets[0] = v1;
        this.sets[1] = v2;
    }

    @Override
    public final byte getKind() {
        return 15;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            this.convertAndCache();
            return this.tupleSet.compareTo(obj);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean equals(Object obj) {
        try {
            if (!(obj instanceof SetOfTuplesValue)) {
                this.convertAndCache();
                return this.tupleSet.equals(obj);
            }
            SetOfTuplesValue tvs = (SetOfTuplesValue)obj;
            boolean isEmpty1 = this.isEmpty();
            if (isEmpty1) {
                return tvs.isEmpty();
            }
            if (tvs.isEmpty()) {
                return isEmpty1;
            }
            if (this.sets.length != tvs.sets.length) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= this.sets.length) {
                    return true;
                }
                if (!this.sets[i].equals(tvs.sets[i])) {
                    return false;
                }
                ++i;
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean member(Value elem) {
        try {
            TupleValue tv = (TupleValue)elem.toTuple();
            if (tv == null) {
                FcnRcdValue fcn = (FcnRcdValue)elem.toFcnRcd();
                if (fcn == null) {
                    if (elem instanceof ModelValue) {
                        return ((ModelValue)elem).modelValueMember(this);
                    }
                    Assert.fail("Attempted to check if non-tuple\n" + Values.ppr(elem.toString()) + "\nis in the set of tuples:\n" + Values.ppr(this.toString()), this.getSource());
                }
                if (fcn.intv != null) {
                    return false;
                }
                int i = 0;
                while (i < fcn.domain.length) {
                    if (!(fcn.domain[i] instanceof IntValue)) {
                        Assert.fail("Attempted to check if non-tuple\n" + Values.ppr(elem.toString()) + "\nis in the set of tuples:\n" + Values.ppr(this.toString()), this.getSource());
                    }
                    ++i;
                }
                return false;
            }
            if (tv.elems.length == this.sets.length) {
                int i = 0;
                while (i < this.sets.length) {
                    if (!this.sets[i].member(tv.elems[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean isFinite() {
        try {
            int i = 0;
            while (true) {
                if (i >= this.sets.length) {
                    return true;
                }
                if (!this.sets[i].isFinite()) {
                    return false;
                }
                ++i;
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            if (ex.idx < ex.path.length) {
                Assert.fail("Attempted to apply EXCEPT construct to the set of tuples:\n" + Values.ppr(this.toString()), this.getSource());
            }
            return ex.value;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            if (exs.length != 0) {
                Assert.fail("Attempted to apply EXCEPT construct to the set of tuples:\n" + Values.ppr(this.toString()), this.getSource());
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            long sz = 1L;
            int i = 0;
            while (i < this.sets.length) {
                if ((sz *= (long)this.sets[i].size()) < Integer.MIN_VALUE || sz > Integer.MAX_VALUE) {
                    Assert.fail("Overflow when computing the number of elements in " + Values.ppr(this.toString()), this.getSource());
                }
                ++i;
            }
            return (int)sz;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean isNormalized() {
        try {
            if (this.tupleSet != null && this.tupleSet != SetEnumValue.DummyEnum) {
                return this.tupleSet.isNormalized();
            }
            int i = 0;
            while (true) {
                if (i >= this.sets.length) {
                    return true;
                }
                if (!this.sets[i].isNormalized()) {
                    return false;
                }
                ++i;
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value normalize() {
        try {
            if (this.tupleSet == null || this.tupleSet == SetEnumValue.DummyEnum) {
                int i = 0;
                while (i < this.sets.length) {
                    this.sets[i].normalize();
                    ++i;
                }
            } else {
                this.tupleSet.normalize();
            }
            return this;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final void deepNormalize() {
        try {
            int i = 0;
            while (i < this.sets.length) {
                this.sets[i].deepNormalize();
                ++i;
            }
            if (this.tupleSet == null) {
                this.tupleSet = SetEnumValue.DummyEnum;
            } else if (this.tupleSet != SetEnumValue.DummyEnum) {
                this.tupleSet.deepNormalize();
            }
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        try {
            boolean defined = true;
            int i = 0;
            while (i < this.sets.length) {
                defined = defined && this.sets[i].isDefined();
                ++i;
            }
            return defined;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue deepCopy() {
        return this;
    }

    @Override
    public final long fingerPrint(long fp) {
        try {
            this.convertAndCache();
            return this.tupleSet.fingerPrint(fp);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue permute(IMVPerm perm) {
        try {
            this.convertAndCache();
            return this.tupleSet.permute(perm);
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    private final void convertAndCache() {
        if (this.tupleSet == null) {
            this.tupleSet = (SetEnumValue)this.toSetEnum();
        } else if (this.tupleSet == SetEnumValue.DummyEnum) {
            SetEnumValue val = (SetEnumValue)this.toSetEnum();
            val.deepNormalize();
            this.tupleSet = val;
        }
    }

    @Override
    public final Value toSetEnum() {
        Value elem;
        if (this.tupleSet != null && this.tupleSet != SetEnumValue.DummyEnum) {
            return this.tupleSet;
        }
        ValueVec vals = new ValueVec();
        ValueEnumeration Enum2 = this.elements();
        while ((elem = Enum2.nextElement()) != null) {
            vals.addElement(elem);
        }
        if (coverage) {
            this.cm.incSecondary(vals.size());
        }
        return new SetEnumValue(vals, this.isNormalized(), this.cm);
    }

    @Override
    public final void write(IValueOutputStream vos) throws IOException {
        this.tupleSet.write(vos);
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            boolean unlazy = TLCGlobals.expand;
            try {
                if (unlazy) {
                    long sz = 1L;
                    int i = 0;
                    while (i < this.sets.length) {
                        if ((sz *= (long)this.sets[i].size()) < Integer.MIN_VALUE || sz > Integer.MAX_VALUE) {
                            unlazy = false;
                            break;
                        }
                        ++i;
                    }
                    unlazy = sz < (long)TLCGlobals.enumBound;
                }
            }
            catch (Throwable e) {
                if (swallow) {
                    unlazy = false;
                }
                throw e;
            }
            if (unlazy) {
                Value val = this.toSetEnum();
                return val.toString(sb, offset, swallow);
            }
            if (this.sets.length > 0) {
                sb.append("(");
                this.sets[0].toString(sb, offset, swallow);
            }
            int i = 1;
            while (i < this.sets.length) {
                sb.append(" \\X ");
                this.sets[i].toString(sb, offset, swallow);
                ++i;
            }
            if (this.sets.length > 0) {
                sb.append(")");
            }
            return sb;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final ValueEnumeration elements() {
        try {
            if (this.tupleSet == null || this.tupleSet == SetEnumValue.DummyEnum) {
                return new Enumerator();
            }
            return this.tupleSet.elements();
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    final class Enumerator
    implements ValueEnumeration {
        private ValueEnumeration[] enums;
        private Value[] currentElems;
        private boolean isDone;

        public Enumerator() {
            this.enums = new ValueEnumeration[SetOfTuplesValue.this.sets.length];
            this.currentElems = new Value[SetOfTuplesValue.this.sets.length];
            this.isDone = false;
            int i = 0;
            while (i < SetOfTuplesValue.this.sets.length) {
                if (SetOfTuplesValue.this.sets[i] instanceof Enumerable) {
                    this.enums[i] = ((Enumerable)((Object)SetOfTuplesValue.this.sets[i])).elements();
                    this.currentElems[i] = this.enums[i].nextElement();
                    if (this.currentElems[i] == null) {
                        this.enums = null;
                        this.isDone = true;
                        break;
                    }
                } else {
                    Assert.fail("Attempted to enumerate a set of the form s1 \\X s2 ... \\X sn,\nbut can't enumerate s" + i + ":\n" + Values.ppr(SetOfTuplesValue.this.sets[i].toString()), SetOfTuplesValue.this.getSource());
                }
                ++i;
            }
        }

        @Override
        public final void reset() {
            if (this.enums != null) {
                int i = 0;
                while (i < this.enums.length) {
                    this.enums[i].reset();
                    this.currentElems[i] = this.enums[i].nextElement();
                    ++i;
                }
                this.isDone = false;
            }
        }

        @Override
        public final Value nextElement() {
            if (this.isDone) {
                return null;
            }
            Value[] elems = new Value[this.currentElems.length];
            if (coverage) {
                SetOfTuplesValue.this.cm.incSecondary(elems.length);
            }
            int i = 0;
            while (i < elems.length) {
                elems[i] = this.currentElems[i];
                ++i;
            }
            i = elems.length - 1;
            while (i >= 0) {
                this.currentElems[i] = this.enums[i].nextElement();
                if (this.currentElems[i] != null) break;
                if (i == 0) {
                    this.isDone = true;
                    break;
                }
                this.enums[i].reset();
                this.currentElems[i] = this.enums[i].nextElement();
                --i;
            }
            return new TupleValue(elems, SetOfTuplesValue.this.cm);
        }
    }
}

