/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util;

import java.io.IOException;
import java.io.PrintWriter;
import tla2sany.semantic.SemanticNode;
import tlc2.tool.Action;
import tlc2.tool.TLCState;
import tlc2.util.BitVector;
import tlc2.util.IStateWriter;
import util.FileUtil;

public class StateWriter
implements IStateWriter {
    protected final PrintWriter writer;
    protected int stateNum;
    protected String fname;

    public StateWriter(String fname) throws IOException {
        this.fname = fname;
        this.writer = new PrintWriter(FileUtil.newBFOS(fname));
        this.stateNum = 1;
    }

    @Override
    public String getDumpFileName() {
        return this.fname;
    }

    @Override
    public boolean isNoop() {
        return false;
    }

    @Override
    public boolean isDot() {
        return false;
    }

    @Override
    public synchronized void writeState(TLCState state) {
        this.writer.println("State " + this.stateNum + ":");
        this.writer.println(state.toString());
        ++this.stateNum;
    }

    @Override
    public synchronized void writeState(TLCState state, TLCState successor, short stateFlags) {
        if (!this.isSet(stateFlags, 1)) {
            this.writeState(successor);
        }
    }

    @Override
    public synchronized void writeState(TLCState state, TLCState successor, short stateFlags, Action action) {
        if (!this.isSet(stateFlags, 1)) {
            this.writeState(successor);
        }
    }

    @Override
    public synchronized void writeState(TLCState state, TLCState successor, short stateFlags, Action action, SemanticNode pred) {
        if (!this.isSet(stateFlags, 1)) {
            this.writeState(successor);
        }
    }

    @Override
    public void writeState(TLCState state, TLCState successor, short stateFlags, IStateWriter.Visualization visualization) {
        if (!this.isSet(stateFlags, 1)) {
            this.writeState(successor);
        }
    }

    @Override
    public void close() {
        this.writer.close();
    }

    @Override
    public void writeState(TLCState state, TLCState successor, BitVector actionChecks, int from, int to, short stateFlags) {
        if (!this.isSet(stateFlags, 1)) {
            this.writeState(state);
        }
    }

    @Override
    public void writeState(TLCState state, TLCState successor, BitVector actionChecks, int from, int to, short stateFlags, IStateWriter.Visualization visualization) {
        if (!this.isSet(stateFlags, 1)) {
            this.writeState(state);
        }
    }

    @Override
    public void snapshot() throws IOException {
    }

    @Override
    public boolean isConstrained() {
        return false;
    }
}

