/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import tlc2.tool.ToolGlobals;
import util.UniqueString;

public class BuiltInOPs
implements ToolGlobals {
    private static int[] OpCodeTable = new int[200];

    static {
        BuiltInOPs.put(OP_aa, 50);
        BuiltInOPs.put(OP_bc, 1);
        BuiltInOPs.put(OP_be, 2);
        BuiltInOPs.put(OP_bf, 3);
        BuiltInOPs.put(OP_case, 4);
        BuiltInOPs.put(OP_cp, 5);
        BuiltInOPs.put(OP_cl, 6);
        BuiltInOPs.put(OP_dl, 7);
        BuiltInOPs.put(OP_exc, 8);
        BuiltInOPs.put(OP_fa, 9);
        BuiltInOPs.put(OP_fc, 10);
        BuiltInOPs.put(OP_ite, 11);
        BuiltInOPs.put(OP_nrfs, 12);
        BuiltInOPs.put(OP_pair, 13);
        BuiltInOPs.put(OP_rc, 14);
        BuiltInOPs.put(OP_rs, 15);
        BuiltInOPs.put(OP_rfs, 16);
        BuiltInOPs.put(OP_seq, 17);
        BuiltInOPs.put(OP_sa, 51);
        BuiltInOPs.put(OP_se, 18);
        BuiltInOPs.put(OP_sf, 53);
        BuiltInOPs.put(OP_soa, 19);
        BuiltInOPs.put(OP_sor, 20);
        BuiltInOPs.put(OP_sof, 21);
        BuiltInOPs.put(OP_sso, 22);
        BuiltInOPs.put(OP_tup, 23);
        BuiltInOPs.put(OP_te, 55);
        BuiltInOPs.put(OP_tf, 56);
        BuiltInOPs.put(OP_uc, 24);
        BuiltInOPs.put(OP_ue, 25);
        BuiltInOPs.put(OP_uf, 26);
        BuiltInOPs.put(OP_wf, 54);
        BuiltInOPs.put(OP_lnot, 27);
        BuiltInOPs.put(OP_subset, 29);
        BuiltInOPs.put(OP_union, 30);
        BuiltInOPs.put(OP_domain, 31);
        BuiltInOPs.put(OP_box, 59);
        BuiltInOPs.put(OP_diamond, 60);
        BuiltInOPs.put(OP_enabled, 34);
        BuiltInOPs.put(OP_unchanged, 49);
        BuiltInOPs.put(OP_eq, 35);
        BuiltInOPs.put(OP_land, 36);
        BuiltInOPs.put(OP_lor, 37);
        BuiltInOPs.put(OP_implies, 38);
        BuiltInOPs.put(OP_cdot, 52);
        BuiltInOPs.put(OP_equiv, 39);
        BuiltInOPs.put(OP_leadto, 57);
        BuiltInOPs.put(OP_arrow, 58);
        BuiltInOPs.put(OP_noteq, 40);
        BuiltInOPs.put(OP_subseteq, 41);
        BuiltInOPs.put(OP_in, 42);
        BuiltInOPs.put(OP_notin, 43);
        BuiltInOPs.put(OP_setdiff, 44);
        BuiltInOPs.put(OP_cap, 45);
        BuiltInOPs.put(OP_nop, 46);
        BuiltInOPs.put(OP_cup, 47);
        BuiltInOPs.put(OP_prime, 48);
    }

    private static void put(UniqueString op, int opcode) {
        int loc = op.getTok();
        if (loc >= OpCodeTable.length) {
            int len1 = loc + 20;
            int[] OpCodeTable1 = new int[len1];
            int i = 0;
            while (i < OpCodeTable.length) {
                OpCodeTable1[i] = OpCodeTable[i];
                ++i;
            }
            OpCodeTable = OpCodeTable1;
        }
        BuiltInOPs.OpCodeTable[loc] = opcode;
    }

    public static int getOpCode(UniqueString op) {
        int loc = op.getTok();
        return loc < OpCodeTable.length ? OpCodeTable[loc] : 0;
    }

    public static int getOpCode(int loc) {
        return loc < OpCodeTable.length ? OpCodeTable[loc] : 0;
    }

    public static boolean isTemporal(int opcode) {
        return 53 <= opcode && opcode <= 60;
    }

    public static boolean isAction(int opcode) {
        return 48 <= opcode && opcode <= 52;
    }
}

