/*
 * Decompiled with CFR 0.152.
 */
package tlc2.debug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.debug.Scope;
import org.eclipse.lsp4j.debug.Variable;
import tla2sany.semantic.SemanticNode;
import tlc2.debug.IDebugTarget;
import tlc2.debug.TLCCapabilities;
import tlc2.debug.TLCDebugger;
import tlc2.debug.TLCSourceBreakpoint;
import tlc2.debug.TLCStackFrame;
import tlc2.tool.IStateFunctor;
import tlc2.tool.TLCState;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.value.impl.RecordValue;

public class TLCInitStatesStackFrame
extends TLCStackFrame {
    public static final String SCOPE = "Initials";
    private final transient IStateFunctor functor;
    private final transient Map<Integer, TLCState> idToStateMap = new HashMap<Integer, TLCState>();
    protected final transient int stateId = rnd.nextInt(0x7FFFFFFE) + 1;

    public TLCInitStatesStackFrame(TLCStackFrame parent, SemanticNode pred, Context con, Tool tool, IStateFunctor functor) {
        super(parent, pred, con, tool);
        this.functor = functor;
    }

    protected Set<TLCState> getStates() {
        return this.functor.getStates().toSet();
    }

    @Override
    public Scope[] getScopes() {
        ArrayList<Scope> scopes = new ArrayList<Scope>(Arrays.asList(super.getScopes()));
        Scope scope = new Scope();
        scope.setName(SCOPE);
        scope.setVariablesReference(this.stateId);
        scopes.add(scope);
        return scopes.toArray(new Scope[scopes.size()]);
    }

    @Override
    public boolean handle(TLCDebugger debugger) {
        return debugger.stack.size() == 1;
    }

    @Override
    public void preHalt(TLCDebugger debugger) {
        debugger.sendCapabilities(TLCCapabilities.NO_STEP_BACK);
        debugger.setGranularity(IDebugTarget.Granularity.State);
    }

    @Override
    public void postHalt(TLCDebugger debugger) {
        debugger.sendCapabilities(TLCCapabilities.STEP_BACK);
        debugger.setGranularity(IDebugTarget.Granularity.Formula);
    }

    @Override
    public Variable[] getVariables(int vr) {
        if (vr == this.stateId) {
            return this.tool.eval(() -> {
                TreeSet<TLCState> initials = new TreeSet<TLCState>((s1, s2) -> s1.toString().compareTo(s2.toString()));
                initials.addAll(this.functor.getStates().toSet());
                Variable[] vars = new Variable[initials.size()];
                int width = String.valueOf(initials.size()).length();
                Iterator itr = initials.iterator();
                int i = 0;
                while (i < vars.length) {
                    TLCState t = (TLCState)itr.next();
                    RecordValue r = new RecordValue(t);
                    vars[i] = this.getStateAsVariable(r, t.getLevel() + "." + String.format("%0" + width + "d", i + 1) + ": " + (t.hasAction() ? t.getAction().getLocation() : "<???>"));
                    this.idToStateMap.put(vars[i].getVariablesReference(), t);
                    ++i;
                }
                return vars;
            });
        }
        return super.getVariables(vr);
    }

    @Override
    public synchronized CompletableFuture<Void> gotoState(TLCDebugger debugger, int id) {
        TLCState tlcState = this.idToStateMap.get(id);
        if (tlcState != null) {
            this.functor.setElement(tlcState);
            return super.gotoState(debugger, id);
        }
        return super.gotoState(debugger, id);
    }

    Variable[] getStatesVariables() {
        return this.getVariables(this.stateId);
    }

    @Override
    public boolean matches(TLCSourceBreakpoint bp) {
        if (super.matches(bp)) {
            return this.functor.getStates().toSet().stream().filter(t -> bp.matchesExpression(this.tool, (TLCState)t, TLCState.Empty, this.getContext(), true)).findAny().isPresent();
        }
        return false;
    }
}

