/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.queue;

import java.io.IOException;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.queue.DiskByteArrayQueue;
import tlc2.tool.queue.IStateQueue;

public abstract class ByteArrayQueue
implements IStateQueue {
    protected long len = 0L;
    private int numWaiting = 0;
    private volatile boolean finish = false;
    private boolean stop = false;
    private Object mu = new Object();

    private final byte[] toBytes(TLCState state) {
        try {
            DiskByteArrayQueue.ByteValueOutputStream vos = new DiskByteArrayQueue.ByteValueOutputStream();
            state.write(vos);
            return vos.toByteArray();
        }
        catch (IOException notExpectedToHappen) {
            notExpectedToHappen.printStackTrace();
            return null;
        }
    }

    private final byte[] toBytes(TLCState state, DiskByteArrayQueue.ByteValueOutputStream vos) {
        try {
            state.write(vos);
            return vos.toByteArray();
        }
        catch (IOException notExpectedToHappen) {
            notExpectedToHappen.printStackTrace();
            return null;
        }
    }

    private final TLCState toState(byte[] bytes) {
        try {
            TLCState state = TLCState.Empty.createEmpty();
            state.read(new DiskByteArrayQueue.ByteValueInputStream(bytes));
            return state;
        }
        catch (IOException notExpectedToHappen) {
            notExpectedToHappen.printStackTrace();
            return null;
        }
    }

    @Override
    public final void enqueue(TLCState state) {
        this.enqueue(this.toBytes(state));
    }

    private final void enqueue(byte[] state) {
        this.enqueueInner(state);
        ++this.len;
    }

    @Override
    public final TLCState dequeue() {
        byte[] bytes = this.dequeueRaw();
        if (bytes != null) {
            return this.toState(bytes);
        }
        return null;
    }

    private final byte[] dequeueRaw() {
        if (this.isEmpty()) {
            return null;
        }
        byte[] state = this.dequeueInner();
        --this.len;
        return state;
    }

    @Override
    public final void sEnqueue(TLCState state) {
        this.sEnqueue(this.toBytes(state));
    }

    private final synchronized void sEnqueue(byte[] state) {
        this.enqueueInner(state);
        ++this.len;
        if (this.numWaiting > 0 && !this.stop) {
            this.notifyAll();
        }
    }

    @Override
    public final void sEnqueue(TLCState[] states) {
        byte[][] bytes = new byte[states.length][];
        int i = 0;
        while (i < states.length) {
            bytes[i] = this.toBytes(states[i]);
            ++i;
        }
        this.sEnqueue(bytes);
    }

    private final synchronized void sEnqueue(byte[][] states) {
        int i = 0;
        while (i < states.length) {
            this.enqueueInner(states[i]);
            ++i;
        }
        this.len += (long)states.length;
        if (this.numWaiting > 0 && !this.stop) {
            this.notifyAll();
        }
    }

    @Override
    public final void sEnqueue(StateVec stateVec) {
        this.sEnqueue(stateVec, stateVec.size());
    }

    public final void sEnqueue(StateVec stateVec, int n) {
        if (n == 0) {
            return;
        }
        DiskByteArrayQueue.ByteValueOutputStream vos = new DiskByteArrayQueue.ByteValueOutputStream();
        byte[][] bytes = new byte[n][];
        int i = 0;
        while (i < stateVec.size()) {
            TLCState state = stateVec.elementAt(i);
            if (state != null) {
                bytes[n - 1] = this.toBytes(state, vos);
                --n;
            }
            ++i;
        }
        this.sEnqueue(bytes);
    }

    @Override
    public final TLCState sPeek() {
        byte[] bytes = this.sPeekRaw();
        if (bytes != null) {
            return this.toState(bytes);
        }
        return null;
    }

    private final synchronized byte[] sPeekRaw() {
        if (this.isAvail()) {
            return this.peekInner();
        }
        return null;
    }

    @Override
    public final TLCState sDequeue() {
        byte[] bytes = this.sDequeueRaw();
        if (bytes != null) {
            return this.toState(bytes);
        }
        return null;
    }

    private final synchronized byte[] sDequeueRaw() {
        if (this.isAvail()) {
            byte[] state = this.dequeueInner();
            assert (state != null) : "Null state found on queue";
            --this.len;
            return state;
        }
        return null;
    }

    @Override
    public final TLCState[] sDequeue(int cnt) {
        byte[][] bytes = this.sDequeueRaw(cnt);
        if (bytes != null) {
            TLCState[] array = new TLCState[cnt];
            int i = 0;
            while (i < array.length) {
                array[i] = this.toState(bytes[i]);
                ++i;
            }
            return array;
        }
        return null;
    }

    private final synchronized byte[][] sDequeueRaw(int cnt) {
        assert (cnt > 0) : "Nonpositive number of states requested.";
        if (this.isAvail()) {
            if ((long)cnt > this.len) {
                cnt = (int)this.len;
            }
            byte[][] states = new byte[cnt][];
            int idx = 0;
            while (idx < cnt && this.len > 0L) {
                states[idx] = this.dequeueInner();
                --this.len;
                ++idx;
            }
            if (idx == cnt) {
                return states;
            }
            byte[][] res = new byte[idx][];
            int i = 0;
            while (i < idx) {
                res[i] = states[i];
                ++i;
            }
            return res;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final boolean isAvail() {
        if (!this.finish) ** GOTO lbl24
        return false;
lbl-1000:
        // 1 sources

        {
            ++this.numWaiting;
            if (this.numWaiting >= TLCGlobals.getNumWorkers()) {
                if (this.isEmpty()) {
                    --this.numWaiting;
                    return false;
                }
                var1_1 = this.mu;
                synchronized (var1_1) {
                    this.mu.notify();
                }
            }
            try {
                this.wait();
            }
            catch (Exception e) {
                MP.printError(1000, "making a worker wait for a state from the queue", (Throwable)e);
                System.exit(1);
            }
            --this.numWaiting;
            if (!this.finish) continue;
            return false;
lbl24:
            // 2 sources

            ** while (this.isEmpty() || this.stop)
        }
lbl25:
        // 1 sources

        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void finishAll() {
        this.finish = true;
        this.notifyAll();
        Object object = this.mu;
        synchronized (object) {
            this.mu.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public final boolean suspendAll() {
        needWait = false;
        var2_2 = this;
        synchronized (var2_2) {
            block15: {
                if (!this.finish) break block15;
                return false;
            }
            this.stop = true;
            needWait = this.needsWaiting();
            // MONITOREXIT @DISABLED, blocks:[1, 7] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
            if (true) ** GOTO lbl43
        }
        do {
            var2_2 = this.mu;
            synchronized (var2_2) {
                block16: {
                    if (!this.finish) break block16;
                    return false;
                }
                try {
                    this.mu.wait();
                }
                catch (Exception e) {
                    MP.printError(1000, "waiting for a worker to wake up", (Throwable)e);
                    System.exit(1);
                }
            }
            var2_2 = this;
            synchronized (var2_2) {
                block17: {
                    if (!this.finish) break block17;
                    return false;
                }
                needWait = this.needsWaiting();
            }
lbl43:
            // 2 sources

        } while (needWait);
        return true;
    }

    private boolean needsWaiting() {
        return this.numWaiting < TLCGlobals.getNumWorkers();
    }

    @Override
    public final synchronized void resumeAll() {
        this.stop = false;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeAllStuck() {
        Object object;
        if (this.stop) {
            object = this.mu;
            synchronized (object) {
                this.mu.notifyAll();
            }
        }
        if (!this.stop && !this.isEmpty() && this.numWaiting > 0) {
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }
    }

    @Override
    public final long size() {
        return this.len;
    }

    @Override
    public boolean isEmpty() {
        return this.len < 1L;
    }

    abstract void enqueueInner(byte[] var1);

    abstract byte[] dequeueInner();

    abstract byte[] peekInner();

    @Override
    public abstract void beginChkpt() throws IOException;

    @Override
    public abstract void commitChkpt() throws IOException;

    @Override
    public abstract void recover() throws IOException;
}

