/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import tlc2.tool.liveness.BEGraphNode;
import tlc2.tool.liveness.TBGraph;
import tlc2.tool.liveness.TBGraphNode;

public class BTGraphNode
extends BEGraphNode {
    private int tindex;

    public BTGraphNode(long fp, int index) {
        super(fp);
        this.tindex = index;
    }

    public final int getIndex() {
        return this.tindex & 0x3FFFFFFF;
    }

    public final void setIndex(int index) {
        this.tindex = this.tindex & 0xC0000000 | index;
    }

    public final boolean isDone() {
        return this.tindex < 0;
    }

    public final void setDone() {
        this.tindex |= Integer.MIN_VALUE;
    }

    public static BTGraphNode makeDummy(long fp) {
        return new BTGraphNode(fp, 0x40000000);
    }

    public final boolean isDummy() {
        return (this.tindex & 0x40000000) > 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.stateFP ^ this.stateFP >>> 32);
        result = 31 * result + this.getIndex();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BTGraphNode other = (BTGraphNode)obj;
        if (this.stateFP != other.stateFP) {
            return false;
        }
        return this.getIndex() == other.getIndex();
    }

    @Override
    public final TBGraphNode getTNode(TBGraph tableau) {
        return tableau.getNode(this.getIndex());
    }

    @Override
    public final String nodeInfo() {
        return "<" + this.stateFP + "," + this.getIndex() + ">";
    }

    @Override
    protected final void toString(StringBuffer buf, boolean unseen) {
        if (this.getVisited() == unseen) {
            this.flipVisited();
            buf.append("(" + this.stateFP + "," + this.getIndex() + ") --> ");
            int size = this.nextSize();
            if (size != 0) {
                BTGraphNode node = (BTGraphNode)this.nextAt(0);
                buf.append("(" + node.stateFP + "," + node.getIndex() + ")");
            }
            int i = 1;
            while (i < size) {
                buf.append(", ");
                BTGraphNode node = (BTGraphNode)this.nextAt(i);
                buf.append("(" + node.stateFP + "," + node.getIndex() + ")");
                ++i;
            }
            buf.append("\n");
            i = 0;
            while (i < size) {
                this.nextAt(i).toString(buf, unseen);
                ++i;
            }
        }
    }
}

