/*
 * Decompiled with CFR 0.152.
 */
package tlc2.debug;

import org.eclipse.lsp4j.debug.SourceBreakpoint;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.st.Location;
import tlc2.debug.TLCDebuggerExpression;
import tlc2.tool.EvalException;
import tlc2.tool.FingerprintException;
import tlc2.tool.TLCState;
import tlc2.tool.impl.SpecProcessor;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.value.IValue;
import tlc2.value.impl.BoolValue;
import util.Assert;

public class TLCSourceBreakpoint
extends SourceBreakpoint {
    private final int hits;
    private final Location location;
    private final OpDefNode condition;

    public TLCSourceBreakpoint(SpecProcessor processor, String s) {
        this.location = Location.nullLoc;
        this.setLine(this.location.beginLine());
        this.hits = 0;
        this.setCondition(s);
        ModuleNode semanticRoot = processor.getRootModule();
        OpDefNode odn = semanticRoot.getOpDef(s);
        this.condition = odn != null ? odn : TLCDebuggerExpression.process(processor, semanticRoot, this.location, s);
    }

    public TLCSourceBreakpoint(SpecProcessor processor, String module, SourceBreakpoint s, ModuleNode semanticRoot) {
        OpDefNode odn;
        this.setColumn(s.getColumn());
        this.setLine(s.getLine());
        int column = this.getColumn() != null ? this.getColumn() : 1;
        this.location = new Location(module, this.getLine() + 1, column, this.getLine(), column + 1);
        this.setCondition(s.getCondition());
        this.setLogMessage(s.getLogMessage());
        this.setHitCondition(s.getHitCondition());
        int h = 0;
        if (this.getHitCondition() != null) {
            try {
                h = Integer.parseInt(this.getHitCondition());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.hits = h;
        this.condition = s.getCondition() != null && !s.getCondition().isBlank() ? ((odn = semanticRoot.getOpDef(s.getCondition())) != null ? odn : TLCDebuggerExpression.process(processor, semanticRoot, this.location, s.getCondition())) : null;
    }

    public int getHits() {
        return this.hits;
    }

    public boolean isInline() {
        return this.getColumnAsInt() == -1;
    }

    public int getColumnAsInt() {
        if (this.getColumn() != null) {
            return this.getColumn();
        }
        return -1;
    }

    public Location getLocation() {
        return this.location;
    }

    protected boolean matchesExpression(Tool tool, TLCState s, TLCState t, Context c, boolean fire) {
        if (this.condition != null) {
            try {
                Context ctxt = Context.Empty;
                FormalParamNode[] formalParamNodeArray = this.condition.getParams();
                int n = formalParamNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FormalParamNode p = formalParamNodeArray[n2];
                    ctxt = ctxt.cons(p, c.lookup(sn -> sn.getName().equals(p.getName())));
                    ++n2;
                }
                IValue eval = tool.noDebug().eval(this.condition.getBody(), ctxt, s, t, 0);
                if (eval instanceof BoolValue) {
                    fire &= ((BoolValue)eval).val;
                }
            }
            catch (EvalException | FingerprintException | Assert.TLCRuntimeException runtimeException) {
                // empty catch block
            }
        }
        return fire;
    }

    public boolean matchesLocation(Location loc) {
        if (this.location == Location.nullLoc) {
            return true;
        }
        return this.getLine() == loc.beginLine() && this.getColumnAsInt() <= loc.beginColumn();
    }
}

