/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.HashSet;
import java.util.Set;
import tla2sany.semantic.SymbolNode;

public interface SymbolMatcher {
    public boolean matches(SymbolNode var1);

    public static class NameAndTypeMatcher
    implements SymbolMatcher {
        private String prefix;

        public NameAndTypeMatcher setPrefix(String aPrefix) {
            this.prefix = aPrefix;
            return this;
        }

        @Override
        public boolean matches(SymbolNode aSymbol) {
            if (!this.matchesAnyType() && !this.matchTypes().contains(aSymbol.getClass())) {
                return false;
            }
            if (aSymbol.getKind() == 7 && aSymbol.getName().toString().startsWith("$")) {
                return false;
            }
            String symbolName = aSymbol.getName().toString();
            if (this.matchCaseSensitive() && !symbolName.startsWith(this.getPrefix())) {
                return false;
            }
            return symbolName.toLowerCase().startsWith(this.getPrefix().toLowerCase());
        }

        protected Set<Class<? extends SymbolNode>> matchTypes() {
            return new HashSet<Class<? extends SymbolNode>>();
        }

        protected boolean matchesAnyType() {
            return this.matchTypes().isEmpty();
        }

        protected boolean matchCaseSensitive() {
            return false;
        }

        protected String getPrefix() {
            return this.prefix;
        }
    }
}

