/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import tlc2.tool.IStateFunctor;
import tlc2.tool.ITool;
import tlc2.tool.SimulationWorker;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.liveness.ILiveCheck;
import tlc2.util.SetOfStates;

public class ExplorationWorker
extends SimulationWorker {
    private volatile boolean halted = false;

    public ExplorationWorker(int id, ITool tool, BlockingQueue<SimulationWorker.SimulationWorkerResult> resultQueue, long seed, int maxTraceDepth, long maxTraceNum, String traceActions, boolean checkDeadlock, String traceFile, ILiveCheck liveCheck, LongAdder numOfGenStates, AtomicLong numOfGenTraces, AtomicLong m2AndMean) {
        super(id, tool, resultQueue, seed, maxTraceDepth, maxTraceNum, traceActions, checkDeadlock, traceFile, liveCheck, numOfGenStates, numOfGenTraces, m2AndMean);
    }

    @Override
    protected Optional<SimulationWorker.SimulationWorkerError> simulateRandomTrace() throws Exception {
        this.tool.getInitStates(new IStateFunctor(){

            @Override
            public Object addElement(TLCState state) {
                if (ExplorationWorker.this.tool.isInModel(state)) {
                    ExplorationWorker.this.initStates.addElement(state);
                }
                return state;
            }

            @Override
            public Object setElement(TLCState state) {
                ExplorationWorker.this.initStates.clear();
                ExplorationWorker.this.initStates.addElement(state);
                return state;
            }

            @Override
            public SetOfStates getStates() {
                return new SetOfStates(ExplorationWorker.this.initStates);
            }
        });
        this.curState = this.randomState(this.localRng, this.initStates);
        ExplorationWorker.setCurrentState(this.curState);
        int traceIdx = 0;
        while (traceIdx < this.maxTraceDepth) {
            this.checkForInterrupt();
            this.nextStates.clear();
            try {
                this.tool.getNextStates(this, this.curState);
            }
            catch (SimulationWorker.SimulationWorkerError swe) {
                return Optional.of(swe);
            }
            if (this.halted) {
                this.halted = false;
                return Optional.empty();
            }
            if (this.nextStates.isEmpty()) {
                if (!this.checkDeadlock) break;
                return Optional.of(new SimulationWorker.SimulationWorkerError(this, 2114, null, this.getTrace(this.curState), null));
            }
            TLCState s1 = this.randomState(this.localRng, this.nextStates);
            s1.execCallable();
            this.statistics.collectPostSuccessor(this.curState, s1.getAction(), s1);
            this.curState = s1;
            ExplorationWorker.setCurrentState(this.curState);
            ++traceIdx;
        }
        this.checkForInterrupt();
        this.liveCheck.checkTrace(this.tool.noDebug(), new Supplier<StateVec>(){

            @Override
            public StateVec get() {
                return ExplorationWorker.this.getTrace(ExplorationWorker.this.curState);
            }
        });
        this.statistics.collectPostTrace(this.curState);
        this.postTrace(this.curState);
        return Optional.empty();
    }

    @Override
    public boolean halt() {
        boolean old = this.halted;
        this.halted = true;
        return old;
    }
}

