/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import util.ClasspathResourceLocator;
import util.FileUtil;
import util.FilenameToStream;
import util.FilesystemResourceLocator;
import util.ResourceLocator;
import util.SequentialResourceLocator;
import util.ToolIO;

public class SimpleFilenameToStream
implements FilenameToStream {
    public static final String TLA_LIBRARY = "TLA-Library";
    public static final String STANDARD_MODULES_FOLDER = "StandardModules";
    private static final ClassLoader cl = SimpleFilenameToStream.class.getClassLoader();
    private static final String STANDARD_MODULES = "tla2sany/StandardModules/";
    protected final Path tmpDir = FilenameToStream.getTempDirectory();
    private final ResourceLocator userFileResourceLocator;
    private final ResourceLocator standardLibraryResourceLocator;

    public SimpleFilenameToStream() {
        this((String[])null);
    }

    public SimpleFilenameToStream(String libraryPath) {
        this(new String[]{libraryPath});
    }

    public SimpleFilenameToStream(String[] anLibraryPaths) {
        if (anLibraryPaths == null) {
            anLibraryPaths = SimpleFilenameToStream.parsePaths(System.getProperty(TLA_LIBRARY));
        }
        this.userFileResourceLocator = new SequentialResourceLocator(List.of(SimpleFilenameToStream.searchUserDirOrCWD(), SimpleFilenameToStream.searchFilesystemPaths(anLibraryPaths)));
        this.standardLibraryResourceLocator = SimpleFilenameToStream.getInstallationBasePath();
    }

    private static ResourceLocator getInstallationBasePath() {
        return new SequentialResourceLocator(List.of(new ClasspathResourceLocator(cl, STANDARD_MODULES), new ClasspathResourceLocator(cl, "")));
    }

    @Override
    public String getFullPath() {
        return this.userFileResourceLocator.describeSearchLocations() + ", " + this.standardLibraryResourceLocator.describeSearchLocations();
    }

    private static ResourceLocator searchUserDirOrCWD() {
        String userDir = ToolIO.getUserDir();
        if (userDir != null) {
            return new FilesystemResourceLocator(Path.of(userDir, new String[0]));
        }
        String cwd = System.getProperty("user.dir");
        if (cwd != null) {
            return new FilesystemResourceLocator(Path.of(cwd, new String[0]));
        }
        return ResourceLocator.EMPTY;
    }

    private static ResourceLocator searchFilesystemPaths(String[] paths) {
        return new SequentialResourceLocator(Arrays.stream(paths).map(string -> Path.of(string, new String[0])).map(FilesystemResourceLocator::new).collect(Collectors.toList()));
    }

    private static String[] parsePaths(String pathList) {
        return pathList == null ? new String[]{} : pathList.split(FileUtil.pathSeparator);
    }

    private final FilenameToStream.TLAFile locate(String name) {
        FilenameToStream.TLAFile userModule = this.locateAndCopyToFilesystemIfNecessary(this.userFileResourceLocator, name, false);
        if (userModule != null) {
            return userModule;
        }
        FilenameToStream.TLAFile libraryModule = this.locateAndCopyToFilesystemIfNecessary(this.standardLibraryResourceLocator, name, true);
        if (libraryModule != null) {
            return libraryModule;
        }
        String userDir = ToolIO.getUserDir();
        String parent = userDir == null ? "." : userDir;
        return new FilenameToStream.TLAFile(parent, name, (FilenameToStream)this);
    }

    private FilenameToStream.TLAFile locateAndCopyToFilesystemIfNecessary(ResourceLocator locator, String name, boolean isLibraryModule) {
        URL location;
        block13: {
            location = locator.locate(name);
            if (location != null) break block13;
            return null;
        }
        try {
            if ("file".equalsIgnoreCase(location.getProtocol())) {
                Path locationOnFilesystem = Path.of(location.toURI());
                return new FilenameToStream.TLAFile(locationOnFilesystem, isLibraryModule, (FilenameToStream)this);
            }
            Throwable throwable = null;
            Object var6_9 = null;
            try (InputStream in = location.openStream();){
                return this.read(name, location, in, isLibraryModule);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private FilenameToStream.TLAFile read(String name, URL location, InputStream is, boolean isLibraryModule) {
        FilenameToStream.TLAFile sourceFile = new FilenameToStream.TLAFile(this.tmpDir.resolve(name), location, isLibraryModule, (FilenameToStream)this);
        sourceFile.deleteOnExit();
        try {
            int len;
            FileOutputStream fos = new FileOutputStream(sourceFile);
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) > 0) {
                fos.write(buf, 0, len);
            }
            fos.close();
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sourceFile;
    }

    @Override
    public FilenameToStream.TLAFile resolve(String name, boolean isModule) {
        int n = name.indexOf(10);
        if (n >= 0) {
            ToolIO.out.println("*** Warning: module name '" + name + "' contained NEWLINE; Only the part before NEWLINE is considered.");
            name = name.substring(0, n);
        }
        Object sourceFileName = null;
        if (isModule) {
            if (name.toLowerCase().endsWith(".tla")) {
                name = name.substring(0, name.length() - ".tla".length());
            }
            sourceFileName = name + ".tla";
        } else {
            sourceFileName = name;
        }
        return this.locate((String)sourceFileName);
    }

    public File resolve(String name) {
        return this.resolve(name, false);
    }

    @Override
    public boolean isStandardModule(String moduleName) {
        FilenameToStream.TLAFile file = this.resolve(moduleName, true);
        return file.exists() && file.isLibraryModule();
    }
}

