/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util.statistics.management;

import javax.management.NotCompliantMBeanException;
import tlc2.tool.management.TLCStandardMBean;
import tlc2.util.statistics.IBucketStatistics;
import tlc2.util.statistics.management.BucketStatisticsMXBean;

public class BucketStatisticsMXWrapper
extends TLCStandardMBean
implements BucketStatisticsMXBean {
    private IBucketStatistics graphStats;
    private final String objectName;

    public BucketStatisticsMXWrapper(IBucketStatistics graphStats, String graphName, String pkg) throws NotCompliantMBeanException {
        super((Class)BucketStatisticsMXBean.class);
        this.graphStats = graphStats;
        this.objectName = graphName;
        this.registerMBean(String.format("%s:type=%s", pkg, this.objectName));
    }

    @Override
    public String getObjectName() {
        return this.objectName;
    }

    @Override
    public long getObservations() {
        return this.graphStats.getObservations();
    }

    @Override
    public int getMedian() {
        return this.graphStats.getMedian();
    }

    @Override
    public double getMean() {
        return this.graphStats.getMean();
    }

    @Override
    public int getMin() {
        return this.graphStats.getMin();
    }

    @Override
    public int getMax() {
        return this.graphStats.getMax();
    }

    @Override
    public double getStdDev() {
        return this.graphStats.getStdDev();
    }

    @Override
    public double get75Percentile() {
        return this.graphStats.getPercentile(0.75);
    }

    @Override
    public double get95Percentile() {
        return this.graphStats.getPercentile(0.95);
    }

    @Override
    public double get98Percentile() {
        return this.graphStats.getPercentile(0.98);
    }

    @Override
    public double get99Percentile() {
        return this.graphStats.getPercentile(0.99);
    }

    @Override
    public double get999Percentile() {
        return this.graphStats.getPercentile(0.999);
    }
}

