/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.impl;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import tla2sany.parser.SyntaxTreeNode;
import tla2sany.semantic.APSubstInNode;
import tla2sany.semantic.Context;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.LabelNode;
import tla2sany.semantic.LetInNode;
import tla2sany.semantic.OpApplNode;
import tla2sany.semantic.OpArgNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.OpDefOrDeclNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.Subst;
import tla2sany.semantic.SubstInNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.semantic.ThmOrAssumpDefNode;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.Action;
import tlc2.tool.BuiltInOPs;
import tlc2.tool.EvalControl;
import tlc2.tool.EvalException;
import tlc2.tool.IActionItemList;
import tlc2.tool.IContextEnumerator;
import tlc2.tool.INextStateFunctor;
import tlc2.tool.IStateFunctor;
import tlc2.tool.ITool;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateFun;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.TLCStateMut;
import tlc2.tool.TLCStateMutExt;
import tlc2.tool.ToolGlobals;
import tlc2.tool.coverage.CostModel;
import tlc2.tool.impl.ActionItemList;
import tlc2.tool.impl.ActionItemListExt;
import tlc2.tool.impl.AliasTLCStateInfo;
import tlc2.tool.impl.ContextEnumerator;
import tlc2.tool.impl.Spec;
import tlc2.tool.impl.WorkerValue;
import tlc2.util.ExpectInlined;
import tlc2.util.IdThread;
import tlc2.util.RandomGenerator;
import tlc2.util.Vect;
import tlc2.value.IFcnLambdaValue;
import tlc2.value.IMVPerm;
import tlc2.value.IValue;
import tlc2.value.ValueConstants;
import tlc2.value.Values;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.Enumerable;
import tlc2.value.impl.FcnLambdaValue;
import tlc2.value.impl.FcnParams;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.FunctionValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.LazySupplierValue;
import tlc2.value.impl.LazyValue;
import tlc2.value.impl.MVPerm;
import tlc2.value.impl.MVPerms;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.OpLambdaValue;
import tlc2.value.impl.OpValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.Reducible;
import tlc2.value.impl.SetCapValue;
import tlc2.value.impl.SetCupValue;
import tlc2.value.impl.SetDiffValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.SetOfFcnsValue;
import tlc2.value.impl.SetOfRcdsValue;
import tlc2.value.impl.SetOfTuplesValue;
import tlc2.value.impl.SetPredValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.SubsetValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.UnionValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueEnumeration;
import tlc2.value.impl.ValueExcept;
import tlc2.value.impl.ValueVec;
import util.Assert;
import util.FilenameToStream;
import util.UniqueString;

public abstract class Tool
extends Spec
implements ValueConstants,
ToolGlobals,
ITool {
    public static final String TLCSTATEMUTEXT_KEY = Tool.class.getName() + "." + TLCStateMutExt.class.getSimpleName();
    public static final String CDOT_KEY = Tool.class.getName() + ".cdot";
    public static final String PROBABILISTIC_KEY = Tool.class.getName() + ".probabilistic";
    private static final boolean PROBABILISTIC = Boolean.getBoolean(PROBABILISTIC_KEY);
    public static final Value[] EmptyArgs = new Value[0];
    protected final Action[] actions;
    private Vect<Action> actionVec = new Vect(10);
    protected final Mode toolMode;

    public Tool(String specFile, String configFile) {
        this(new File(specFile), specFile, configFile, null);
    }

    public Tool(String specFile, String configFile, FilenameToStream resolver) {
        this(new File(specFile), specFile, configFile, resolver);
    }

    public Tool(String specFile, String configFile, FilenameToStream resolver, Map<String, Object> params) {
        this(new File(specFile), specFile, configFile, resolver, params);
    }

    public Tool(String specFile, String configFile, FilenameToStream resolver, Mode mode, Map<String, Object> params) {
        this(new File(specFile), specFile, configFile, resolver, mode, params);
    }

    private Tool(File specDir, String specFile, String configFile, FilenameToStream resolver) {
        this(specDir.isAbsolute() ? specDir.getParent() : "", specFile, configFile, resolver, new HashMap<String, Object>());
    }

    private Tool(File specDir, String specFile, String configFile, FilenameToStream resolver, Map<String, Object> params) {
        this(specDir.isAbsolute() ? specDir.getParent() : "", specFile, configFile, resolver, params);
    }

    private Tool(File specDir, String specFile, String configFile, FilenameToStream resolver, Mode mode, Map<String, Object> params) {
        this(specDir.isAbsolute() ? specDir.getParent() : "", specFile, configFile, resolver, mode, params);
    }

    public Tool(String specDir, String specFile, String configFile, FilenameToStream resolver, Map<String, Object> params) {
        this(specDir, specFile, configFile, resolver, Mode.MC, params);
    }

    public Tool(String specDir, String specFile, String configFile, FilenameToStream resolver, Mode mode, Map<String, Object> params) {
        super(specDir, specFile, configFile, resolver, mode, params);
        int i;
        this.toolMode = mode;
        if (mode == Mode.Simulation || mode == Mode.Executor || mode == Mode.MC_DEBUG || Boolean.getBoolean(TLCSTATEMUTEXT_KEY)) {
            assert (TLCState.Empty instanceof TLCStateMutExt);
            TLCStateMutExt.setTool(this);
        } else {
            assert (TLCState.Empty instanceof TLCStateMut);
            TLCStateMut.setTool(this);
        }
        Action next = this.getNextStateSpec();
        if (next == null) {
            this.actions = new Action[0];
        } else {
            this.getActions(next);
            int sz = this.actionVec.size();
            this.actions = new Action[sz];
            i = 0;
            while (i < sz) {
                this.actions[i] = this.actionVec.elementAt(i);
                ++i;
            }
        }
        Vect<Action> initAndNext = this.getInitStateSpec().concat(this.actionVec);
        i = 0;
        while (i < initAndNext.size()) {
            initAndNext.elementAt(i).setId(i);
            ++i;
        }
    }

    Tool(Tool other) {
        super(other);
        this.actions = other.actions;
        this.actionVec = other.actionVec;
        this.toolMode = other.toolMode;
    }

    @Override
    public Mode getMode() {
        return this.toolMode;
    }

    @Override
    public final Action[] getActions() {
        return this.actions;
    }

    private final void getActions(Action next) {
        this.getActions(next.pred, next.con, next.getOpDef(), next.cm);
    }

    private final void getActions(SemanticNode next, tlc2.util.Context con, OpDefNode opDefNode, CostModel cm) {
        switch (next.getKind()) {
            case 9: {
                OpApplNode next1 = (OpApplNode)next;
                this.getActionsAppl(next1, con, opDefNode, cm);
                return;
            }
            case 10: {
                LetInNode next1 = (LetInNode)next;
                this.getActions(next1.getBody(), con, opDefNode, cm);
                return;
            }
            case 13: {
                SubstInNode next1 = (SubstInNode)next;
                Subst[] substs = next1.getSubsts();
                if (substs.length == 0) {
                    this.getActions(next1.getBody(), con, opDefNode, cm);
                } else {
                    Action action = new Action(this, next1, con, opDefNode);
                    this.actionVec.addElement(action);
                }
                return;
            }
            case 30: {
                APSubstInNode next1 = (APSubstInNode)next;
                Subst[] substs = next1.getSubsts();
                if (substs.length == 0) {
                    this.getActions(next1.getBody(), con, opDefNode, cm);
                } else {
                    Action action = new Action(this, next1, con, opDefNode);
                    this.actionVec.addElement(action);
                }
                return;
            }
            case 29: {
                LabelNode next1 = (LabelNode)next;
                this.getActions(next1.getBody(), con, opDefNode, cm);
                return;
            }
        }
        Assert.fail("The next state relation is not a boolean expression.\n" + String.valueOf(next), next, con);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void getActionsAppl(OpApplNode next, tlc2.util.Context con, OpDefNode actionName, CostModel cm) {
        ExprOrOpArgNode[] args = next.getArgs();
        SymbolNode opNode = next.getOperator();
        int opcode = BuiltInOPs.getOpCode(opNode.getName());
        if (opcode == 0) {
            OpDefNode opDef;
            Object val = this.lookup(opNode, con, false);
            if (val instanceof OpDefNode && (opcode = BuiltInOPs.getOpCode((opDef = (OpDefNode)val).getName())) == 0) {
                try {
                    FormalParamNode[] formals = opDef.getParams();
                    int alen = args.length;
                    int argLevel = 0;
                    int i = 0;
                    while (i < alen) {
                        argLevel = args[i].getLevel();
                        if (argLevel != 0) break;
                        ++i;
                    }
                    if (argLevel == 0) {
                        tlc2.util.Context con1 = con;
                        int i2 = 0;
                        while (i2 < alen) {
                            IValue aval = this.eval(args[i2], con, TLCState.Empty, cm);
                            con1 = con1.cons(formals[i2], aval);
                            ++i2;
                        }
                        this.getActions(opDef.getBody(), con1, opDef, cm);
                        return;
                    }
                }
                catch (Throwable formals) {
                    // empty catch block
                }
            }
            if (opcode == 0) {
                Action action = new Action(this, next, con, (OpDefNode)opNode);
                this.actionVec.addElement(action);
                return;
            }
        }
        switch (opcode) {
            case 2: {
                int cnt = this.actionVec.size();
                try {
                    ContextEnumerator Enum2 = this.contexts(next, con, TLCState.Empty, TLCState.Empty, 0, cm);
                    if (Enum2.isDone()) {
                        this.actionVec.addElement(new Action(this, next, con, actionName));
                        return;
                    }
                    while (true) {
                        tlc2.util.Context econ;
                        if ((econ = Enum2.nextElement()) == null) {
                            if ($assertionsDisabled) return;
                            if (cnt < this.actionVec.size()) return;
                            throw new AssertionError((Object)"AssertionError when creating Actions. This case should have been handled by Enum.isDone conditional above!");
                        }
                        this.getActions(args[0], econ, actionName, cm);
                    }
                }
                catch (Throwable e) {
                    Action action = new Action(this, next, con, actionName);
                    this.actionVec.removeAll(cnt);
                    this.actionVec.addElement(action);
                }
                return;
            }
            case 7: 
            case 37: {
                int i = 0;
                while (i < args.length) {
                    this.getActions(args[i], con, actionName, cm);
                    ++i;
                }
                return;
            }
        }
        Action action = new Action(this, next, con, actionName);
        this.actionVec.addElement(action);
    }

    @Override
    public final StateVec getInitStates() {
        StateVec initStates = new StateVec(0);
        this.getInitStates(initStates);
        return initStates;
    }

    @Override
    public void getInitStates(IStateFunctor functor) {
        Vect<Action> init = this.getInitStateSpec();
        ActionItemList acts = ActionItemListExt.Empty;
        int i = init.size() - 1;
        while (i > 0) {
            Action elem = init.elementAt(i);
            acts = acts.cons(elem, -1);
            --i;
        }
        if (init.size() != 0) {
            Action elem = init.elementAt(0);
            TLCState ps = TLCState.Empty.createEmpty();
            if (acts.isEmpty()) {
                acts.setAction(elem);
            }
            this.getInitStates(elem.pred, acts, elem.con, ps, functor, elem.cm);
        }
    }

    @Override
    public final TLCState makeState(SemanticNode pred) {
        TLCState state;
        ActionItemList acts = ActionItemList.Empty;
        TLCState ps = TLCState.Empty.createEmpty();
        StateVec states = new StateVec(0);
        this.getInitStates(pred, acts, tlc2.util.Context.Empty, ps, states, acts.cm);
        if (states.size() != 1) {
            Assert.fail("The predicate does not specify a unique state." + String.valueOf(pred), pred);
        }
        if (!this.isGoodState(state = states.elementAt(0))) {
            Assert.fail("The state specified by the predicate is not complete." + String.valueOf(pred), pred);
        }
        return state;
    }

    protected void getInitStates(SemanticNode init, ActionItemList acts, tlc2.util.Context c, TLCState ps, IStateFunctor states, CostModel cm) {
        switch (init.getKind()) {
            case 9: {
                OpApplNode init1 = (OpApplNode)init;
                this.getInitStatesAppl(init1, acts, c, ps, states, cm);
                return;
            }
            case 10: {
                LetInNode init1 = (LetInNode)init;
                this.getInitStates(init1.getBody(), acts, c, ps, states, cm);
                return;
            }
            case 13: {
                SubstInNode init1 = (SubstInNode)init;
                Subst[] subs = init1.getSubsts();
                tlc2.util.Context c1 = c;
                int i = 0;
                while (i < subs.length) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, false, coverage ? sub.getCM() : cm, toolId));
                    ++i;
                }
                this.getInitStates(init1.getBody(), acts, c1, ps, states, cm);
                return;
            }
            case 30: {
                APSubstInNode init1 = (APSubstInNode)init;
                Subst[] subs = init1.getSubsts();
                tlc2.util.Context c1 = c;
                int i = 0;
                while (i < subs.length) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, false, cm, toolId));
                    ++i;
                }
                this.getInitStates(init1.getBody(), acts, c1, ps, states, cm);
                return;
            }
            case 29: {
                LabelNode init1 = (LabelNode)init;
                this.getInitStates(init1.getBody(), acts, c, ps, states, cm);
                return;
            }
        }
        Assert.fail("The init state relation is not a boolean expression.\n" + String.valueOf(init), init, c);
    }

    protected void getInitStates(ActionItemList acts, TLCState ps, IStateFunctor states, CostModel cm) {
        if (acts.isEmpty()) {
            if (coverage) {
                cm.incInvocations();
            }
            if (TLCGlobals.Coverage.isActionEnabled()) {
                cm.getRoot().incInvocations();
            }
            states.addElement(ps.copy().setAction(acts.getAction()));
            return;
        }
        if (ps.allAssigned()) {
            while (!acts.isEmpty()) {
                Value bval = this.eval(acts.carPred(), acts.carContext(), ps, TLCState.Empty, 8, acts.cm);
                if (!(bval instanceof BoolValue)) {
                    Assert.fail(2247, new String[]{"initial states", "boolean", bval.toString(), acts.pred.toString()}, acts.carPred(), acts.carContext());
                }
                if (!((BoolValue)bval).val) {
                    if (coverage) {
                        cm.getRoot().incSecondary();
                    }
                    this.processUnsatisfied(ps, acts.carPred(), acts.carContext(), states, cm);
                    return;
                }
                acts = acts.cdr();
            }
            if (coverage) {
                cm.incInvocations();
                cm.getRoot().incInvocations();
            }
            states.addElement(ps.copy().setAction(acts.getAction()));
            return;
        }
        ActionItemList acts1 = acts.cdr();
        this.getInitStates(acts.carPred(), acts1, acts.carContext(), ps, states, acts.cm);
    }

    protected void getInitStatesAppl(OpApplNode init, ActionItemList acts, tlc2.util.Context c, TLCState ps, IStateFunctor states, CostModel cm) {
        Object bval;
        if (coverage) {
            cm = cm.get(init);
        }
        ExprOrOpArgNode[] args = init.getArgs();
        int alen = args.length;
        SymbolNode opNode = init.getOperator();
        int opcode = BuiltInOPs.getOpCode(opNode.getName());
        if (opcode == 0) {
            LazyValue lv;
            SymbolNode opDef;
            Object val = this.lookup(opNode, c, ps, false);
            if (val instanceof OpDefNode && (opcode = BuiltInOPs.getOpCode((opDef = (OpDefNode)val).getName())) == 0) {
                tlc2.util.Context c1 = this.getOpContext((OpDefNode)opDef, args, c, true, cm, toolId);
                this.getInitStates(((OpDefNode)opDef).getBody(), acts, c1, ps, states, cm);
                return;
            }
            if (val instanceof ThmOrAssumpDefNode) {
                opDef = (ThmOrAssumpDefNode)val;
                opcode = BuiltInOPs.getOpCode(opDef.getName());
                tlc2.util.Context c1 = this.getOpContext((ThmOrAssumpDefNode)opDef, args, c, true);
                this.getInitStates(((ThmOrAssumpDefNode)opDef).getBody(), acts, c1, ps, states, cm);
                return;
            }
            if (val instanceof LazyValue && (val = (lv = (LazyValue)val).getCachedValue(this, ps, null, 0)) == null) {
                this.getInitStates(lv.expr, acts, lv.con, ps, states, cm);
                return;
            }
            bval = val;
            if (val instanceof OpValue) {
                bval = ((OpValue)val).eval(this, args, c, ps, TLCState.Empty, 8, cm);
            }
            if (opcode == 0) {
                if (!(bval instanceof BoolValue)) {
                    Assert.fail(2247, new String[]{"initial states", "boolean", bval.toString(), init.toString()}, (SemanticNode)init, c);
                }
                if (((BoolValue)bval).val) {
                    this.getInitStates(acts, ps, states, cm);
                }
                return;
            }
        }
        switch (opcode) {
            case 7: 
            case 37: {
                int i = 0;
                while (i < alen) {
                    this.getInitStates(args[i], acts, c, ps, states, cm);
                    ++i;
                }
                return;
            }
            case 6: 
            case 36: {
                int i = alen - 1;
                while (i > 0) {
                    acts = (ActionItemList)acts.cons(args[i], c, cm, i);
                    --i;
                }
                this.getInitStates(args[0], acts, c, ps, states, cm);
                return;
            }
            case 2: {
                tlc2.util.Context c1;
                ExprOrOpArgNode body = args[0];
                ContextEnumerator Enum2 = this.contexts(init, c, ps, TLCState.Empty, 8, cm);
                while ((c1 = Enum2.nextElement()) != null) {
                    this.getInitStates(body, acts, c1, ps, states, cm);
                }
                return;
            }
            case 3: {
                ExprOrOpArgNode body = args[0];
                ContextEnumerator Enum2 = this.contexts(init, c, ps, TLCState.Empty, 8, cm);
                tlc2.util.Context c1 = Enum2.nextElement();
                if (c1 == null) {
                    this.getInitStates(acts, ps, states, cm);
                } else {
                    tlc2.util.Context c2;
                    ActionItemList acts1 = acts;
                    while ((c2 = Enum2.nextElement()) != null) {
                        acts1 = (ActionItemList)acts1.cons(body, c2, cm, -1);
                    }
                    this.getInitStates(body, acts1, c1, ps, states, cm);
                }
                return;
            }
            case 11: {
                Value guard = this.eval(args[0], c, ps, TLCState.Empty, 8, cm);
                if (!(guard instanceof BoolValue)) {
                    Assert.fail("In computing initial states, a non-boolean expression (" + guard.getKindString() + ") was used as the condition of an IF.\n" + String.valueOf(init), init, c);
                }
                int idx = ((BoolValue)guard).val ? 1 : 2;
                this.getInitStates(args[idx], acts, c, ps, states, cm);
                return;
            }
            case 4: {
                ExprOrOpArgNode other = null;
                int i = 0;
                while (i < alen) {
                    OpApplNode pair2 = (OpApplNode)args[i];
                    ExprOrOpArgNode[] pairArgs = pair2.getArgs();
                    if (pairArgs[0] == null) {
                        other = pairArgs[1];
                    } else {
                        Value bval2 = this.eval(pairArgs[0], c, ps, TLCState.Empty, 8, cm);
                        if (!(bval2 instanceof BoolValue)) {
                            Assert.fail("In computing initial states, a non-boolean expression (" + bval2.getKindString() + ") was used as a guard condition of a CASE.\n" + String.valueOf(pairArgs[1]), pairArgs[1], c);
                        }
                        if (((BoolValue)bval2).val) {
                            this.getInitStates(pairArgs[1], acts, c, ps, states, cm);
                            return;
                        }
                    }
                    ++i;
                }
                if (other == null) {
                    Assert.fail("In computing initial states, TLC encountered a CASE with no conditions true.\n" + String.valueOf(init), init, c);
                }
                this.getInitStates(other, acts, c, ps, states, cm);
                return;
            }
            case 9: {
                FunctionValue fcn;
                Value fval = this.eval(args[0], c, ps, TLCState.Empty, 8, cm);
                if (fval instanceof FcnLambdaValue) {
                    fcn = (FcnLambdaValue)fval;
                    if (((FcnLambdaValue)fcn).fcnRcd == null) {
                        tlc2.util.Context c1 = this.getFcnContext((IFcnLambdaValue)((Object)fcn), args, c, ps, TLCState.Empty, 8, cm);
                        this.getInitStates(((FcnLambdaValue)fcn).body, acts, c1, ps, states, cm);
                        return;
                    }
                    fval = ((FcnLambdaValue)fcn).fcnRcd;
                } else if (!(fval instanceof FunctionValue)) {
                    Assert.fail("In computing initial states, a non-function (" + fval.getKindString() + ") was applied as a function.\n" + String.valueOf(init), init, c);
                }
                fcn = (FunctionValue)((Object)fval);
                Value argVal = this.eval(args[1], c, ps, TLCState.Empty, 8, cm);
                Value bval3 = fcn.apply(argVal, 8);
                if (!(bval3 instanceof BoolValue)) {
                    Assert.fail(2248, new String[]{"initial states", "boolean", init.toString()}, (SemanticNode)args[1], c);
                }
                if (((BoolValue)bval3).val) {
                    this.getInitStates(acts, ps, states, cm);
                }
                return;
            }
            case 35: {
                UniqueString varName;
                SymbolNode var = this.getVar(args[0], c, false, toolId);
                if (var == null || var.getName().getVarLoc() < 0) {
                    bval = this.eval(init, c, ps, TLCState.Empty, 8, cm);
                    if (!((BoolValue)bval).val) {
                        return;
                    }
                } else {
                    varName = var.getName();
                    IValue lval = ps.lookup(varName);
                    Value rval = this.eval(args[1], c, ps, TLCState.Empty, 8, cm);
                    if (lval == null) {
                        ps = ps.bind(varName, (IValue)rval);
                        this.getInitStates(acts, ps, states, cm);
                        ps.unbind(varName);
                        return;
                    }
                    if (!lval.equals(rval)) {
                        return;
                    }
                }
                this.getInitStates(acts, ps, states, cm);
                return;
            }
            case 42: {
                UniqueString varName;
                SymbolNode var = this.getVar(args[0], c, false, toolId);
                if (var == null || var.getName().getVarLoc() < 0) {
                    bval = this.eval(init, c, ps, TLCState.Empty, 8, cm);
                    if (!((BoolValue)bval).val) {
                        return;
                    }
                } else {
                    varName = var.getName();
                    Value lval = (Value)ps.lookup(varName);
                    Value rval = this.eval(args[1], c, ps, TLCState.Empty, 8, cm);
                    if (lval == null) {
                        Value elem;
                        if (!(rval instanceof Enumerable)) {
                            Assert.fail("In computing initial states, the right side of \\IN is not enumerable.\n" + String.valueOf(init), init, c);
                        }
                        ValueEnumeration Enum3 = ((Enumerable)((Object)rval)).elements();
                        while ((elem = Enum3.nextElement()) != null) {
                            ps.bind(varName, (IValue)elem);
                            this.getInitStates(acts, ps, states, cm);
                            ps.unbind(varName);
                        }
                        return;
                    }
                    if (!rval.member(lval)) {
                        return;
                    }
                }
                this.getInitStates(acts, ps, states, cm);
                return;
            }
            case 38: {
                Value lval = this.eval(args[0], c, ps, TLCState.Empty, 8, cm);
                if (!(lval instanceof BoolValue)) {
                    Assert.fail("In computing initial states of a predicate of form P => Q, P was " + lval.getKindString() + "\n." + String.valueOf(init), init, c);
                }
                if (((BoolValue)lval).val) {
                    this.getInitStates(args[1], acts, c, ps, states, cm);
                } else {
                    this.getInitStates(acts, ps, states, cm);
                }
                return;
            }
            case 46: {
                this.getInitStates(args[0], acts, c, ps, states, cm);
                return;
            }
        }
        Value bval4 = this.eval(init, c, ps, TLCState.Empty, 8, cm);
        if (!(bval4 instanceof BoolValue)) {
            Assert.fail("In computing initial states, TLC expected a boolean expression,\nbut instead found " + String.valueOf(bval4) + ".\n" + String.valueOf(init), init, c);
        }
        if (((BoolValue)bval4).val) {
            this.getInitStates(acts, ps, states, cm);
        }
    }

    @Override
    public final StateVec getNextStates(Action action, TLCState state) {
        return this.getNextStates(action, action.con, state);
    }

    public final StateVec getNextStates(Action action, tlc2.util.Context ctx, TLCState state) {
        ActionItemList acts = ActionItemList.Empty;
        TLCState s1 = TLCState.Empty.createEmpty();
        StateVec nss = new StateVec(0);
        this.getNextStates(action, action.pred, acts, ctx, state, s1.setPredecessor(state).setAction(action), nss, action.cm);
        if (coverage) {
            action.cm.incInvocations(nss.size());
        }
        if (PROBABILISTIC && nss.size() > 1) {
            System.err.println("Simulator generated more than one next state");
        }
        return nss;
    }

    @Override
    public boolean getNextStates(INextStateFunctor functor, TLCState state) {
        int i = 0;
        while (i < this.actions.length) {
            this.getNextStates(functor, state, this.actions[i]);
            ++i;
        }
        return false;
    }

    @Override
    public boolean getNextStates(INextStateFunctor functor, TLCState state, Action action) {
        this.getNextStates(action, action.pred, ActionItemList.Empty, action.con, state, TLCState.Empty.createEmpty().setPredecessor(state).setAction(action), functor, action.cm);
        return false;
    }

    protected abstract TLCState getNextStates(Action var1, SemanticNode var2, ActionItemList var3, tlc2.util.Context var4, TLCState var5, TLCState var6, INextStateFunctor var7, CostModel var8);

    protected final TLCState getNextStatesImpl(Action action, SemanticNode pred, ActionItemList acts, tlc2.util.Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        switch (pred.getKind()) {
            case 9: {
                OpApplNode pred1 = (OpApplNode)pred;
                if (coverage) {
                    cm = cm.get(pred);
                }
                return this.getNextStatesAppl(action, pred1, acts, c, s0, s1, nss, cm);
            }
            case 10: {
                LetInNode pred1 = (LetInNode)pred;
                return this.getNextStates(action, pred1.getBody(), acts, c, s0, s1, nss, cm);
            }
            case 13: {
                return this.getNextStatesImplSubstInKind(action, (SubstInNode)pred, acts, c, s0, s1, nss, cm);
            }
            case 30: {
                return this.getNextStatesImplApSubstInKind(action, (APSubstInNode)pred, acts, c, s0, s1, nss, cm);
            }
            case 29: {
                LabelNode pred1 = (LabelNode)pred;
                return this.getNextStates(action, pred1.getBody(), acts, c, s0, s1, nss, cm);
            }
        }
        Assert.fail("The next state relation is not a boolean expression.\n" + String.valueOf(pred), pred, c);
        return s1;
    }

    @ExpectInlined
    private final TLCState getNextStatesImplSubstInKind(Action action, SubstInNode pred1, ActionItemList acts, tlc2.util.Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        Subst[] subs = pred1.getSubsts();
        int slen = subs.length;
        tlc2.util.Context c1 = c;
        int i = 0;
        while (i < slen) {
            Subst sub = subs[i];
            c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, false, coverage ? sub.getCM() : cm, toolId));
            ++i;
        }
        return this.getNextStates(action, pred1.getBody(), acts, c1, s0, s1, nss, cm);
    }

    @ExpectInlined
    private final TLCState getNextStatesImplApSubstInKind(Action action, APSubstInNode pred1, ActionItemList acts, tlc2.util.Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        Subst[] subs = pred1.getSubsts();
        int slen = subs.length;
        tlc2.util.Context c1 = c;
        int i = 0;
        while (i < slen) {
            Subst sub = subs[i];
            c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, false, cm, toolId));
            ++i;
        }
        return this.getNextStates(action, pred1.getBody(), acts, c1, s0, s1, nss, cm);
    }

    @ExpectInlined
    private final TLCState getNextStates(Action action, ActionItemList acts, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        TLCState copy = this.getNextStates0(action, acts, s0, s1, nss, cm);
        if (coverage && copy != s1) {
            cm.incInvocations();
        }
        return copy;
    }

    @ExpectInlined
    private final TLCState getNextStates0(Action action, ActionItemList acts, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        IValue v2;
        if (acts.isEmpty()) {
            nss.addElement(s0, action, s1);
            return s1.copy();
        }
        if (TLCGlobals.warn && s1.allAssigned()) {
            return this.getNextStatesAllAssigned(action, acts, s0, s1, nss, cm);
        }
        int kind = acts.carKind();
        SemanticNode pred = acts.carPred();
        tlc2.util.Context c = acts.carContext();
        ActionItemList acts1 = acts.cdr();
        cm = acts.cm;
        if (kind > 0) {
            return this.getNextStates(action, pred, acts1, c, s0, s1, nss, cm);
        }
        if (kind == -1) {
            return this.getNextStates(action, pred, acts1, c, s0, s1, nss, cm);
        }
        if (kind == -2) {
            return this.processUnchanged(action, pred, acts1, c, s0, s1, nss, cm);
        }
        IValue v1 = this.eval(pred, c, s0, cm);
        if (!v1.equals(v2 = this.eval(pred, c, s1, cm))) {
            if (coverage) {
                return this.getNextStates(action, acts1, s0, s1, nss, cm);
            }
            return this.getNextStates0(action, acts1, s0, s1, nss, cm);
        }
        return s1;
    }

    private final TLCState getNextStatesAllAssigned(Action action, ActionItemList acts, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        int kind = acts.carKind();
        SemanticNode pred = acts.carPred();
        tlc2.util.Context c = acts.carContext();
        CostModel cm2 = acts.cm;
        while (!acts.isEmpty()) {
            if (kind > 0 || kind == -1) {
                Value bval = this.eval(pred, c, s0, s1, 0, cm2);
                if (!(bval instanceof BoolValue)) {
                    Assert.fail(2247, new String[]{"next states", "boolean", bval.toString(), acts.pred.toString()}, pred, c);
                }
                if (!((BoolValue)bval).val) {
                    return this.processUnsatisfied(s0, action, s1, pred, c, nss, cm);
                }
            } else {
                IValue v2;
                if (kind == -2) {
                    return this.processUnchanged(action, pred, acts.cdr(), c, s0, s1, nss, cm2);
                }
                IValue v1 = this.eval(pred, c, s0, cm2);
                if (v1.equals(v2 = this.eval(pred, c, s1, cm2))) {
                    return s1;
                }
            }
            acts = acts.cdr();
            pred = acts.carPred();
            c = acts.carContext();
            kind = acts.carKind();
            cm2 = acts.cm;
        }
        nss.addElement(s0, action, s1);
        return s1.copy();
    }

    @ExpectInlined
    protected TLCState processUnsatisfied(TLCState ps, SemanticNode pred, tlc2.util.Context c, IStateFunctor states, CostModel cm) {
        return states.addUnsatisfiedState(ps, pred, c);
    }

    @ExpectInlined
    protected TLCState processUnsatisfied(TLCState s0, Action action, TLCState s1, SemanticNode pred, tlc2.util.Context c, INextStateFunctor nss, CostModel cm) {
        return nss.addUnsatisfiedState(s0, action, s1, pred, c);
    }

    @ExpectInlined
    protected abstract TLCState getNextStatesAppl(Action var1, OpApplNode var2, ActionItemList var3, tlc2.util.Context var4, TLCState var5, TLCState var6, INextStateFunctor var7, CostModel var8);

    protected final TLCState getNextStatesApplImpl(Action action, OpApplNode pred, ActionItemList acts, tlc2.util.Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        ExprOrOpArgNode[] args = pred.getArgs();
        int alen = args.length;
        SymbolNode opNode = pred.getOperator();
        int opcode = BuiltInOPs.getOpCode(opNode.getName());
        if (opcode == 0) {
            LazyValue lv;
            SymbolNode opDef;
            Object val = this.lookup(opNode, c, s0, false);
            if (val instanceof OpDefNode && (opcode = BuiltInOPs.getOpCode((opDef = (OpDefNode)val).getName())) == 0) {
                return this.getNextStates(action, ((OpDefNode)opDef).getBody(), acts, this.getOpContext((OpDefNode)opDef, args, c, true, cm, toolId), s0, s1, nss, cm);
            }
            if (val instanceof ThmOrAssumpDefNode) {
                opDef = (ThmOrAssumpDefNode)val;
                return this.getNextStates(action, ((ThmOrAssumpDefNode)opDef).getBody(), acts, this.getOpContext((ThmOrAssumpDefNode)opDef, args, c, true), s0, s1, nss, cm);
            }
            if (val instanceof LazyValue && (val = (lv = (LazyValue)val).getCachedValue(this, s0, s1, 0)) == null) {
                return this.getNextStates(action, lv.expr, acts, lv.con, s0, s1, nss, lv.cm);
            }
            Object bval = this.getNextStatesApplEvalAppl(alen, args, c, s0, s1, cm, val);
            if (opcode == 0) {
                return this.getNextStatesApplUsrDefOp(action, pred, acts, s0, s1, nss, cm, bval);
            }
        }
        return this.getNextStatesApplSwitch(action, pred, acts, c, s0, s1, nss, cm, args, alen, opcode);
    }

    private final Object getNextStatesApplEvalAppl(int alen, ExprOrOpArgNode[] args, tlc2.util.Context c, TLCState s0, TLCState s1, CostModel cm, Object val) {
        if (val instanceof OpValue) {
            return ((OpValue)val).eval(this, args, c, s0, s1, 0, cm);
        }
        return val;
    }

    private final TLCState getNextStatesApplUsrDefOp(Action action, OpApplNode pred, ActionItemList acts, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm, Object bval) {
        if (!(bval instanceof BoolValue)) {
            Assert.fail(2247, new String[]{"next states", "boolean", bval.toString(), pred.toString()}, pred);
        }
        if (((BoolValue)bval).val) {
            if (coverage) {
                return this.getNextStates(action, acts, s0, s1, nss, cm);
            }
            return this.getNextStates0(action, acts, s0, s1, nss, cm);
        }
        return s1;
    }

    private final TLCState getNextStatesApplSwitch(final Action action, OpApplNode pred, ActionItemList acts, tlc2.util.Context c, final TLCState s0, TLCState s1, final INextStateFunctor nss, CostModel cm, ExprOrOpArgNode[] args, int alen, int opcode) {
        TLCState resState = s1;
        switch (opcode) {
            case 6: 
            case 36: {
                ActionItemList acts1 = acts;
                int i = alen - 1;
                while (i > 0) {
                    acts1 = (ActionItemList)acts1.cons(args[i], c, cm, i);
                    --i;
                }
                return this.getNextStates(action, args[0], acts1, c, s0, s1, nss, cm);
            }
            case 7: 
            case 37: {
                if (PROBABILISTIC) {
                    RandomGenerator rng = TLCGlobals.simulator.getRNG();
                    int index = (int)Math.floor(rng.nextDouble() * (double)alen);
                    int p = rng.nextPrime();
                    int i = 0;
                    while (i < alen) {
                        resState = this.getNextStates(action, args[index], acts, c, s0, resState, nss, cm);
                        if (nss.hasStates()) {
                            return resState;
                        }
                        index = (index + p) % alen;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < alen) {
                        resState = this.getNextStates(action, args[i], acts, c, s0, resState, nss, cm);
                        ++i;
                    }
                }
                return resState;
            }
            case 2: {
                ExprOrOpArgNode body = args[0];
                if (PROBABILISTIC) {
                    tlc2.util.Context c1;
                    ContextEnumerator Enum2 = this.contexts(Enumerable.Ordering.RANDOMIZED, pred, c, s0, s1, 0, cm);
                    while ((c1 = Enum2.nextElement()) != null) {
                        resState = this.getNextStates(action, body, acts, c1, s0, resState, nss, cm);
                        if (!nss.hasStates()) continue;
                        return resState;
                    }
                } else {
                    tlc2.util.Context c1;
                    ContextEnumerator Enum3 = this.contexts(pred, c, s0, s1, 0, cm);
                    while ((c1 = Enum3.nextElement()) != null) {
                        resState = this.getNextStates(action, body, acts, c1, s0, resState, nss, cm);
                    }
                }
                return resState;
            }
            case 3: {
                ExprOrOpArgNode body = args[0];
                ContextEnumerator Enum4 = this.contexts(pred, c, s0, s1, 0, cm);
                tlc2.util.Context c1 = Enum4.nextElement();
                if (c1 == null) {
                    resState = this.getNextStates(action, acts, s0, s1, nss, cm);
                } else {
                    tlc2.util.Context c2;
                    ActionItemList acts1 = acts;
                    while ((c2 = Enum4.nextElement()) != null) {
                        acts1 = (ActionItemList)acts1.cons(body, c2, cm, -1);
                    }
                    resState = this.getNextStates(action, body, acts1, c1, s0, s1, nss, cm);
                }
                return resState;
            }
            case 9: {
                Value argVal;
                Value bval;
                FunctionValue fcn;
                Value fval = this.eval(args[0], c, s0, s1, 1, cm);
                if (fval instanceof FcnLambdaValue) {
                    fcn = (FcnLambdaValue)fval;
                    if (((FcnLambdaValue)fcn).fcnRcd == null) {
                        tlc2.util.Context c1 = this.getFcnContext((IFcnLambdaValue)((Object)fcn), args, c, s0, s1, 0, cm);
                        return this.getNextStates(action, ((FcnLambdaValue)fcn).body, acts, c1, s0, s1, nss, ((FcnLambdaValue)fcn).cm);
                    }
                    fval = ((FcnLambdaValue)fcn).fcnRcd;
                }
                if (!(fval instanceof FunctionValue)) {
                    Assert.fail("In computing next states, a non-function (" + fval.getKindString() + ") was applied as a function.\n" + String.valueOf(pred), pred, c);
                }
                if (!((bval = (fcn = (FunctionValue)((Object)fval)).apply(argVal = this.eval(args[1], c, s0, s1, 0, cm), 0)) instanceof BoolValue)) {
                    Assert.fail(2248, new String[]{"next states", "boolean", pred.toString()}, (SemanticNode)args[1], c);
                }
                if (((BoolValue)bval).val) {
                    return this.getNextStates(action, acts, s0, s1, nss, cm);
                }
                return resState;
            }
            case 50: {
                ActionItemList acts1 = (ActionItemList)acts.cons(args[1], c, cm, -3);
                return this.getNextStates(action, args[0], acts1, c, s0, s1, nss, cm);
            }
            case 51: {
                resState = this.getNextStates(action, args[0], acts, c, s0, resState, nss, cm);
                return this.processUnchanged(action, args[1], acts, c, s0, resState, nss, cm);
            }
            case 11: {
                Value guard = this.eval(args[0], c, s0, s1, 0, cm);
                if (!(guard instanceof BoolValue)) {
                    Assert.fail("In computing next states, a non-boolean expression (" + guard.getKindString() + ") was used as the condition of an IF." + String.valueOf(pred), pred, c);
                }
                if (((BoolValue)guard).val) {
                    return this.getNextStates(action, args[1], acts, c, s0, s1, nss, cm);
                }
                return this.getNextStates(action, args[2], acts, c, s0, s1, nss, cm);
            }
            case 4: {
                ExprOrOpArgNode other = null;
                if (PROBABILISTIC) {
                    throw new UnsupportedOperationException("Probabilistic evaluation of next-state relation not implemented for CASE yet.");
                }
                int i = 0;
                while (i < alen) {
                    OpApplNode pair2 = (OpApplNode)args[i];
                    ExprOrOpArgNode[] pairArgs = pair2.getArgs();
                    if (pairArgs[0] == null) {
                        other = pairArgs[1];
                    } else {
                        Value bval = this.eval(pairArgs[0], c, s0, s1, 0, coverage ? cm.get(args[i]) : cm);
                        if (!(bval instanceof BoolValue)) {
                            Assert.fail("In computing next states, a non-boolean expression (" + bval.getKindString() + ") was used as a guard condition of a CASE.\n" + String.valueOf(pairArgs[1]), pairArgs[1], c);
                        }
                        if (((BoolValue)bval).val) {
                            return this.getNextStates(action, pairArgs[1], acts, c, s0, s1, nss, coverage ? cm.get(args[i]) : cm);
                        }
                    }
                    ++i;
                }
                if (other == null) {
                    Assert.fail("In computing next states, TLC encountered a CASE with no conditions true.\n" + String.valueOf(pred), pred, c);
                }
                return this.getNextStates(action, other, acts, c, s0, s1, nss, coverage ? cm.get(args[alen - 1]) : cm);
            }
            case 35: {
                SymbolNode var = this.getPrimedVar(args[0], c, false);
                if (var == null) {
                    Value bval = this.eval(pred, c, s0, s1, 0, cm);
                    if (!((BoolValue)bval).val) {
                        return resState;
                    }
                } else {
                    UniqueString varName = var.getName();
                    IValue lval = s1.lookup(varName);
                    Value rval = this.eval(args[1], c, s0, s1, 0, cm);
                    if (lval == null) {
                        resState.bind(varName, (IValue)rval);
                        resState = this.getNextStates(action, acts, s0, resState, nss, cm);
                        resState.unbind(varName);
                        return resState;
                    }
                    if (!lval.equals(rval)) {
                        return resState;
                    }
                }
                return this.getNextStates(action, acts, s0, s1, nss, cm);
            }
            case 42: {
                SymbolNode var = this.getPrimedVar(args[0], c, false);
                if (var == null) {
                    Value bval = this.eval(pred, c, s0, s1, 0, cm);
                    if (!((BoolValue)bval).val) {
                        return resState;
                    }
                } else {
                    UniqueString varName = var.getName();
                    Value lval = (Value)s1.lookup(varName);
                    Value rval = this.eval(args[1], c, s0, s1, 0, cm);
                    if (lval == null) {
                        Value elem;
                        ValueEnumeration Enum5;
                        if (!(rval instanceof Enumerable)) {
                            Assert.fail("In computing next states, the right side of \\IN is not enumerable.\n" + String.valueOf(pred), pred, c);
                        }
                        if (PROBABILISTIC) {
                            Enum5 = ((Enumerable)((Object)rval)).elements(Enumerable.Ordering.RANDOMIZED);
                            while ((elem = Enum5.nextElement()) != null) {
                                resState.bind(varName, (IValue)elem);
                                resState = this.getNextStates(action, acts, s0, resState, nss, cm);
                                resState.unbind(varName);
                                if (!nss.hasStates()) continue;
                                return resState;
                            }
                        }
                        Enum5 = ((Enumerable)((Object)rval)).elements();
                        while ((elem = Enum5.nextElement()) != null) {
                            resState.bind(varName, (IValue)elem);
                            resState = this.getNextStates(action, acts, s0, resState, nss, cm);
                            resState.unbind(varName);
                        }
                        return resState;
                    }
                    if (!rval.member(lval)) {
                        return resState;
                    }
                }
                return this.getNextStates(action, acts, s0, s1, nss, cm);
            }
            case 38: {
                Value bval = this.eval(args[0], c, s0, s1, 0, cm);
                if (!(bval instanceof BoolValue)) {
                    Assert.fail("In computing next states of a predicate of the form P => Q, P was\n" + bval.getKindString() + ".\n" + String.valueOf(pred), pred, c);
                }
                if (((BoolValue)bval).val) {
                    return this.getNextStates(action, args[1], acts, c, s0, s1, nss, cm);
                }
                return this.getNextStates(action, acts, s0, s1, nss, cm);
            }
            case 49: {
                return this.processUnchanged(action, args[0], acts, c, s0, s1, nss, cm);
            }
            case 52: {
                if (Boolean.getBoolean(CDOT_KEY)) {
                    TLCState t = s0.copyWith(s1);
                    StateVec iss = new StateVec(0);
                    this.getNextStates(action, args[0], acts, c, s0, t, iss, cm);
                    int sz = iss.size();
                    nss.incrementStatesGenerated(sz);
                    int i = 0;
                    while (i < sz) {
                        TLCState u = s1.copy();
                        t = iss.elementAt(i);
                        this.getNextStates(action, args[1], acts, c, t, u, new INextStateFunctor(){

                            @Override
                            public TLCState addUnsatisfiedState(TLCState t, Action action2, TLCState u, SemanticNode pred, tlc2.util.Context c) {
                                return nss.addUnsatisfiedState(s0, action2, u.setPredecessor(s0), pred, c);
                            }

                            @Override
                            public Object addElement(TLCState t, Action a, TLCState u) {
                                return nss.addElement(s0, action, u.setPredecessor(s0));
                            }
                        }, cm);
                        ++i;
                    }
                    return resState;
                }
                Assert.fail("The current version of TLC does not support action composition.  An incomplete implementation can be enabled via the tlc2.tool.impl.Tool.cdot=true java property.", pred, c);
                return s1;
            }
            case 46: {
                return this.getNextStates(action, args[0], acts, c, s0, s1, nss, cm);
            }
        }
        Value bval = this.eval(pred, c, s0, s1, 0, cm);
        if (!(bval instanceof BoolValue)) {
            Assert.fail(2247, new String[]{"next states", "boolean", bval.toString(), pred.toString()}, (SemanticNode)pred, c);
        }
        if (((BoolValue)bval).val) {
            resState = this.getNextStates(action, acts, s0, s1, nss, cm);
        }
        return resState;
    }

    @ExpectInlined
    protected abstract TLCState processUnchanged(Action var1, SemanticNode var2, ActionItemList var3, tlc2.util.Context var4, TLCState var5, TLCState var6, INextStateFunctor var7, CostModel var8);

    protected final TLCState processUnchangedImpl(Action action, SemanticNode expr, ActionItemList acts, tlc2.util.Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        if (coverage) {
            cm = cm.get(expr);
        }
        SymbolNode var = this.getVar(expr, c, false, toolId);
        TLCState resState = s1;
        if (var != null) {
            return this.processUnchangedImplVar(action, expr, acts, s0, s1, nss, var, cm);
        }
        if (expr instanceof OpApplNode) {
            OpApplNode expr1 = (OpApplNode)expr;
            ExprOrOpArgNode[] args = expr1.getArgs();
            int alen = args.length;
            SymbolNode opNode = expr1.getOperator();
            UniqueString opName = opNode.getName();
            int opcode = BuiltInOPs.getOpCode(opName);
            if (opcode == 23) {
                return this.processUnchangedImplTuple(action, acts, c, s0, s1, nss, args, alen, cm, coverage ? cm.get(expr1) : cm);
            }
            if (opcode == 0 && alen == 0) {
                return this.processUnchangedImpl0Arity(action, expr, acts, c, s0, s1, nss, cm, opNode, opName);
            }
        }
        return this.verifyUnchanged(action, expr, acts, c, s0, s1, nss, cm);
    }

    @ExpectInlined
    private final TLCState processUnchangedImpl0Arity(Action action, SemanticNode expr, ActionItemList acts, tlc2.util.Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm, SymbolNode opNode, UniqueString opName) {
        Object val = this.lookup(opNode, c, false);
        if (val instanceof OpDefNode) {
            return this.processUnchanged(action, ((OpDefNode)val).getBody(), acts, c, s0, s1, nss, cm);
        }
        if (val instanceof LazyValue) {
            LazyValue lv = (LazyValue)val;
            return this.processUnchanged(action, lv.expr, acts, lv.con, s0, s1, nss, cm);
        }
        return this.verifyUnchanged(action, expr, acts, c, s0, s1, nss, cm);
    }

    private TLCState verifyUnchanged(Action action, SemanticNode expr, ActionItemList acts, tlc2.util.Context c, TLCState s0, TLCState s1, INextStateFunctor nss, CostModel cm) {
        Value v1;
        TLCState resState = s1;
        IValue v0 = this.eval(expr, c, s0, cm);
        if (v0.equals(v1 = this.eval(expr, c, s1, TLCState.Null, 0, cm))) {
            resState = this.getNextStates(action, acts, s0, s1, nss, cm);
        }
        return resState;
    }

    @Override
    public IValue eval(SemanticNode expr, tlc2.util.Context c, TLCState s0) {
        return this.eval(expr, c, s0, TLCState.Empty, 0, CostModel.DO_NOT_RECORD);
    }

    @Override
    public IValue eval(SemanticNode expr, tlc2.util.Context c) {
        return this.eval(expr, c, TLCState.Empty);
    }

    @Override
    public IValue eval(SemanticNode expr) {
        return this.eval(expr, tlc2.util.Context.Empty);
    }

    @ExpectInlined
    private final TLCState processUnchangedImplTuple(Action action, ActionItemList acts, tlc2.util.Context c, TLCState s0, TLCState s1, INextStateFunctor nss, ExprOrOpArgNode[] args, int alen, CostModel cm, CostModel cmNested) {
        if (alen != 0) {
            ActionItemList acts1 = acts;
            int i = alen - 1;
            while (i > 0) {
                acts1 = (ActionItemList)acts1.cons(args[i], c, cmNested, -2);
                --i;
            }
            return this.processUnchanged(action, args[0], acts1, c, s0, s1, nss, cmNested);
        }
        return this.getNextStates(action, acts, s0, s1, nss, cm);
    }

    @ExpectInlined
    private final TLCState processUnchangedImplVar(Action action, SemanticNode expr, ActionItemList acts, TLCState s0, TLCState s1, INextStateFunctor nss, SymbolNode var, CostModel cm) {
        TLCState resState = s1;
        UniqueString varName = var.getName();
        IValue val0 = s0.lookup(varName);
        IValue val1 = s1.lookup(varName);
        if (val1 == null) {
            resState.bind(varName, val0);
            resState = coverage ? this.getNextStates(action, acts, s0, resState, nss, cm) : this.getNextStates0(action, acts, s0, resState, nss, cm);
            resState.unbind(varName);
        } else if (val0.equals(val1)) {
            resState = coverage ? this.getNextStates(action, acts, s0, s1, nss, cm) : this.getNextStates0(action, acts, s0, s1, nss, cm);
        } else {
            MP.printWarning(2143, varName.toString(), expr.toString());
        }
        return resState;
    }

    @Override
    public TLCState evalAlias(TLCState current, TLCState successor) {
        if ("".equals(this.config.getAlias())) {
            return current;
        }
        IdThread.setCurrentState(current);
        try {
            TLCState alias = this.eval(this.getAliasSpec(), tlc2.util.Context.Empty, current, successor, 0).toState();
            if (alias != null) {
                return alias;
            }
        }
        catch (EvalException | Assert.TLCRuntimeException e) {
            return new RecordValue(new RecordValue(current), UniqueString.of("_ALIASEvalError"), (Value)new StringValue(e.getMessage())).toState();
        }
        return current;
    }

    @Override
    public TLCStateInfo evalAlias(TLCStateInfo current, TLCState successor) {
        if (!this.hasAlias()) {
            return current;
        }
        return this.evalAlias(current, successor, tlc2.util.Context.Empty);
    }

    @Override
    public TLCStateInfo evalAlias(TLCStateInfo current, TLCState successor, Supplier<List<TLCStateInfo>> prefix) {
        if (!this.hasAlias()) {
            return current;
        }
        ExternalModuleTable emt = this.getSpecProcessor().getSpecObj().getExternalModuleTable();
        Context tlcExt = emt.getContext(UniqueString.of("TLCExt"));
        if (tlcExt == null) {
            return this.evalAlias(current, successor, tlc2.util.Context.Empty);
        }
        SymbolNode tlcExtTrace = tlcExt.getSymbol(UniqueString.of("Trace"));
        return this.evalAlias(current, successor, tlc2.util.Context.Empty.cons(tlcExtTrace, new LazySupplierValue(tlcExtTrace, () -> new TupleValue((Value[])((List)prefix.get()).stream().map(si -> new RecordValue(si.state)).toArray(Value[]::new)))));
    }

    private TLCStateInfo evalAlias(TLCStateInfo current, TLCState successor, tlc2.util.Context ctxt) {
        IdThread.setCurrentState(current.state);
        try {
            TLCState alias = this.eval(this.getAliasSpec(), ctxt, current.state, successor, 0).toState();
            if (alias != null) {
                return new AliasTLCStateInfo(alias, current);
            }
        }
        catch (EvalException | Assert.TLCRuntimeException e) {
            return new AliasTLCStateInfo(new RecordValue((RecordValue)current.toRecordValue(), UniqueString.of("_ALIASEvalError"), (Value)new StringValue(e.getMessage())).toState(), current);
        }
        return current;
    }

    @Override
    public IValue eval(SemanticNode expr, tlc2.util.Context c, TLCState s0, CostModel cm) {
        return this.eval(expr, c, s0, TLCState.Empty, 0, cm);
    }

    @Override
    public final IValue eval(SemanticNode expr, tlc2.util.Context c, TLCState s0, TLCState s1, int control) {
        return this.eval(expr, c, s0, s1, control, CostModel.DO_NOT_RECORD);
    }

    public Value evalPure(OpDefNode opDef, ExprOrOpArgNode[] args, tlc2.util.Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        tlc2.util.Context c1 = this.getOpContext(opDef, args, c, true, cm, toolId);
        return this.eval(opDef.getBody(), c1, s0, s1, control, cm);
    }

    @Override
    public abstract Value eval(SemanticNode var1, tlc2.util.Context var2, TLCState var3, TLCState var4, int var5, CostModel var6);

    @ExpectInlined
    protected Value evalImpl(SemanticNode expr, tlc2.util.Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        switch (expr.getKind()) {
            case 29: {
                LabelNode expr1 = (LabelNode)expr;
                return this.eval(expr1.getBody(), c, s0, s1, control, cm);
            }
            case 9: {
                OpApplNode expr1 = (OpApplNode)expr;
                if (coverage) {
                    cm = cm.get(expr);
                }
                return this.evalAppl(expr1, c, s0, s1, control, cm);
            }
            case 10: {
                return this.evalImplLetInKind((LetInNode)expr, c, s0, s1, control, cm);
            }
            case 13: {
                return this.evalImplSubstInKind((SubstInNode)expr, c, s0, s1, control, cm);
            }
            case 30: {
                return this.evalImplApSubstInKind((APSubstInNode)expr, c, s0, s1, control, cm);
            }
            case 16: 
            case 17: 
            case 18: {
                return (Value)WorkerValue.mux(expr.getToolObject(toolId));
            }
            case 19: {
                return (Value)c.lookup(EXCEPT_AT);
            }
            case 8: {
                return this.evalImplOpArgKind((OpArgNode)expr, c, s0, s1, cm);
            }
        }
        Assert.fail("Attempted to evaluate an expression that cannot be evaluated.\n" + String.valueOf(expr), expr, c);
        return null;
    }

    @ExpectInlined
    private final Value evalImplLetInKind(LetInNode expr1, tlc2.util.Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        OpDefNode[] letDefs = expr1.getLets();
        int letLen = letDefs.length;
        tlc2.util.Context c1 = c;
        int i = 0;
        while (i < letLen) {
            OpDefNode opDef = letDefs[i];
            if (opDef.getArity() == 0) {
                LazyValue rhs = new LazyValue(opDef.getBody(), c1, cm);
                c1 = c1.cons(opDef, rhs);
            }
            ++i;
        }
        return this.eval(expr1.getBody(), c1, s0, s1, control, cm);
    }

    @ExpectInlined
    private final Value evalImplSubstInKind(SubstInNode expr1, tlc2.util.Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        Subst[] subs = expr1.getSubsts();
        int slen = subs.length;
        tlc2.util.Context c1 = c;
        int i = 0;
        while (i < slen) {
            Subst sub = subs[i];
            c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, true, coverage ? sub.getCM() : cm, toolId));
            ++i;
        }
        return this.eval(expr1.getBody(), c1, s0, s1, control, cm);
    }

    @ExpectInlined
    private final Value evalImplApSubstInKind(APSubstInNode expr1, tlc2.util.Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        Subst[] subs = expr1.getSubsts();
        int slen = subs.length;
        tlc2.util.Context c1 = c;
        int i = 0;
        while (i < slen) {
            Subst sub = subs[i];
            c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, true, cm, toolId));
            ++i;
        }
        return this.eval(expr1.getBody(), c1, s0, s1, control, cm);
    }

    @ExpectInlined
    private final Value evalImplOpArgKind(OpArgNode expr1, tlc2.util.Context c, TLCState s0, TLCState s1, CostModel cm) {
        SymbolNode opNode = expr1.getOp();
        Object val = this.lookup(opNode, c, false);
        if (val instanceof OpDefNode) {
            return this.setSource(expr1, new OpLambdaValue((OpDefNode)val, this, c, s0, s1, cm));
        }
        return (Value)val;
    }

    @ExpectInlined
    protected abstract Value evalAppl(OpApplNode var1, tlc2.util.Context var2, TLCState var3, TLCState var4, int var5, CostModel var6);

    protected final Value evalApplImpl(OpApplNode expr, tlc2.util.Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        tlc2.util.Context c1;
        if (coverage) {
            cm = cm.getAndIncrement(expr);
        }
        ExprOrOpArgNode[] args = expr.getArgs();
        SymbolNode opNode = expr.getOperator();
        int opcode = BuiltInOPs.getOpCode(opNode.getName());
        if (opcode == 0) {
            Object val = this.lookup(opNode, c, s0, EvalControl.isPrimed(control));
            if (val instanceof LazyValue) {
                LazyValue lv = (LazyValue)val;
                if (s1 == null) {
                    val = this.eval(lv.expr, lv.con, s0, TLCState.Null, control, lv.getCostModel());
                } else {
                    return lv.getValue(this, s0, s1, control);
                }
            }
            Value res = null;
            if (val instanceof OpDefNode) {
                OpDefNode opDef = (OpDefNode)val;
                opcode = BuiltInOPs.getOpCode(opDef.getName());
                if (opcode == 0) {
                    c1 = this.getOpContext(opDef, args, c, true, cm, toolId);
                    res = this.eval(opDef.getBody(), c1, s0, s1, control, cm);
                }
            } else if (val instanceof Value) {
                res = (Value)val;
                if (val instanceof OpValue) {
                    res = ((OpValue)val).eval(this, args, c, s0, s1, control, cm);
                }
            } else {
                if (val instanceof ThmOrAssumpDefNode) {
                    ThmOrAssumpDefNode opDef = (ThmOrAssumpDefNode)val;
                    tlc2.util.Context c12 = this.getOpContext(opDef, args, c, true);
                    return this.eval(opDef.getBody(), c12, s0, s1, control, cm);
                }
                if (!EvalControl.isEnabled(control) && EvalControl.isPrimed(control) && opNode instanceof OpDeclNode) {
                    Assert.fail(2148, new String[]{opNode.getName().toString(), expr.toString()}, (SemanticNode)expr, c);
                }
                Assert.fail(2280, new String[]{opNode.getName().toString(), expr.toString()}, (SemanticNode)expr, c);
            }
            if (opcode == 0) {
                return res;
            }
        }
        switch (opcode) {
            case 1: {
                ExprOrOpArgNode pred = args[0];
                ExprNode inExpr = expr.getBdedQuantBounds()[0];
                Value inVal = this.eval(inExpr, c, s0, s1, control, cm);
                if (!(inVal instanceof Enumerable)) {
                    Assert.fail("Attempted to compute the value of an expression of\nform CHOOSE x \\in S: P, but S was not enumerable.\n" + String.valueOf(expr), expr, c);
                }
                inVal.normalize();
                ValueEnumeration enumSet = ((Enumerable)((Object)inVal)).elements(Enumerable.Ordering.NORMALIZED);
                FormalParamNode[] bvars = expr.getBdedQuantSymbolLists()[0];
                boolean isTuple = expr.isBdedQuantATuple()[0];
                if (isTuple) {
                    Value val;
                    int cnt = bvars.length;
                    while ((val = enumSet.nextElement()) != null) {
                        TupleValue tv = (TupleValue)val.toTuple();
                        if (tv == null || tv.size() != cnt) {
                            Assert.fail("Attempted to compute the value of an expression of form\nCHOOSE <<x1, ... , xN>> \\in S: P, but S was not a set\nof N-tuples.\n" + String.valueOf(expr), expr, c);
                        }
                        tlc2.util.Context c13 = c;
                        int i = 0;
                        while (i < cnt) {
                            c13 = c13.cons(bvars[i], tv.elems[i]);
                            ++i;
                        }
                        Value bval = this.eval(pred, c13, s0, s1, control, cm);
                        if (!(bval instanceof BoolValue)) {
                            Assert.fail(2215, new String[]{"boolean", expr.toString()}, (SemanticNode)pred, c13);
                        }
                        if (!((BoolValue)bval).val) continue;
                        return val;
                    }
                } else {
                    Value val;
                    FormalParamNode name = bvars[0];
                    while ((val = enumSet.nextElement()) != null) {
                        tlc2.util.Context c14 = c.cons(name, val);
                        Value bval = this.eval(pred, c14, s0, s1, control, cm);
                        if (!(bval instanceof BoolValue)) {
                            Assert.fail(2215, new String[]{"boolean", expr.toString()}, (SemanticNode)pred, c14);
                        }
                        if (!((BoolValue)bval).val) continue;
                        return val;
                    }
                }
                Assert.fail("Attempted to compute the value of an expression of form\nCHOOSE x \\in S: P, but no element of S satisfied P.\n" + String.valueOf(expr), expr, c);
                return null;
            }
            case 2: {
                Value bval;
                tlc2.util.Context c15;
                ContextEnumerator Enum2 = this.contexts(expr, c, s0, s1, control, cm);
                ExprOrOpArgNode body = args[0];
                while ((c15 = Enum2.nextElement()) != null) {
                    bval = this.eval(body, c15, s0, s1, control, cm);
                    if (!(bval instanceof BoolValue)) {
                        Assert.fail(2215, new String[]{"boolean", expr.toString()}, (SemanticNode)body, c15);
                    }
                    if (!((BoolValue)bval).val) continue;
                    return BoolValue.ValTrue;
                }
                return BoolValue.ValFalse;
            }
            case 3: {
                Value bval;
                tlc2.util.Context c15;
                ContextEnumerator Enum2 = this.contexts(expr, c, s0, s1, control, cm);
                ExprOrOpArgNode body = args[0];
                while ((c15 = Enum2.nextElement()) != null) {
                    bval = this.eval(body, c15, s0, s1, control, cm);
                    if (!(bval instanceof BoolValue)) {
                        Assert.fail(2215, new String[]{"boolean", expr.toString()}, (SemanticNode)body, c15);
                    }
                    if (((BoolValue)bval).val) continue;
                    return BoolValue.ValFalse;
                }
                return BoolValue.ValTrue;
            }
            case 4: {
                OpApplNode pairNode;
                int alen = args.length;
                ExprOrOpArgNode other = null;
                int i = 0;
                while (i < alen) {
                    pairNode = (OpApplNode)args[i];
                    ExprOrOpArgNode[] pairArgs = pairNode.getArgs();
                    if (pairArgs[0] == null) {
                        other = pairArgs[1];
                        if (coverage) {
                            cm = cm.get(pairNode);
                        }
                    } else {
                        Value bval = this.eval(pairArgs[0], c, s0, s1, control, coverage ? cm.get(pairNode) : cm);
                        if (!(bval instanceof BoolValue)) {
                            Assert.fail("A non-boolean expression (" + bval.getKindString() + ") was used as a condition of a CASE. " + String.valueOf(pairArgs[0]), pairArgs[0], c);
                        }
                        if (((BoolValue)bval).val) {
                            return this.eval(pairArgs[1], c, s0, s1, control, coverage ? cm.get(pairNode) : cm);
                        }
                    }
                    ++i;
                }
                if (other == null) {
                    Assert.fail("Attempted to evaluate a CASE with no conditions true.\n" + String.valueOf(expr), expr, c);
                }
                return this.eval(other, c, s0, s1, control, cm);
            }
            case 5: {
                int alen = args.length;
                Value[] sets = new Value[alen];
                int i = 0;
                while (i < alen) {
                    sets[i] = this.eval(args[i], c, s0, s1, control, cm);
                    ++i;
                }
                return this.setSource(expr, new SetOfTuplesValue(sets, cm));
            }
            case 6: {
                Value bval;
                int alen = args.length;
                int i = 0;
                while (i < alen) {
                    bval = this.eval(args[i], c, s0, s1, control, cm);
                    if (!(bval instanceof BoolValue)) {
                        Assert.fail("A non-boolean expression (" + bval.getKindString() + ") was used as a formula in a conjunction.\n" + String.valueOf(args[i]), args[i], c);
                    }
                    if (!((BoolValue)bval).val) {
                        return BoolValue.ValFalse;
                    }
                    ++i;
                }
                return BoolValue.ValTrue;
            }
            case 7: {
                Value bval;
                int alen = args.length;
                int i = 0;
                while (i < alen) {
                    bval = this.eval(args[i], c, s0, s1, control, cm);
                    if (!(bval instanceof BoolValue)) {
                        Assert.fail("A non-boolean expression (" + bval.getKindString() + ") was used as a formula in a disjunction.\n" + String.valueOf(args[i]), args[i], c);
                    }
                    if (((BoolValue)bval).val) {
                        return BoolValue.ValTrue;
                    }
                    ++i;
                }
                return BoolValue.ValFalse;
            }
            case 8: {
                OpApplNode pairNode;
                int alen = args.length;
                Value result = this.eval(args[0], c, s0, s1, control, cm);
                int i = 1;
                while (i < alen) {
                    pairNode = (OpApplNode)args[i];
                    ExprOrOpArgNode[] pairArgs = pairNode.getArgs();
                    ExprOrOpArgNode[] cmpts = ((OpApplNode)pairArgs[0]).getArgs();
                    Value[] lhs = new Value[cmpts.length];
                    int j = 0;
                    while (j < lhs.length) {
                        lhs[j] = this.eval(cmpts[j], c, s0, s1, control, coverage ? cm.get(pairNode).get(pairArgs[0]) : cm);
                        ++j;
                    }
                    Value atVal = result.select(lhs);
                    if (atVal == null) {
                        MP.printWarning(2144, new String[]{args[0].toString()});
                    } else {
                        tlc2.util.Context c16 = c.cons(EXCEPT_AT, atVal);
                        Value rhs = this.eval(pairArgs[1], c16, s0, s1, control, coverage ? cm.get(pairNode) : cm);
                        ValueExcept vex = new ValueExcept(lhs, rhs);
                        result = result.takeExcept(vex);
                    }
                    ++i;
                }
                return result;
            }
            case 9: {
                FunctionValue fcn;
                Value result = null;
                Value fval = this.eval(args[0], c, s0, s1, EvalControl.setKeepLazy(control), cm);
                if (fval instanceof FcnRcdValue || fval instanceof FcnLambdaValue) {
                    fcn = (FunctionValue)((Object)fval);
                    Value argVal = this.eval(args[1], c, s0, s1, control, cm);
                    result = fcn.apply(argVal, control);
                } else if (fval instanceof TupleValue || fval instanceof RecordValue) {
                    fcn = (FunctionValue)((Object)fval);
                    if (args.length != 2) {
                        Assert.fail("Attempted to evaluate an expression of form f[e1, ... , eN]\nwith f a tuple or record and N > 1.\n" + String.valueOf(expr), expr, c);
                    }
                    Value aval = this.eval(args[1], c, s0, s1, control, cm);
                    result = fcn.apply(aval, control);
                } else {
                    Assert.fail("A non-function (" + fval.getKindString() + ") was applied as a function.\n" + String.valueOf(expr), expr, c);
                }
                return result;
            }
            case 10: 
            case 12: 
            case 16: {
                FormalParamNode[][] formals = expr.getBdedQuantSymbolLists();
                boolean[] isTuples = expr.isBdedQuantATuple();
                ExprNode[] domains = expr.getBdedQuantBounds();
                Value[] dvals = new Value[domains.length];
                boolean isFcnRcd = true;
                int i = 0;
                while (i < dvals.length) {
                    dvals[i] = this.eval(domains[i], c, s0, s1, control, cm);
                    isFcnRcd = isFcnRcd && dvals[i] instanceof Reducible;
                    ++i;
                }
                FcnParams params = new FcnParams(formals, isTuples, dvals);
                ExprOrOpArgNode fbody = args[0];
                FcnLambdaValue fval = (FcnLambdaValue)this.setSource(expr, new FcnLambdaValue(params, fbody, this, c, s0, s1, control, cm));
                if (opcode == 16) {
                    FormalParamNode fname = expr.getUnbdedQuantSymbols()[0];
                    fval.makeRecursive(fname);
                    isFcnRcd = false;
                }
                if (isFcnRcd && !EvalControl.isKeepLazy(control)) {
                    return fval.toFcnRcd();
                }
                return fval;
            }
            case 11: {
                Value bval = this.eval(args[0], c, s0, s1, control, cm);
                if (!(bval instanceof BoolValue)) {
                    Assert.fail("A non-boolean expression (" + bval.getKindString() + ") was used as the condition of an IF.\n" + String.valueOf(expr), expr, c);
                }
                if (((BoolValue)bval).val) {
                    return this.eval(args[1], c, s0, s1, control, cm);
                }
                return this.eval(args[2], c, s0, s1, control, cm);
            }
            case 14: {
                int alen = args.length;
                UniqueString[] names = new UniqueString[alen];
                Value[] vals = new Value[alen];
                int i = 0;
                while (i < alen) {
                    OpApplNode pairNode = (OpApplNode)args[i];
                    ExprOrOpArgNode[] pair2 = pairNode.getArgs();
                    names[i] = ((StringValue)pair2[0].getToolObject(toolId)).getVal();
                    vals[i] = this.eval(pair2[1], c, s0, s1, control, coverage ? cm.get(pairNode) : cm);
                    ++i;
                }
                return this.setSource(expr, new RecordValue(names, vals, false, cm));
            }
            case 15: {
                Value rval = this.eval(args[0], c, s0, s1, control, cm);
                Value sval = (Value)WorkerValue.mux(args[1].getToolObject(toolId));
                if (rval instanceof RecordValue) {
                    Value result = ((RecordValue)rval).select(sval);
                    if (result == null) {
                        Assert.fail("Attempted to select nonexistent field " + String.valueOf(sval) + " from the record\n" + Values.ppr(rval.toString()) + "\n" + String.valueOf(expr), expr, c);
                    }
                    return result;
                }
                FunctionValue fcn = (FcnRcdValue)rval.toFcnRcd();
                if (fcn == null) {
                    Assert.fail("Attempted to select field " + String.valueOf(sval) + " from a non-record value " + Values.ppr(rval.toString()) + "\n" + String.valueOf(expr), expr, c);
                }
                return ((FcnRcdValue)fcn).apply(sval, control);
            }
            case 18: {
                int alen = args.length;
                Value[] vals = new ValueVec(alen);
                int i = 0;
                while (i < alen) {
                    vals.addElement(this.eval(args[i], c, s0, s1, control, cm));
                    ++i;
                }
                return this.setSource(expr, new SetEnumValue((ValueVec)vals, false, cm));
            }
            case 19: {
                ValueVec vals = new ValueVec();
                ContextEnumerator Enum3 = this.contexts(expr, c, s0, s1, control, cm);
                ExprOrOpArgNode body = args[0];
                while ((c1 = Enum3.nextElement()) != null) {
                    Value val = this.eval(body, c1, s0, s1, control, cm);
                    vals.addElement(val);
                }
                return this.setSource(expr, new SetEnumValue(vals, false, cm));
            }
            case 20: {
                int alen = args.length;
                UniqueString[] names = new UniqueString[alen];
                Value[] vals = new Value[alen];
                int i = 0;
                while (i < alen) {
                    OpApplNode pairNode = (OpApplNode)args[i];
                    ExprOrOpArgNode[] pair3 = pairNode.getArgs();
                    names[i] = ((StringValue)pair3[0].getToolObject(toolId)).getVal();
                    vals[i] = this.eval(pair3[1], c, s0, s1, control, coverage ? cm.get(pairNode) : cm);
                    ++i;
                }
                return this.setSource(expr, new SetOfRcdsValue(names, vals, false, cm));
            }
            case 21: {
                Value lhs = this.eval(args[0], c, s0, s1, control, cm);
                Value rhs = this.eval(args[1], c, s0, s1, control, cm);
                return this.setSource(expr, new SetOfFcnsValue(lhs, rhs, cm));
            }
            case 22: {
                ExprOrOpArgNode pred = args[0];
                ExprNode inExpr = expr.getBdedQuantBounds()[0];
                Value inVal = this.eval(inExpr, c, s0, s1, control, cm);
                boolean isTuple = expr.isBdedQuantATuple()[0];
                FormalParamNode[] bvars = expr.getBdedQuantSymbolLists()[0];
                if (inVal instanceof Reducible) {
                    ValueVec vals = new ValueVec();
                    ValueEnumeration enumSet = ((Enumerable)((Object)inVal)).elements();
                    if (isTuple) {
                        Value elem;
                        while ((elem = enumSet.nextElement()) != null) {
                            tlc2.util.Context c17 = c;
                            Value[] tuple = ((TupleValue)elem).elems;
                            int i = 0;
                            while (i < bvars.length) {
                                c17 = c17.cons(bvars[i], tuple[i]);
                                ++i;
                            }
                            Value bval = this.eval(pred, c17, s0, s1, control, cm);
                            if (!(bval instanceof BoolValue)) {
                                Assert.fail("Attempted to evaluate an expression of form {x \\in S : P(x)} when P was " + bval.getKindString() + ".\n" + String.valueOf(pred), pred, c17);
                            }
                            if (!((BoolValue)bval).val) continue;
                            vals.addElement(elem);
                        }
                    } else {
                        Value elem;
                        FormalParamNode idName = bvars[0];
                        while ((elem = enumSet.nextElement()) != null) {
                            tlc2.util.Context c18 = c.cons(idName, elem);
                            Value bval = this.eval(pred, c18, s0, s1, control, cm);
                            if (!(bval instanceof BoolValue)) {
                                Assert.fail("Attempted to evaluate an expression of form {x \\in S : P(x)} when P was " + bval.getKindString() + ".\n" + String.valueOf(pred), pred, c18);
                            }
                            if (!((BoolValue)bval).val) continue;
                            vals.addElement(elem);
                        }
                    }
                    return this.setSource(expr, new SetEnumValue(vals, inVal.isNormalized(), cm));
                }
                if (isTuple) {
                    return this.setSource(expr, new SetPredValue(bvars, inVal, pred, this, c, s0, s1, control, cm));
                }
                return this.setSource(expr, new SetPredValue(bvars[0], inVal, pred, this, c, s0, s1, control, cm));
            }
            case 23: {
                int alen = args.length;
                Value[] vals = new Value[alen];
                int i = 0;
                while (i < alen) {
                    vals[i] = this.eval(args[i], c, s0, s1, control, cm);
                    ++i;
                }
                return this.setSource(expr, new TupleValue(vals, cm));
            }
            case 24: {
                Assert.fail("TLC attempted to evaluate an unbounded CHOOSE.\nMake sure that the expression is of form CHOOSE x \\in S: P(x).\n" + String.valueOf(expr), expr, c);
                return null;
            }
            case 25: {
                Assert.fail("TLC attempted to evaluate an unbounded \\E.\nMake sure that the expression is of form \\E x \\in S: P(x).\n" + String.valueOf(expr), expr, c);
                return null;
            }
            case 26: {
                Assert.fail("TLC attempted to evaluate an unbounded \\A.\nMake sure that the expression is of form \\A x \\in S: P(x).\n" + String.valueOf(expr), expr, c);
                return null;
            }
            case 27: {
                Value arg = this.eval(args[0], c, s0, s1, control, cm);
                if (!(arg instanceof BoolValue)) {
                    Assert.fail("Attempted to apply the operator ~ to a non-boolean\n(" + arg.getKindString() + ")\n" + String.valueOf(expr), args[0], c);
                }
                return ((BoolValue)arg).val ? BoolValue.ValFalse : BoolValue.ValTrue;
            }
            case 29: {
                Value arg = this.eval(args[0], c, s0, s1, control, cm);
                return this.setSource(expr, new SubsetValue(arg, cm));
            }
            case 30: {
                Value arg = this.eval(args[0], c, s0, s1, control, cm);
                return this.setSource(expr, UnionValue.union(arg));
            }
            case 31: {
                Value arg = this.eval(args[0], c, s0, s1, control, cm);
                if (!(arg instanceof FunctionValue)) {
                    Assert.fail("Attempted to apply the operator DOMAIN to a non-function\n(" + arg.getKindString() + ")\n" + String.valueOf(expr), expr, c);
                }
                return this.setSource(expr, ((FunctionValue)((Object)arg)).getDomain());
            }
            case 34: {
                TLCState sfun = TLCStateFun.Empty;
                tlc2.util.Context c19 = tlc2.util.Context.branch(c);
                sfun = this.enabled((SemanticNode)args[0], ActionItemList.Empty, c19, s0, sfun, cm);
                return sfun != null ? BoolValue.ValTrue : BoolValue.ValFalse;
            }
            case 35: {
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                Value arg2 = this.eval(args[1], c, s0, s1, control, cm);
                return arg1.equals(arg2) ? BoolValue.ValTrue : BoolValue.ValFalse;
            }
            case 36: {
                Value arg2;
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                if (!(arg1 instanceof BoolValue)) {
                    Assert.fail("Attempted to evaluate an expression of form P /\\ Q when P was\n" + arg1.getKindString() + ".\n" + String.valueOf(expr), expr, c);
                }
                if (((BoolValue)arg1).val) {
                    arg2 = this.eval(args[1], c, s0, s1, control, cm);
                    if (!(arg2 instanceof BoolValue)) {
                        Assert.fail("Attempted to evaluate an expression of form P /\\ Q when Q was\n" + arg2.getKindString() + ".\n" + String.valueOf(expr), expr, c);
                    }
                    return arg2;
                }
                return BoolValue.ValFalse;
            }
            case 37: {
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                if (!(arg1 instanceof BoolValue)) {
                    Assert.fail("Attempted to evaluate an expression of form P \\/ Q when P was\n" + arg1.getKindString() + ".\n" + String.valueOf(expr), expr, c);
                }
                if (((BoolValue)arg1).val) {
                    return BoolValue.ValTrue;
                }
                Value arg2 = this.eval(args[1], c, s0, s1, control, cm);
                if (!(arg2 instanceof BoolValue)) {
                    Assert.fail("Attempted to evaluate an expression of form P \\/ Q when Q was\n" + arg2.getKindString() + ".\n" + String.valueOf(expr), expr, c);
                }
                return arg2;
            }
            case 38: {
                Value arg2;
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                if (!(arg1 instanceof BoolValue)) {
                    Assert.fail("Attempted to evaluate an expression of form P => Q when P was\n" + arg1.getKindString() + ".\n" + String.valueOf(expr), expr, c);
                }
                if (((BoolValue)arg1).val) {
                    arg2 = this.eval(args[1], c, s0, s1, control, cm);
                    if (!(arg2 instanceof BoolValue)) {
                        Assert.fail("Attempted to evaluate an expression of form P => Q when Q was\n" + arg2.getKindString() + ".\n" + String.valueOf(expr), expr, c);
                    }
                    return arg2;
                }
                return BoolValue.ValTrue;
            }
            case 39: {
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                Value arg2 = this.eval(args[1], c, s0, s1, control, cm);
                if (!(arg1 instanceof BoolValue) || !(arg2 instanceof BoolValue)) {
                    Assert.fail("Attempted to evaluate an expression of form P <=> Q when P or Q was not a boolean.\n" + String.valueOf(expr), expr, c);
                }
                BoolValue bval1 = (BoolValue)arg1;
                BoolValue bval2 = (BoolValue)arg2;
                return bval1.val == bval2.val ? BoolValue.ValTrue : BoolValue.ValFalse;
            }
            case 40: {
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                Value arg2 = this.eval(args[1], c, s0, s1, control, cm);
                return arg1.equals(arg2) ? BoolValue.ValFalse : BoolValue.ValTrue;
            }
            case 41: {
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                Value arg2 = this.eval(args[1], c, s0, s1, control, cm);
                if (!(arg1 instanceof Enumerable)) {
                    Assert.fail("Attempted to evaluate an expression of form S \\subseteq T, but S was not enumerable.\n" + String.valueOf(expr), expr, c);
                }
                return ((Enumerable)((Object)arg1)).isSubsetEq(arg2);
            }
            case 42: {
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                Value arg2 = this.eval(args[1], c, s0, s1, control, cm);
                return arg2.member(arg1) ? BoolValue.ValTrue : BoolValue.ValFalse;
            }
            case 43: {
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                Value arg2 = this.eval(args[1], c, s0, s1, control, cm);
                return arg2.member(arg1) ? BoolValue.ValFalse : BoolValue.ValTrue;
            }
            case 44: {
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                Value arg2 = this.eval(args[1], c, s0, s1, control, cm);
                if (arg1 instanceof Reducible) {
                    return this.setSource(expr, ((Reducible)((Object)arg1)).diff(arg2));
                }
                return this.setSource(expr, new SetDiffValue(arg1, arg2));
            }
            case 45: {
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                Value arg2 = this.eval(args[1], c, s0, s1, control, cm);
                if (arg1 instanceof Reducible) {
                    return this.setSource(expr, ((Reducible)((Object)arg1)).cap(arg2));
                }
                if (arg2 instanceof Reducible) {
                    return this.setSource(expr, ((Reducible)((Object)arg2)).cap(arg1));
                }
                return this.setSource(expr, new SetCapValue(arg1, arg2));
            }
            case 46: {
                return this.eval(args[0], c, s0, s1, control, cm);
            }
            case 47: {
                Value arg1 = this.eval(args[0], c, s0, s1, control, cm);
                Value arg2 = this.eval(args[1], c, s0, s1, control, cm);
                if (arg1 instanceof Reducible) {
                    return this.setSource(expr, ((Reducible)((Object)arg1)).cup(arg2));
                }
                if (arg2 instanceof Reducible) {
                    return this.setSource(expr, ((Reducible)((Object)arg2)).cup(arg1));
                }
                return this.setSource(expr, new SetCupValue(arg1, arg2, cm));
            }
            case 48: {
                return this.eval(args[0], c, s1, TLCState.Null, EvalControl.setPrimedIfEnabled(control), cm);
            }
            case 49: {
                Value v0 = this.eval(args[0], c, s0, TLCState.Empty, control, cm);
                Value v1 = this.eval(args[0], c, s1, TLCState.Null, EvalControl.setPrimedIfEnabled(control), cm);
                return v0.equals(v1) ? BoolValue.ValTrue : BoolValue.ValFalse;
            }
            case 50: {
                Value v1;
                Value res = this.eval(args[0], c, s0, s1, control, cm);
                if (!(res instanceof BoolValue)) {
                    Assert.fail("Attempted to evaluate an expression of form <A>_e, but A was not a boolean.\n" + String.valueOf(expr), expr, c);
                }
                if (!((BoolValue)res).val) {
                    return BoolValue.ValFalse;
                }
                Value v0 = this.eval(args[1], c, s0, TLCState.Empty, control, cm);
                return v0.equals(v1 = this.eval(args[1], c, s1, TLCState.Null, EvalControl.setPrimedIfEnabled(control), cm)) ? BoolValue.ValFalse : BoolValue.ValTrue;
            }
            case 51: {
                Value v1;
                Value res = this.eval(args[0], c, s0, s1, control, cm);
                if (!(res instanceof BoolValue)) {
                    Assert.fail("Attempted to evaluate an expression of form [A]_e, but A was not a boolean.\n" + String.valueOf(expr), expr, c);
                }
                if (((BoolValue)res).val) {
                    return BoolValue.ValTrue;
                }
                Value v0 = this.eval(args[1], c, s0, TLCState.Empty, control, cm);
                return v0.equals(v1 = this.eval(args[1], c, s1, TLCState.Null, EvalControl.setPrimedIfEnabled(control), cm)) ? BoolValue.ValTrue : BoolValue.ValFalse;
            }
            case 52: {
                if (Boolean.getBoolean(CDOT_KEY)) {
                    TLCState t = TLCState.Empty.createEmpty();
                    StateVec iss = new StateVec(0);
                    this.getNextStates(Action.UNKNOWN, args[0], ActionItemList.Empty, c, s0, t, iss, cm);
                    int sz = iss.size();
                    int i = 0;
                    while (i < sz) {
                        t = iss.elementAt(i);
                        Value res = this.eval(args[1], c, t, s1, control, cm);
                        if (((BoolValue)res).val) {
                            return BoolValue.ValTrue;
                        }
                        ++i;
                    }
                    return BoolValue.ValFalse;
                }
                Assert.fail("The current version of TLC does not support action composition.  An incomplete implementation can be enabled via the tlc2.tool.impl.Tool.cdot=true java property.", expr, c);
                return null;
            }
            case 53: {
                Assert.fail(2261, new String[]{"SF", expr.toString()}, (SemanticNode)expr, c);
                return null;
            }
            case 54: {
                Assert.fail(2261, new String[]{"WF", expr.toString()}, (SemanticNode)expr, c);
                return null;
            }
            case 55: {
                Assert.fail(2261, new String[]{"\\EE", expr.toString()}, (SemanticNode)expr, c);
                return null;
            }
            case 56: {
                Assert.fail(2261, new String[]{"\\AA", expr.toString()}, (SemanticNode)expr, c);
                return null;
            }
            case 57: {
                Assert.fail(2261, new String[]{"a ~> b", expr.toString()}, (SemanticNode)expr, c);
                return null;
            }
            case 58: {
                Assert.fail(2261, new String[]{"a -+-> formula", expr.toString()}, (SemanticNode)expr, c);
                return null;
            }
            case 59: {
                Assert.fail(2261, new String[]{"[]A", expr.toString()}, (SemanticNode)expr, c);
                return null;
            }
            case 60: {
                Assert.fail(2261, new String[]{"<>A", expr.toString()}, (SemanticNode)expr, c);
                return null;
            }
        }
        Assert.fail("TLC BUG: could not evaluate this expression.\n" + String.valueOf(expr), expr, c);
        return null;
    }

    protected abstract Value setSource(SemanticNode var1, Value var2);

    @Override
    public final boolean isGoodState(TLCState state) {
        return state.allAssigned();
    }

    @Override
    public final boolean isInModel(TLCState state) throws EvalException {
        ExprNode[] constrs = this.getModelConstraints();
        int i = 0;
        while (i < constrs.length) {
            if (!this.isInModel(constrs[i], state)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public final boolean isInModel(ExprNode constraint, TLCState state) throws EvalException {
        CostModel cm = coverage ? ((Action)constraint.getToolObject((int)Tool.toolId)).cm : CostModel.DO_NOT_RECORD;
        IValue bval = this.eval(constraint, tlc2.util.Context.Empty, state, cm);
        if (!(bval instanceof BoolValue)) {
            Assert.fail(2215, new String[]{"boolean", constraint.toString()}, constraint);
        }
        if (!((BoolValue)bval).val) {
            if (coverage) {
                cm.incInvocations();
            }
            return false;
        }
        if (coverage) {
            cm.incSecondary();
        }
        return true;
    }

    @Override
    public final boolean isInActions(TLCState s1, TLCState s2) throws EvalException {
        ExprNode[] constrs = this.getActionConstraints();
        int i = 0;
        while (i < constrs.length) {
            if (!this.isInActions(constrs[i], s1, s2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public final boolean isInActions(ExprNode constraint, TLCState s1, TLCState s2) throws EvalException {
        CostModel cm = coverage ? ((Action)constraint.getToolObject((int)Tool.toolId)).cm : CostModel.DO_NOT_RECORD;
        Value bval = this.eval(constraint, tlc2.util.Context.Empty, s1, s2, 0, cm);
        if (!(bval instanceof BoolValue)) {
            Assert.fail(2215, new String[]{"boolean", constraint.toString()}, constraint);
        }
        if (!((BoolValue)bval).val) {
            if (coverage) {
                cm.incInvocations();
            }
            return false;
        }
        if (coverage) {
            cm.incSecondary();
        }
        return true;
    }

    @Override
    public final double evalReward(TLCState s1, TLCState s2, double fallback) throws EvalException {
        ExprNode constrs = this.getRLReward();
        if (constrs != null) {
            Value bval = this.eval(constrs, tlc2.util.Context.Empty, s1, s2, 0, CostModel.DO_NOT_RECORD);
            if (!(bval instanceof IntValue)) {
                Assert.fail(2215, new String[]{"integer", constrs.toString()}, constrs);
            }
            return (double)((IntValue)bval).val * 1.0;
        }
        return fallback;
    }

    @Override
    public final boolean hasStateOrActionConstraints() {
        return this.getModelConstraints().length > 0 || this.getActionConstraints().length > 0;
    }

    @Override
    public final TLCState enabled(SemanticNode pred, tlc2.util.Context c, TLCState s0, TLCState s1) {
        return this.enabled(pred, ActionItemList.Empty, c, s0, s1, CostModel.DO_NOT_RECORD);
    }

    @Override
    public final TLCState enabled(SemanticNode pred, tlc2.util.Context c, TLCState s0, TLCState s1, ExprNode subscript, int ail) {
        ActionItemList acts = (ActionItemList)ActionItemList.Empty.cons(subscript, c, CostModel.DO_NOT_RECORD, ail);
        return this.enabled(pred, acts, c, s0, s1, CostModel.DO_NOT_RECORD);
    }

    @Override
    public final TLCState enabled(SemanticNode pred, IActionItemList acts, tlc2.util.Context c, TLCState s0, TLCState s1) {
        return this.enabled(pred, acts, c, s0, s1, CostModel.DO_NOT_RECORD);
    }

    @Override
    public abstract TLCState enabled(SemanticNode var1, IActionItemList var2, tlc2.util.Context var3, TLCState var4, TLCState var5, CostModel var6);

    protected final TLCState enabledImpl(SemanticNode pred, ActionItemList acts, tlc2.util.Context c, TLCState s0, TLCState s1, CostModel cm) {
        switch (pred.getKind()) {
            case 9: {
                OpApplNode pred1 = (OpApplNode)pred;
                return this.enabledAppl(pred1, acts, c, s0, s1, cm);
            }
            case 10: {
                LetInNode pred1 = (LetInNode)pred;
                OpDefNode[] letDefs = pred1.getLets();
                tlc2.util.Context c1 = c;
                int i = 0;
                while (i < letDefs.length) {
                    OpDefNode opDef = letDefs[i];
                    if (opDef.getArity() == 0) {
                        LazyValue rhs = new LazyValue(opDef.getBody(), c1, cm);
                        c1 = c1.cons(opDef, rhs);
                    }
                    ++i;
                }
                return this.enabled((SemanticNode)pred1.getBody(), acts, c1, s0, s1, cm);
            }
            case 13: {
                SubstInNode pred1 = (SubstInNode)pred;
                Subst[] subs = pred1.getSubsts();
                int slen = subs.length;
                tlc2.util.Context c1 = c;
                int i = 0;
                while (i < slen) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, false, coverage ? sub.getCM() : cm, toolId));
                    ++i;
                }
                return this.enabled((SemanticNode)pred1.getBody(), acts, c1, s0, s1, cm);
            }
            case 30: {
                APSubstInNode pred1 = (APSubstInNode)pred;
                Subst[] subs = pred1.getSubsts();
                int slen = subs.length;
                tlc2.util.Context c1 = c;
                int i = 0;
                while (i < slen) {
                    Subst sub = subs[i];
                    c1 = c1.cons(sub.getOp(), this.getVal(sub.getExpr(), c, false, cm, toolId));
                    ++i;
                }
                return this.enabled((SemanticNode)pred1.getBody(), acts, c1, s0, s1, cm);
            }
            case 29: {
                LabelNode pred1 = (LabelNode)pred;
                return this.enabled((SemanticNode)pred1.getBody(), acts, c, s0, s1, cm);
            }
        }
        Assert.fail("Attempted to compute ENABLED on a non-boolean expression.\n" + String.valueOf(pred), pred, c);
        return null;
    }

    private final TLCState enabled(ActionItemList acts, TLCState s0, TLCState s1, CostModel cm) {
        Value v2;
        if (acts.isEmpty()) {
            return s1;
        }
        int kind = acts.carKind();
        SemanticNode pred = acts.carPred();
        tlc2.util.Context c = acts.carContext();
        cm = acts.cm;
        ActionItemList acts1 = acts.cdr();
        if (kind > 0) {
            TLCState res = this.enabled(pred, acts1, c, s0, s1, cm);
            return res;
        }
        if (kind == -1) {
            TLCState res = this.enabled(pred, acts1, c, s0, s1, cm);
            return res;
        }
        if (kind == -2) {
            TLCState res = this.enabledUnchanged(pred, acts1, c, s0, s1, cm);
            return res;
        }
        Value v1 = this.eval(pred, c, s0, TLCState.Empty, 4, cm);
        if (v1.equals(v2 = this.eval(pred, c, s1, TLCState.Null, 2, cm))) {
            return null;
        }
        TLCState res = this.enabled(acts1, s0, s1, cm);
        return res;
    }

    protected abstract TLCState enabledAppl(OpApplNode var1, ActionItemList var2, tlc2.util.Context var3, TLCState var4, TLCState var5, CostModel var6);

    protected final TLCState enabledApplImpl(OpApplNode pred, ActionItemList acts, tlc2.util.Context c, TLCState s0, TLCState s1, CostModel cm) {
        Value bval;
        Object bval2;
        if (coverage) {
            cm = cm.get(pred);
        }
        ExprOrOpArgNode[] args = pred.getArgs();
        int alen = args.length;
        SymbolNode opNode = pred.getOperator();
        int opcode = BuiltInOPs.getOpCode(opNode.getName());
        if (opcode == 0) {
            SymbolNode opDef;
            Object val = this.lookup(opNode, c, s0, false);
            if (val instanceof OpDefNode && (opcode = BuiltInOPs.getOpCode((opDef = (OpDefNode)val).getName())) == 0) {
                tlc2.util.Context c1 = this.getOpContext((OpDefNode)opDef, args, c, true, cm, toolId);
                return this.enabled((SemanticNode)((OpDefNode)opDef).getBody(), acts, c1, s0, s1, cm);
            }
            if (val instanceof ThmOrAssumpDefNode) {
                opDef = (ThmOrAssumpDefNode)val;
                tlc2.util.Context c1 = this.getOpContext((ThmOrAssumpDefNode)opDef, args, c, true);
                return this.enabled((SemanticNode)((ThmOrAssumpDefNode)opDef).getBody(), acts, c1, s0, s1, cm);
            }
            if (val instanceof LazyValue) {
                LazyValue lv = (LazyValue)val;
                return this.enabled(lv.expr, acts, lv.con, s0, s1, lv.cm);
            }
            bval2 = val;
            if (val instanceof OpValue) {
                bval2 = ((OpValue)val).eval(this, args, c, s0, s1, 4, cm);
            }
            if (opcode == 0) {
                if (!(bval2 instanceof BoolValue)) {
                    Assert.fail(2247, new String[]{"ENABLED", "boolean", bval2.toString(), pred.toString()}, (SemanticNode)pred, c);
                }
                if (((BoolValue)bval2).val) {
                    return this.enabled(acts, s0, s1, cm);
                }
                return null;
            }
        }
        switch (opcode) {
            case 50: {
                ActionItemList acts1 = (ActionItemList)acts.cons(args[1], c, cm, -3);
                return this.enabled((SemanticNode)args[0], acts1, c, s0, s1, cm);
            }
            case 2: {
                tlc2.util.Context c1;
                ExprOrOpArgNode body = args[0];
                ContextEnumerator Enum2 = this.contexts(pred, c, s0, s1, 4, cm);
                while ((c1 = Enum2.nextElement()) != null) {
                    TLCState s2 = this.enabled((SemanticNode)body, acts, c1, s0, s1, cm);
                    if (s2 == null) continue;
                    return s2;
                }
                return null;
            }
            case 3: {
                tlc2.util.Context c2;
                ExprOrOpArgNode body = args[0];
                ContextEnumerator Enum2 = this.contexts(pred, c, s0, s1, 4, cm);
                tlc2.util.Context c1 = Enum2.nextElement();
                if (c1 == null) {
                    return this.enabled(acts, s0, s1, cm);
                }
                ActionItemList acts1 = acts;
                while ((c2 = Enum2.nextElement()) != null) {
                    acts1 = (ActionItemList)acts1.cons(body, c2, cm, -1);
                }
                return this.enabled((SemanticNode)body, acts1, c1, s0, s1, cm);
            }
            case 4: {
                ExprOrOpArgNode other = null;
                int i = 0;
                while (i < alen) {
                    OpApplNode pair2 = (OpApplNode)args[i];
                    ExprOrOpArgNode[] pairArgs = pair2.getArgs();
                    if (pairArgs[0] == null) {
                        other = pairArgs[1];
                    } else {
                        Value bval3 = this.eval(pairArgs[0], c, s0, s1, 4, cm);
                        if (!(bval3 instanceof BoolValue)) {
                            Assert.fail("In computing ENABLED, a non-boolean expression(" + bval3.getKindString() + ") was used as a guard condition of a CASE.\n" + String.valueOf(pairArgs[1]), pairArgs[1], c);
                        }
                        if (((BoolValue)bval3).val) {
                            return this.enabled((SemanticNode)pairArgs[1], acts, c, s0, s1, cm);
                        }
                    }
                    ++i;
                }
                if (other == null) {
                    Assert.fail("In computing ENABLED, TLC encountered a CASE with no conditions true.\n" + String.valueOf(pred), pred, c);
                }
                return this.enabled(other, acts, c, s0, s1, cm);
            }
            case 6: 
            case 36: {
                ActionItemList acts1 = acts;
                int i = alen - 1;
                while (i > 0) {
                    acts1 = (ActionItemList)acts1.cons(args[i], c, cm, i);
                    --i;
                }
                return this.enabled((SemanticNode)args[0], acts1, c, s0, s1, cm);
            }
            case 7: 
            case 37: {
                int i = 0;
                while (i < alen) {
                    TLCState s2 = this.enabled((SemanticNode)args[i], acts, c, s0, s1, cm);
                    if (s2 != null) {
                        return s2;
                    }
                    ++i;
                }
                return null;
            }
            case 9: {
                FunctionValue fcn;
                Value fval = this.eval(args[0], c, s0, s1, EvalControl.setKeepLazy(4), cm);
                if (fval instanceof FcnLambdaValue) {
                    fcn = (FcnLambdaValue)fval;
                    if (((FcnLambdaValue)fcn).fcnRcd == null) {
                        tlc2.util.Context c1 = this.getFcnContext((IFcnLambdaValue)((Object)fcn), args, c, s0, s1, 4, cm);
                        return this.enabled(((FcnLambdaValue)fcn).body, acts, c1, s0, s1, cm);
                    }
                    fval = ((FcnLambdaValue)fcn).fcnRcd;
                }
                if (fval instanceof FunctionValue) {
                    fcn = (FunctionValue)((Object)fval);
                    Value argVal = this.eval(args[1], c, s0, s1, 4, cm);
                    Value bval4 = fcn.apply(argVal, 4);
                    if (!(bval4 instanceof BoolValue)) {
                        Assert.fail(2248, new String[]{"ENABLED", "boolean", pred.toString()}, (SemanticNode)args[1], c);
                    }
                    if (!((BoolValue)bval4).val) {
                        return null;
                    }
                } else {
                    Assert.fail("In computing ENABLED, a non-function (" + fval.getKindString() + ") was applied as a function.\n" + String.valueOf(pred), pred, c);
                }
                return this.enabled(acts, s0, s1, cm);
            }
            case 11: {
                Value guard = this.eval(args[0], c, s0, s1, 4, cm);
                if (!(guard instanceof BoolValue)) {
                    Assert.fail("In computing ENABLED, a non-boolean expression(" + guard.getKindString() + ") was used as the guard condition of an IF.\n" + String.valueOf(pred), pred, c);
                }
                int idx = ((BoolValue)guard).val ? 1 : 2;
                return this.enabled((SemanticNode)args[idx], acts, c, s0, s1, cm);
            }
            case 51: {
                TLCState s2 = this.enabled((SemanticNode)args[0], acts, c, s0, s1, cm);
                if (s2 != null) {
                    return s2;
                }
                return this.enabledUnchanged(args[1], acts, c, s0, s1, cm);
            }
            case 55: 
            case 56: {
                Assert.fail("In computing ENABLED, TLC encountered temporal quantifier.\n" + String.valueOf(pred), pred, c);
                return null;
            }
            case 24: {
                Assert.fail("In computing ENABLED, TLC encountered unbounded CHOOSE. Make sure that the expression is of form CHOOSE x \\in S: P(x).\n" + String.valueOf(pred), pred, c);
                return null;
            }
            case 25: {
                Assert.fail("In computing ENABLED, TLC encountered unbounded quantifier. Make sure that the expression is of form \\E x \\in S: P(x).\n" + String.valueOf(pred), pred, c);
                return null;
            }
            case 26: {
                Assert.fail("In computing ENABLED, TLC encountered unbounded quantifier. Make sure that the expression is of form \\A x \\in S: P(x).\n" + String.valueOf(pred), pred, c);
                return null;
            }
            case 53: {
                Assert.fail(2260, new String[]{"SF", pred.toString()}, (SemanticNode)pred, c);
                return null;
            }
            case 54: {
                Assert.fail(2260, new String[]{"WF", pred.toString()}, (SemanticNode)pred, c);
                return null;
            }
            case 59: {
                Assert.fail(2260, new String[]{"[]", pred.toString()}, (SemanticNode)pred, c);
                return null;
            }
            case 60: {
                Assert.fail(2260, new String[]{"<>", pred.toString()}, (SemanticNode)pred, c);
                return null;
            }
            case 49: {
                return this.enabledUnchanged(args[0], acts, c, s0, s1, cm);
            }
            case 35: {
                UniqueString varName;
                SymbolNode var = this.getPrimedVar(args[0], c, true);
                if (var == null) {
                    bval2 = this.eval(pred, c, s0, s1, 4, cm);
                    if (!((BoolValue)bval2).val) {
                        return null;
                    }
                } else {
                    varName = var.getName();
                    IValue lval = s1.lookup(varName);
                    Value rval = this.eval(args[1], c, s0, s1, 4, cm);
                    if (lval == null) {
                        TLCState s2 = s1.bind(var, (IValue)rval);
                        return this.enabled(acts, s0, s2, cm);
                    }
                    if (!lval.equals(rval)) {
                        return null;
                    }
                }
                return this.enabled(acts, s0, s1, cm);
            }
            case 38: {
                bval = this.eval(args[0], c, s0, s1, 4, cm);
                if (!(bval instanceof BoolValue)) {
                    Assert.fail("While computing ENABLED of an expression of the form P => Q, P was " + bval.getKindString() + ".\n" + String.valueOf(pred), pred, c);
                }
                if (((BoolValue)bval).val) {
                    return this.enabled((SemanticNode)args[1], acts, c, s0, s1, cm);
                }
                return this.enabled(acts, s0, s1, cm);
            }
            case 52: {
                if (Boolean.getBoolean(CDOT_KEY)) {
                    TLCState t = s0.copyWith(s1);
                    StateVec iss = new StateVec(0);
                    this.getNextStates(Action.UNKNOWN, args[0], ActionItemList.Empty, c, s0, t, iss, cm);
                    int sz = iss.size();
                    int i = 0;
                    while (i < sz) {
                        t = iss.elementAt(i);
                        TLCState s2 = this.enabled((SemanticNode)args[1], acts, c, t, s1, cm);
                        if (s2 != null) {
                            return s2;
                        }
                        ++i;
                    }
                    return null;
                }
                Assert.fail("The current version of TLC does not support action composition.  An incomplete implementation can be enabled via the tlc2.tool.impl.Tool.cdot=true java property.", pred, c);
                return null;
            }
            case 57: {
                Assert.fail("In computing ENABLED, TLC encountered a temporal formula (a ~> b).\n" + String.valueOf(pred), pred, c);
                return null;
            }
            case 58: {
                Assert.fail("In computing ENABLED, TLC encountered a temporal formula (a -+-> formula).\n" + String.valueOf(pred), pred, c);
                return null;
            }
            case 42: {
                UniqueString varName;
                SymbolNode var = this.getPrimedVar(args[0], c, true);
                if (var == null) {
                    bval2 = this.eval(pred, c, s0, s1, 4, cm);
                    if (!((BoolValue)bval2).val) {
                        return null;
                    }
                } else {
                    varName = var.getName();
                    Value lval = (Value)s1.lookup(varName);
                    Value rval = this.eval(args[1], c, s0, s1, 4, cm);
                    if (lval == null) {
                        Value val;
                        if (!(rval instanceof Enumerable)) {
                            Assert.fail("The right side of \\IN is not enumerable.\n" + String.valueOf(pred), pred, c);
                        }
                        ValueEnumeration Enum3 = ((Enumerable)((Object)rval)).elements();
                        while ((val = Enum3.nextElement()) != null) {
                            TLCState s2 = s1.bind(var, (IValue)val);
                            if ((s2 = this.enabled(acts, s0, s2, cm)) == null) continue;
                            return s2;
                        }
                        return null;
                    }
                    if (!rval.member(lval)) {
                        return null;
                    }
                }
                return this.enabled(acts, s0, s1, cm);
            }
            case 46: {
                return this.enabled((SemanticNode)args[0], acts, c, s0, s1, cm);
            }
        }
        bval = this.eval(pred, c, s0, s1, 4, cm);
        if (!(bval instanceof BoolValue)) {
            Assert.fail(2247, new String[]{"ENABLED", "boolean", bval.toString(), pred.toString()}, (SemanticNode)pred, c);
        }
        if (((BoolValue)bval).val) {
            return this.enabled(acts, s0, s1, cm);
        }
        return null;
    }

    protected abstract TLCState enabledUnchanged(SemanticNode var1, ActionItemList var2, tlc2.util.Context var3, TLCState var4, TLCState var5, CostModel var6);

    protected final TLCState enabledUnchangedImpl(SemanticNode expr, ActionItemList acts, tlc2.util.Context c, TLCState s0, TLCState s1, CostModel cm) {
        Value v1;
        Value v0;
        SymbolNode var;
        if (coverage) {
            cm = cm.get(expr);
        }
        if ((var = this.getVar(expr, c, true, toolId)) != null) {
            UniqueString varName = var.getName();
            Value v02 = this.eval(expr, c, s0, s1, 4, cm);
            IValue v12 = s1.lookup(varName);
            if (v12 == null) {
                s1 = s1.bind(var, (IValue)v02);
                return this.enabled(acts, s0, s1, cm);
            }
            if (v12.equals(v02)) {
                return this.enabled(acts, s0, s1, cm);
            }
            MP.printWarning(2143, varName.toString(), expr.toString());
            return null;
        }
        if (expr instanceof OpApplNode) {
            OpApplNode expr1 = (OpApplNode)expr;
            ExprOrOpArgNode[] args = expr1.getArgs();
            int alen = args.length;
            SymbolNode opNode = expr1.getOperator();
            UniqueString opName = opNode.getName();
            int opcode = BuiltInOPs.getOpCode(opName);
            if (opcode == 23) {
                if (alen != 0) {
                    ActionItemList acts1 = acts;
                    int i = 1;
                    while (i < alen) {
                        acts1 = (ActionItemList)acts1.cons(args[i], c, cm, -2);
                        ++i;
                    }
                    return this.enabledUnchanged(args[0], acts1, c, s0, s1, cm);
                }
                return this.enabled(acts, s0, s1, cm);
            }
            if (opcode == 0 && alen == 0) {
                Object val = this.lookup(opNode, c, false);
                if (val instanceof LazyValue) {
                    LazyValue lv = (LazyValue)val;
                    return this.enabledUnchanged(lv.expr, acts, lv.con, s0, s1, cm);
                }
                if (val instanceof OpDefNode) {
                    return this.enabledUnchanged(((OpDefNode)val).getBody(), acts, c, s0, s1, cm);
                }
                if (val == null) {
                    Assert.fail("In computing ENABLED, TLC found the undefined identifier\n" + String.valueOf(opName) + " in an UNCHANGED expression at\n" + String.valueOf(expr), expr, c);
                }
                return this.enabled(acts, s0, s1, cm);
            }
        }
        if (!(v0 = this.eval(expr, c, s0, TLCState.Empty, 4, cm)).equals(v1 = this.eval(expr, c, s1, TLCState.Empty, 2, cm))) {
            return null;
        }
        return this.enabled(acts, s0, s1, cm);
    }

    @Override
    public final boolean isValid(Action act, TLCState s0, TLCState s1) {
        Value val = this.eval(act.pred, act.con, s0, s1, 0, act.cm);
        if (!(val instanceof BoolValue)) {
            Assert.fail(2215, new String[]{"boolean", act.pred.toString()}, act.pred, act.con);
        }
        return ((BoolValue)val).val;
    }

    @Override
    public boolean isValid(Action act, TLCState state) {
        return this.isValid(act, state, TLCState.Empty);
    }

    @Override
    public final boolean isValid(Action act) {
        return this.isValid(act, TLCState.Empty, TLCState.Empty);
    }

    @Override
    public boolean isValid(ExprNode expr, tlc2.util.Context ctxt) {
        Value val = this.eval(expr, ctxt, TLCState.Empty, TLCState.Empty, 16, CostModel.DO_NOT_RECORD);
        if (!(val instanceof BoolValue)) {
            Assert.fail(2215, new String[]{"boolean", expr.toString()}, expr);
        }
        return ((BoolValue)val).val;
    }

    @Override
    public final boolean isValid(ExprNode expr) {
        return this.isValid(expr, tlc2.util.Context.Empty);
    }

    public boolean isValidAssumption(ExprNode assumption) {
        return this.isValid(assumption);
    }

    @Override
    public final int checkAssumptions() {
        ExprNode[] assumps = this.getAssumptions();
        boolean[] isAxiom = this.getAssumptionIsAxiom();
        int i = 0;
        while (i < assumps.length) {
            try {
                if (!isAxiom[i] && !this.isValidAssumption(assumps[i])) {
                    return MP.printError(2104, assumps[i].toString());
                }
            }
            catch (Exception e) {
                return MP.printError(2105, new String[]{assumps[i].toString(), e.getMessage()});
            }
            ++i;
        }
        return 0;
    }

    @Override
    public final int checkPostCondition() {
        return this.checkPostConditionWithContext(tlc2.util.Context.Empty);
    }

    @Override
    public final int checkPostConditionWithCounterExample(IValue value) {
        OpDefNode def = this.getCounterExampleDef();
        if (def == null) {
            return this.checkPostCondition();
        }
        tlc2.util.Context ctxt = tlc2.util.Context.Empty.cons(def, value);
        return this.checkPostConditionWithContext(ctxt);
    }

    private final int checkPostConditionWithContext(tlc2.util.Context ctxt) {
        ExprNode[] postConditions = this.getPostConditionSpecs();
        int i = 0;
        while (i < postConditions.length) {
            ExprNode en = postConditions[i];
            try {
                if (!this.isValid(en, ctxt)) {
                    return MP.printError(2104, en.toString());
                }
            }
            catch (Exception e) {
                return MP.printError(2105, new String[]{en.toString(), e.getMessage()});
            }
            ++i;
        }
        return 0;
    }

    @Override
    public final TLCStateInfo getState(long fp) {
        class InitStateSelectorFunctor
        implements IStateFunctor {
            private final long fp;
            public TLCState state;

            public InitStateSelectorFunctor(long fp) {
                this.fp = fp;
            }

            @Override
            public Object addElement(TLCState state) {
                if (state == null) {
                    return null;
                }
                if (this.state != null) {
                    return null;
                }
                if (this.fp == state.fingerPrint()) {
                    this.state = state;
                }
                return null;
            }
        }
        InitStateSelectorFunctor functor = new InitStateSelectorFunctor(fp);
        this.getInitStates(functor);
        TLCState state = functor.state;
        if (state != null) {
            assert (state.isInitial());
            TLCStateInfo info = new TLCStateInfo(state);
            info.fp = fp;
            return info;
        }
        return null;
    }

    @Override
    public final TLCStateInfo getState(long fp, TLCStateInfo sinfo) {
        TLCStateInfo tlcStateInfo = this.getState(fp, sinfo.state);
        if (tlcStateInfo == null) {
            throw new EvalException(2117);
        }
        tlcStateInfo.stateNumber = sinfo.stateNumber + 1L;
        tlcStateInfo.fp = fp;
        return tlcStateInfo;
    }

    @Override
    public final TLCStateInfo getState(long fp, TLCState s) {
        IdThread.setCurrentState(s);
        int i = 0;
        while (i < this.actions.length) {
            Action curAction = this.actions[i];
            StateVec nextStates = this.getNextStates(curAction, s);
            int j = 0;
            while (j < nextStates.size()) {
                TLCState state = nextStates.elementAt(j);
                long nfp = state.fingerPrint();
                if (fp == nfp) {
                    state.setPredecessor(s);
                    assert (!state.isInitial());
                    return new TLCStateInfo(state, curAction);
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    @Override
    public final TLCStateInfo getState(TLCState s1, TLCState s) {
        IdThread.setCurrentState(s);
        int i = 0;
        while (i < this.actions.length) {
            Action curAction = this.actions[i];
            StateVec nextStates = this.getNextStates(curAction, s);
            int j = 0;
            while (j < nextStates.size()) {
                TLCState state = nextStates.elementAt(j);
                try {
                    if (s1.equals(state)) {
                        state.setPredecessor(s);
                        assert (!state.isInitial());
                        return new TLCStateInfo(state, curAction);
                    }
                }
                catch (Assert.TLCRuntimeException tLCRuntimeException) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    @Override
    public final IMVPerm[] getSymmetryPerms() {
        IMVPerm[] subgroup;
        OpDefNode opDef;
        IValue fcns;
        String name = this.config.getSymmetry();
        if (name.length() == 0) {
            return null;
        }
        Object symm = this.unprocessedDefns.get(name);
        if (symm == null) {
            Assert.fail(2229, new String[]{"symmetry function", name});
        }
        if (!(symm instanceof OpDefNode)) {
            Assert.fail("The symmetry function " + name + " must specify a set of permutations.");
        }
        if (!((fcns = this.eval((opDef = (OpDefNode)symm).getBody(), tlc2.util.Context.Empty, TLCState.Empty, CostModel.DO_NOT_RECORD)) instanceof Enumerable) || !(fcns instanceof SetEnumValue)) {
            Assert.fail("The symmetry operator must specify a set of functions.", opDef.getBody());
        }
        List<Value> values = ((SetEnumValue)fcns).elements().all();
        for (Value v : values) {
            if (v instanceof FcnRcdValue) continue;
            Assert.fail("The symmetry values must be function records.", opDef.getBody());
        }
        ExprOrOpArgNode[] argNodes = ((OpApplNode)opDef.getBody()).getArgs();
        StringBuilder cardinalityOneSetList = new StringBuilder();
        int offenderCount = 0;
        if (argNodes.length >= values.size()) {
            ExprOrOpArgNode[] exprOrOpArgNodeArray = argNodes;
            int n = argNodes.length;
            int n2 = 0;
            while (n2 < n) {
                ExprOrOpArgNode node = exprOrOpArgNodeArray[n2];
                this.addToSubTwoSizedSymmetrySetList(node, cardinalityOneSetList);
                ++offenderCount;
                ++n2;
            }
        }
        if (offenderCount == 0) {
            subgroup = MVPerms.permutationSubgroup((Enumerable)fcns);
            HashSet<ModelValue> subgroupMembers = new HashSet<ModelValue>();
            Object[] objectArray = subgroup;
            int n = subgroup.length;
            int n3 = 0;
            while (n3 < n) {
                IMVPerm imvp = objectArray[n3];
                if (imvp instanceof MVPerm) {
                    subgroupMembers.addAll(((MVPerm)imvp).getAllModelValues());
                }
                ++n3;
            }
            objectArray = argNodes;
            n = argNodes.length;
            n3 = 0;
            while (n3 < n) {
                Object node = objectArray[n3];
                SetEnumValue enumValue = this.getSetEnumValueFromArgumentNode((ExprOrOpArgNode)node);
                if (enumValue != null) {
                    Value v;
                    ValueEnumeration ve = enumValue.elements();
                    boolean found = false;
                    while ((v = ve.nextElement()) != null) {
                        if (!(v instanceof ModelValue) || !subgroupMembers.contains(v)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.addToSubTwoSizedSymmetrySetList((ExprOrOpArgNode)node, cardinalityOneSetList);
                        ++offenderCount;
                    }
                }
                ++n3;
            }
        } else {
            subgroup = null;
        }
        if (offenderCount > 0) {
            String plurality = offenderCount > 1 ? "s" : "";
            String antiPlurality = offenderCount > 1 ? "" : "s";
            String toHaveConjugation = offenderCount > 1 ? "have" : "has";
            MP.printWarning(2300, plurality, cardinalityOneSetList.toString(), toHaveConjugation, antiPlurality);
        }
        return subgroup;
    }

    private void addToSubTwoSizedSymmetrySetList(ExprOrOpArgNode node, StringBuilder cardinalityOneSetList) {
        String displayDefinition;
        String alias;
        SyntaxTreeNode tn = (SyntaxTreeNode)node.getTreeNode();
        String image = tn.getHumanReadableImage();
        if (image.startsWith("Permutations")) {
            int imageLength = image.length();
            alias = image.substring("Permutations".length() + 1, imageLength - 1);
        } else {
            alias = image;
        }
        String specDefinitionName = this.config.getOverridenSpecNameForConfigName(alias);
        String string = displayDefinition = specDefinitionName != null ? specDefinitionName : alias;
        if (cardinalityOneSetList.length() > 0) {
            cardinalityOneSetList.append(", and ");
        }
        cardinalityOneSetList.append(displayDefinition);
    }

    private SetEnumValue getSetEnumValueFromArgumentNode(ExprOrOpArgNode node) {
        ExprOrOpArgNode[] operands;
        OpDefNode operator;
        OpApplNode permutationNode;
        if (node instanceof OpApplNode && (permutationNode = (OpApplNode)node).getOperator() instanceof OpDefNode && "Permutations".equals((operator = (OpDefNode)permutationNode.getOperator()).getName().toString()) && (operands = permutationNode.getArgs()).length == 1 && operands[0] instanceof OpApplNode && ((OpApplNode)operands[0]).getOperator() instanceof OpDefOrDeclNode) {
            WorkerValue wv;
            Object unwrapped;
            Object o = ((OpDefOrDeclNode)((OpApplNode)operands[0]).getOperator()).getToolObject(toolId);
            if (o instanceof SetEnumValue) {
                return (SetEnumValue)o;
            }
            if (o instanceof WorkerValue && (unwrapped = WorkerValue.mux(wv = (WorkerValue)o)) instanceof SetEnumValue) {
                return (SetEnumValue)unwrapped;
            }
        }
        return null;
    }

    @Override
    public final boolean hasSymmetry() {
        if (this.config == null) {
            return false;
        }
        String name = this.config.getSymmetry();
        return name.length() > 0;
    }

    @Override
    public final tlc2.util.Context getFcnContext(IFcnLambdaValue fcn, ExprOrOpArgNode[] args, tlc2.util.Context c, TLCState s0, TLCState s1, int control) {
        return this.getFcnContext(fcn, args, c, s0, s1, control, CostModel.DO_NOT_RECORD);
    }

    @Override
    public final tlc2.util.Context getFcnContext(IFcnLambdaValue fcn, ExprOrOpArgNode[] args, tlc2.util.Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        tlc2.util.Context fcon = fcn.getCon();
        int plen = fcn.getParams().length();
        FormalParamNode[][] formals = fcn.getParams().getFormals();
        Value[] domains = (Value[])fcn.getParams().getDomains();
        boolean[] isTuples = fcn.getParams().isTuples();
        Value argVal = this.eval(args[1], c, s0, s1, control, cm);
        if (plen == 1) {
            if (!domains[0].member(argVal)) {
                Assert.fail("In applying the function\n" + Values.ppr(fcn.toString()) + ",\nthe first argument is:\n" + Values.ppr(argVal.toString()) + "which is not in its domain.\n" + String.valueOf(args[0]), args[0], c);
            }
            if (isTuples[0]) {
                FormalParamNode[] ids = formals[0];
                TupleValue tv = (TupleValue)argVal.toTuple();
                if (tv == null || argVal.size() != ids.length) {
                    Assert.fail("In applying the function\n" + Values.ppr(this.toString()) + ",\nthe argument is:\n" + Values.ppr(argVal.toString()) + "which does not match its formal parameter.\n" + String.valueOf(args[0]), args[0], c);
                }
                Value[] elems = tv.elems;
                int i = 0;
                while (i < ids.length) {
                    fcon = fcon.cons(ids[i], elems[i]);
                    ++i;
                }
            } else {
                fcon = fcon.cons(formals[0][0], argVal);
            }
        } else {
            TupleValue tv = (TupleValue)argVal.toTuple();
            if (tv == null) {
                Assert.fail("Attempted to apply a function to an argument not in its domain.\n" + String.valueOf(args[0]), args[0], c);
            }
            int argn = 0;
            Value[] elems = tv.elems;
            int i = 0;
            while (i < formals.length) {
                FormalParamNode[] ids = formals[i];
                Value domain = domains[i];
                if (isTuples[i]) {
                    TupleValue tv1;
                    if (!domain.member(elems[argn])) {
                        Assert.fail("In applying the function\n" + Values.ppr(fcn.toString()) + ",\nthe argument number " + (argn + 1) + " is:\n" + Values.ppr(elems[argn].toString()) + "\nwhich is not in its domain.\n" + String.valueOf(args[0]), args[0], c);
                    }
                    if ((tv1 = (TupleValue)elems[argn++].toTuple()) == null || tv1.size() != ids.length) {
                        Assert.fail("In applying the function\n" + Values.ppr(fcn.toString()) + ",\nthe argument number " + argn + " is:\n" + Values.ppr(elems[argn - 1].toString()) + "which does not match its formal parameter.\n" + String.valueOf(args[0]), args[0], c);
                    }
                    Value[] avals = tv1.elems;
                    int j = 0;
                    while (j < ids.length) {
                        fcon = fcon.cons(ids[j], avals[j]);
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < ids.length) {
                        if (!domain.member(elems[argn])) {
                            Assert.fail("In applying the function\n" + Values.ppr(fcn.toString()) + ",\nthe argument number " + (argn + 1) + " is:\n" + Values.ppr(elems[argn].toString()) + "which is not in its domain.\n" + String.valueOf(args[0]), args[0], c);
                        }
                        fcon = fcon.cons(ids[j], elems[argn++]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        return fcon;
    }

    @Override
    public final IContextEnumerator contexts(OpApplNode appl, tlc2.util.Context c, TLCState s0, TLCState s1, int control) {
        return this.contexts(appl, c, s0, s1, control, CostModel.DO_NOT_RECORD);
    }

    public final ContextEnumerator contexts(OpApplNode appl, tlc2.util.Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        return this.contexts(Enumerable.Ordering.NORMALIZED, appl, c, s0, s1, control, cm);
    }

    @Override
    public final ContextEnumerator contexts(Enumerable.Ordering ordering, OpApplNode appl, tlc2.util.Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        FormalParamNode[][] formals = appl.getBdedQuantSymbolLists();
        boolean[] isTuples = appl.isBdedQuantATuple();
        ExprNode[] domains = appl.getBdedQuantBounds();
        int flen = formals.length;
        int alen = 0;
        int i = 0;
        while (i < flen) {
            alen += isTuples[i] ? 1 : formals[i].length;
            ++i;
        }
        Object[] vars = new Object[alen];
        ValueEnumeration[] enums = new ValueEnumeration[alen];
        int idx = 0;
        int i2 = 0;
        while (i2 < flen) {
            Value boundSet = this.eval(domains[i2], c, s0, s1, control, cm);
            if (!(boundSet instanceof Enumerable)) {
                Assert.fail(boundSet.getNonEnumerableErrorMsg(domains[i2]), domains[i2], c);
            }
            FormalParamNode[] farg = formals[i2];
            if (isTuples[i2]) {
                vars[idx] = farg;
                enums[idx++] = ((Enumerable)((Object)boundSet)).elements(ordering);
            } else {
                int j = 0;
                while (j < farg.length) {
                    vars[idx] = farg[j];
                    enums[idx++] = ((Enumerable)((Object)boundSet)).elements(ordering);
                    ++j;
                }
            }
            ++i2;
        }
        return new ContextEnumerator(vars, enums, c);
    }

    @Override
    public tlc2.util.Context getOpContext(OpDefNode odn, ExprOrOpArgNode[] args, tlc2.util.Context ctx, boolean b) {
        return this.getOpContext(odn, args, ctx, b, toolId);
    }

    @Override
    public Object lookup(SymbolNode opNode, tlc2.util.Context con, boolean b) {
        return this.lookup(opNode, con, b, toolId);
    }

    @Override
    public Object getVal(ExprOrOpArgNode expr, tlc2.util.Context con, boolean b) {
        return this.getVal(expr, con, b, toolId);
    }

    public static boolean isProbabilistic() {
        return PROBABILISTIC;
    }

    public static enum Mode {
        Simulation,
        MC,
        MC_DEBUG,
        Executor;

    }
}

