/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import tla2sany.modanalyzer.ModulePointer;
import tla2sany.modanalyzer.ParseUnit;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.output.SanyOutput;
import tla2sany.semantic.AbortException;
import tla2sany.semantic.Errors;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.ExternalModuleTable;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tlc2.debug.TLCDebuggerExpression;
import tlc2.tool.Action;
import tlc2.tool.impl.Spec;
import tlc2.tool.impl.SpecProcessor;
import tlc2.util.Context;
import tlc2.value.impl.StringValue;
import util.FilenameToStream;

public class ParameterizedSpecObj
extends SpecObj {
    public static final String POST_CONDITIONS = "POST_CONDITIONS";
    public static final String INVARIANT = "INVARIANT";
    private final Spec spec;
    private final Map<String, Object> params;

    public ParameterizedSpecObj(Spec spec, FilenameToStream resolver, Map<String, Object> params) {
        super(spec.rootFile, resolver);
        this.spec = spec;
        this.params = params;
    }

    @Override
    protected final ParseUnit findOrCreateParsedUnit(String name, Errors errors, boolean firstCall, SanyOutput out) throws AbortException {
        ModulePointer rootModule;
        ParseUnit pu = super.findOrCreateParsedUnit(name, errors, firstCall, out);
        if (firstCall && this.params.containsKey(POST_CONDITIONS)) {
            rootModule = pu.getRootModule();
            List pcs = (List)this.params.get(POST_CONDITIONS);
            for (PostCondition pc : pcs) {
                rootModule.getRelatives().addExtendee(pc.module);
            }
        }
        if (firstCall && this.params.containsKey(INVARIANT)) {
            rootModule = pu.getRootModule();
            List invs = (List)this.params.get(INVARIANT);
            for (InvariantTemplate inv : invs) {
                inv.getModules().forEach(rootModule.getRelatives()::addExtendee);
            }
        }
        return pu;
    }

    @Override
    public List<ExprNode> getPostConditionSpecs() {
        ArrayList<ExprNode> res = new ArrayList<ExprNode>();
        List pcs = this.params.getOrDefault(POST_CONDITIONS, new ArrayList());
        for (PostCondition pc : pcs) {
            ExternalModuleTable mt = this.getExternalModuleTable();
            ModuleNode moduleNode = mt.getModuleNode(pc.module);
            OpDefNode opDef = moduleNode.getOpDef(pc.operator);
            Stream.of(moduleNode.getConstantDecls()).forEach(decl -> decl.setToolObject(this.spec.getId(), new StringValue(postCondition.constDecls.get(decl.getName().toString()))));
            res.add(opDef.getBody());
        }
        return res;
    }

    @Override
    public List<Action> getInvariants(SpecProcessor specProcessor) {
        ArrayList<Action> res = new ArrayList<Action>();
        List invs = this.params.getOrDefault(INVARIANT, new ArrayList());
        for (InvariantTemplate inv : invs) {
            res.add(inv.getAction(specProcessor));
        }
        return res;
    }

    public static abstract class InvariantTemplate {
        protected final Set<String> modules;

        public InvariantTemplate(Set<String> modules) {
            this.modules = modules;
        }

        public abstract Action getAction(SpecProcessor var1);

        public Set<String> getModules() {
            return this.modules;
        }
    }

    public static class PostCondition {
        public final String module;
        public final String operator;
        public final Map<String, String> constDecls;

        public PostCondition(String module, String operator) {
            this(module, operator, new HashMap<String, String>());
        }

        public PostCondition(String module, String operator, String def, String constDef) {
            this(module, operator);
            this.constDecls.put(def, constDef);
        }

        public PostCondition(String module, String operator, Map<String, String> constDecls) {
            this.module = module;
            this.operator = operator;
            this.constDecls = constDecls;
        }
    }

    public static class RuntimeInvariantTemplate
    extends InvariantTemplate {
        private final String expr;

        public RuntimeInvariantTemplate(String expr) {
            this(Set.of(), expr);
        }

        public RuntimeInvariantTemplate(Set<String> modules, String expr) {
            super(modules);
            this.expr = expr;
        }

        @Override
        public Action getAction(SpecProcessor spec) {
            OpDefNode opDef = TLCDebuggerExpression.process(spec, spec.getRootModule(), this.expr);
            return new Action((SemanticNode)opDef.getBody(), Context.Empty, opDef, false, true);
        }
    }
}

