/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.ToLongFunction;
import java.util.logging.Level;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.fp.DiskFPSet;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetConfiguration;
import tlc2.tool.fp.FPSetStatistic;
import tlc2.tool.fp.LongArray;
import tlc2.tool.fp.LongArrays;
import tlc2.tool.fp.NonCheckpointableDiskFPSet;
import tlc2.tool.fp.management.DiskFPSetMXWrapper;
import tlc2.util.BufferedRandomAccessFile;
import util.Assert;

public final class OffHeapDiskFPSet
extends NonCheckpointableDiskFPSet
implements FPSetStatistic {
    private static final OffHeapSynchronizer SYNC = new OffHeapSynchronizer();
    private static final int PROBE_LIMIT = Integer.getInteger(OffHeapDiskFPSet.class.getName() + ".probeLimit", 1024);
    static final long EMPTY = 0L;
    private final transient LongArray array;
    private final transient Indexer indexer;
    private int numThreads;
    private static final int FOUND = -1;

    public static boolean isSupported() {
        return LongArray.isSupported();
    }

    protected OffHeapDiskFPSet(FPSetConfiguration fpSetConfig) throws RemoteException {
        super(fpSetConfig);
        long positions = fpSetConfig.getMemoryInFingerprintCnt();
        this.array = new LongArray(positions);
        this.indexer = Long.bitCount(positions) == 1 ? new BitshiftingIndexer(positions, fpSetConfig.getFpBits()) : (Mult1024Indexer.isSupported(positions) ? new Mult1024Indexer(positions, fpSetConfig.getFpBits()) : new InfinitePrecisionIndexer(positions, fpSetConfig.getFpBits()));
        this.flusher = new OffHeapMSBFlusher(this.array);
        this.flusherChosen = SYNC.getFlusherChosen();
        SYNC.add(this);
    }

    @Override
    public FPSet init(int numThreads, String aMetadir, String filename) throws IOException {
        super.init(numThreads, aMetadir, filename);
        this.numThreads = numThreads;
        this.array.zeroMemory(numThreads);
        return this;
    }

    @Override
    public void incWorkers(int numWorkers) {
        assert (numWorkers == this.numThreads);
        SYNC.incWorkers(numWorkers);
    }

    public void evict() {
        ++this.growDiskMark;
        long timestamp = System.currentTimeMillis();
        long insertions = this.tblCnt.longValue();
        double lf = this.tblCnt.doubleValue() / (double)this.maxTblCnt;
        LOGGER.log(Level.FINE, "Started eviction of disk {0} the {1}. time at {2} after {3} insertions, load factor {4} and reprobe of {5}.", new Object[]{((DiskFPSetMXWrapper)this.diskFPSetMXWrapper).getObjectName(), this.getGrowDiskMark(), timestamp, insertions, lf, PROBE_LIMIT});
        assert (OffHeapDiskFPSet.checkInput(this.array, this.indexer, PROBE_LIMIT)) : "Table violates invariants prior to eviction: " + this.array.toString();
        this.flusher = this.getFlusher(this.numThreads, insertions);
        try {
            this.flusher.flushTable();
        }
        catch (IOException e) {
            throw new OffHeapRuntimeException(e);
        }
        long l = System.currentTimeMillis() - timestamp;
        this.flushTime += l;
        LOGGER.log(Level.FINE, "Finished eviction of disk {0} the {1}. time at {2}, in {3} sec after {4} insertions, load factor {5} and reprobe of {6}.", new Object[]{((DiskFPSetMXWrapper)this.diskFPSetMXWrapper).getObjectName(), this.getGrowDiskMark(), System.currentTimeMillis(), l, insertions, lf, PROBE_LIMIT});
    }

    private DiskFPSet.Flusher getFlusher(int numThreads, long insertions) {
        if (this.array.size() >= 8192L && Math.floor((double)this.array.size() / (double)numThreads) > (double)(2 * PROBE_LIMIT)) {
            return new ConcurrentOffHeapMSBFlusher(this.array, PROBE_LIMIT, numThreads, insertions);
        }
        return this.flusher;
    }

    private boolean checkEvictPending() {
        if (SYNC.evictPending()) {
            SYNC.awaitEviction();
            return true;
        }
        return false;
    }

    @Override
    public long sizeof() {
        long size = 44L;
        size += this.maxTblCnt * 8L;
        return size += this.getIndexCapacity() * 4L;
    }

    @Override
    protected final boolean needsDiskFlush() {
        return this.loadFactorExceeds(1.0) || this.forceFlush;
    }

    private final boolean loadFactorExceeds(double limit) {
        double d = this.tblCnt.doubleValue() / (double)this.maxTblCnt;
        return d >= limit;
    }

    @Override
    final boolean memLookup(long fp0) {
        return this.memLookup0(fp0) == -1;
    }

    final int memLookup0(long fp0) {
        int free = PROBE_LIMIT;
        int i = 0;
        while (i <= PROBE_LIMIT) {
            long position = this.indexer.getIdx(fp0, i);
            long l = this.array.get(position);
            if (fp0 == (l & Long.MAX_VALUE)) {
                return -1;
            }
            if (l == 0L) {
                return Math.min(i, free);
            }
            if (l < 0L && free == PROBE_LIMIT) {
                free = i;
            }
            ++i;
        }
        return free;
    }

    @Override
    final boolean memInsert(long fp0) throws IOException {
        return this.memInsert0(fp0, 0);
    }

    final boolean memInsert0(long fp0, int start) throws IOException {
        int i = start;
        while (i < PROBE_LIMIT) {
            long position = this.indexer.getIdx(fp0, i);
            long expected = this.array.get(position);
            if (expected == 0L || expected < 0L && fp0 != (expected & Long.MAX_VALUE)) {
                if (this.array.trySet(position, expected, fp0)) {
                    this.tblCnt.increment();
                    return false;
                }
                --i;
            } else if ((expected & Long.MAX_VALUE) == fp0) {
                return true;
            }
            ++i;
        }
        this.forceFlush();
        return this.put(fp0);
    }

    @Override
    public final boolean put(long fp) throws IOException {
        if (this.checkEvictPending()) {
            return this.put(fp);
        }
        long fp0 = fp & Long.MAX_VALUE;
        int start = 0;
        if (this.index != null) {
            start = this.memLookup0(fp0);
            if (start == -1) {
                this.memHitCnt.increment();
                return true;
            }
            if (this.diskLookup(fp0)) {
                this.diskHitCnt.increment();
                return true;
            }
        }
        return this.memInsert0(fp0, start);
    }

    @Override
    public final boolean contains(long fp) throws IOException {
        if (this.checkEvictPending()) {
            return this.contains(fp);
        }
        long fp0 = fp & Long.MAX_VALUE;
        if (this.memLookup(fp0)) {
            return true;
        }
        if (this.diskLookup(fp0)) {
            this.diskHitCnt.increment();
            return true;
        }
        return false;
    }

    @Override
    public void forceFlush() {
        SYNC.evict();
    }

    @Override
    void acquireTblWriteLock() {
    }

    @Override
    void releaseTblWriteLock() {
    }

    @Override
    public long getTblCapacity() {
        return this.maxTblCnt;
    }

    @Override
    public long getTblLoad() {
        return this.getTblCnt();
    }

    @Override
    public long getOverallCapacity() {
        return this.array.size();
    }

    @Override
    public long getBucketCapacity() {
        return PROBE_LIMIT;
    }

    @Override
    public long checkFPs() throws IOException {
        if (this.getTblCnt() <= 0L) {
            return Long.MAX_VALUE;
        }
        final int numThreads = TLCGlobals.getNumWorkers();
        this.flusher = this.getFlusher(numThreads, this.getTblCnt());
        this.flusher.prepareTable();
        ArrayList<1> tasks = new ArrayList<1>(numThreads);
        final long length = (long)Math.floor((double)this.array.size() / (double)numThreads);
        int i = 0;
        while (i < numThreads) {
            final int id = i++;
            tasks.add(new Callable<Long>(){

                @Override
                public Long call() throws Exception {
                    boolean isLast = id == numThreads - 1;
                    long start = (long)id * length;
                    long end = (isLast ? OffHeapDiskFPSet.this.array.size() - 1L : start + length) + 1L;
                    long distance = Long.MAX_VALUE;
                    Iterator itr = new Iterator(OffHeapDiskFPSet.this.array, OffHeapDiskFPSet.this.getTblCnt(), start, OffHeapDiskFPSet.this.indexer, isLast && id != 0 ? Iterator.WRAP.FORBIDDEN : Iterator.WRAP.ALLOWED);
                    try {
                        long x = itr.next();
                        long y = 0L;
                        while ((y = itr.next(end)) != 0L) {
                            long d = y - x;
                            if (!$assertionsDisabled && !(d > 0L ^ (d < 0L && itr.getPos() > end && isLast))) {
                                throw new AssertionError();
                            }
                            distance = Math.min(distance, d);
                            x = y;
                        }
                        return distance;
                    }
                    catch (NoSuchElementException e) {
                        return distance;
                    }
                }
            });
        }
        ExecutorService executorService = Executors.newFixedThreadPool(numThreads);
        try {
            long distance;
            long l = distance = executorService.invokeAll(tasks).stream().min(new Comparator<Future<Long>>(){

                @Override
                public int compare(Future<Long> o1, Future<Long> o2) {
                    try {
                        return Long.compare(o1.get(), o2.get());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new OffHeapRuntimeException(e);
                    }
                    catch (ExecutionException e) {
                        throw new OffHeapRuntimeException(e);
                    }
                }
            }).get().get().longValue();
            return l;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new OffHeapRuntimeException(ie);
        }
        catch (ExecutionException e) {
            throw new OffHeapRuntimeException(e);
        }
        finally {
            executorService.shutdown();
        }
    }

    private LongArrays.LongComparator getLongComparator() {
        return new LongArrays.LongComparator(){

            @Override
            public int compare(long fpA, long posA, long fpB, long posB) {
                boolean wrappedB;
                if (fpA <= 0L || fpB <= 0L) {
                    return 0;
                }
                boolean wrappedA = OffHeapDiskFPSet.this.indexer.getIdx(fpA) > posA;
                boolean bl = wrappedB = OffHeapDiskFPSet.this.indexer.getIdx(fpB) > posB;
                if (wrappedA == wrappedB && posA > posB) {
                    return fpA < fpB ? -1 : 1;
                }
                if (wrappedA ^ wrappedB) {
                    if (posA < posB && fpA < fpB) {
                        return -1;
                    }
                    if (posA > posB && fpA > fpB) {
                        return -1;
                    }
                }
                return 0;
            }
        };
    }

    private long getTableOffset(LongArray a, long reprobe, Indexer indexer, long start, long limit) {
        long occupied = 0L;
        long pos = start;
        while (pos < limit) {
            long idx;
            long fp = a.get(pos % a.size());
            if (fp > 0L && (idx = indexer.getIdx(fp)) <= pos && idx + reprobe >= pos) {
                ++occupied;
            }
            ++pos;
        }
        return occupied;
    }

    private long getNextLower(long idx) {
        long fp = this.array.get(idx);
        while (fp <= 0L || this.indexer.getIdx(fp) > idx) {
            fp = this.array.get(--idx);
        }
        return fp;
    }

    private long getDiskOffset(int id, long fp) throws IOException {
        if (this.index == null) {
            return 0L;
        }
        int indexLength = this.index.length;
        int loPage = 0;
        int hiPage = indexLength - 1;
        long loVal = this.index[loPage];
        long hiVal = this.index[hiPage];
        if (fp <= loVal) {
            return 0L;
        }
        if (fp >= hiVal) {
            return this.braf[id].length() / 8L;
        }
        double dfp = fp;
        while (loPage < hiPage - 1) {
            long v;
            double dhi = hiPage;
            double dlo = loPage;
            double dloVal = loVal;
            double dhiVal = hiVal;
            int midPage = loPage + 1 + (int)((dhi - dlo - 1.0) * (dfp - dloVal) / (dhiVal - dloVal));
            if (midPage == hiPage) {
                --midPage;
            }
            if (fp < (v = this.index[midPage])) {
                hiPage = midPage;
                hiVal = v;
                continue;
            }
            if (fp > v) {
                loPage = midPage;
                loVal = v;
                continue;
            }
            return (long)midPage * 1L * 1024L;
        }
        Assert.check(hiPage == loPage + 1, 2134);
        assert (this.index[loPage] < fp && fp < this.index[hiPage]);
        long midEntry = -1L;
        long loEntry = (long)loPage * 1024L;
        long hiEntry = loPage == indexLength - 2 ? this.fileCnt - 1L : (long)hiPage * 1024L;
        BufferedRandomAccessFile raf = this.braf[id];
        while (loEntry < hiEntry) {
            midEntry = this.calculateMidEntry(loVal, hiVal, dfp, loEntry, hiEntry);
            raf.seek(midEntry * 8L);
            long v = raf.readLong();
            if (fp < v) {
                hiEntry = midEntry;
                hiVal = v;
                continue;
            }
            if (fp <= v) break;
            loEntry = midEntry + 1L;
            loVal = v;
            midEntry = loEntry;
        }
        assert (this.isHigher(midEntry, fp, raf));
        return midEntry;
    }

    public boolean isHigher(long midEntry, long fp, BufferedRandomAccessFile raf) throws IOException {
        raf.seek((midEntry - 1L) * 8L);
        long low = raf.readLong();
        long high = raf.readLong();
        return low < fp && fp < high;
    }

    @Override
    protected int calculateIndexLen(long tblcnt) {
        int indexLen = super.calculateIndexLen(tblcnt);
        if ((tblcnt + this.fileCnt - 1L) % 1024L == 0L) {
            --indexLen;
        }
        return indexLen;
    }

    protected void writeIndex(long[] index, RandomAccessFile raf, long length) throws IOException {
        int i = 0;
        while (i < index.length) {
            long value;
            long pos = Math.min((long)i * 1024L, length);
            raf.seek(pos * 8L);
            index[i] = value = raf.readLong();
            ++i;
        }
    }

    private static boolean checkInput(LongArray array, Indexer indexer, int reprobe) {
        long pos = 0L;
        while (pos <= array.size() + (long)reprobe - 1L) {
            long tmp = array.get(pos % array.size());
            if (tmp != 0L) {
                if (tmp < 0L) {
                    tmp &= Long.MAX_VALUE;
                }
                long idx = indexer.getIdx(tmp);
                if (!(pos < (long)reprobe && idx > array.size() - 1L - pos - (long)reprobe || pos > array.size() - 1L && idx + (long)reprobe < pos || idx <= pos && pos <= idx + (long)reprobe)) {
                    System.err.println(String.format("%s with idx %s at pos %s (reprobe: %s).", tmp, idx, pos, reprobe));
                    return false;
                }
            }
            ++pos;
        }
        return true;
    }

    private static long checkSorted(LongArray array, Indexer indexer, int reprobe, long start, long end) {
        if ((long)reprobe >= array.size()) {
            reprobe = (int)(array.size() - 1L);
        }
        long e = 0L;
        long pos = start;
        while (pos <= end) {
            long idx;
            long tmp = array.get(pos % array.size());
            if (tmp > 0L && (idx = indexer.getIdx(tmp)) <= pos && idx + (long)reprobe >= pos) {
                if (e == 0L) {
                    e = tmp;
                } else {
                    if (e >= tmp) {
                        System.err.println(String.format("%s >= %s at pos %s.", e, tmp, pos));
                        return pos;
                    }
                    e = tmp;
                }
            }
            ++pos;
        }
        return -1L;
    }

    private static long checkSorted(LongArray array, Indexer indexer, int reprobe) {
        return OffHeapDiskFPSet.checkSorted(array, indexer, reprobe, 0L, array.size() - 1L + (long)reprobe);
    }

    private static boolean checkRAFs(BufferedRandomAccessFile[] rafs) throws IOException {
        int i = 0;
        while (i < rafs.length - 1) {
            long start;
            long end = rafs[i].getFilePointer();
            if (end != (start = rafs[i + 1].getMark())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean checkTable(LongArray array) {
        long i = 0L;
        while (i < array.size()) {
            long elem = array.get(i);
            if (elem > 0L) {
                System.err.println(String.format("%s elem at pos %s.", elem, i));
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean checkIndex(long[] idx) {
        int i = 1;
        while (i < idx.length) {
            if (idx[i - 1] >= idx[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean checkIndex(long[] idx, RandomAccessFile raf, long length) throws IOException {
        long i = 0L;
        while (i < (long)idx.length) {
            long pos = Math.min(i * 1024L, length);
            raf.seek(pos * 8L);
            long value = raf.readLong();
            long index = idx[(int)i];
            if (value != index) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static class BitshiftingIndexer
    implements Indexer {
        private final long prefixMask;
        private final int rShift;
        private final long positions;

        public BitshiftingIndexer(long positions, int fpBits) {
            assert (positions >= 0L && fpBits > 0 && fpBits < 64);
            this.positions = positions;
            this.prefixMask = -1L >>> fpBits;
            assert (this.prefixMask > positions) : "fingerprint equals index if positions exceeds fingerprint space.";
            long n = (-1L >>> fpBits) - (positions - 1L);
            int moveBy = 0;
            while (n >= positions) {
                ++moveBy;
                n >>>= 1;
            }
            this.rShift = moveBy;
        }

        @Override
        public long getIdx(long fp) {
            return (fp & this.prefixMask) >>> this.rShift;
        }

        @Override
        public long getIdx(long fp, int probe) {
            return (((fp & this.prefixMask) >>> this.rShift) + (long)probe) % this.positions;
        }
    }

    public class ConcurrentOffHeapMSBFlusher
    extends OffHeapMSBFlusher {
        private final int numThreads;
        private final ExecutorService executorService;
        private final int r;
        private final long insertions;
        private final long length;
        private List<Result> offsets;

        public ConcurrentOffHeapMSBFlusher(LongArray array, int r, int numThreads, long insertions) {
            super(array);
            this.r = r;
            this.numThreads = numThreads;
            this.insertions = insertions;
            this.length = (long)Math.floor((double)this.a.size() / (double)numThreads);
            this.executorService = Executors.newFixedThreadPool(numThreads);
        }

        @Override
        protected void prepareTable() {
            long now = System.currentTimeMillis();
            final CyclicBarrier phase = new CyclicBarrier(this.numThreads);
            ArrayList<1> tasks = new ArrayList<1>(this.numThreads);
            int i = 0;
            while (i < this.numThreads) {
                final int id = i++;
                tasks.add(new Callable<Result>(){

                    @Override
                    public Result call() throws Exception {
                        boolean isFirst = id == 0;
                        boolean isLast = id == ConcurrentOffHeapMSBFlusher.this.numThreads - 1;
                        long start = (long)id * ConcurrentOffHeapMSBFlusher.this.length;
                        long end = isLast ? ConcurrentOffHeapMSBFlusher.this.a.size() - 1L : start + ConcurrentOffHeapMSBFlusher.this.length;
                        LongArrays.sort(ConcurrentOffHeapMSBFlusher.this.a, isFirst ? 0L : start + 1L, end, OffHeapDiskFPSet.this.getLongComparator());
                        if (!$assertionsDisabled && OffHeapDiskFPSet.checkSorted(ConcurrentOffHeapMSBFlusher.this.a, ((ConcurrentOffHeapMSBFlusher)ConcurrentOffHeapMSBFlusher.this).OffHeapDiskFPSet.this.indexer, ConcurrentOffHeapMSBFlusher.this.r, isFirst ? 0L : start + 1L, end) != -1L) {
                            throw new AssertionError((Object)String.format("Array %s not fully sorted at index %s and reprobe %s in range [%s,%s].", ConcurrentOffHeapMSBFlusher.this.a.toString(), OffHeapDiskFPSet.checkSorted(((ConcurrentOffHeapMSBFlusher)ConcurrentOffHeapMSBFlusher.this).OffHeapDiskFPSet.this.array, ((ConcurrentOffHeapMSBFlusher)ConcurrentOffHeapMSBFlusher.this).OffHeapDiskFPSet.this.indexer, ConcurrentOffHeapMSBFlusher.this.r, start, end), ConcurrentOffHeapMSBFlusher.this.r, start, end));
                        }
                        phase.await();
                        LongArrays.sort(ConcurrentOffHeapMSBFlusher.this.a, end - (long)ConcurrentOffHeapMSBFlusher.this.r + 1L, end + (long)ConcurrentOffHeapMSBFlusher.this.r + 1L, OffHeapDiskFPSet.this.getLongComparator());
                        phase.await();
                        long limit = isLast ? ConcurrentOffHeapMSBFlusher.this.a.size() + (long)ConcurrentOffHeapMSBFlusher.this.r : end;
                        long occupied = OffHeapDiskFPSet.this.getTableOffset(ConcurrentOffHeapMSBFlusher.this.a, ConcurrentOffHeapMSBFlusher.this.r, ((ConcurrentOffHeapMSBFlusher)ConcurrentOffHeapMSBFlusher.this).OffHeapDiskFPSet.this.indexer, start, limit);
                        if (!$assertionsDisabled && occupied > limit - start) {
                            throw new AssertionError();
                        }
                        if (((ConcurrentOffHeapMSBFlusher)ConcurrentOffHeapMSBFlusher.this).OffHeapDiskFPSet.this.index == null) {
                            return new Result(occupied, 0L);
                        }
                        if (isFirst && isLast) {
                            return new Result(occupied, ((ConcurrentOffHeapMSBFlusher)ConcurrentOffHeapMSBFlusher.this).OffHeapDiskFPSet.this.fileCnt);
                        }
                        if (isFirst) {
                            return new Result(occupied, OffHeapDiskFPSet.this.getDiskOffset(id, OffHeapDiskFPSet.this.getNextLower(end)));
                        }
                        if (isLast) {
                            return new Result(occupied, ((ConcurrentOffHeapMSBFlusher)ConcurrentOffHeapMSBFlusher.this).OffHeapDiskFPSet.this.fileCnt - OffHeapDiskFPSet.this.getDiskOffset(id, OffHeapDiskFPSet.this.getNextLower(start)));
                        }
                        return new Result(occupied, OffHeapDiskFPSet.this.getDiskOffset(id, OffHeapDiskFPSet.this.getNextLower(end)) - OffHeapDiskFPSet.this.getDiskOffset(id, OffHeapDiskFPSet.this.getNextLower(start)));
                    }
                });
            }
            try {
                this.offsets = this.futuresToResults(this.executorService.invokeAll(tasks));
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new OffHeapRuntimeException(ie);
            }
            catch (ExecutionException notExpectedToHappen) {
                throw new OffHeapRuntimeException(notExpectedToHappen);
            }
            assert (OffHeapDiskFPSet.checkSorted(this.a, OffHeapDiskFPSet.this.indexer, this.r) == -1L) : String.format("Array %s not fully sorted at index %s and reprobe %s.", this.a.toString(), OffHeapDiskFPSet.checkSorted(OffHeapDiskFPSet.this.array, OffHeapDiskFPSet.this.indexer, this.r), this.r);
            LOGGER.log(Level.FINE, "Sorted in-memory table with {0} workers and reprobe {1} in {2} ms.", new Object[]{this.numThreads, this.r, System.currentTimeMillis() - now});
        }

        private List<Result> futuresToResults(List<Future<Result>> futures) throws InterruptedException, ExecutionException {
            ArrayList<Result> res = new ArrayList<Result>(futures.size());
            for (Future<Result> future : futures) {
                res.add(future.get());
            }
            return res;
        }

        @Override
        protected void mergeNewEntries(BufferedRandomAccessFile[] inRAFs, BufferedRandomAccessFile outRAF, Iterator ignored) throws IOException {
            long now = System.currentTimeMillis();
            assert (this.offsets.stream().mapToLong(new ToLongFunction<Result>(){

                @Override
                public long applyAsLong(Result result) {
                    return result.getTable();
                }
            }).sum() == this.insertions) : "Missing inserted elements during eviction.";
            assert (this.offsets.stream().mapToLong(new ToLongFunction<Result>(){

                @Override
                public long applyAsLong(Result result) {
                    return result.getDisk();
                }
            }).sum() == OffHeapDiskFPSet.this.fileCnt) : "Missing disk elements during eviction.";
            int id = 1;
            while (id < this.numThreads) {
                Result prev = this.offsets.get(id - 1);
                Result result = this.offsets.get(id);
                result.setInOffset(prev.getInOffset() + prev.getDisk());
                result.setOutOffSet(prev.getOutOffset() + prev.getTotal());
                ++id;
            }
            long outLength = outRAF.length();
            ArrayList<4> tasks = new ArrayList<4>(this.numThreads);
            final BufferedRandomAccessFile[] tmpRAFs = new BufferedRandomAccessFile[this.numThreads];
            int i = 0;
            while (i < this.numThreads) {
                final int id2 = i;
                tmpRAFs[id2] = new BufferedRandomAccessFile(new File(OffHeapDiskFPSet.this.tmpFilename), "rw");
                tmpRAFs[id2].setLength(outLength);
                final Result result = this.offsets.get(id2);
                tmpRAFs[id2].seekAndMark(result.getOutOffset() * 8L);
                final Iterator itr = new Iterator(this.a, result.getTable(), (long)id2 * this.length, OffHeapDiskFPSet.this.indexer, id2 == 0 ? Iterator.WRAP.ALLOWED : Iterator.WRAP.FORBIDDEN);
                final BufferedRandomAccessFile inRAF = inRAFs[id2];
                assert ((result.getInOffset() + result.getDisk()) * 8L <= inRAF.length());
                inRAF.seekAndMark(result.getInOffset() * 8L);
                final long diskReads = id2 == this.numThreads - 1 ? OffHeapDiskFPSet.this.fileCnt - result.getInOffset() : result.getDisk();
                tasks.add(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ConcurrentOffHeapMSBFlusher.super.mergeNewEntries(inRAF, tmpRAFs[id2], itr, diskReads);
                        if (!$assertionsDisabled && tmpRAFs[id2].getFilePointer() != (result.getOutOffset() + result.getTotal()) * 8L) {
                            throw new AssertionError((Object)(id2 + " writer did not write expected amount of fingerprints to disk."));
                        }
                        return null;
                    }
                });
                ++i;
            }
            try {
                try {
                    this.executorService.invokeAll(tasks);
                    this.executorService.shutdown();
                    this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    assert (OffHeapDiskFPSet.checkRAFs(tmpRAFs));
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new OffHeapRuntimeException(ie);
                }
            }
            finally {
                this.executorService.shutdown();
            }
            i = 0;
            while (i < tmpRAFs.length) {
                tmpRAFs[i].close();
                ++i;
            }
            outRAF.invalidateBufferedData();
            assert (OffHeapDiskFPSet.checkRAFs(inRAFs));
            assert (OffHeapDiskFPSet.checkTable(this.a)) : "Missed element during eviction.";
            LOGGER.log(Level.FINE, "Wrote table to disk with {0} workers in {1} ms.", new Object[]{this.numThreads, System.currentTimeMillis() - now});
        }

        private class Result {
            private final long occupiedTable;
            private final long occupiedDisk;
            private long outOffset;
            private long inOffset;

            public Result(long occupiedTable, long occupiedDisk) {
                this.occupiedTable = occupiedTable;
                this.occupiedDisk = occupiedDisk;
            }

            public long getDisk() {
                return this.occupiedDisk;
            }

            public long getTable() {
                return this.occupiedTable;
            }

            public long getTotal() {
                return this.occupiedDisk + this.occupiedTable;
            }

            public void setOutOffSet(long offset) {
                this.outOffset = offset;
            }

            public void setInOffset(long offset) {
                this.inOffset = offset;
            }

            public long getInOffset() {
                return this.inOffset;
            }

            public long getOutOffset() {
                return this.outOffset;
            }
        }
    }

    public static interface Indexer {
        public long getIdx(long var1);

        public long getIdx(long var1, int var3);
    }

    public static class InfinitePrecisionIndexer
    implements Indexer {
        private final BigDecimal factor;
        private final BigDecimal positions;

        public InfinitePrecisionIndexer(long positions, int fpBits) {
            assert (positions >= 0L && fpBits > 0 && fpBits < 64);
            this.positions = BigDecimal.valueOf(positions);
            BigDecimal divisor = new BigDecimal(BigInteger.valueOf(1L).shiftLeft(64 - fpBits));
            this.factor = BigDecimal.valueOf(positions).divide(divisor);
        }

        public InfinitePrecisionIndexer(long positions, int fpBits, long maxFingerprint) {
            assert (positions >= 0L && fpBits > 0 && fpBits < 64);
            this.positions = BigDecimal.valueOf(positions);
            this.factor = BigDecimal.valueOf(positions).divide(BigDecimal.valueOf(maxFingerprint));
        }

        @Override
        public long getIdx(long fp) {
            return this.getIdx(fp, 0);
        }

        @Override
        public long getIdx(long fp, int probe) {
            BigDecimal scaled = BigDecimal.valueOf(fp).multiply(this.factor).add(BigDecimal.valueOf(probe)).remainder(this.positions);
            assert (0L <= scaled.longValue() && scaled.longValue() < this.positions.longValue());
            return scaled.longValue();
        }
    }

    public static class InfinitePrecisionMult1024Indexer
    implements Indexer {
        private final long positions;
        private final int shift;
        private final BigInteger multiplier;

        public static boolean isSupported(long positions) {
            return (positions << 3) % 0x40000000L == 0L;
        }

        public InfinitePrecisionMult1024Indexer(long positions, int fpBits) {
            assert (fpBits > 0 && fpBits < 64);
            assert (InfinitePrecisionMult1024Indexer.isSupported(positions)) : "positions * 8 is not a multiple of 1024MB";
            assert (positions >= 0L && Long.numberOfTrailingZeros(positions) > fpBits) : "fingerprint space is smaller than number of positions";
            this.positions = positions;
            BigInteger max = BigInteger.ONE.shiftLeft(64 - fpBits);
            BigInteger bPos = BigInteger.valueOf(positions);
            BigInteger gcd = max.gcd(bPos);
            this.multiplier = bPos.divide(gcd);
            BigInteger rMax = max.divide(gcd);
            assert (rMax.bitCount() == 1);
            this.shift = rMax.getLowestSetBit();
        }

        @Override
        public long getIdx(long fp) {
            long idx = BigInteger.valueOf(fp).multiply(this.multiplier).shiftRight(this.shift).longValue();
            assert (0L <= (idx %= this.positions) && idx < this.positions);
            return idx;
        }

        @Override
        public long getIdx(long fp, int probe) {
            long idx = BigInteger.valueOf(fp).multiply(this.multiplier).shiftRight(this.shift).longValue();
            idx %= this.positions;
            assert (0L <= (idx += (long)probe) && idx < this.positions);
            return idx % this.positions;
        }
    }

    public static class Iterator {
        private final long elements;
        private final LongArray array;
        private final Indexer indexer;
        private final WRAP canWrap;
        private long pos = 0L;
        private long elementsRead = 0L;

        public Iterator(LongArray array, long elements, Indexer indexer) {
            this(array, elements, 0L, indexer, WRAP.ALLOWED);
        }

        public Iterator(LongArray array, long elements, long start, Indexer indexer) {
            this(array, elements, start, indexer, WRAP.FORBIDDEN);
        }

        public Iterator(LongArray array, long elements, long start, Indexer indexer, WRAP canWrap) {
            this.array = array;
            this.elements = elements;
            this.indexer = indexer;
            this.pos = start;
            this.canWrap = canWrap;
        }

        public long getPos() {
            return this.pos;
        }

        public long next() {
            return this.next0(false, Long.MAX_VALUE);
        }

        long next(long maxPos) {
            if (this.pos >= maxPos) {
                return 0L;
            }
            return this.next0(false, maxPos);
        }

        public long markNext() {
            return this.next0(true, Long.MAX_VALUE);
        }

        private long next0(boolean mark, long maxPos) {
            do {
                long position;
                long elem;
                if ((elem = this.array.get(position = this.pos % this.array.size())) == 0L) {
                    ++this.pos;
                    continue;
                }
                if (elem < 0L) {
                    ++this.pos;
                    continue;
                }
                long baseIdx = this.indexer.getIdx(elem);
                if (baseIdx > this.pos) {
                    assert (this.canWrap == WRAP.ALLOWED);
                    ++this.pos;
                    continue;
                }
                ++this.pos;
                if (mark) {
                    this.array.set(position, elem | Long.MIN_VALUE);
                }
                ++this.elementsRead;
                return elem;
            } while (this.hasNext() && this.pos < maxPos);
            if (this.pos >= maxPos) {
                return 0L;
            }
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return this.elementsRead < this.elements;
        }

        private static enum WRAP {
            ALLOWED,
            FORBIDDEN;

        }
    }

    public static class Mult1024Indexer
    implements Indexer {
        private final long positions;
        private final int shift;
        private final long multiplier;

        public static boolean isSupported(long positions) {
            return (positions << 3) % 0x40000000L == 0L;
        }

        public Mult1024Indexer(long positions, int fpBits) {
            assert (fpBits > 0 && fpBits < 64);
            assert (Mult1024Indexer.isSupported(positions)) : "positions * 8 is not a multiple of 1024MB";
            assert (positions >= 0L && Long.numberOfTrailingZeros(positions) > fpBits) : "fingerprint space is smaller than number of positions";
            this.positions = positions;
            BigInteger max = BigInteger.ONE.shiftLeft(64 - fpBits);
            BigInteger bPos = BigInteger.valueOf(positions);
            BigInteger gcd = max.gcd(bPos);
            assert (gcd.bitCount() == 1);
            this.multiplier = bPos.divide(gcd).longValueExact();
            BigInteger rMax = max.divide(gcd);
            assert (rMax.bitCount() == 1);
            this.shift = rMax.getLowestSetBit();
            assert (this.shift >= 0 && this.shift < 64) : "Shift value must be valid (0 to 63)";
        }

        @Override
        public long getIdx(long fp) {
            assert (fp >= 0L);
            long h = Math.multiplyHigh(fp, this.multiplier);
            long l = fp * this.multiplier;
            long idx = h << 64 - this.shift | l >>> this.shift;
            assert (0L <= idx && idx < this.positions);
            return idx;
        }

        @Override
        public long getIdx(long fp, int probe) {
            return (this.getIdx(fp) + (long)probe) % this.positions;
        }
    }

    public class OffHeapMSBFlusher
    extends DiskFPSet.Flusher {
        protected final LongArray a;

        public OffHeapMSBFlusher(LongArray array) {
            super(OffHeapDiskFPSet.this);
            this.a = array;
        }

        @Override
        protected void prepareTable() {
            super.prepareTable();
            int r = PROBE_LIMIT;
            assert (OffHeapDiskFPSet.checkInput(OffHeapDiskFPSet.this.array, OffHeapDiskFPSet.this.indexer, r)) : "Table violates invariants prior to eviction";
            LongArrays.sort(this.a, 0L, this.a.size() - 1L + (long)r, OffHeapDiskFPSet.this.getLongComparator());
            assert (OffHeapDiskFPSet.checkSorted(this.a, OffHeapDiskFPSet.this.indexer, r) == -1L) : String.format("Array %s not fully sorted at index %s and reprobe %s.", this.a.toString(), OffHeapDiskFPSet.checkSorted(OffHeapDiskFPSet.this.array, OffHeapDiskFPSet.this.indexer, r), r);
        }

        @Override
        protected void mergeNewEntries(BufferedRandomAccessFile[] inRAFs, BufferedRandomAccessFile outRAF) throws IOException {
            long buffLen = OffHeapDiskFPSet.this.tblCnt.sum();
            Iterator itr = new Iterator(OffHeapDiskFPSet.this.array, buffLen, OffHeapDiskFPSet.this.indexer);
            int indexLen = OffHeapDiskFPSet.this.calculateIndexLen(buffLen);
            OffHeapDiskFPSet.this.index = new long[indexLen];
            this.mergeNewEntries(inRAFs, outRAF, itr);
            long length = outRAF.length() / 8L - 1L;
            OffHeapDiskFPSet.this.writeIndex(OffHeapDiskFPSet.this.index, outRAF, length);
            assert (OffHeapDiskFPSet.checkIndex(OffHeapDiskFPSet.this.index)) : "Broken disk index.";
            assert (OffHeapDiskFPSet.checkIndex(OffHeapDiskFPSet.this.index, outRAF, length)) : "Misaligned disk index.";
            OffHeapDiskFPSet.this.fileCnt += buffLen;
        }

        protected void mergeNewEntries(BufferedRandomAccessFile[] inRAFs, BufferedRandomAccessFile outRAF, Iterator itr) throws IOException {
            inRAFs[0].seek(0L);
            this.mergeNewEntries(inRAFs[0], outRAF, itr, inRAFs[0].length() / 8L);
        }

        protected void mergeNewEntries(BufferedRandomAccessFile inRAF, RandomAccessFile outRAF, Iterator itr, long diskReads) throws IOException {
            long value = 0L;
            if (diskReads > 0L) {
                value = inRAF.readLong();
            } else assert (OffHeapDiskFPSet.this.fileCnt == 0L);
            long tableReads = itr.elements;
            long fp = itr.markNext();
            do {
                long nextValue;
                long nextFP;
                if (value == fp) {
                    MP.printWarning(2166, String.valueOf(value));
                    --diskReads;
                    outRAF.writeLong(fp);
                    OffHeapDiskFPSet.this.diskWriteCnt.increment();
                    if (--tableReads > 0L) {
                        nextFP = itr.markNext();
                        assert (nextFP > fp) : nextFP + " > " + fp + " from table at pos " + itr.pos + " " + this.a.toString(itr.pos - 10L, itr.pos + 10L);
                        fp = nextFP;
                    }
                    if (diskReads > 0L) {
                        nextValue = inRAF.readLong();
                        assert (value < nextValue);
                        value = nextValue;
                    }
                }
                assert (fp > 0L) : "Wrote an invalid fingerprint to disk.";
                if (tableReads > 0L && (fp < value || diskReads == 0L)) {
                    outRAF.writeLong(fp);
                    OffHeapDiskFPSet.this.diskWriteCnt.increment();
                    if (--tableReads > 0L) {
                        nextFP = itr.markNext();
                        assert (nextFP > fp) : nextFP + " > " + fp + " from table at pos " + itr.pos + " " + this.a.toString(itr.pos - 10L, itr.pos + 10L);
                        fp = nextFP;
                    }
                }
                if (diskReads <= 0L || value >= fp && tableReads != 0L) continue;
                outRAF.writeLong(value);
                OffHeapDiskFPSet.this.diskWriteCnt.increment();
                if (--diskReads <= 0L) continue;
                nextValue = inRAF.readLong();
                assert (value < nextValue);
                value = nextValue;
            } while (diskReads > 0L || tableReads > 0L);
            Assert.check(diskReads == 0L && tableReads == 0L, 1000);
            assert (!itr.hasNext());
        }
    }

    public static class OffHeapRuntimeException
    extends RuntimeException {
        public OffHeapRuntimeException(Exception ie) {
            super(ie);
        }
    }

    private static class OffHeapSynchronizer {
        private final Set<OffHeapDiskFPSet> sets = new HashSet<OffHeapDiskFPSet>();
        private final AtomicBoolean flusherChosen = new AtomicBoolean();
        private final Phaser phaser = new Phaser(1){

            @Override
            protected boolean onAdvance(int phase, int registeredParties) {
                for (OffHeapDiskFPSet set : sets) {
                    set.evict();
                }
                Assert.check(flusherChosen.compareAndSet(true, false), 1000);
                return super.onAdvance(phase, registeredParties);
            }
        };

        private OffHeapSynchronizer() {
        }

        public final void add(OffHeapDiskFPSet aSet) {
            this.sets.add(aSet);
        }

        public final void incWorkers(int numWorkers) {
            int parties = this.phaser.getRegisteredParties();
            if (parties < numWorkers) {
                this.phaser.bulkRegister(numWorkers - parties);
            }
        }

        public final boolean evictPending() {
            return this.flusherChosen.get();
        }

        public final void evict() {
            this.flusherChosen.compareAndSet(false, true);
        }

        public final void awaitEviction() {
            this.phaser.arriveAndAwaitAdvance();
        }

        public AtomicBoolean getFlusherChosen() {
            return this.flusherChosen;
        }
    }
}

