/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tlc2.TLCGlobals;
import tlc2.tool.Action;
import tlc2.tool.INextStateFunctor;
import tlc2.tool.IStateFunctor;
import tlc2.tool.TLCState;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.Value;
import util.Assert;

public final class StateVec
implements IStateFunctor,
INextStateFunctor {
    private TLCState[] v;
    private int size;
    private static final TLCState[] emptyStateArr = new TLCState[0];

    public StateVec(TLCState item0) {
        this.size = 1;
        this.v = new TLCState[1];
        this.v[0] = item0;
    }

    public StateVec(int length) {
        this.size = 0;
        this.v = length == 0 ? emptyStateArr : new TLCState[length];
    }

    public StateVec(StateVec other) {
        this(other.size);
        this.size = other.size;
        int i = 0;
        while (i < this.v.length) {
            this.v[i] = other.elementAt(i);
            ++i;
        }
    }

    public StateVec(TLCState[] v) {
        this.v = v;
        this.size = v.length;
    }

    public final boolean empty() {
        return this.size == 0;
    }

    public final int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public final void grow(int add) {
        int oldLen = this.v.length;
        if (oldLen >= TLCGlobals.setBound) {
            Assert.fail(2172);
        }
        int newLen = Math.min(Math.max(oldLen + add, 2 * oldLen), TLCGlobals.setBound);
        TLCState[] oldv = this.v;
        this.v = new TLCState[newLen];
        int i = 0;
        while (i < this.size) {
            this.v[i] = oldv[i];
            ++i;
        }
    }

    public final TLCState elementAt(int i) {
        return this.v[i];
    }

    public TLCState first() {
        return this.elementAt(0);
    }

    public TLCState last() {
        return this.elementAt(this.size() - 1);
    }

    public final void clear() {
        this.size = 0;
    }

    @Override
    public final StateVec addElement(TLCState state) {
        if (this.size >= this.v.length) {
            this.grow(1);
        }
        this.v[this.size++] = state;
        return this;
    }

    @Override
    public final StateVec addElement(TLCState predecessor, Action action, TLCState state) {
        return this.addElement(state.setPredecessor(predecessor).setAction(action));
    }

    public final StateVec addElements(StateVec s1) {
        StateVec s0 = this;
        if (s1.size > s0.size) {
            StateVec tmp = s0;
            s0 = s1;
            s1 = tmp;
        }
        int size0 = s0.size;
        int size1 = s1.size;
        TLCState[] v0 = s0.v;
        TLCState[] v1 = s1.v;
        if (v0.length < size0 + size1) {
            s0.grow(size1);
            v0 = s0.v;
        }
        int i = 0;
        while (i < size1) {
            v0[size0 + i] = v1[i];
            ++i;
        }
        s0.size = size0 + size1;
        return s0;
    }

    public final void removeElement(int index) {
        this.v[index] = this.v[this.size - 1];
        --this.size;
    }

    public void removeAt(int index) {
        this.replaceAt(index, null);
    }

    public void replaceAt(int index, TLCState state) {
        this.v[index] = state;
    }

    public final StateVec copy() {
        TLCState[] res = new TLCState[this.size];
        int i = 0;
        while (i < this.size) {
            res[i] = this.v[i].copy();
            ++i;
        }
        return new StateVec(res);
    }

    public final StateVec deepCopy() {
        TLCState[] res = new TLCState[this.size];
        int i = 0;
        while (i < this.size) {
            res[i] = this.v[i].deepCopy();
            ++i;
        }
        return new StateVec(res);
    }

    public final void reset() {
        this.size = 0;
    }

    public final void deepNormalize() {
        int i = 0;
        while (i < this.size) {
            this.v[i].deepNormalize();
            ++i;
        }
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        if (this.size > 0) {
            sb.append(this.v[0].toString());
        }
        int i = 1;
        while (i < this.size) {
            sb.append(", ");
            sb.append(this.v[i].toString());
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    public final boolean contains(TLCState state) {
        int i = 0;
        while (i < this.size) {
            if (this.v[i].fingerPrint() == state.fingerPrint()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final Value[] toRecords(TLCState append) {
        Value[] values = new Value[this.size + 1];
        int i = 0;
        while (i < this.size) {
            values[i] = new RecordValue(this.v[i]);
            ++i;
        }
        values[values.length - 1] = new RecordValue(append);
        return values;
    }

    public final Value[] toRecords(TLCState from, TLCState append) {
        LinkedList<RecordValue> res = new LinkedList<RecordValue>();
        res.add(new RecordValue(append));
        int i = this.size - 1;
        while (i >= 0) {
            res.push(new RecordValue(this.v[i]));
            if (from.fingerPrint() == this.v[i].fingerPrint()) break;
            --i;
        }
        return res.toArray(new Value[res.size()]);
    }

    @Override
    public final boolean hasStates() {
        return !this.isEmpty();
    }

    public Stream<TLCState> stream() {
        return Arrays.stream(this.v, 0, this.size);
    }

    public List<TLCState> toList() {
        return this.stream().collect(Collectors.toList());
    }
}

