/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.OpDeclNode;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.tool.AbstractChecker;
import tlc2.tool.DFIDWorker;
import tlc2.tool.EvalException;
import tlc2.tool.ITool;
import tlc2.tool.IWorker;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.fp.dfid.FPIntSet;
import tlc2.tool.fp.dfid.MemFPIntSet;
import tlc2.tool.impl.CallStackTool;
import tlc2.tool.liveness.LiveException;
import tlc2.util.IStateWriter;
import tlc2.util.IdThread;
import tlc2.util.LongVec;
import tlc2.util.SetOfStates;
import util.Assert;
import util.FileUtil;
import util.UniqueString;

public class DFIDModelChecker
extends AbstractChecker {
    public TLCState[] theInitStates;
    public long[] theInitFPs;
    public FPIntSet theFPSet;
    private final AtomicLong numOfGenStates;
    protected final ThreadLocal<Integer> threadLocal = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 1;
        }
    };
    protected static final int INITIAL_CAPACITY = 16;

    public DFIDModelChecker(ITool tool, String metadir, IStateWriter stateWriter, boolean deadlock, String fromChkpt, long startTime) throws EvalException, IOException {
        super(tool, metadir, stateWriter, deadlock, fromChkpt, startTime);
        Assert.check(TLCGlobals.getNumWorkers() == 1, 1000, "Depth-First Iterative Deepening mode does not support multiple workers (https://github.com/tlaplus/tlaplus/issues/548).  Please run TLC with a single worker.");
        Assert.check(!this.checkLiveness, 1000, "Depth-First Iterative Deepening mode does not support checking liveness properties (https://github.com/tlaplus/tlaplus/issues/548).  Please check liveness properties in Breadth-First-Search mode.");
        this.theInitStates = null;
        this.theInitFPs = null;
        this.theFPSet = new MemFPIntSet();
        this.theFPSet.init(TLCGlobals.getNumWorkers(), this.metadir, this.tool.getRootFile());
        this.workers = new DFIDWorker[TLCGlobals.getNumWorkers()];
        this.numOfGenStates = new AtomicLong(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int modelCheckImpl() throws Exception {
        result = 0;
        recovered = this.recover();
        try {
            if (this.checkLiveness && this.liveCheck.getNumChecker() == 0) {
                return MP.printError(2253);
            }
            result = this.checkAssumptions();
            if (result != 0) {
                return result;
            }
            result = this.doInit(false);
            if (result != 0) {
                return result;
            }
        }
        catch (Throwable e) {
            if (this.errState != null) {
                MP.printError(2102, new String[]{e.getMessage(), this.errState.toString()});
            } else {
                MP.printError(1000, "computing initial states", e);
            }
            try {
                this.numOfGenStates.set(0L);
                this.doInit(new CallStackTool(this.tool), true);
            }
            catch (Throwable e1) {
                result = MP.printError(2103, this.tool.toString());
            }
            this.printSummary(false);
            this.cleanup(false);
            return result;
        }
        if (recovered) {
            MP.printMessage(2207, new String[]{String.valueOf(this.numOfGenStates), String.valueOf(this.theInitStates.length)});
        } else {
            MP.printMessage(2208, new String[]{String.valueOf(this.numOfGenStates), String.valueOf(this.theInitStates.length)});
        }
        if (this.tool.getActions().length == 0) {
            this.reportSuccess();
            this.printSummary(true);
            this.cleanup(true);
            return result;
        }
        result = 1000;
        try {
            terminated = false;
            level = 2;
            ** GOTO lbl111
        }
        catch (Exception e) {
            try {
                result = e instanceof LiveException != false ? ((LiveException)e).errorCode : MP.printError(1000, e);
                var8_16 = result;
                if (result == 0) {
                    v0 = true;
                }
                v0 = false;
            }
            catch (Throwable var7_22) {
                success = result == 0;
                this.printSummary(success);
                this.cleanup(success);
                throw var7_22;
            }
lbl57:
            // 2 sources

            while (true) {
                success = v1;
                this.printSummary(success);
                this.cleanup(success);
                return var8_13;
            }
lbl-1000:
            // 2 sources

            {
                while (true) {
                    result = 0;
                    this.reportSuccess();
                    ** GOTO lbl126
                    break;
                }
lbl66:
                // 1 sources

                while (this.keepCallStack) {
                    cTool = new CallStackTool(this.tool);
                    try {
                        this.doNext(cTool, this.predErrState, this.predErrState.fingerPrint(), true, new StateVec(1), new LongVec());
                    }
                    catch (Throwable e) {
                        MP.printError(2103, cTool.toString());
                    }
                    ** GOTO lbl126
                }
                ** GOTO lbl126
                while (true) {
                    MP.printMessage(2205, new String[]{String.valueOf(level), String.valueOf(this.numOfGenStates), String.valueOf(this.theFPSet.size())});
                    FPIntSet.incLevel();
                    result = this.runTLC(level);
                    cTool = this;
                    synchronized (cTool) {
                        this.done = false;
                    }
                    if (result == 0) ** GOTO lbl-1000
                    var8_14 = result;
                    success = result == 0;
                    break;
                }
            }
            this.printSummary(success);
            this.cleanup(success);
            return var8_14;
lbl-1000:
            // 1 sources

            {
                block32: {
                    block33: {
                        i = 0;
                        while (i < this.workers.length) {
                            if (((DFIDWorker)this.workers[i]).isTerminated()) {
                                terminated = true;
                                break;
                            }
                            ++i;
                        }
                        moreLevel = false;
                        i = 0;
                        while (i < this.workers.length) {
                            if (((DFIDWorker)this.workers[i]).hasMoreLevel()) {
                                moreLevel = true;
                                break;
                            }
                            ++i;
                        }
                        terminated = terminated != false || moreLevel == false;
                        ++level;
lbl111:
                        // 2 sources

                        if (level > TLCGlobals.DFIDMax) break block32;
                        if (!terminated) ** continue;
                        if (this.errState != null) ** GOTO lbl66
                        if (!this.checkLiveness) ** GOTO lbl-1000
                        MP.printMessage(2206, new String[]{String.valueOf(this.numOfGenStates), String.valueOf(this.theFPSet.size())});
                        result = this.liveCheck.finalCheck(this.tool);
                        if (result != 0) ** break;
                        ** continue;
                        var8_13 = result;
                        if (result != 0) break block33;
                        v1 = true;
                        ** GOTO lbl57
                    }
                    v1 = false;
                    ** continue;
                }
                var8_15 = result;
                success = result == 0;
            }
            this.printSummary(success);
            this.cleanup(success);
            return var8_15;
            success = v0;
            this.printSummary(success);
            this.cleanup(success);
            return var8_16;
        }
    }

    public final int checkAssumptions() {
        ExprNode[] assumps = this.tool.getAssumptions();
        boolean[] isAxiom = this.tool.getAssumptionIsAxiom();
        int i = 0;
        while (i < assumps.length) {
            try {
                if (!isAxiom[i] && !this.tool.isValid(assumps[i])) {
                    return MP.printError(2104, assumps[i].toString());
                }
            }
            catch (Exception e) {
                return MP.printError(2105, new String[]{assumps[i].toString(), e.getMessage()});
            }
            ++i;
        }
        return 0;
    }

    @Override
    public final int doInit(boolean ignoreCancel) throws Throwable {
        return this.doInit(this.tool, ignoreCancel);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int doInit(ITool tool, boolean ignoreCancel) throws Throwable {
        TLCState curState = null;
        try {
            StateVec states = tool.getInitStates();
            this.numOfGenStates.set(states.size());
            long l = this.numOfGenStates.get();
            this.theInitStates = new TLCState[(int)l];
            this.theInitFPs = new long[(int)l];
            int idx = 0;
            int i = 0;
            while ((long)i < l) {
                long fp;
                curState = states.elementAt(i);
                if (!tool.isGoodState(curState)) {
                    return MP.printError(2106, curState.toString());
                }
                boolean inModel = tool.isInModel(curState);
                int status = 0;
                if (inModel && (status = this.theFPSet.setStatus(fp = curState.fingerPrint(), 0)) == 0) {
                    this.theInitStates[idx] = curState;
                    this.theInitFPs[idx++] = fp;
                    this.allStateWriter.writeState(curState);
                    if (this.checkLiveness) {
                        this.liveCheck.addInitState(tool, curState, fp);
                    }
                }
                if (status == 0) {
                    int j = 0;
                    while (j < tool.getInvariants().length) {
                        if (!tool.isValid(tool.getInvariants()[j], curState)) {
                            MP.printError(2107, new String[]{tool.getInvNames()[j], tool.evalAlias(curState, curState).toString()});
                            if (!TLCGlobals.continuation) {
                                return 2107;
                            }
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < tool.getImpliedInits().length) {
                        if (!tool.isValid(tool.getImpliedInits()[j], curState)) {
                            return MP.printError(2108, new String[]{tool.getImpliedInitNames()[j], tool.evalAlias(curState, curState).toString()});
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if ((long)idx >= this.numOfGenStates.get()) return 0;
            TLCState[] stateTemp = new TLCState[idx];
            long[] fpTemp = new long[idx];
            System.arraycopy(this.theInitStates, 0, stateTemp, 0, idx);
            System.arraycopy(this.theInitFPs, 0, fpTemp, 0, idx);
            this.theInitStates = stateTemp;
            this.theInitFPs = fpTemp;
            return 0;
        }
        catch (Throwable e) {
            if (e instanceof OutOfMemoryError) {
                return MP.printError(1002);
            }
            this.errState = curState;
            throw e;
        }
    }

    public final boolean doNext(TLCState curState, long cfp, boolean isLeaf, StateVec states, LongVec fps) throws Throwable {
        return this.doNext(this.tool, curState, cfp, isLeaf, states, fps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean doNext(ITool tool, TLCState curState, long cfp, boolean isLeaf, StateVec states, LongVec fps) throws Throwable {
        boolean deadLocked = true;
        TLCState succState = null;
        SetOfStates liveNextStates = null;
        if (this.checkLiveness && isLeaf) {
            liveNextStates = new SetOfStates(16 * this.threadLocal.get());
        }
        try {
            int k = 0;
            boolean allSuccDone = true;
            boolean allSuccNonLeaf = true;
            int i2 = 0;
            while (i2 < tool.getActions().length) {
                StateVec nextStates = tool.getNextStates(tool.getActions()[i2], curState);
                int sz = nextStates.size();
                this.numOfGenStates.getAndAdd(sz);
                deadLocked = deadLocked && sz == 0;
                int j = 0;
                while (j < sz) {
                    block55: {
                        DFIDModelChecker dFIDModelChecker;
                        int len;
                        block54: {
                            succState = nextStates.elementAt(j);
                            if (!tool.isGoodState(succState)) {
                                DFIDModelChecker dFIDModelChecker2 = this;
                                synchronized (dFIDModelChecker2) {
                                    int errorCode = 2109;
                                    if (this.setErrState(curState, succState, false, 2109)) {
                                        Set<OpDeclNode> unassigned = succState.getUnassigned();
                                        String[] parameters = tool.getActions().length == 1 ? new String[]{unassigned.size() > 1 ? "s are" : " is", unassigned.stream().map(n -> n.getName().toString()).collect(Collectors.joining(", "))} : new String[]{tool.getActions()[i2].getName().toString(), unassigned.size() > 1 ? "s are" : " is", unassigned.stream().map(n -> n.getName().toString()).collect(Collectors.joining(", "))};
                                        this.printTrace(2109, parameters, curState, succState);
                                    }
                                }
                                return allSuccNonLeaf;
                            }
                            boolean inModel = tool.isInModel(succState) && tool.isInActions(curState, succState);
                            int status = 0;
                            if (inModel) {
                                long fp = succState.fingerPrint();
                                status = this.theFPSet.setStatus(fp, 0);
                                allSuccDone = allSuccDone && FPIntSet.isDone(status);
                                allSuccNonLeaf = allSuccNonLeaf && !FPIntSet.isLeaf(status);
                                this.allStateWriter.writeState(curState, succState, status == 0 ? (short)0 : 1);
                                if (!FPIntSet.isCompleted(status)) {
                                    states.addElement(succState);
                                    fps.addElement(fp);
                                }
                                if (this.checkLiveness && isLeaf) {
                                    liveNextStates.put(fp, succState);
                                }
                            }
                            if (status == 0) {
                                try {
                                    len = tool.getInvariants().length;
                                    k = 0;
                                    while (k < len) {
                                        if (!tool.isValid(tool.getInvariants()[k], succState)) {
                                            dFIDModelChecker = this;
                                            synchronized (dFIDModelChecker) {
                                                if (TLCGlobals.continuation) {
                                                    this.printTrace(2110, new String[]{tool.getInvNames()[k]}, curState, succState);
                                                    break;
                                                }
                                                if (this.setErrState(curState, succState, false, 2110)) {
                                                    this.printTrace(2110, new String[]{tool.getInvNames()[k]}, curState, succState);
                                                    this.notify();
                                                }
                                                return allSuccNonLeaf;
                                            }
                                        }
                                        ++k;
                                    }
                                    if (k >= len) break block54;
                                    break block55;
                                }
                                catch (Exception e) {
                                    dFIDModelChecker = this;
                                    synchronized (dFIDModelChecker) {
                                        if (this.setErrState(curState, succState, true, 2111)) {
                                            this.printTrace(2111, new String[]{tool.getInvNames()[k]}, curState, succState);
                                            this.notify();
                                        }
                                        return allSuccNonLeaf;
                                    }
                                }
                            }
                        }
                        try {
                            len = tool.getImpliedActions().length;
                            k = 0;
                            while (k < len) {
                                if (!tool.isValid(tool.getImpliedActions()[k], curState, succState)) {
                                    dFIDModelChecker = this;
                                    synchronized (dFIDModelChecker) {
                                        if (TLCGlobals.continuation) {
                                            this.printTrace(2112, new String[]{tool.getImpliedActNames()[k]}, curState, succState);
                                            break;
                                        }
                                        if (this.setErrState(curState, succState, false, 2112)) {
                                            this.printTrace(2112, new String[]{tool.getImpliedActNames()[k]}, curState, succState);
                                            this.notify();
                                        }
                                        return allSuccNonLeaf;
                                    }
                                }
                                ++k;
                            }
                            if (k < len) {
                                // empty if block
                            }
                        }
                        catch (Exception e) {
                            dFIDModelChecker = this;
                            synchronized (dFIDModelChecker) {
                                if (this.setErrState(curState, succState, true, 2113)) {
                                    this.printTrace(2113, new String[]{tool.getImpliedActNames()[k]}, curState, succState);
                                    this.notify();
                                }
                            }
                            return allSuccNonLeaf;
                        }
                    }
                    ++j;
                }
                succState = null;
                ++i2;
            }
            if (deadLocked && this.checkDeadlock) {
                DFIDModelChecker i2 = this;
                synchronized (i2) {
                    if (this.setErrState(curState, null, false, 2114)) {
                        this.printTrace(2114, null, curState, null);
                        this.notify();
                    }
                }
                return allSuccNonLeaf;
            }
            if (this.checkLiveness && isLeaf) {
                long curStateFP = curState.fingerPrint();
                liveNextStates.put(curStateFP, curState);
                this.allStateWriter.writeState(curState, curState, (short)0, IStateWriter.Visualization.STUTTERING);
                this.liveCheck.addNextState(tool, curState, curStateFP, liveNextStates);
                int multiplier = this.threadLocal.get();
                if (liveNextStates.capacity() > multiplier * 16) {
                    this.threadLocal.set(multiplier + 1);
                }
            }
            if (allSuccDone || isLeaf && allSuccNonLeaf) {
                this.theFPSet.setStatus(cfp, 1);
            }
            return allSuccNonLeaf;
        }
        catch (Throwable e) {
            boolean keep = e instanceof StackOverflowError || e instanceof OutOfMemoryError;
            DFIDModelChecker dFIDModelChecker = this;
            synchronized (dFIDModelChecker) {
                int errorCode = e instanceof StackOverflowError ? 1005 : (e instanceof OutOfMemoryError ? 1001 : 1000);
                if (this.setErrState(curState, succState, !keep, errorCode)) {
                    String[] parameters = null;
                    if (errorCode == 1000) {
                        parameters = new String[]{MP.ECGeneralMsg("computing the set of next states", e)};
                    }
                    this.printTrace(errorCode, parameters, curState, succState);
                    this.notifyAll();
                }
            }
            throw e;
        }
    }

    private final void printTrace(int errorCode, String[] parameters, TLCState s1, TLCState s2) {
        if (2110 == errorCode) {
            ((DFIDWorker)this.workers[IdThread.GetId()]).printInvariantTrace(errorCode, parameters, s1, s2);
        } else {
            ((DFIDWorker)this.workers[IdThread.GetId()]).printErrorTrace(errorCode, parameters, s1, s2);
        }
    }

    @Override
    public boolean setErrState(TLCState curState, TLCState succState, boolean keep, int errorCode) {
        boolean result = super.setErrState(curState, succState, keep, errorCode);
        if (!result) {
            return false;
        }
        this.setStop(2);
        return true;
    }

    public final void setStop(int code) {
        int i = 0;
        while (i < this.workers.length) {
            ((DFIDWorker)this.workers[i]).setStop(code);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int doPeriodicWork() throws Exception {
        FPIntSet fPIntSet = this.theFPSet;
        synchronized (fPIntSet) {
            int result;
            if (this.checkLiveness && (result = this.liveCheck.check(this.tool, false)) != 0) {
                return result;
            }
            if (TLCGlobals.doCheckPoint()) {
                MP.printMessage(2195, this.metadir);
                this.theFPSet.beginChkpt();
                if (this.checkLiveness) {
                    this.liveCheck.beginChkpt();
                }
                UniqueString.internTbl.beginChkpt(this.metadir);
                this.theFPSet.commitChkpt();
                if (this.checkLiveness) {
                    this.liveCheck.commitChkpt();
                }
                UniqueString.internTbl.commitChkpt(this.metadir);
                MP.printMessage(2196);
            }
        }
        return 0;
    }

    public final boolean recover() throws IOException {
        boolean recovered = false;
        if (this.fromChkpt != null) {
            MP.printMessage(2197, this.fromChkpt);
            this.theFPSet.recover();
            if (this.checkLiveness) {
                this.liveCheck.recover();
            }
            MP.printMessage(2203, String.valueOf(this.theFPSet.size()));
            recovered = true;
            this.numOfGenStates.set(this.theFPSet.size());
        }
        return recovered;
    }

    protected final void cleanup(boolean success) throws IOException {
        this.theFPSet.close();
        if (this.checkLiveness) {
            this.liveCheck.close();
        }
        this.allStateWriter.close();
        FileUtil.deleteDir(this.metadir, success);
    }

    public final void printSummary(boolean success) throws IOException {
        this.reportCoverage(this.workers);
        if (TLCGlobals.tool) {
            MP.printMessage(2206, String.valueOf(this.numOfGenStates), String.valueOf(this.theFPSet.size()));
        }
        MP.printMessage(2204, String.valueOf(this.numOfGenStates), String.valueOf(this.theFPSet.size()));
    }

    private final void reportSuccess() throws IOException {
        DFIDModelChecker.reportSuccess(this.theFPSet.size(), this.theFPSet.checkFPs(), this.numOfGenStates.get());
    }

    @Override
    protected IWorker[] startWorkers(AbstractChecker checker, int checkIndex) {
        int i = 0;
        while (i < this.workers.length) {
            this.workers[i] = new DFIDWorker(i, checkIndex, checker);
            ++i;
        }
        i = 0;
        while (i < this.workers.length) {
            this.workers[i].start();
            ++i;
        }
        return this.workers;
    }

    @Override
    protected void runTLCContinueDoing(int count, int depth) throws Exception {
        MP.printMessage(2206, String.valueOf(this.numOfGenStates), String.valueOf(this.theFPSet.size()));
        if (count == 0) {
            this.reportCoverage(this.workers);
            count = TLCGlobals.coverageInterval / TLCGlobals.progressInterval;
        } else {
            --count;
        }
        this.wait(TLCGlobals.progressInterval);
    }
}

