/*
 * Decompiled with CFR 0.152.
 */
package tlc2.module;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tla2sany.semantic.ExprOrOpArgNode;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.StringNode;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.overrides.Evaluation;
import tlc2.overrides.TLAPlusOperator;
import tlc2.tool.Action;
import tlc2.tool.EvalException;
import tlc2.tool.ModelChecker;
import tlc2.tool.StateVec;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.TLCStateMutExt;
import tlc2.tool.coverage.CostModel;
import tlc2.tool.impl.Tool;
import tlc2.util.Context;
import tlc2.util.FP64;
import tlc2.util.IdThread;
import tlc2.value.Values;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.CounterExample;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.ModelValue;
import tlc2.value.impl.RecordValue;
import tlc2.value.impl.StringValue;
import tlc2.value.impl.TupleValue;
import tlc2.value.impl.Value;
import util.Assert;

public class TLCExt {
    public static final long serialVersionUID = 20210223L;
    private static final Scanner scanner = new Scanner(System.in);
    private static final ReentrantReadWriteLock tlcEval2Lock = new ReentrantReadWriteLock();

    @Evaluation(definition="AssertError", module="TLCExt", warn=false, silent=true)
    public static synchronized Value assertError(Tool tool, ExprOrOpArgNode[] args, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        block2: {
            Assert.check(args[0] instanceof StringNode, "In computing AssertError, a non-string expression (" + String.valueOf(args[0]) + ") was used as the err of an AssertError(err, exp).");
            try {
                tool.eval(args[1], c, s0, s1, control, cm);
            }
            catch (EvalException | Assert.TLCRuntimeException e) {
                StringValue err = (StringValue)tool.eval(args[0], c, s0);
                if (!err.val.equals(e.getMessage())) break block2;
                return BoolValue.ValTrue;
            }
        }
        return BoolValue.ValFalse;
    }

    @Evaluation(definition="PickSuccessor", module="TLCExt", warn=false, silent=true, minLevel=2)
    public static synchronized Value pickSuccessor(Tool tool, ExprOrOpArgNode[] args, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        try {
            if (TLCGlobals.mainChecker != null && ((ModelChecker)TLCGlobals.mainChecker).theFPSet.contains(s1.fingerPrint())) {
                return BoolValue.ValTrue;
            }
        }
        catch (IOException notExpectedToHappen) {
            notExpectedToHappen.printStackTrace();
            return BoolValue.ValTrue;
        }
        Value guard = tool.eval(args[0], c, s0, s1, control, cm);
        if (!(guard instanceof BoolValue)) {
            Assert.fail("In evaluating TLCExt!PickSuccessor, a non-boolean expression (" + guard.getKindString() + ") was used as the condition of an IF.\n" + String.valueOf(args[0]));
        }
        if (((BoolValue)guard).val) {
            return BoolValue.ValTrue;
        }
        if (s1 == TLCState.Empty || !s1.allAssigned()) {
            return BoolValue.ValTrue;
        }
        Action action = null;
        if (s1 instanceof TLCStateMutExt) {
            action = s1.getAction();
        } else {
            Action[] actionArray = tool.getActions();
            int n = actionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Action act = actionArray[n2];
                StateVec nextStates = tool.getNextStates(act, s0);
                if (nextStates.contains(s1)) {
                    action = act;
                    break;
                }
                ++n2;
            }
        }
        while (true) {
            MP.printMessage(20000, String.format("Extend behavior of length %s with a \"%s\" step [%s]? (Yes/no/explored/states/diff):", s0.getLevel(), action.getName(), action));
            String nextLine = scanner.nextLine();
            if (nextLine.trim().isEmpty() || nextLine.toLowerCase().startsWith("y")) {
                return BoolValue.ValTrue;
            }
            if (nextLine.charAt(0) == 's') {
                MP.printMessage(20000, String.format("%s\n~>\n%s", s0.toString().trim(), s1.toString().trim()));
                continue;
            }
            if (nextLine.charAt(0) == 'd') {
                MP.printMessage(20000, s1.toString(s0));
                continue;
            }
            if (nextLine.charAt(0) == 'e') {
                if (TLCGlobals.mainChecker != null) {
                    try {
                        ((ModelChecker)TLCGlobals.mainChecker).theFPSet.put(s1.fingerPrint());
                    }
                    catch (IOException notExpectedToHappen) {
                        notExpectedToHappen.printStackTrace();
                    }
                    return BoolValue.ValTrue;
                }
                MP.printMessage(20000, String.format("Marking a state explored is unsupported by the current TLC mode. Is TLC running in simulation mode?", new Object[0]));
                continue;
            }
            if (nextLine.charAt(0) == 'n') break;
        }
        return BoolValue.ValFalse;
    }

    @TLAPlusOperator(identifier="ToTrace", module="TLCExt", warn=false)
    public static Value lassoOrdinal(Value val) {
        if (!(val instanceof CounterExample)) {
            throw new EvalException(2283, new String[]{"ToTrace", "CounterExample", Values.ppr(val.toString())});
        }
        return ((CounterExample)val).toTrace();
    }

    @Evaluation(definition="CounterExample", module="TLCExt", minLevel=1, warn=false, silent=true)
    public static Value error(Tool tool, ExprOrOpArgNode[] args, Context c, TLCState s0, TLCState s1, int control, CostModel cm) throws IOException {
        Object lookup = c.lookup(tool.getCounterExampleDef());
        if (lookup instanceof Value) {
            return (Value)lookup;
        }
        return new CounterExample();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Evaluation(definition="Trace", module="TLCExt", minLevel=1, warn=false, silent=true)
    public static TupleValue getTrace(Tool tool, ExprOrOpArgNode[] args, Context c, TLCState s0, TLCState s1, int control, CostModel cm) throws IOException {
        if (!s0.allAssigned()) {
            Set<OpDeclNode> unassigned = s0.getUnassigned();
            Assert.fail(1000, String.format("In evaluating TLCExt!Trace, the state is not completely specified yet (variable%s %s undefined).", unassigned.size() > 1 ? "s" : "", unassigned.stream().map(n -> n.getName().toString()).collect(Collectors.joining(", "))));
        }
        if (TLCGlobals.simulator != null) {
            StateVec trace = TLCGlobals.simulator.getTrace(s0);
            Value[] values = new Value[trace.size()];
            int j = 0;
            while (j < trace.size()) {
                TLCState state = trace.elementAt(j);
                values[j] = new RecordValue(state, state.getAction());
                ++j;
            }
            return new TupleValue(values);
        }
        if (s0.isInitial()) {
            return new TupleValue(new Value[]{new RecordValue(s0)});
        }
        Class<TLCExt> clazz = TLCExt.class;
        synchronized (TLCExt.class) {
            if (s0.uid == -1L) {
                ArrayList<TLCStateInfo> trace = new ArrayList<TLCStateInfo>();
                TLCState currentState = IdThread.getCurrentState();
                if (currentState.isInitial()) {
                    trace.add(new TLCStateInfo(currentState));
                    trace.add(new TLCStateInfo(s0));
                } else {
                    trace.addAll(Arrays.asList(TLCGlobals.mainChecker.getTraceInfo(currentState)));
                    trace.add(new TLCStateInfo(currentState));
                    trace.add(new TLCStateInfo(s0));
                    IdThread.setCurrentState(currentState);
                }
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return new TupleValue((Value[])trace.stream().map(si -> new RecordValue(si.state)).toArray(Value[]::new));
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return TLCExt.getTrace0(s0, TLCGlobals.mainChecker.getTraceInfo(s0));
        }
    }

    private static final TupleValue getTrace0(TLCState s0, TLCStateInfo[] trace) {
        Value[] values = new Value[trace.length + 1];
        int j = 0;
        while (j < trace.length) {
            values[j] = new RecordValue(trace[j].state);
            ++j;
        }
        values[values.length - 1] = new RecordValue(s0);
        return new TupleValue(values);
    }

    @Evaluation(definition="TLCDefer", module="TLCExt", warn=false, silent=true)
    public static Value tlcDefer(Tool tool, ExprOrOpArgNode[] args, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        try {
            Stream.of(s0, s1).forEach(s -> s.setCallable(() -> {
                Value[] argVals = new Value[args.length];
                int i = 0;
                while (i < args.length) {
                    argVals[i] = tool.eval(args[i], c, s0, s1, control, cm);
                    ++i;
                }
                return null;
            }));
        }
        catch (Throwable e) {
            Assert.fail(2154, new String[]{"TLCDefer", e.getMessage()});
        }
        return BoolValue.ValTrue;
    }

    @TLAPlusOperator(identifier="TLCNoOp", module="TLCExt", warn=false)
    public static Value tlcNoOp(Value val) {
        return val;
    }

    @TLAPlusOperator(identifier="TLCModelValue", module="TLCExt", warn=false)
    public static synchronized Value tlcModelValue(Value val) {
        if (!(val instanceof StringValue)) {
            throw new EvalException(2283, new String[]{"ModelValue", "string", Values.ppr(val.toString())});
        }
        StringValue str = (StringValue)val;
        return ModelValue.add(str.val.toString());
    }

    @Evaluation(definition="TLCCache", module="TLCExt", warn=false, silent=true)
    public static Value tlcEval2(Tool tool, ExprOrOpArgNode[] args, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        ExprOrOpArgNode expr = args[0];
        ExprOrOpArgNode closure = args[1];
        if (expr.getLevel() == 0) {
            Value key = tool.eval(closure, c, s0, s1, control, cm);
            ReentrantReadWriteLock.ReadLock readLock = tlcEval2Lock.readLock();
            ReentrantReadWriteLock.WriteLock writeLock = null;
            readLock.lock();
            try {
                HashMap<Value, Value> cache = (HashMap<Value, Value>)expr.getToolObject(tool.getId());
                Value value = null;
                if (cache != null) {
                    value = (Value)cache.get(key);
                }
                if (value != null) {
                    Value value2 = value;
                    return value2;
                }
                readLock.unlock();
                readLock = null;
                writeLock = tlcEval2Lock.writeLock();
                writeLock.lock();
                if (cache == null) {
                    cache = (HashMap)expr.getToolObject(tool.getId());
                }
                if (cache == null) {
                    cache = new HashMap<Value, Value>();
                    expr.setToolObject(tool.getId(), cache);
                }
                if ((value = (Value)cache.get(key)) != null) {
                    Value value3 = value;
                    return value3;
                }
                value = tool.eval(expr, c, s0, s1, control, cm);
                value.initialize();
                cache.put(key, value);
                Value value4 = value;
                return value4;
            }
            finally {
                if (readLock != null) {
                    readLock.unlock();
                }
                if (writeLock != null) {
                    writeLock.unlock();
                }
            }
        }
        if (expr.getLevel() == 1) {
            int key = expr.hashCode() ^ closure.hashCode() ^ tool.eval(closure, c, s0).hashCode();
            Value value = s0.getCached(key);
            if (value != null) {
                return value;
            }
            return s0.setCached(key, tool.eval(expr, c, s0, s1, control, cm));
        }
        return null;
    }

    @TLAPlusOperator(identifier="TLCFP", module="TLCExt", warn=false)
    public static synchronized IntValue tlcFingerprint(Value val) {
        val.deepNormalize();
        return IntValue.gen(FP64.Hash(val.fingerPrint(FP64.New())));
    }

    @Evaluation(definition="TLCEvalDefinition", module="TLCExt", warn=false, silent=true)
    public static Value tlcDefByName(Tool tool, ExprOrOpArgNode[] args, Context c, TLCState s0, TLCState s1, int control, CostModel cm) {
        Value v = tool.eval(args[0], c, s0, s1, control, cm);
        if (!(v instanceof StringValue)) {
            throw new EvalException(2283, new String[]{"TLCEvalDefinition", "string", Values.ppr(v.toString())});
        }
        StringValue sv = (StringValue)v;
        ModuleNode mn = tool.getSpecProcessor().getModuleTbl().getRootModule();
        assert (mn != null);
        OpDefNode opDef = mn.getOpDef(sv.val);
        if (opDef == null) {
            throw new EvalException(2283, new String[]{"TLCEvalDefinition", "name of a definition reachable from the root module", Values.ppr(v.toString())});
        }
        if (opDef.getArity() != 0) {
            throw new EvalException(2283, new String[]{"TLCEvalDefinition", "a zero-arity definition", opDef.getSignature()});
        }
        return tool.eval(opDef.getBody(), c, s0, s1, control, cm);
    }

    @TLAPlusOperator(identifier="TLCGetOrDefault", module="TLCExt", warn=false)
    public static Value tlcGetOrDefault(Value vidx, Value defVal) {
        if (vidx instanceof IntValue) {
            int idx = ((IntValue)vidx).val;
            Thread th = Thread.currentThread();
            Value res = null;
            if (th instanceof IdThread) {
                res = (Value)((IdThread)th).getLocalValue(idx);
            } else if (TLCGlobals.mainChecker != null) {
                res = (Value)TLCGlobals.mainChecker.getValue(0, idx);
            } else if (TLCGlobals.simulator != null) {
                res = (Value)TLCGlobals.simulator.getLocalValue(idx);
            }
            if (res == null) {
                return defVal;
            }
            return res;
        }
        return defVal;
    }
}

