/*
 * Decompiled with CFR 0.152.
 */
package tlc2.module;

import tlc2.tool.EvalException;
import tlc2.tool.impl.TLARegistry;
import tlc2.util.Vect;
import tlc2.value.IBoolValue;
import tlc2.value.ValueConstants;
import tlc2.value.Values;
import tlc2.value.impl.BoolValue;
import tlc2.value.impl.FcnRcdValue;
import tlc2.value.impl.IntValue;
import tlc2.value.impl.OpValue;
import tlc2.value.impl.SetEnumValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueVec;
import util.Assert;

public class Bags
implements ValueConstants {
    public static final long serialVersionUID = 20160822L;

    static {
        Assert.check(TLARegistry.put("BagCup", "\\oplus") == null, 2131, "BagCup");
        Assert.check(TLARegistry.put("BagDiff", "\\ominus") == null, 2131, "BagDiff");
        Assert.check(TLARegistry.put("SqSubseteq", "\\sqsubseteq") == null, 2131, "SqSubseteq");
    }

    public static Value EmptyBag() {
        return FcnRcdValue.EmptyFcn;
    }

    public static IBoolValue IsABag(Value b) {
        FcnRcdValue fcn = (FcnRcdValue)b.toFcnRcd();
        if (fcn == null) {
            return BoolValue.ValFalse;
        }
        Value[] vals = fcn.values;
        int i = 0;
        while (i < vals.length) {
            if (!(vals[i] instanceof IntValue) || ((IntValue)vals[i]).val <= 0) {
                return BoolValue.ValFalse;
            }
            ++i;
        }
        return BoolValue.ValTrue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IntValue BagCardinality(Value b) {
        FcnRcdValue fcn = (FcnRcdValue)b.toFcnRcd();
        if (fcn == null) {
            throw new EvalException(2176, new String[]{"BagCardinality", "a function with a finite domain", Values.ppr(b.toString())});
        }
        int num = 0;
        Value[] vals = fcn.values;
        int i = 0;
        while (i < vals.length) {
            if (!(vals[i] instanceof IntValue)) throw new EvalException(2176, new String[]{"BagCardinality", "a bag", Values.ppr(b.toString())});
            int cnt = ((IntValue)vals[i]).val;
            if (cnt <= 0) throw new EvalException(2176, new String[]{"BagCardinality", "a bag", Values.ppr(b.toString())});
            num += ((IntValue)vals[i]).val;
            ++i;
        }
        return IntValue.gen(num);
    }

    public static IBoolValue BagIn(Value e, Value b) {
        FcnRcdValue fcn = (FcnRcdValue)b.toFcnRcd();
        Value[] values = fcn.values;
        Value[] domain = fcn.getDomainAsValues();
        int i = 0;
        while (i < domain.length) {
            if (e.equals(domain[i])) {
                if (values[i] instanceof IntValue) {
                    return ((IntValue)values[i]).val > 0 ? BoolValue.ValTrue : BoolValue.ValFalse;
                }
                throw new EvalException(2169, new String[]{"second", "BagIn", "bag", Values.ppr(b.toString())});
            }
            ++i;
        }
        return BoolValue.ValFalse;
    }

    public static IntValue CopiesIn(Value e, Value b) {
        FcnRcdValue fcn = (FcnRcdValue)b.toFcnRcd();
        Value[] values = fcn.values;
        Value[] domain = fcn.getDomainAsValues();
        int i = 0;
        while (i < domain.length) {
            if (e.equals(domain[i])) {
                if (values[i] instanceof IntValue) {
                    return (IntValue)values[i];
                }
                throw new EvalException(2169, new String[]{"second", "CopiesIn", "bag", Values.ppr(b.toString())});
            }
            ++i;
        }
        return IntValue.ValZero;
    }

    public static Value BagCup(Value b1, Value b2) {
        FcnRcdValue fcn1 = (FcnRcdValue)b1.toFcnRcd();
        FcnRcdValue fcn2 = (FcnRcdValue)b2.toFcnRcd();
        if (!Bags.IsABag(fcn1).getVal()) {
            throw new EvalException(2169, new String[]{"first", "(+)", "bag", Values.ppr(b1.toString())});
        }
        if (!Bags.IsABag(fcn2).getVal()) {
            throw new EvalException(2169, new String[]{"second", "(+)", "bag", Values.ppr(b2.toString())});
        }
        Value[] domain1 = fcn1.getDomainAsValues();
        Value[] values1 = fcn1.values;
        Value[] domain2 = fcn2.getDomainAsValues();
        Value[] values2 = fcn2.values;
        Vect<Value> dVec = new Vect<Value>(domain1.length);
        Vect<Value> vVec = new Vect<Value>(domain1.length);
        int i = 0;
        while (i < domain1.length) {
            dVec.addElement(domain1[i]);
            vVec.addElement(values1[i]);
            ++i;
        }
        i = 0;
        while (i < domain2.length) {
            boolean found = false;
            int j = 0;
            while (j < domain1.length) {
                if (domain2[i].equals(domain1[j])) {
                    int v1 = ((IntValue)values1[j]).val;
                    int v2 = ((IntValue)values2[i]).val;
                    vVec.setElementAt(IntValue.gen(v1 + v2), j);
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                dVec.addElement(domain2[i]);
                vVec.addElement(values2[i]);
            }
            ++i;
        }
        Value[] domain = new Value[dVec.size()];
        Value[] values = new Value[dVec.size()];
        int i2 = 0;
        while (i2 < domain.length) {
            domain[i2] = (Value)dVec.elementAt(i2);
            values[i2] = (Value)vVec.elementAt(i2);
            ++i2;
        }
        return new FcnRcdValue(domain, values, false);
    }

    public static Value BagDiff(Value b1, Value b2) {
        FcnRcdValue fcn1 = (FcnRcdValue)b1.toFcnRcd();
        FcnRcdValue fcn2 = (FcnRcdValue)b2.toFcnRcd();
        if (fcn1 == null) {
            throw new EvalException(2169, new String[]{"first", "(-)", "bag", Values.ppr(b1.toString())});
        }
        if (fcn2 == null) {
            throw new EvalException(2169, new String[]{"second", "(-)", "bag", Values.ppr(b2.toString())});
        }
        Value[] domain1 = fcn1.getDomainAsValues();
        Value[] values1 = fcn1.values;
        Value[] domain2 = fcn2.getDomainAsValues();
        Value[] values2 = fcn2.values;
        Vect<Value> dVec = new Vect<Value>(domain1.length);
        Vect<IntValue> vVec = new Vect<IntValue>(domain1.length);
        int i = 0;
        while (i < domain1.length) {
            int v1 = ((IntValue)values1[i]).val;
            int j = 0;
            while (j < domain2.length) {
                if (domain1[i].equals(domain2[j])) {
                    int v2 = ((IntValue)values2[j]).val;
                    v1 -= v2;
                    break;
                }
                ++j;
            }
            if (v1 > 0) {
                dVec.addElement(domain1[i]);
                vVec.addElement(IntValue.gen(v1));
            }
            ++i;
        }
        Value[] domain = new Value[dVec.size()];
        Value[] values = new Value[vVec.size()];
        int i2 = 0;
        while (i2 < domain.length) {
            domain[i2] = (Value)dVec.elementAt(i2);
            values[i2] = (Value)vVec.elementAt(i2);
            ++i2;
        }
        return new FcnRcdValue(domain, values, fcn1.isNormalized());
    }

    public static Value BagUnion(Value s) {
        SetEnumValue s1 = (SetEnumValue)s.toSetEnum();
        if (s1 == null) {
            throw new EvalException(2176, new String[]{"BagUnion", "a finite enumerable set", Values.ppr(s.toString())});
        }
        s1.normalize();
        ValueVec elems = s1.elems;
        int sz = elems.size();
        if (sz == 0) {
            return FcnRcdValue.EmptyFcn;
        }
        if (sz == 1) {
            return elems.elementAt(0);
        }
        ValueVec dVec = new ValueVec();
        ValueVec vVec = new ValueVec();
        FcnRcdValue fcn = (FcnRcdValue)elems.elementAt(0).toFcnRcd();
        if (fcn == null) {
            throw new EvalException(2177, Values.ppr(s.toString()));
        }
        Value[] domain = fcn.getDomainAsValues();
        Value[] values = fcn.values;
        int i = 0;
        while (i < domain.length) {
            dVec.addElement(domain[i]);
            vVec.addElement(values[i]);
            ++i;
        }
        i = 1;
        while (i < sz) {
            fcn = (FcnRcdValue)elems.elementAt(i).toFcnRcd();
            if (fcn == null) {
                throw new EvalException(2177, Values.ppr(s.toString()));
            }
            domain = fcn.getDomainAsValues();
            values = fcn.values;
            int j = 0;
            while (j < domain.length) {
                boolean found = false;
                int k = 0;
                while (k < dVec.size()) {
                    if (domain[j].equals(dVec.elementAt(k))) {
                        int v1 = ((IntValue)vVec.elementAt((int)k)).val;
                        int v2 = ((IntValue)values[j]).val;
                        vVec.setElementAt(IntValue.gen(v1 + v2), k);
                        found = true;
                        break;
                    }
                    ++k;
                }
                if (!found) {
                    dVec.addElement(domain[j]);
                    vVec.addElement(values[j]);
                }
                ++j;
            }
            ++i;
        }
        Value[] dom = new Value[dVec.size()];
        Value[] vals = new Value[vVec.size()];
        int i2 = 0;
        while (i2 < dom.length) {
            dom[i2] = dVec.elementAt(i2);
            vals[i2] = vVec.elementAt(i2);
            ++i2;
        }
        return new FcnRcdValue(dom, vals, false);
    }

    public static IBoolValue SqSubseteq(Value b1, Value b2) {
        FcnRcdValue fcn1 = (FcnRcdValue)b1.toFcnRcd();
        FcnRcdValue fcn2 = (FcnRcdValue)b2.toFcnRcd();
        if (fcn1 == null) {
            throw new EvalException(2176, new String[]{"\\sqsubseteq", "a function with a finite domain", Values.ppr(b1.toString())});
        }
        if (fcn2 == null) {
            throw new EvalException(2176, new String[]{"\\sqsubseteq", "a function with a finite domain", Values.ppr(b2.toString())});
        }
        Value[] domain1 = fcn1.getDomainAsValues();
        Value[] values1 = fcn1.values;
        Value[] domain2 = fcn2.getDomainAsValues();
        Value[] values2 = fcn2.values;
        int i = 0;
        while (i < domain1.length) {
            int v1 = ((IntValue)values1[i]).val;
            int j = 0;
            while (j < domain2.length) {
                if (domain1[i].equals(domain2[j])) {
                    int v2 = ((IntValue)values2[j]).val;
                    v1 -= v2;
                    break;
                }
                ++j;
            }
            if (v1 > 0) {
                return BoolValue.ValFalse;
            }
            ++i;
        }
        return BoolValue.ValTrue;
    }

    public static Value BagOfAll(Value f, Value b) {
        if (!(f instanceof OpValue)) {
            throw new EvalException(2266, new String[]{"first", "BagOfAll", "operator", Values.ppr(f.toString())});
        }
        FcnRcdValue fcn = (FcnRcdValue)b.toFcnRcd();
        if (fcn == null) {
            throw new EvalException(2169, new String[]{"second", "BagOfAll", "function with a finite domain", Values.ppr(b.toString())});
        }
        OpValue ff = (OpValue)f;
        ValueVec dVec = new ValueVec();
        ValueVec vVec = new ValueVec();
        Value[] domain = fcn.getDomainAsValues();
        Value[] values = fcn.values;
        Value[] args = new Value[1];
        int i = 0;
        while (i < domain.length) {
            args[0] = domain[i];
            Value val = ff.eval(args, 0);
            boolean found = false;
            int j = 0;
            while (j < dVec.size()) {
                if (val.equals(dVec.elementAt(j))) {
                    int v1 = ((IntValue)vVec.elementAt((int)j)).val;
                    int v2 = ((IntValue)values[i]).val;
                    vVec.setElementAt(IntValue.gen(v1 + v2), j);
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                dVec.addElement(val);
                vVec.addElement(values[i]);
            }
            ++i;
        }
        Value[] dom = new Value[dVec.size()];
        Value[] vals = new Value[vVec.size()];
        int i2 = 0;
        while (i2 < dom.length) {
            dom[i2] = dVec.elementAt(i2);
            vals[i2] = vVec.elementAt(i2);
            ++i2;
        }
        return new FcnRcdValue(dom, vals, false);
    }

    public static Value BagToSet(Value b) {
        FcnRcdValue fcn = (FcnRcdValue)b.toFcnRcd();
        if (fcn == null) {
            throw new EvalException(2176, new String[]{"BagToSet", "a function with a finite domain", Values.ppr(b.toString())});
        }
        return fcn.getDomain();
    }

    public static Value SetToBag(Value b) {
        SetEnumValue s1 = (SetEnumValue)b.toSetEnum();
        if (s1 == null) {
            throw new EvalException(2176, new String[]{"BagToSet", "a function with a finite domain", Values.ppr(b.toString())});
        }
        if (!s1.isNormalized()) {
            s1.normalize();
        }
        ValueVec elems = s1.elems;
        Value[] domain = new Value[elems.size()];
        Value[] values = new Value[elems.size()];
        int i = 0;
        while (i < elems.size()) {
            domain[i] = elems.elementAt(i);
            values[i] = IntValue.ValOne;
            ++i;
        }
        return new FcnRcdValue(domain, values, s1.isNormalized());
    }
}

