/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import tla2tex.CommentToken;
import tla2tex.Debug;
import tla2tex.Misc;
import tla2tex.OutputFileWriter;
import tla2tex.Position;
import tla2tex.Token;

public class WriteTLAFile {
    public static void Write(Token[][] spec, String fileName) {
        OutputFileWriter writer = new OutputFileWriter(fileName);
        int line = 0;
        boolean deleting = false;
        int multiBelow = 0;
        while (line < spec.length) {
            Object outLine = "";
            int item = 0;
            boolean nullComment = false;
            while (item < spec[line].length) {
                Token tok = spec[line][item];
                outLine = item > 0 ? (String)outLine + WriteTLAFile.SpacesString(tok.column - spec[line][item - 1].column - spec[line][item - 1].getWidth()) : (String)outLine + WriteTLAFile.SpacesString(tok.column);
                block0 : switch (tok.type) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 12: 
                    case 13: {
                        outLine = (String)outLine + tok.string;
                        break;
                    }
                    case 3: {
                        outLine = (String)outLine + "\"" + tok.string + "\"";
                        break;
                    }
                    case 5: {
                        CommentToken ctok = (CommentToken)tok;
                        if (ctok.subtype == 7) {
                            deleting = false;
                            multiBelow = 0;
                        }
                        Object commentString = "";
                        if (ctok.subtype == 8 || ctok.subtype == 9) {
                            CommentToken bctok;
                            Token btok;
                            Position bpos;
                            int i = 0;
                            while (ctok != null && i < multiBelow) {
                                bpos = ctok.belowAlign;
                                ctok = null;
                                if (bpos.line != -1) {
                                    btok = bpos.toToken(spec);
                                    if (btok.type == 5) {
                                        bctok = (CommentToken)btok;
                                        if (bctok.subtype == 8 || bctok.subtype == 9) {
                                            ctok = bctok;
                                        }
                                    }
                                }
                                ++i;
                            }
                            if (ctok != null) {
                                commentString = ctok.string;
                                if (deleting) {
                                    commentString = "`^" + (String)commentString;
                                }
                                deleting = WriteTLAFile.UnmatchedDelete((String)commentString);
                                commentString = WriteTLAFile.RemoveDeletions((String)commentString);
                                while (deleting && ctok != null && Misc.isBlank((String)commentString)) {
                                    bpos = ctok.belowAlign;
                                    ctok = null;
                                    if (bpos.line == -1) continue;
                                    btok = bpos.toToken(spec);
                                    if (btok.type != 5) continue;
                                    bctok = (CommentToken)btok;
                                    if (bctok.subtype != 8 && bctok.subtype != 9) continue;
                                    ctok = bctok;
                                    ++multiBelow;
                                    commentString = ctok.string;
                                    deleting = WriteTLAFile.UnmatchedDelete("`^" + (String)commentString);
                                    commentString = WriteTLAFile.RemoveDeletions("`^" + (String)commentString);
                                }
                            }
                            if (ctok != null && Misc.isBlank((String)commentString)) {
                                commentString = WriteTLAFile.SpacesString(ctok.string.length());
                            }
                        } else {
                            commentString = WriteTLAFile.RemoveDeletions(ctok.string);
                            commentString = (String)commentString + WriteTLAFile.SpacesString(ctok.string.length() - ((String)commentString).length());
                        }
                        if (ctok != null) {
                            commentString = WriteTLAFile.ReplaceQuoteTildes((String)commentString);
                            switch (ctok.rsubtype) {
                                case 1: {
                                    outLine = (String)outLine + "(*" + (String)commentString + "*)";
                                    break block0;
                                }
                                case 2: {
                                    outLine = (String)outLine + "\\*" + (String)commentString;
                                    break block0;
                                }
                                case 3: {
                                    outLine = (String)outLine + "(*" + (String)commentString;
                                    break block0;
                                }
                                case 4: {
                                    outLine = (String)outLine + (String)commentString + "*)";
                                    break block0;
                                }
                                case 5: {
                                    outLine = (String)outLine + (String)commentString;
                                    break block0;
                                }
                            }
                            Debug.ReportBug("Bad CommentToken subtype found.");
                            break;
                        }
                        nullComment = true;
                        break;
                    }
                    default: {
                        Debug.ReportBug("Bad token type found.");
                    }
                }
                ++item;
            }
            if (!nullComment || spec[line].length != 1) {
                writer.putLine((String)outLine);
            }
            ++line;
        }
        writer.close();
    }

    private static String SpacesString(int n) {
        int i = 0;
        Object result = "";
        while (i < n) {
            result = (String)result + " ";
            ++i;
        }
        return result;
    }

    private static boolean UnmatchedDelete(String str) {
        return str.lastIndexOf("^'") < str.lastIndexOf("`^");
    }

    private static String RemoveDeletions(String str) {
        String rest = str;
        Object start = "";
        int nextDel = rest.indexOf("`^");
        while (nextDel != -1) {
            start = (String)start + rest.substring(0, nextDel);
            int nextEnd = (rest = rest.substring(nextDel)).indexOf("^'");
            if (nextEnd == -1) {
                nextDel = -1;
                rest = "";
                continue;
            }
            rest = rest.substring(nextEnd + 2);
            nextDel = rest.indexOf("`^");
        }
        return (String)start + rest;
    }

    private static String ReplaceQuoteTildes(String str) {
        Object result = str;
        int nextRepl = ((String)result).indexOf("`~");
        while (nextRepl != -1) {
            result = ((String)result).substring(0, nextRepl) + "  " + ((String)result).substring(nextRepl + 2);
            nextRepl = ((String)result).indexOf("`~");
        }
        nextRepl = ((String)result).indexOf("~'");
        while (nextRepl != -1) {
            result = ((String)result).substring(0, nextRepl) + "  " + ((String)result).substring(nextRepl + 2);
            nextRepl = ((String)result).indexOf("~'");
        }
        nextRepl = ((String)result).indexOf("`.");
        while (nextRepl != -1) {
            result = ((String)result).substring(0, nextRepl) + "  " + ((String)result).substring(nextRepl + 2);
            nextRepl = ((String)result).indexOf("`.");
        }
        nextRepl = ((String)result).indexOf(".'");
        while (nextRepl != -1) {
            result = ((String)result).substring(0, nextRepl) + "  " + ((String)result).substring(nextRepl + 2);
            nextRepl = ((String)result).indexOf(".'");
        }
        return result;
    }
}

