/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import java.lang.invoke.StringConcatFactory;
import java.util.Hashtable;
import java.util.Vector;
import tla2tex.BuiltInSymbols;
import tla2tex.CToken;
import tla2tex.Debug;
import tla2tex.LaTeXOutput;
import tla2tex.Misc;
import tla2tex.OutputFileWriter;
import tla2tex.Parameters;
import tla2tex.ResourceFileReader;
import tla2tex.Symbol;
import tla2tex.TokenizeComment;

public final class FormatComments {
    private static String nullString = "";
    private static Hashtable wordHashTable = new Hashtable(100000);
    private static Hashtable ambiguousHashTable = new Hashtable(100);
    private static Hashtable repeatCharHashTable = new Hashtable(100);
    private static Hashtable alignTokenHashTable = new Hashtable(100);
    public static final int ONE_LINE = 1;
    public static final int ZERO_WIDTH = 2;
    public static final int PAR = 3;
    public static final int RIGHT_MULTI = 4;

    public static void WriteComment(OutputFileWriter writer, Vector vec, int commentType, float indentOrWidth, boolean tlaMode) {
        CToken[][] tokens = null;
        tokens = tlaMode ? TokenizeComment.Tokenize(vec) : TokenizeComment.TeXTokenize(vec);
        if (tokens == null) {
            return;
        }
        CToken.FindPfStepCTokens(tokens);
        if (tlaMode) {
            FormatComments.adjustIsTLA(tokens);
        }
        FormatComments.InnerWriteComment(writer, tokens, commentType, indentOrWidth);
    }

    public static void Initialize() {
        FormatComments.ReadWordFile();
        FormatComments.InitializeAmbiguousHashtable();
        FormatComments.InitializeRepeatCharHashtable();
        FormatComments.InitializeAlignTokenHashtable();
    }

    public static boolean IsWord(String str) {
        return wordHashTable.get(str) != null;
    }

    private static void ReadWordFile() {
        ResourceFileReader wordFileReader = new ResourceFileReader(Parameters.WordFile);
        String word = wordFileReader.getLine();
        while (word != null) {
            wordHashTable.put(word, nullString);
            wordHashTable.put(word.substring(0, 1).toUpperCase() + word.substring(1), new String());
            word = wordFileReader.getLine();
        }
        wordFileReader.close();
    }

    public static boolean isAmbiguous(String str) {
        return ambiguousHashTable.get(str) != null;
    }

    private static String getAmbiguous(String str) {
        return (String)ambiguousHashTable.get(str);
    }

    private static void add(String tla, String tex) {
        ambiguousHashTable.put(tla, tex);
    }

    private static void InitializeAmbiguousHashtable() {
        FormatComments.add("_", "\\_");
        FormatComments.add("(", "(");
        FormatComments.add("[", "[");
        FormatComments.add(")", ")");
        FormatComments.add("]", "]");
        FormatComments.add("~", "\\ensuremath{\\sim}");
        FormatComments.add("'", "\\mbox{'}");
        FormatComments.add("-", "-");
        FormatComments.add("+", "+");
        FormatComments.add("*", "*");
        FormatComments.add("/", "/");
        FormatComments.add("&", "\\&");
        FormatComments.add("#", "\\#");
        FormatComments.add(":", ":");
        FormatComments.add("...", "\\.{\\dots}");
        FormatComments.add("$", "\\.{\\$}");
        FormatComments.add("?", "\\.{?}");
        FormatComments.add("??", "\\.{??}");
        FormatComments.add("%", "\\.{\\%}");
        FormatComments.add("!!", "\\.{!!}");
        FormatComments.add(",", ",");
        FormatComments.add("!", "!");
        FormatComments.add(".", ".");
        FormatComments.add("@", "@");
        FormatComments.add("--", "--");
    }

    public static boolean isRepeatChar(char ch) {
        return repeatCharHashTable.get("" + ch) != null;
    }

    private static String getRepeatCharCommand(char ch) {
        return ((Symbol)FormatComments.repeatCharHashTable.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001"}, (char)ch))).TeXString;
    }

    public static int getRepeatCharMin(char ch) {
        return ((Symbol)FormatComments.repeatCharHashTable.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001"}, (char)ch))).symbolType;
    }

    private static void addRepeatChar(char ch, String tex, int min) {
        repeatCharHashTable.put("" + ch, new Symbol("", tex, min, 0));
    }

    private static void InitializeRepeatCharHashtable() {
        FormatComments.addRepeatChar('-', "\\cdash", 3);
        FormatComments.addRepeatChar('=', "\\ceqdash", 3);
        FormatComments.addRepeatChar('^', "", 3);
        FormatComments.addRepeatChar('#', "", 3);
        FormatComments.addRepeatChar('_', "\\usdash", 2);
        FormatComments.addRepeatChar('~', "\\tdash", 2);
        FormatComments.addRepeatChar('*', "", 3);
        FormatComments.addRepeatChar('.', "", 4);
        FormatComments.addRepeatChar('+', "", 3);
    }

    private static boolean isAlignToken(String str) {
        return alignTokenHashTable.get(str) != null;
    }

    private static void addAlignToken(String str) {
        alignTokenHashTable.put(str, nullString);
    }

    private static void InitializeAlignTokenHashtable() {
        FormatComments.addAlignToken("=>");
        FormatComments.addAlignToken("\\cdot");
        FormatComments.addAlignToken("<=>");
        FormatComments.addAlignToken("\\equiv");
        FormatComments.addAlignToken("~>");
        FormatComments.addAlignToken("-+->");
        FormatComments.addAlignToken("\\ll");
        FormatComments.addAlignToken("\\gg");
        FormatComments.addAlignToken("\\");
        FormatComments.addAlignToken("\\cap");
        FormatComments.addAlignToken("\\intersect");
        FormatComments.addAlignToken("\\cup");
        FormatComments.addAlignToken("\\union");
        FormatComments.addAlignToken("/\\");
        FormatComments.addAlignToken("\\/");
        FormatComments.addAlignToken("\\land");
        FormatComments.addAlignToken("\\lor");
        FormatComments.addAlignToken("\\X");
        FormatComments.addAlignToken("-");
        FormatComments.addAlignToken("+");
        FormatComments.addAlignToken("*");
        FormatComments.addAlignToken("^");
        FormatComments.addAlignToken("|");
        FormatComments.addAlignToken("||");
        FormatComments.addAlignToken("&");
        FormatComments.addAlignToken("&&");
        FormatComments.addAlignToken("++");
        FormatComments.addAlignToken("--");
        FormatComments.addAlignToken("**");
        FormatComments.addAlignToken("^^");
        FormatComments.addAlignToken("|-");
        FormatComments.addAlignToken("|=");
        FormatComments.addAlignToken("-|");
        FormatComments.addAlignToken("=|");
        FormatComments.addAlignToken("<:");
        FormatComments.addAlignToken(":>");
        FormatComments.addAlignToken(":=");
        FormatComments.addAlignToken("::=");
        FormatComments.addAlignToken("(+)");
        FormatComments.addAlignToken("(-)");
        FormatComments.addAlignToken("\\oplus");
        FormatComments.addAlignToken("\\ominus");
        FormatComments.addAlignToken("(.)");
        FormatComments.addAlignToken("\\odot");
        FormatComments.addAlignToken("(/)");
        FormatComments.addAlignToken("\\oslash");
        FormatComments.addAlignToken("(\\X)");
        FormatComments.addAlignToken("\\otimes");
        FormatComments.addAlignToken("\\uplus");
        FormatComments.addAlignToken("\\sqcap");
        FormatComments.addAlignToken("\\sqcup");
        FormatComments.addAlignToken("\\div");
        FormatComments.addAlignToken("\\star");
        FormatComments.addAlignToken("\\o");
        FormatComments.addAlignToken("\\circ");
        FormatComments.addAlignToken("\\bigcirc");
        FormatComments.addAlignToken("\\bullet");
        FormatComments.addAlignToken("\\in");
        FormatComments.addAlignToken("\\notin");
        FormatComments.addAlignToken("=");
        FormatComments.addAlignToken("#");
        FormatComments.addAlignToken("/=");
        FormatComments.addAlignToken("<");
        FormatComments.addAlignToken(">");
        FormatComments.addAlignToken("=<");
        FormatComments.addAlignToken(">=");
        FormatComments.addAlignToken("\\prec");
        FormatComments.addAlignToken("\\succ");
        FormatComments.addAlignToken("\\preceq");
        FormatComments.addAlignToken("\\succeq");
        FormatComments.addAlignToken("\\sim");
        FormatComments.addAlignToken("\\simeq");
        FormatComments.addAlignToken("\\approx");
        FormatComments.addAlignToken("\\doteq");
        FormatComments.addAlignToken("\\asymp");
        FormatComments.addAlignToken("\\sqsubset");
        FormatComments.addAlignToken("\\sqsupset");
        FormatComments.addAlignToken("\\sqsubseteq");
        FormatComments.addAlignToken("\\sqsupseteq");
        FormatComments.addAlignToken("\\propto");
        FormatComments.addAlignToken(":");
        FormatComments.addAlignToken("->");
        FormatComments.addAlignToken("|->");
        FormatComments.addAlignToken("<-");
        FormatComments.addAlignToken("==");
        FormatComments.addAlignToken("ELSE");
        FormatComments.addAlignToken("THEN");
        FormatComments.addAlignToken("LET");
        FormatComments.addAlignToken("IN");
        FormatComments.addAlignToken("[]");
        FormatComments.addAlignToken("..");
        FormatComments.addAlignToken("...");
        FormatComments.addAlignToken("$");
        FormatComments.addAlignToken("$$");
        FormatComments.addAlignToken("%");
        FormatComments.addAlignToken("%%");
        FormatComments.addAlignToken("##");
        FormatComments.addAlignToken("@@");
        FormatComments.addAlignToken("\\times");
        FormatComments.addAlignToken("\\leq");
        FormatComments.addAlignToken("\\geq");
        FormatComments.addAlignToken("\\mod");
        FormatComments.addAlignToken("\\wr");
        FormatComments.addAlignToken("\\cong");
        FormatComments.addAlignToken("-.");
        FormatComments.addAlignToken("@");
    }

    private static boolean PossibleAlignment(CToken[][] com, int line, int itemNo) {
        return com[line][itemNo].column > com[line][itemNo - 1].column + com[line][itemNo - 1].getWidth() + 1 || com[line][itemNo].column > com[line][itemNo - 1].column + com[line][itemNo - 1].getWidth() && com[line][itemNo - 1].type == 1 && !com[line][itemNo - 1].string.equals(".") && !com[line][itemNo - 1].string.equals(",");
    }

    private static CToken nextCToken(CToken[][] com, int line, int item) {
        if (item + 1 < com[line].length) {
            return com[line][item + 1];
        }
        if (line + 1 < com.length && com[line + 1].length != 0) {
            return com[line + 1][0];
        }
        return CToken.nullCToken;
    }

    private static CToken previousCToken(CToken[][] com, int line, int item) {
        if (item > 0) {
            return com[line][item - 1];
        }
        if (line > 0 && com[line - 1].length != 0) {
            return com[line - 1][com[line - 1].length - 1];
        }
        return CToken.nullCToken;
    }

    private static boolean isPreviousAdjacent(CToken[][] com, int line, int item) {
        return item > 0 && com[line][item - 1].column + com[line][item - 1].getWidth() == com[line][item].column;
    }

    private static boolean isNextAdjacent(CToken[][] com, int line, int item) {
        return item + 1 < com[line].length && com[line][item].column + com[line][item].getWidth() == com[line][item + 1].column;
    }

    public static void adjustIsTLA(CToken[][] com) {
        int line = 0;
        int item = 0;
        CToken tok = null;
        CToken ptok = null;
        CToken ntok = null;
        line = 0;
        while (line < com.length) {
            item = 0;
            while (item < com[line].length) {
                tok = com[line][item];
                if (!tok.isTLA) {
                    ptok = FormatComments.previousCToken(com, line, item);
                    ntok = FormatComments.nextCToken(com, line, item);
                    if (tok.string.equals("'") && FormatComments.isNextAdjacent(com, line, item) && ntok.type == 4) {
                        tok.isAmbiguous = false;
                        ntok.isAmbiguous = false;
                        ntok.isTLA = false;
                    }
                    if (tok.string.equals("-") && FormatComments.isPreviousAdjacent(com, line, item)) {
                        if (item == com[line].length - 1 && ptok.type == 4 && !ptok.isTLA) {
                            tok.isAmbiguous = false;
                            ptok.isAmbiguous = false;
                        }
                        if (!(!FormatComments.isNextAdjacent(com, line, item) || ntok.type != 4 || ntok.isTLA && ptok.isTLA)) {
                            tok.isAmbiguous = false;
                            ptok.isAmbiguous = false;
                            ntok.isAmbiguous = false;
                        }
                    }
                    if (tok.string.equals("+") && FormatComments.isPreviousAdjacent(com, line, item) && ptok.string.equals("TLA")) {
                        tok.isAmbiguous = false;
                        ptok.isAmbiguous = false;
                    }
                }
                ++item;
            }
            ++line;
        }
        line = 0;
        while (line < com.length) {
            item = 0;
            while (item < com[line].length) {
                tok = com[line][item];
                if (tok.string.equals(".") && FormatComments.isNextAdjacent(com, line, item) && com[line][item + 1].type == 4) {
                    tok.isTLA = true;
                    com[line][item + 1].isTLA = true;
                    if (FormatComments.isPreviousAdjacent(com, line, item)) {
                        com[line][item - 1].isTLA = true;
                    }
                } else if ((tok.string.equals("(") || tok.string.equals("[")) && FormatComments.isPreviousAdjacent(com, line, item)) {
                    tok.isTLA = true;
                    com[line][item - 1].isTLA = true;
                }
                ++item;
            }
            ++line;
        }
        line = 0;
        while (line < com.length) {
            item = 0;
            while (item < com[line].length) {
                tok = com[line][item];
                ptok = FormatComments.previousCToken(com, line, item);
                String tstr = tok.string;
                if (!(tok.type != 4 || !tok.isAmbiguous || Misc.IsLowerCase(tstr) || Misc.IsUpperCase(tstr) && FormatComments.IsWord(tstr.toLowerCase()) || Misc.IsCapitalized(tstr) && (item == 0 || ptok.string.equals(".") || ptok.string.equals("(") || ptok.string.equals(")") || ptok.type == 8 || ptok.type == 7 || ptok.column + ptok.getWidth() <= tok.column - 2))) {
                    tok.isTLA = true;
                }
                ++item;
            }
            ++line;
        }
        line = 0;
        while (line < com.length) {
            item = 0;
            while (item < com[line].length) {
                tok = com[line][item];
                if (tok.type == 1 && Misc.IsUpperCase(tok.string) && (item > 0 && com[line][item - 1].type == 4 && !com[line][item - 1].isTLA && Misc.IsUpperCase(com[line][item - 1].string) || item + 1 < com[line].length && com[line][item + 1].type == 4 && !com[line][item + 1].isTLA && Misc.IsUpperCase(com[line][item + 1].string))) {
                    tok.type = 4;
                    tok.isTLA = false;
                }
                ++item;
            }
            ++line;
        }
        int parenLevel = 0;
        line = 0;
        while (line < com.length) {
            item = 0;
            if (com.length == 0) {
                parenLevel = 0;
            }
            while (item < com[line].length) {
                tok = com[line][item];
                if (parenLevel > 0) {
                    tok.isTLA = true;
                }
                if (tok.type == 1 && BuiltInSymbols.GetBuiltInSymbol((String)tok.string, (boolean)true).symbolType == 4 && (parenLevel > 0 || tok.isTLA)) {
                    ++parenLevel;
                } else if (tok.type == 1 && (BuiltInSymbols.GetBuiltInSymbol((String)tok.string, (boolean)true).symbolType == 5 || tok.string.equals("]_")) && parenLevel > 0) {
                    --parenLevel;
                }
                ++item;
            }
            ++line;
        }
        line = 0;
        while (line < com.length) {
            item = 0;
            while (item < com[line].length) {
                tok = com[line][item];
                ptok = FormatComments.previousCToken(com, line, item);
                ntok = FormatComments.nextCToken(com, line, item);
                if (!tok.isTLA && tok.isAmbiguous) {
                    switch (tok.type) {
                        case 2: 
                        case 4: {
                            int stype;
                            if (Parameters.TLACommentOption) {
                                tok.isTLA = true;
                            } else if (ptok.type == 1 && ((stype = BuiltInSymbols.GetBuiltInSymbol((String)ptok.string, (boolean)true).symbolType) == 1 || stype == 2) && (ptok.isTLA || ptok.isAmbiguous)) {
                                tok.isTLA = true;
                                ptok.isTLA = true;
                            }
                            if (ntok.type != 1 || (stype = BuiltInSymbols.GetBuiltInSymbol((String)ntok.string, (boolean)true).symbolType) != 1 && stype != 3 || !ntok.isTLA && !ntok.isAmbiguous) break;
                            tok.isTLA = true;
                            ntok.isTLA = true;
                            break;
                        }
                        case 1: {
                            int stype = BuiltInSymbols.GetBuiltInSymbol((String)tok.string, (boolean)true).symbolType;
                            if ((stype == 2 || stype == 1) && (ntok.isTLA || ntok.isAmbiguous)) {
                                tok.isTLA = true;
                                ntok.isTLA = true;
                            }
                            if (stype != 1 && stype != 3 || !ptok.isTLA && !ptok.isAmbiguous) break;
                            tok.isTLA = true;
                            ptok.isTLA = true;
                            break;
                        }
                        default: {
                            Debug.ReportBug("FormatComments.adjustIsTLA: ambiguous CToken of wrong type");
                        }
                    }
                }
                ++item;
            }
            ++line;
        }
        Hashtable<String, String> thisCommentTLA = new Hashtable<String, String>(100);
        line = 0;
        while (line < com.length) {
            item = 0;
            while (item < com[line].length) {
                tok = com[line][item];
                if (tok.type == 4 && tok.isTLA) {
                    thisCommentTLA.put(tok.string, nullString);
                }
                ++item;
            }
            ++line;
        }
        line = 0;
        while (line < com.length) {
            item = 0;
            while (item < com[line].length) {
                tok = com[line][item];
                if (tok.isAmbiguous && !FormatComments.IsWord(tok.string) && thisCommentTLA.get(tok.string) != null) {
                    tok.isTLA = true;
                }
                ++item;
            }
            ++line;
        }
        line = 0;
        while (line < com.length) {
            item = 0;
            while (item < com[line].length) {
                tok = com[line][item];
                if (tok.type == 9 || tok.type == 10) {
                    tok.isTLA = false;
                }
                ++item;
            }
            ++line;
        }
    }

    private static boolean IsTLALine(CToken[] tokLine) {
        boolean result = true;
        int i = 0;
        while (result && i < tokLine.length) {
            result = tokLine[i].isTLA;
            ++i;
        }
        return result;
    }

    private static void InnerWriteComment(OutputFileWriter writer, CToken[][] com, int commentType, float indentOrWidth) {
        int[] lineType = new int[com.length];
        String[] parStart = new String[com.length];
        boolean[] oneLine = new boolean[com.length];
        boolean thisAligned = false;
        boolean prevAligned = false;
        int line = 0;
        while (line < com.length) {
            thisAligned = false;
            if (line + 1 < com.length && com[line + 1].length != 0) {
                int m = 0;
                int n = 0;
                int lastn = com[line + 1].length;
                while (!thisAligned && m < com[line].length && com[line][m].column <= com[line + 1][lastn - 1].column) {
                    CToken mtok = com[line][m];
                    if (!(!FormatComments.isAlignToken(mtok.string) && mtok.type != 6 || FormatComments.isPreviousAdjacent(com, line, m) && FormatComments.isNextAdjacent(com, line, m))) {
                        while (!thisAligned && n < lastn && mtok.column >= com[line + 1][n].column) {
                            CToken ntok = com[line + 1][n];
                            if (!(mtok.column != ntok.column || !mtok.string.equals(ntok.string) || FormatComments.isPreviousAdjacent(com, line + 1, n) && FormatComments.isNextAdjacent(com, line + 1, n))) {
                                thisAligned = true;
                            }
                            ++n;
                        }
                    }
                    ++m;
                }
            }
            boolean bl = oneLine[line] = thisAligned || FormatComments.IsTLALine(com[line]) || prevAligned && line + 1 < com.length && com[line + 1].length > 0 && com[line][0].column > com[line + 1][0].column;
            if (thisAligned && (line + 2 == com.length || com[line + 2].length == 0)) {
                oneLine[line + 1] = true;
            }
            prevAligned = thisAligned;
            ++line;
        }
        line = 0;
        while (line + 1 < com.length) {
            if (com[line].length != 0) {
                CToken tok = com[line][0];
                if (com[line + 1].length != 0 && tok.string.equals(com[line + 1][0].string) && (tok.type != 4 || tok.string.length() >= 4 && tok.isAmbiguous || tok.isTLA) && tok.isTLA == com[line + 1][0].isTLA) {
                    oneLine[line] = true;
                    if (line + 2 == com.length || com[line + 2].length == 0) {
                        oneLine[line + 1] = true;
                    }
                }
            }
            ++line;
        }
        line = 0;
        while (line + 1 < com.length) {
            if (com[line].length != 0 && com[line][0].type == 2 && com[line + 1].length != 0 && com[line + 1][0].type == 2) {
                oneLine[line] = true;
                if (line + 2 == com.length || com[line + 2].length == 0) {
                    oneLine[line + 1] = true;
                }
            }
            ++line;
        }
        line = 0;
        while (line < com.length) {
            int itemNo = 1;
            int maxUnalignedLine = line + 1;
            while (itemNo <= 5 && itemNo < com[line].length) {
                if (FormatComments.PossibleAlignment(com, line, itemNo)) {
                    int col = com[line][itemNo].column;
                    int nextLine = line + 1;
                    while (nextLine < com.length && itemNo < com[nextLine].length && FormatComments.PossibleAlignment(com, nextLine, itemNo) && com[nextLine][itemNo].column == col) {
                        ++nextLine;
                    }
                    if (nextLine > maxUnalignedLine) {
                        maxUnalignedLine = nextLine;
                    }
                }
                ++itemNo;
            }
            if (maxUnalignedLine - line >= 3) {
                int kk = line;
                while (kk < maxUnalignedLine - 1) {
                    oneLine[kk] = true;
                    ++kk;
                }
                if (maxUnalignedLine == com.length || com[maxUnalignedLine].length == 0) {
                    oneLine[maxUnalignedLine - 1] = true;
                }
            }
            ++line;
        }
        line = 0;
        while (line < com.length) {
            if (com[line].length != 0) {
                int item = 0;
                while (item < com[line].length && com[line][item].type == 6) {
                    ++item;
                }
                if (item == com[line].length) {
                    oneLine[line] = true;
                }
            }
            ++line;
        }
        int marginDepth = 0;
        int[] margin = new int[200];
        line = 0;
        margin[0] = 999;
        while (line < com.length) {
            if (com[line].length > 0 && com[line][0].column < margin[0]) {
                margin[0] = com[line][0].column;
            }
            ++line;
        }
        boolean startNewPar = false;
        if (FormatComments.IsParType(commentType)) {
            startNewPar = true;
            line = 0;
            while (line < com.length) {
                if (com[line].length == 0) {
                    lineType[line] = -2;
                    ++line;
                    continue;
                }
                int nextParLine = line + 1;
                int newMargin = com[line][0].column;
                int labelItem = 0;
                int popArg = 0;
                boolean nest = false;
                String nestArg = "F";
                boolean isLabel = false;
                String isLabelArg = "F";
                int dim1Cols = 0;
                int dim2Cols = 0;
                if (com[line][0].type == 9 || com[line][0].type == 10 && com[line].length == 1) {
                    int tokType = com[line][0].type;
                    if (tokType == 9) {
                        newMargin = 0;
                        popArg = marginDepth;
                        marginDepth = 0;
                    } else {
                        newMargin = com[line][0].column;
                        while (margin[marginDepth] > newMargin) {
                            --marginDepth;
                            ++popArg;
                        }
                        dim1Cols = com[line][0].column - margin[marginDepth];
                    }
                    while (nextParLine < com.length && com[nextParLine].length > 0 && com[nextParLine][0].type == tokType) {
                        ++nextParLine;
                    }
                } else {
                    int leftMargin;
                    if (!oneLine[line] && line + 1 < com.length && com[line + 1].length != 0 && !oneLine[line + 1] && com[line + 1][0].column >= com[line][0].column) {
                        newMargin = com[line + 1][0].column;
                        nextParLine = line + 2;
                        while (nextParLine < com.length && com[nextParLine].length != 0 && !oneLine[nextParLine] && com[nextParLine][0].column == newMargin) {
                            ++nextParLine;
                        }
                    }
                    if ((leftMargin = com[line][0].column) > newMargin) {
                        leftMargin = newMargin;
                    }
                    while (margin[marginDepth] > leftMargin) {
                        --marginDepth;
                        ++popArg;
                    }
                    dim1Cols = com[line][0].column - margin[marginDepth];
                    boolean bl = nest = margin[marginDepth] != newMargin;
                    if (nest) {
                        nestArg = "T";
                    }
                    if (com[line][0].column < newMargin) {
                        int i = 0;
                        while (i + 1 < com[line].length && com[line][i + 1].column <= newMargin) {
                            ++i;
                        }
                        boolean bl2 = isLabel = com[line][i].column == newMargin;
                        if (isLabel) {
                            labelItem = i;
                            isLabelArg = "T";
                        }
                    }
                    dim2Cols = isLabel ? com[line][labelItem].column - com[line][labelItem - 1].column - com[line][labelItem - 1].getWidth() : newMargin - com[line][0].column;
                    if (nest) {
                        margin[++marginDepth] = newMargin;
                    }
                }
                lineType[line] = labelItem;
                String temp = "\\begin{cpar}{" + popArg + "}{" + nestArg + "}{" + isLabelArg + "}{" + Misc.floatToString(Parameters.LaTeXCommentLeftSpace(dim1Cols), 2) + "}{" + Misc.floatToString(Parameters.LaTeXCommentLeftSpace(dim2Cols), 2) + "}{";
                parStart[line] = isLabel ? temp + "%" : temp + "}%";
                ++line;
                while (line < nextParLine) {
                    lineType[line] = -1;
                    ++line;
                }
            }
        } else if (com.length != 0) {
            lineType[0] = -1;
        }
        line = 0;
        while (line < com.length && lineType[line] == -2) {
            ++line;
        }
        int endLine = com.length;
        while (endLine > line && lineType[endLine - 1] == -2) {
            --endLine;
        }
        if (line == endLine || !FormatComments.IsParType(commentType) && com[0].length == 0) {
            if (commentType == 1) {
                writer.putLine("\\@y{}%");
            }
            return;
        }
        Object tempStr = "";
        switch (commentType) {
            case 1: {
                tempStr = "\\@y{";
                if (com[0].length > 0 && com[0][0].column > 0) {
                    tempStr = (String)tempStr + "\\@s{" + Misc.floatToString(Parameters.LaTeXCommentLeftSpace(com[0][0].column - 1), 2) + "}";
                }
                writer.putLine((String)tempStr + "%");
                break;
            }
            case 2: {
                tempStr = "\\@z{";
                if (com[0].length > 0 && com[0][0].column > 0) {
                    tempStr = (String)tempStr + "\\@s{" + Misc.floatToString(Parameters.LaTeXCommentLeftSpace(com[0][0].column - 1), 2) + "}";
                }
                writer.putLine((String)tempStr + "%");
                break;
            }
            case 3: {
                float indent = indentOrWidth;
                if (indent < -1.0f) {
                    indent = Parameters.LaTeXCommentLeftSpace(margin[0]);
                }
                writer.putLine("\\begin{lcom}{" + Misc.floatToString(indent, 2) + "}%");
                break;
            }
            case 4: {
                writer.putLine("\\begin{mcom}{" + Misc.floatToString(indentOrWidth, 2) + "}%");
                break;
            }
            default: {
                Debug.ReportBug("The impossible has happened in FormatComments.InnerWriteComment");
            }
        }
        Object curOutput = "";
        boolean openPar = false;
        boolean openVerb = false;
        boolean openMath = false;
        boolean openLabel = false;
        int item = 0;
        while (line < endLine) {
            if (lineType[line] == -2) {
                if (openPar) {
                    FormatComments.CloseParagraph(writer, (String)curOutput, openMath, openVerb);
                    openPar = false;
                    openMath = false;
                    openVerb = false;
                    curOutput = "";
                }
                int numOfBlankLines = 0;
                while (lineType[line] == -2) {
                    ++numOfBlankLines;
                    ++line;
                }
                --line;
                writer.putLine("\\vshade{" + Misc.floatToString(Parameters.LaTeXCommentVSpace(numOfBlankLines), 2) + "}%");
            } else {
                if (lineType[line] != -1) {
                    if (openPar) {
                        FormatComments.CloseParagraph(writer, (String)curOutput, openMath, openVerb);
                        openMath = false;
                        openVerb = false;
                        curOutput = "";
                    }
                    writer.putLine(parStart[line]);
                    openPar = true;
                    Debug.Assert(!openVerb && !openMath, "FormatComments.InnerWriteComment: Invariant (openMath \\/ openVerb) => openPar  violated");
                    openLabel = false;
                    if (lineType[line] > 0) {
                        openLabel = true;
                    }
                }
                Debug.Assert(((String)curOutput).equals(""), "FormatComments.InnerWriteComment: Output not processed\n    when it should have been");
                item = 0;
                while (item < com[line].length) {
                    if (openLabel && item == lineType[line]) {
                        if (openMath) {
                            curOutput = (String)curOutput + "}";
                            openMath = false;
                        }
                        Misc.BreakStringOut(writer, (String)curOutput + "}%");
                        curOutput = "";
                        openLabel = false;
                    }
                    if (com[line][item].type == 9) {
                        if (openMath) {
                            curOutput = (String)curOutput + "}";
                            openMath = false;
                        }
                        if (FormatComments.IsParType(commentType) && !openLabel && item == 0) {
                            Debug.Assert(((String)curOutput).equals(""), "FormatComments.InnerWriteComment: failed to write curOutput");
                            if (!openVerb) {
                                writer.putLine("\\begin{minipage}[t]{\\linewidth}");
                                writer.putLine("\\begin{verbatim}");
                                openVerb = true;
                                int w = com[line][item].column;
                                while (w > 0) {
                                    curOutput = (String)curOutput + " ";
                                    --w;
                                }
                            }
                            writer.putLine((String)curOutput + com[line][0].string);
                            curOutput = "";
                        } else {
                            curOutput = (String)curOutput + Misc.TeXify(com[line][item].string);
                        }
                    } else {
                        if (openVerb) {
                            writer.putLine("\\end{verbatim}%");
                            writer.putLine("\\end{minipage}");
                            openVerb = false;
                        }
                        CToken tok = com[line][item];
                        CToken ptok = FormatComments.previousCToken(com, line, item);
                        if (openMath && (!tok.isTLA || tok.type == 10)) {
                            curOutput = (String)curOutput + "}";
                            openMath = false;
                        }
                        if (!FormatComments.isPreviousAdjacent(com, line, item) && (lineType[line] < 0 || item != 0 && item != lineType[line])) {
                            curOutput = item > 0 && ptok.column + ptok.getWidth() <= tok.column - 5 ? (String)curOutput + "\\@s{" + Misc.floatToString(Parameters.LaTeXCommentLeftSpace(tok.column - (ptok.column + ptok.getWidth())), 2) + "}" : (!(!tok.isTLA || !ptok.isTLA || tok.type == 1 && BuiltInSymbols.GetBuiltInSymbol((String)tok.string, (boolean)true).symbolType != 2 && BuiltInSymbols.GetBuiltInSymbol((String)tok.string, (boolean)true).symbolType != 7 || tok.type == 8 || ptok.type == 1 && BuiltInSymbols.GetBuiltInSymbol((String)ptok.string, (boolean)true).symbolType != 3 && BuiltInSymbols.GetBuiltInSymbol((String)ptok.string, (boolean)true).symbolType != 7 || ptok.type == 7) ? (String)curOutput + "} \\ensuremath{" : (String)curOutput + " ");
                        }
                        if (!openMath && tok.isTLA) {
                            curOutput = (String)curOutput + "\\ensuremath{";
                            openMath = true;
                        }
                        switch (tok.type) {
                            case 1: {
                                if (tok.isTLA) {
                                    curOutput = (String)curOutput + BuiltInSymbols.GetBuiltInSymbol((String)tok.string, (boolean)true).TeXString;
                                    if (tok.string.charAt(tok.string.length() - 1) != '_' || tok.string.length() == 1) break;
                                    curOutput = (String)curOutput + "\\_";
                                    break;
                                }
                                curOutput = (String)curOutput + FormatComments.getAmbiguous(tok.string);
                                break;
                            }
                            case 2: {
                                curOutput = (String)curOutput + Misc.TeXify(tok.string);
                                break;
                            }
                            case 3: {
                                curOutput = (String)curOutput + "\\@w{" + Misc.TeXify(tok.string) + "}";
                                break;
                            }
                            case 12: {
                                curOutput = (String)curOutput + LaTeXOutput.PfStepString(tok.string);
                                break;
                            }
                            case 4: {
                                curOutput = (String)curOutput + Misc.TeXifyIdent(tok.string);
                                break;
                            }
                            case 5: {
                                curOutput = (String)curOutput + Misc.TeXify(tok.string);
                                break;
                            }
                            case 6: {
                                Object outS = FormatComments.getRepeatCharCommand(tok.string.charAt(0));
                                outS = ((String)outS).equals("") ? Misc.TeXify(tok.string) : (String)outS + "{" + tok.getWidth() + "}";
                                if (com[line].length == 1) {
                                    if (lineType[line] == -1) {
                                        outS = "{\\par}" + (String)outS;
                                    }
                                    if (line + 1 < lineType.length && lineType[line + 1] == -1) {
                                        outS = (String)outS + "{\\par}";
                                    }
                                }
                                curOutput = (String)curOutput + (String)outS;
                                break;
                            }
                            case 7: {
                                if (tok.isTLA) {
                                    curOutput = (String)curOutput + "\\mbox{``}";
                                    break;
                                }
                                curOutput = (String)curOutput + "``";
                                break;
                            }
                            case 8: {
                                if (tok.isTLA) {
                                    curOutput = (String)curOutput + "\\mbox{''}";
                                    break;
                                }
                                curOutput = (String)curOutput + "''";
                                break;
                            }
                            case 10: {
                                curOutput = (String)curOutput + tok.string;
                                break;
                            }
                            default: {
                                Debug.ReportBug("Bad CToken type found in FormatComments.InnerWriteComment");
                            }
                        }
                    }
                    ++item;
                }
            }
            Misc.WriteIfNonNull(writer, (String)curOutput);
            curOutput = "";
            ++line;
        }
        if (FormatComments.IsParType(commentType) && openPar) {
            FormatComments.CloseParagraph(writer, (String)curOutput, openMath, openVerb);
            curOutput = "";
        } else if (openMath) {
            curOutput = (String)curOutput + "}";
        }
        switch (commentType) {
            case 1: 
            case 2: {
                Misc.BreakStringOut(writer, (String)curOutput + "}%");
                break;
            }
            case 3: {
                Misc.WriteIfNonNull(writer, (String)curOutput);
                writer.putLine("\\end{lcom}%");
                break;
            }
            case 4: {
                Misc.WriteIfNonNull(writer, (String)curOutput);
                writer.putLine("\\end{mcom}%");
                break;
            }
            default: {
                Debug.ReportBug("The impossible happened in FormatComments.InnerWriteComment");
            }
        }
    }

    private static boolean IsParType(int type) {
        return type == 3 || type == 4;
    }

    private static void CloseParagraph(OutputFileWriter writer, String curOutput, boolean openMath, boolean openVerb) {
        Object curOut = curOutput;
        if (openMath) {
            curOut = (String)curOut + "}%";
        }
        if (openVerb) {
            Misc.WriteIfNonNull(writer, (String)curOut);
            curOut = "";
            writer.putLine("\\end{verbatim}");
            writer.putLine("\\end{minipage}");
        }
        Misc.WriteIfNonNull(writer, (String)curOut);
        writer.putLine("\\end{cpar}%");
    }

    private static boolean HasDigit(String str) {
        int i = 0;
        boolean result = false;
        while (!result && i < str.length()) {
            result = Misc.IsDigit(str.charAt(i));
            ++i;
        }
        return result;
    }
}

