/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class TLCRuntime {
    public static final long MinFpMemSize = 0xA00000L;
    private static TLCRuntime runtime;
    private long physicalSystemMemory = -1L;

    public static synchronized TLCRuntime getInstance() {
        if (runtime == null) {
            runtime = new TLCRuntime();
        }
        return runtime;
    }

    private long getPhysicalSystemMemory() {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            return (Long)mBeanServer.getAttribute(new ObjectName("java.lang", "type", "OperatingSystem"), "TotalPhysicalMemorySize");
        }
        catch (ClassCastException | AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            return Runtime.getRuntime().totalMemory();
        }
    }

    public long getAbsolutePhysicalSystemMemory(double fraction) {
        if (this.physicalSystemMemory == -1L) {
            this.physicalSystemMemory = this.getPhysicalSystemMemory();
        }
        double d = (double)this.physicalSystemMemory * fraction;
        return (long)(d / 1024.0 / 1024.0);
    }

    public long getNonHeapPhysicalMemory() {
        long l = 0x4000000L;
        RuntimeMXBean RuntimemxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = RuntimemxBean.getInputArguments();
        for (String arg : arguments) {
            if (!arg.toLowerCase().startsWith("-xx:maxdirectmemorysize")) continue;
            String[] strings = arg.split("=");
            String mem = strings[1].toLowerCase();
            if (mem.endsWith("g")) {
                l = Long.parseLong(mem.substring(0, mem.length() - 1));
                l <<= 30;
                break;
            }
            if (mem.endsWith("m")) {
                l = Long.parseLong(mem.substring(0, mem.length() - 1));
                l <<= 20;
                break;
            }
            if (mem.endsWith("k")) {
                l = Long.parseLong(mem.substring(0, mem.length() - 1));
                l <<= 10;
                break;
            }
            l = Long.parseLong(mem.substring(0, mem.length()));
            break;
        }
        return l;
    }

    public long getFPMemSize(double fpMemSize) {
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (fpMemSize == -1.0) {
            fpMemSize = maxMemory >> 2;
        }
        if (0.0 <= fpMemSize && fpMemSize <= 1.0) {
            fpMemSize = (double)maxMemory * fpMemSize;
        }
        if (fpMemSize < 1.048576E7) {
            fpMemSize = 1.048576E7;
        }
        if (fpMemSize >= (double)maxMemory) {
            fpMemSize = maxMemory - (maxMemory >> 2);
        }
        return (long)fpMemSize;
    }

    public ARCH getArchitecture() {
        if (System.getProperty("sun.arch.data.model") != null && System.getProperty("sun.arch.data.model").equals("64")) {
            return ARCH.x86_64;
        }
        if (System.getProperty("com.ibm.vm.bitmode") != null && System.getProperty("com.ibm.vm.bitmode").equals("64")) {
            return ARCH.x86_64;
        }
        if (System.getProperty("java.vm.version") != null && System.getProperty("java.vm.version").contains("_64")) {
            return ARCH.x86_64;
        }
        return ARCH.x86;
    }

    public long pid() {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class<?> aClass = classLoader.loadClass("java.lang.ProcessHandle");
            Object o = aClass.getMethod("current", new Class[0]).invoke(null, null);
            return (Long)aClass.getMethod("pid", new Class[0]).invoke(o, null);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public boolean isThroughputOptimizedGC() {
        List<GarbageCollectorMXBean> gcs = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gc : gcs) {
            if (!"PS Scavenge".equals(gc.getName())) continue;
            return true;
        }
        return false;
    }

    public static enum ARCH {
        x86,
        x86_64;

    }
}

