/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value.impl;

import tlc2.tool.FingerprintException;
import tlc2.util.Vect;
import tlc2.value.IValue;
import tlc2.value.Values;
import tlc2.value.impl.OpValue;
import tlc2.value.impl.Value;
import tlc2.value.impl.ValueExcept;
import util.Assert;
import util.WrongInvocationException;

public class OpRcdValue
extends OpValue {
    public final Vect<Value[]> domain;
    public final Vect<Value> values;

    public OpRcdValue() {
        this.domain = new Vect();
        this.values = new Vect();
    }

    public OpRcdValue(Vect<Value[]> domain, Vect<Value> values) {
        this.domain = domain;
        this.values = values;
    }

    @Override
    public IValue initialize() {
        int i = 0;
        while (i < this.domain.size()) {
            Value[] args = this.domain.elementAt(i);
            int j = 0;
            while (j < args.length) {
                args[j] = (Value)args[j].initialize();
                ++j;
            }
            Value output = this.values.elementAt(i);
            this.values.setElementAt((Value)output.initialize(), i);
            ++i;
        }
        return this;
    }

    @Override
    public final byte getKind() {
        return 11;
    }

    @Override
    public final int compareTo(Object obj) {
        try {
            Assert.fail("Attempted to compare operator " + Values.ppr(this.toString()) + " with value:\n" + Values.ppr(obj.toString()), this.getSource());
            return 0;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final boolean equals(Object obj) {
        try {
            Assert.fail("Attempted to check equality of operator " + Values.ppr(this.toString()) + " with value:\n" + Values.ppr(obj.toString()), this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean member(Value elem) {
        try {
            Assert.fail("Attempted to check if the value:\n" + Values.ppr(elem.toString()) + "\nis an element of operator " + Values.ppr(this.toString()), this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isFinite() {
        try {
            Assert.fail("Attempted to check if the operator " + Values.ppr(this.toString()) + " is a finite set.", this.getSource());
            return false;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    public final void addLine(Vect vs) {
        try {
            int len = vs.size();
            Value[] args = new Value[len - 2];
            int i = 0;
            while (i < len - 2) {
                args[i] = (Value)vs.elementAt(i + 1);
                ++i;
            }
            this.domain.addElement(args);
            this.values.addElement((Value)vs.elementAt(len - 1));
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value eval(Value[] args, int control) {
        try {
            int sz = this.domain.size();
            int i = 0;
            while (i < sz) {
                Value[] vals = this.domain.elementAt(i);
                if (args.length != vals.length) {
                    Assert.fail("Attempted to apply the operator " + Values.ppr(this.toString()) + "\nwith wrong number of arguments.", this.getSource());
                }
                boolean matched = true;
                int j = 0;
                while (j < vals.length) {
                    matched = vals[j].equals(args[j]);
                    if (!matched) break;
                    ++j;
                }
                if (matched) {
                    return this.values.elementAt(i);
                }
                ++i;
            }
            String msg = "Attempted to apply operator:\n" + Values.ppr(this.toString()) + "\nto arguments (";
            if (args.length > 0) {
                msg = msg + String.valueOf(args[0]);
            }
            int i2 = 1;
            while (i2 < args.length) {
                msg = msg + ", " + String.valueOf(args[i2]);
                ++i2;
            }
            Assert.fail(msg + "), which is undefined.", this.getSource());
            return null;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        try {
            Assert.fail("Attempted to appy EXCEPT construct to the operator " + Values.ppr(this.toString()) + ".", this.getSource());
            return null;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        try {
            Assert.fail("Attempted to apply EXCEPT construct to the operator " + Values.ppr(this.toString()) + ".", this.getSource());
            return null;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final int size() {
        try {
            Assert.fail("Attempted to compute the number of elements in the operator " + Values.ppr(this.toString()) + ".", this.getSource());
            return 0;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isNormalized() {
        try {
            throw new WrongInvocationException("Should not normalize an operator.");
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final Value normalize() {
        try {
            throw new WrongInvocationException("Should not normalize an operator.");
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final boolean isDefined() {
        try {
            boolean defined = true;
            int i = 0;
            while (i < this.values.size()) {
                defined = defined && this.values.elementAt(i).isDefined();
                ++i;
            }
            return defined;
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }

    @Override
    public final IValue deepCopy() {
        return this;
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset, boolean swallow) {
        try {
            sb.append("{ ");
            if (this.values.size() != 0) {
                sb.append("<");
                Value[] args = this.domain.elementAt(0);
                int j = 0;
                while (j < args.length) {
                    sb = args[j].toString(sb, offset, swallow);
                    sb.append(", ");
                    ++j;
                }
                sb = this.values.elementAt(0).toString(sb, offset, swallow);
                sb.append(">");
            }
            int i = 1;
            while (i < this.values.size()) {
                sb.append(", <");
                Value[] args = this.domain.elementAt(i);
                int j = 0;
                while (j < args.length) {
                    sb = args[j].toString(sb, offset, swallow);
                    sb.append(", ");
                    ++j;
                }
                sb = this.values.elementAt(i).toString(sb, offset, swallow);
                sb.append(">");
                ++i;
            }
            return sb.append("}");
        }
        catch (OutOfMemoryError | RuntimeException e) {
            if (this.hasSource()) {
                throw FingerprintException.getNewHead(this, e);
            }
            throw e;
        }
    }
}

