/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.distributed.fp;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import tlc2.tool.distributed.fp.FPSetRMI;
import tlc2.tool.distributed.fp.IFPSetManager;
import tlc2.tool.distributed.fp.callable.BitVectorWrapper;
import tlc2.tool.distributed.fp.callable.CheckFPsCallable;
import tlc2.tool.distributed.fp.callable.ContainsBlockCallable;
import tlc2.tool.distributed.fp.callable.PutBlockCallable;
import tlc2.util.BitVector;
import tlc2.util.LongVec;
import util.Assert;
import util.ToolIO;

public abstract class FPSetManager
implements IFPSetManager {
    private static final Random rnd = new Random();
    private static final Logger LOGGER = Logger.getLogger(FPSetManager.class.getName());
    protected long mask = Long.MAX_VALUE;
    protected List<FPSets> fpSets;
    protected boolean managerIsBroken = false;
    public static int Port = 10998;

    public FPSetManager() {
        this(new ArrayList<FPSets>());
    }

    public FPSetManager(List<FPSets> fpSets) {
        this.fpSets = fpSets;
    }

    public FPSetManager(FPSetRMI fpSet) {
        this();
        this.fpSets.add(new FPSets(fpSet, fpSet.toString()));
    }

    @Override
    public int numOfServers() {
        return this.fpSets.size();
    }

    @Override
    public int numOfAliveServers() {
        HashSet<FPSets> s = new HashSet<FPSets>();
        s.addAll(this.fpSets);
        int aliveServer = 0;
        Iterator itr = s.iterator();
        while (itr.hasNext()) {
            if (!((FPSets)itr.next()).isAvailable()) continue;
            ++aliveServer;
        }
        return aliveServer;
    }

    public synchronized int reassign(int index) {
        if (index < 0 || index >= this.fpSets.size()) {
            throw new IllegalArgumentException("index not within bounds");
        }
        if (this.managerIsBroken) {
            return -1;
        }
        FPSets broken = this.fpSets.get(index);
        broken.setUnavailable();
        int next = (index + 1) % this.fpSets.size();
        while (next != index) {
            FPSets replacement = this.fpSets.get(next);
            if (replacement.isAvailable()) {
                int j = index;
                while (j < next) {
                    this.fpSets.set(j, replacement);
                    ++j;
                }
                return next;
            }
            next = (next + 1) % this.fpSets.size();
        }
        this.managerIsBroken = true;
        return -1;
    }

    @Override
    public void close(boolean cleanup) throws IOException {
        FPSets curr = null;
        int len = this.fpSets.size();
        int idx = 0;
        int lidx = 0;
        idx = 0;
        while (idx < len) {
            curr = this.fpSets.get(idx);
            if (curr != null) break;
            ++idx;
        }
        if (curr == null) {
            return;
        }
        lidx = len - 1;
        while (lidx > idx) {
            FPSets last = this.fpSets.get(lidx);
            if (last != null && last != curr) break;
            --lidx;
        }
        int i2 = idx + 1;
        while (i2 <= lidx) {
            FPSets next = this.fpSets.get(i2);
            if (next != null && next != curr) {
                try {
                    curr.exit(cleanup);
                }
                catch (UnmarshalException unmarshalException) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                curr = next;
            }
            ++i2;
        }
        if (curr != null) {
            try {
                curr.exit(cleanup);
            }
            catch (UnmarshalException i2) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getHostName() {
        String hostname = "Unknown";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hostname;
    }

    @Override
    public boolean put(long fp) {
        int fpIdx = this.getFPSetIndex(fp);
        while (true) {
            try {
                return this.fpSets.get(fpIdx).put(fp);
            }
            catch (Exception e) {
                ToolIO.out.println("Warning: Failed to connect from " + this.getHostName() + " to the fp server at " + this.fpSets.get(fpIdx).getHostname() + ".\n" + e.getMessage());
                if (this.reassign(fpIdx) != -1) continue;
                ToolIO.out.println("Warning: there is no fp server available.");
                return false;
            }
            break;
        }
    }

    @Override
    public boolean contains(long fp) {
        int fpIdx = this.getFPSetIndex(fp);
        while (true) {
            try {
                return this.fpSets.get(fpIdx).contains(fp);
            }
            catch (Exception e) {
                ToolIO.out.println("Warning: Failed to connect from " + this.getHostName() + " to the fp server at " + this.fpSets.get(fpIdx).getHostname() + ".\n" + e.getMessage());
                if (this.reassign(fpIdx) != -1) continue;
                ToolIO.out.println("Warning: there is no fp server available.");
                return false;
            }
            break;
        }
    }

    @Override
    public int getFPSetIndex(long fp) {
        return (int)((fp & this.mask) % (long)this.numOfServers());
    }

    @Override
    public BitVector[] putBlock(LongVec[] fps) {
        int len = this.fpSets.size();
        BitVector[] res = new BitVector[len];
        int i = 0;
        while (i < len) {
            try {
                res[i] = this.fpSets.get(i).putBlock(fps[i]);
            }
            catch (Exception e) {
                ToolIO.out.println("Warning: Failed to connect from " + this.getHostName() + " to the fp server at " + this.fpSets.get(i).getHostname() + ".\n" + e.getMessage());
                if (this.reassign(i) == -1) {
                    ToolIO.out.println("Warning: there is no fp server available.");
                    res[i] = new BitVector(fps[i].size(), true);
                }
                --i;
            }
            ++i;
        }
        return res;
    }

    @Override
    public BitVector[] putBlock(LongVec[] fps, ExecutorService executorService) {
        int len = this.fpSets.size();
        ArrayList<Callable<BitVectorWrapper>> solvers = new ArrayList<Callable<BitVectorWrapper>>();
        int i = 0;
        while (i < len) {
            solvers.add(new PutBlockCallable(this, this.fpSets, fps, i));
            ++i;
        }
        return this.executeCallablesAndCollect(executorService, solvers);
    }

    @Override
    public BitVector[] containsBlock(LongVec[] fps) {
        int len = this.fpSets.size();
        BitVector[] res = new BitVector[len];
        int i = 0;
        while (i < len) {
            try {
                res[i] = this.fpSets.get(i).containsBlock(fps[i]);
            }
            catch (Exception e) {
                ToolIO.out.println("Warning: Failed to connect from " + this.getHostName() + " to the fp server at " + this.fpSets.get(i).getHostname() + ".\n" + e.getMessage());
                if (this.reassign(i) == -1) {
                    ToolIO.out.println("Warning: there is no fp server available.");
                    res[i] = new BitVector(fps[i].size(), true);
                }
                --i;
            }
            ++i;
        }
        return res;
    }

    @Override
    public BitVector[] containsBlock(LongVec[] fps, ExecutorService executorService) {
        int len = this.fpSets.size();
        ArrayList<Callable<BitVectorWrapper>> solvers = new ArrayList<Callable<BitVectorWrapper>>();
        int i = 0;
        while (i < len) {
            solvers.add(new ContainsBlockCallable(this, this.fpSets, fps, i));
            ++i;
        }
        return this.executeCallablesAndCollect(executorService, solvers);
    }

    private BitVector[] executeCallablesAndCollect(ExecutorService executorService, List<Callable<BitVectorWrapper>> solvers) {
        int retry = 0;
        ExecutorCompletionService<BitVectorWrapper> ecs = new ExecutorCompletionService<BitVectorWrapper>(executorService);
        int i = 0;
        while (i < solvers.size()) {
            Callable<BitVectorWrapper> s = solvers.get(i);
            try {
                ecs.submit(s);
                retry = 0;
            }
            catch (RejectedExecutionException e) {
                if (retry++ < 3 && !executorService.isShutdown()) {
                    int sleep = 1 + rnd.nextInt(5);
                    LOGGER.log(Level.FINE, "{0}. time throttleing task submission due to overload during FPSetManager callable execution #{1} for {2} seconds", new Object[]{retry, i});
                    try {
                        Thread.sleep((long)sleep * 1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    --i;
                }
                throw e;
            }
            ++i;
        }
        BitVector[] res = new BitVector[solvers.size()];
        int i2 = 0;
        while (i2 < res.length) {
            try {
                BitVectorWrapper indexBitVector = (BitVectorWrapper)ecs.take().get();
                int index = indexBitVector.getIndex();
                Assert.check(res[index] == null, 1000);
                res[index] = indexBitVector.getBitVector();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            ++i2;
        }
        return res;
    }

    @Override
    public long checkFPs() {
        int len = this.fpSets.size();
        ExecutorService executorService = Executors.newFixedThreadPool(len);
        try {
            ExecutorCompletionService<Long> ecs = new ExecutorCompletionService<Long>(executorService);
            int i = 0;
            while (i < len) {
                ecs.submit(new CheckFPsCallable(this.fpSets.get(i).getFpset()));
                ++i;
            }
            long res = Long.MAX_VALUE;
            int i2 = 0;
            while (i2 < len) {
                try {
                    res = Math.min(res, (Long)ecs.take().get());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                ++i2;
            }
            long l = res;
            return l;
        }
        finally {
            executorService.shutdown();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean checkInvariant() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public long size() {
        int len = this.fpSets.size();
        long res = 0L;
        int i = 0;
        while (i < len) {
            block3: {
                try {
                    res += this.fpSets.get(i).size();
                }
                catch (Exception e) {
                    ToolIO.out.println("Warning: Failed to connect from " + this.getHostName() + " to the fp server at " + this.fpSets.get(i).getHostname() + ".\n" + e.getMessage());
                    if (this.reassign(i) != -1) break block3;
                    ToolIO.out.println("Warning: there is no fp server available.");
                }
            }
            ++i;
        }
        return res;
    }

    @Override
    public long getStatesSeen() {
        long res = 1L;
        int len = this.fpSets.size();
        int i = 0;
        while (i < len) {
            block3: {
                try {
                    res += this.fpSets.get(i).getStatesSeen();
                }
                catch (Exception e) {
                    ToolIO.out.println("Warning: Failed to connect from " + this.getHostName() + " to the fp server at " + this.fpSets.get(i).getHostname() + ".\n" + e.getMessage());
                    if (this.reassign(i) != -1) break block3;
                    ToolIO.out.println("Warning: there is no fp server available.");
                }
            }
            ++i;
        }
        return res;
    }

    public long getMask() {
        return this.mask;
    }

    private final void chkptInner(String fname, boolean chkpt) throws InterruptedException {
        int len = this.fpSets.size();
        Checkpoint[] chkpts = new Checkpoint[len];
        FPSets curr = null;
        int cnt = 0;
        int idx = 0;
        int lidx = 0;
        idx = 0;
        while (idx < len) {
            curr = this.fpSets.get(idx);
            if (curr != null) {
                chkpts[cnt] = new Checkpoint(idx, fname, chkpt);
                chkpts[cnt].run();
                ++cnt;
                break;
            }
            ++idx;
        }
        if (curr == null) {
            return;
        }
        lidx = len - 1;
        while (lidx > idx) {
            FPSets last = this.fpSets.get(lidx);
            if (last != null && last != curr) break;
            --lidx;
        }
        int i = idx + 1;
        while (i <= lidx) {
            FPSets next = this.fpSets.get(i);
            if (next != null && next != curr) {
                curr = next;
                chkpts[cnt] = new Checkpoint(i, fname, chkpt);
                chkpts[cnt].run();
                ++cnt;
            }
            ++i;
        }
        i = 0;
        while (i < cnt) {
            chkpts[i].join();
            ++i;
        }
    }

    @Override
    public void checkpoint(String fname) throws InterruptedException, IOException {
        this.chkptInner(fname, true);
    }

    @Override
    public void commitChkpt() throws IOException {
    }

    @Override
    public void recover(String fname) throws InterruptedException, IOException {
        this.chkptInner(fname, false);
    }

    final class Checkpoint
    extends Thread {
        int hostIndex;
        String filename;
        boolean isChkpt;

        public Checkpoint(int index, String fname, boolean chkpt) {
            this.hostIndex = index;
            this.filename = fname;
            this.isChkpt = chkpt;
        }

        @Override
        public void run() {
            try {
                if (this.isChkpt) {
                    FPSetManager.this.fpSets.get(this.hostIndex).beginChkpt(this.filename);
                    FPSetManager.this.fpSets.get(this.hostIndex).commitChkpt(this.filename);
                } else {
                    FPSetManager.this.fpSets.get(this.hostIndex).recover(this.filename);
                }
            }
            catch (IOException e) {
                ToolIO.out.println("Error: Failed to checkpoint the fingerprint server at " + FPSetManager.this.fpSets.get(this.hostIndex).getHostname() + ". This server might be down.");
            }
        }
    }

    public static class FPSets
    implements Serializable {
        private final String hostname;
        private final FPSetRMI fpset;
        private boolean isAvailable = true;

        public FPSets(FPSetRMI fpset, String hostname) {
            this.fpset = fpset;
            this.hostname = hostname;
        }

        public void setUnavailable() {
            this.isAvailable = false;
        }

        public boolean isAvailable() {
            return this.isAvailable;
        }

        public void exit(boolean cleanup) throws IOException {
            this.fpset.exit(cleanup);
        }

        public void recover(String filename) throws IOException {
            this.fpset.recover(filename);
        }

        public void commitChkpt(String filename) throws IOException {
            this.fpset.commitChkpt(filename);
        }

        public void beginChkpt(String filename) throws IOException {
            this.fpset.beginChkpt(filename);
        }

        public long getStatesSeen() throws RemoteException {
            return this.fpset.getStatesSeen();
        }

        public long size() throws IOException {
            return this.fpset.size();
        }

        public BitVector containsBlock(LongVec longVec) throws IOException {
            return this.fpset.containsBlock(longVec);
        }

        public BitVector putBlock(LongVec longVec) throws IOException {
            return this.fpset.putBlock(longVec);
        }

        public boolean put(long fp) throws IOException {
            return this.fpset.put(fp);
        }

        public boolean contains(long fp) throws IOException {
            return this.fpset.contains(fp);
        }

        public String getHostname() {
            return this.hostname;
        }

        public FPSetRMI getFpset() {
            return this.fpset;
        }
    }
}

