/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.Location;
import tla2sany.st.TreeNode;
import tlc2.tool.ITool;
import tlc2.tool.ToolGlobals;
import tlc2.tool.coverage.CostModel;
import tlc2.util.Context;
import tlc2.value.impl.Value;
import util.UniqueString;

public final class Action
implements ToolGlobals,
Serializable {
    private static final Collector<CharSequence, StringJoiner, String> PARAMETER_LIST = Collector.of(() -> new StringJoiner(",", "(", ")").setEmptyValue(""), StringJoiner::add, StringJoiner::merge, StringJoiner::toString, new Collector.Characteristics[0]);
    private static final UniqueString UNNAMED_ACTION = UniqueString.uniqueStringOf("UnnamedAction");
    public static final Action UNKNOWN = new Action(SemanticNode.nullSN, Context.Empty, UNNAMED_ACTION, false, false);
    public final SemanticNode pred;
    public final Context con;
    private final UniqueString actionName;
    private OpDefNode opDef = null;
    private int id;
    private final boolean isInitPred;
    private final boolean isInternal;
    private final Map<Object, Object> auxiliary = new HashMap<Object, Object>();
    public CostModel cm = CostModel.DO_NOT_RECORD;

    public Action(SemanticNode pred, Context con) {
        this(pred, con, false);
    }

    public Action(SemanticNode pred, Context con, boolean isInitPred) {
        this(pred, con, UNNAMED_ACTION, isInitPred, false);
    }

    private Action(SemanticNode pred, Context con, UniqueString actionName, boolean isInitPred, boolean isInternal) {
        this.pred = pred;
        this.con = con;
        this.actionName = actionName;
        this.isInitPred = isInitPred;
        this.isInternal = isInternal;
    }

    public Action(SemanticNode pred, Context con, OpDefNode opDef) {
        this(pred, con, opDef, false, false);
    }

    public Action(ITool t, SemanticNode pred, Context con, OpDefNode opDef) {
        this(t, pred, con, opDef, false, false);
    }

    public Action(SemanticNode pred, Context con, OpDefNode opDef, boolean isInitPred, boolean isInternal) {
        this(pred, con, opDef != null ? opDef.getName() : UNNAMED_ACTION, isInitPred, isInternal);
        this.opDef = opDef;
    }

    public Action(ITool t, SemanticNode pred, Context con, OpDefNode opDef, boolean isInitPred, boolean isInternal) {
        this(pred, con, opDef, isInitPred, isInternal);
    }

    public final String toString() {
        return "<Action " + this.pred.toString() + ">";
    }

    public final String getLocation() {
        if (this.isNamed()) {
            return this.getLocation(this.actionName.toString());
        }
        return this.getLocation("Action");
    }

    public final String getLocation(String actionName) {
        return String.format("<%s%s %s>", actionName, Arrays.stream(this.opDef != null ? this.opDef.getParams() : new FormalParamNode[]{}).map(p -> this.con.lookup((SymbolNode)p)).filter(o -> o != null).map(Object::toString).collect(PARAMETER_LIST), this.pred.getLocation());
    }

    public final boolean isNamed() {
        return this.actionName != UNNAMED_ACTION && this.actionName != null && !"".equals(this.actionName.toString());
    }

    public final UniqueString getName() {
        return this.actionName;
    }

    public final String getNameOfDefault() {
        if (this.isNamed()) {
            return this.getName().toString();
        }
        return this.toString();
    }

    public final OpDefNode getOpDef() {
        return this.opDef;
    }

    public final boolean isDeclared() {
        return this.getDeclaration() != Location.nullLoc;
    }

    public Location getDeclaration() {
        TreeNode tn;
        if (this.opDef != null && (tn = this.opDef.getTreeNode()) != null && tn.one() != null && tn.one().length >= 1) {
            TreeNode treeNode = tn.one()[0];
            assert (treeNode.isKind(366));
            return treeNode.getLocation();
        }
        return Location.nullLoc;
    }

    public final Location getDefinition() {
        return this.pred.getLocation();
    }

    public final Map<UniqueString, Value> getParameters() {
        return Arrays.stream(this.opDef != null ? this.opDef.getParams() : new FormalParamNode[]{}).filter(p -> this.con.lookup((SymbolNode)p) instanceof Value).collect(Collectors.toMap(SymbolNode::getName, p -> (Value)this.con.lookup((SymbolNode)p), (existing, replacement) -> existing, LinkedHashMap::new));
    }

    public final String getInvocationSignature() {
        return String.format("%s%s", this.actionName, this.getParameters().values().stream().map(Object::toString).collect(PARAMETER_LIST));
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public final boolean isInitPredicate() {
        return this.isInitPred;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public Map<Object, Object> getAuxiliary() {
        return this.auxiliary;
    }
}

