/*
 * Decompiled with CFR 0.152.
 */
package pcal;

import java.util.Vector;
import pcal.IntPair;
import pcal.MappingObject;
import pcal.PCalLocation;
import pcal.PcalDebug;
import pcal.Region;
import pcal.TLAToken;
import pcal.exception.TLAExprException;
import pcal.exception.UnrecoverableException;
import tla2tex.Debug;

public class TLAExpr {
    public Vector<Vector<TLAToken>> tokens = new Vector(4);
    public TLAToken[] anchorTokens = null;
    public int[] anchorTokCol = null;
    private Region origin = null;

    public Region getOrigin() {
        return this.origin;
    }

    public void setOrigin(Region origin) {
        this.origin = origin;
    }

    TLAExpr() {
    }

    TLAExpr(Vector t) {
        this.tokens = t;
        this.anchorTokens = null;
        this.anchorTokCol = null;
    }

    public void addToken(TLAToken tok) {
        this.tokens.elementAt(this.tokens.size() - 1).addElement(tok);
    }

    public void addTokenOffset(TLAToken tok, int offset) {
        Vector<TLAToken> lastLine = this.tokens.elementAt(this.tokens.size() - 1);
        int newCol = offset;
        if (lastLine.size() > 0) {
            TLAToken lastTok = lastLine.elementAt(lastLine.size() - 1);
            newCol = newCol + lastTok.column + lastTok.string.length();
        }
        tok.column = newCol;
        lastLine.addElement(tok);
    }

    public void addLine() {
        this.tokens.addElement(new Vector());
    }

    public void normalize() {
        while (this.tokens.size() > 0 && this.tokens.elementAt(0).size() == 0) {
            this.tokens.removeElementAt(0);
        }
        while (this.tokens.size() > 0 && this.tokens.elementAt(this.tokens.size() - 1).size() == 0) {
            this.tokens.removeElementAt(this.tokens.size() - 1);
        }
        int minCol = 999999;
        int i = 0;
        while (i < this.tokens.size()) {
            if (this.tokens.elementAt(i).size() > 0) {
                TLAToken tok = this.tokens.elementAt(i).elementAt(0);
                if (tok.column < minCol) {
                    minCol = tok.column;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.tokens.size()) {
            int j = 0;
            Vector<TLAToken> curLine = this.tokens.elementAt(i);
            while (j < curLine.size()) {
                TLAToken tok = curLine.elementAt(j);
                tok.column -= minCol;
                ++j;
            }
            ++i;
        }
        this.anchorTokens = new TLAToken[this.tokens.size()];
        this.anchorTokCol = new int[this.tokens.size()];
        i = 0;
        while (i < this.tokens.size()) {
            Vector<TLAToken> curLine = this.tokens.elementAt(i);
            if (curLine.size() > 0) {
                int curLineFirstCol = curLine.elementAt((int)0).column;
                int j = i - 1;
                boolean lineNotFound = true;
                while (j >= 0 && lineNotFound) {
                    Vector<TLAToken> ancLine = this.tokens.elementAt(j);
                    if (ancLine.size() > 0 && ancLine.elementAt((int)0).column <= curLineFirstCol) {
                        TLAToken tok;
                        lineNotFound = false;
                        int k = 0;
                        while (k + 1 < ancLine.size() && ancLine.elementAt((int)(k + 1)).column <= curLineFirstCol) {
                            ++k;
                        }
                        this.anchorTokens[i] = tok = ancLine.elementAt(k);
                        this.anchorTokCol[i] = tok.column;
                    }
                    --j;
                }
            }
            ++i;
        }
    }

    public void renormalize() throws TLAExprException {
        int i = 0;
        while (i < this.tokens.size()) {
            if (this.anchorTokens[i] != null) {
                Vector<TLAToken> line = this.tokens.elementAt(i);
                int k = this.anchorTokens[i].column - this.anchorTokCol[i];
                this.anchorTokCol[i] = this.anchorTokens[i].column;
                if (k < 0) {
                    throw new TLAExprException("TLAExpr.renormalize() found anchor has moved to left.");
                }
                int j = 0;
                while (j < line.size()) {
                    TLAToken tok = line.elementAt(j);
                    tok.column += k;
                    ++j;
                }
            }
            ++i;
        }
    }

    public Vector toStringVector() {
        Vector<String> result = new Vector<String>(this.tokens.size());
        int i = 0;
        while (i < this.tokens.size()) {
            Vector<TLAToken> curTokLine = this.tokens.elementAt(i);
            Object curString = "";
            TLAToken curAncTok = this.anchorTokens[i];
            int curAncCol = this.anchorTokCol[i];
            if (curAncTok != null) {
                curString = TLAExpr.SpacesString(curAncTok.column - curAncCol);
            }
            TLAToken curTok = null;
            TLAToken lastTok = null;
            int j = 0;
            while (j < curTokLine.size()) {
                curTok = curTokLine.elementAt(j);
                curString = j == 0 ? (String)curString + TLAExpr.SpacesString(curTok.column) : (String)curString + TLAExpr.SpacesString(curTok.column - lastTok.column - lastTok.getWidth());
                curString = curTok.type == 3 ? (String)curString + "\"" + curTok.string + "\"" : (String)curString + curTok.string;
                lastTok = curTok;
                ++j;
            }
            result.addElement((String)curString);
            ++i;
        }
        return result;
    }

    public Vector toMappingVector() {
        Vector result = new Vector(4);
        int i = 0;
        while (i < this.tokens.size()) {
            Vector<MappingObject> mapLine = new Vector<MappingObject>();
            Vector<TLAToken> expLine = this.tokens.elementAt(i);
            MappingObject.SourceToken sourceTok = null;
            int j = 0;
            while (j < expLine.size()) {
                TLAToken tok = expLine.elementAt(j);
                int tokEndCol = tok.column + tok.string.length();
                int k = 0;
                while (k < tok.getBeginSubst().size()) {
                    mapLine.addElement(new MappingObject.LeftParen((PCalLocation)tok.getBeginSubst().elementAt(k)));
                    ++k;
                }
                if (tok.source == null) {
                    if (sourceTok == null || !tok.isAppended()) {
                        mapLine.addElement(new MappingObject.BeginTLAToken(tok.column));
                        mapLine.addElement(new MappingObject.EndTLAToken(tokEndCol));
                        sourceTok = null;
                    } else {
                        sourceTok.setEndColumn(tokEndCol);
                    }
                } else {
                    sourceTok = new MappingObject.SourceToken(tok.column, tokEndCol, tok.source);
                    mapLine.addElement(sourceTok);
                }
                k = tok.getEndSubst().size() - 1;
                while (k >= 0) {
                    mapLine.addElement(new MappingObject.RightParen((PCalLocation)tok.getEndSubst().elementAt(k)));
                    --k;
                }
                ++j;
            }
            result.addElement(mapLine);
            ++i;
        }
        return result;
    }

    public String toString() {
        Object result = "<< ";
        int i = 0;
        boolean nonempty = false;
        while (i < this.tokens.size()) {
            if (i > 0) {
                result = (String)result + "\n";
            }
            Vector<TLAToken> curLine = this.tokens.elementAt(i);
            int j = 0;
            while (j < curLine.size()) {
                if (nonempty) {
                    result = (String)result + ", ";
                }
                nonempty = true;
                TLAToken tok = curLine.elementAt(j);
                result = tok.type == 3 ? (String)result + "\"\\\"\", \"" + tok.string + "\", \"\\\"\"" : (tok.string.equals("\\/") ? (String)result + String.format("\"(col%s) \\\\/\"", tok.column) : (tok.string.charAt(0) == '\\' ? (String)result + "\"\\" + tok.string + "\"" : (tok.string.equals("/\\") ? (String)result + String.format("\"(col%s) /\\\\\"", tok.column) : (String)result + "\"" + tok.string + "\"")));
                ++j;
            }
            ++i;
        }
        return (String)result + " >>";
    }

    public void appendExpr(Vector expr, int spaces) throws UnrecoverableException {
        throw new UnrecoverableException("appendExpr not yet implemented");
    }

    public TLAExpr cloneAndNormalize() {
        TLAExpr result = new TLAExpr();
        result.tokens = new Vector();
        int i = 0;
        while (i < this.tokens.size()) {
            Vector<TLAToken> newline = new Vector<TLAToken>();
            Vector<TLAToken> line = this.tokens.elementAt(i);
            int j = 0;
            while (j < line.size()) {
                newline.add(new TLAToken(line.elementAt(j)));
                ++j;
            }
            result.tokens.add(newline);
            ++i;
        }
        result.setOrigin(this.getOrigin());
        result.normalize();
        return result;
    }

    public void prepend(TLAExpr expr, int spaces) throws TLAExprException {
        int i = 0;
        while (i < expr.tokens.size() - 1) {
            this.tokens.add(i, expr.tokens.elementAt(i));
            ++i;
        }
        Vector<TLAToken> exprLine = expr.tokens.elementAt(i);
        Vector<TLAToken> thisLine = this.tokens.elementAt(i);
        TLAToken tok = exprLine.lastElement();
        int incr = tok.column + tok.getWidth() + spaces;
        int j = 0;
        while (j < thisLine.size()) {
            tok = thisLine.elementAt(j);
            tok.column += incr;
            ++j;
        }
        j = 0;
        while (j < exprLine.size()) {
            thisLine.add(j, exprLine.elementAt(j));
            ++j;
        }
        TLAToken[] newAToks = new TLAToken[this.tokens.size()];
        int[] newATCol = new int[this.tokens.size()];
        j = 0;
        while (j < expr.tokens.size()) {
            newAToks[j] = expr.anchorTokens[j];
            newATCol[j] = expr.anchorTokCol[j];
            ++j;
        }
        while (j < this.tokens.size()) {
            newAToks[j] = this.anchorTokens[j - expr.tokens.size() + 1];
            newATCol[j] = this.anchorTokCol[j - expr.tokens.size() + 1];
            ++j;
        }
        this.anchorTokens = newAToks;
        this.anchorTokCol = newATCol;
        this.renormalize();
    }

    public static Vector SeqSubstituteForAll(Vector expVec, Vector exprs, Vector strs) throws TLAExprException {
        Vector<TLAExpr> result = new Vector<TLAExpr>();
        int i = 0;
        while (i < expVec.size()) {
            TLAExpr e = ((TLAExpr)expVec.elementAt(i)).cloneAndNormalize();
            e.substituteForAll(exprs, strs);
            result.add(e);
            ++i;
        }
        return result;
    }

    public void substituteForAll(Vector exprs, Vector strs) throws TLAExprException {
        this.substituteForAll(exprs, strs, true);
    }

    public void substituteForAll(Vector exprs, Vector strs, boolean parenthesize) throws TLAExprException {
        TLAExpr[] expArray = new TLAExpr[exprs.size()];
        String[] strArray = new String[strs.size()];
        IntPair[] nextArray = new IntPair[expArray.length];
        int i = 0;
        while (i < nextArray.length) {
            expArray[i] = (TLAExpr)exprs.elementAt(i);
            strArray[i] = (String)strs.elementAt(i);
            nextArray[i] = this.findNextInstanceIn(strArray[i], new IntPair(0, 0));
            ++i;
        }
        boolean notDone = true;
        while (notDone) {
            IntPair nextPos = null;
            int nextIdx = -1;
            int i2 = 0;
            while (i2 < nextArray.length) {
                IntPair pos = nextArray[i2];
                if (pos != null) {
                    if (nextPos == null) {
                        nextPos = pos;
                        nextIdx = i2;
                    } else if (pos.one < nextPos.one || pos.one == nextPos.one && pos.two < nextPos.two) {
                        nextPos = pos;
                        nextIdx = i2;
                    }
                }
                ++i2;
            }
            if (nextPos == null) {
                notDone = false;
                continue;
            }
            IntPair afterNextPos = this.stepCoord(nextPos, 1);
            IntPair newPos = this.substituteAt(expArray[nextIdx], nextPos, parenthesize);
            nextArray[nextIdx] = newPos == null ? null : this.findNextInstanceIn(strArray[nextIdx], newPos);
            int i3 = 0;
            while (i3 < nextArray.length) {
                if (i3 != nextIdx && nextArray[i3] != null) {
                    Debug.Assert(newPos != null, "Doing substitutions in wrong order.");
                    if (afterNextPos.one == newPos.one) {
                        if (nextArray[i3].one == nextPos.one) {
                            nextArray[i3].two += newPos.two - afterNextPos.two;
                            Debug.Assert(nextArray[i3].two > nextPos.two, "Wrong substitution order.");
                        }
                    } else if (nextArray[i3].one == nextPos.one) {
                        nextArray[i3].one += newPos.one - afterNextPos.one;
                        Debug.Assert(nextArray[i3].two > nextPos.two, "Wrong substitution order.");
                        nextArray[i3].two += newPos.two - afterNextPos.two;
                    } else {
                        nextArray[i3].one += newPos.one - afterNextPos.one;
                    }
                }
                ++i3;
            }
        }
    }

    public void substituteFor(TLAExpr expr, String id, boolean parenthesize) throws TLAExprException {
        IntPair next = new IntPair(0, 0);
        while (next != null) {
            if ((next = this.findNextInstanceIn(id, next)) == null) continue;
            next = this.substituteAt(expr, next, parenthesize);
        }
    }

    public IntPair substituteAt(TLAExpr expr, IntPair coord, boolean par) throws TLAExprException {
        TLAToken tok = this.tokenAt(coord);
        Region tokSource = tok.source;
        if (this.isOneToken()) {
            TLAExpr cloned = expr.cloneAndNormalize();
            if (tokSource != null) {
                cloned.firstToken().getBeginSubst().addAll(tok.getBeginSubst());
                cloned.firstToken().getBeginSubst().addElement(tokSource.getBegin());
                cloned.lastToken().getEndSubst().addAll(tok.getEndSubst());
                cloned.lastToken().getEndSubst().addElement(tokSource.getEnd());
            }
            this.tokens = cloned.tokens;
            this.anchorTokens = cloned.anchorTokens;
            this.anchorTokCol = cloned.anchorTokCol;
            return null;
        }
        Vector<TLAToken> tokLine = this.tokens.elementAt(coord.one);
        int spaces = 0;
        if (coord.two + 1 < tokLine.size()) {
            TLAToken nextTok = tokLine.elementAt(coord.two + 1);
            spaces = nextTok.column - (tok.column + tok.getWidth());
        }
        Vector<TLAToken> restOfLine = new Vector<TLAToken>();
        while (coord.two + 1 < tokLine.size()) {
            restOfLine.add(tokLine.elementAt(coord.two + 1));
            tokLine.remove(coord.two + 1);
        }
        int curLine = coord.one;
        Vector<TLAToken> line = this.tokens.elementAt(curLine);
        if (expr.tokens.size() == 1 && expr.tokens.elementAt(0).size() == 1) {
            TLAToken etok = expr.tokens.elementAt(0).elementAt(0);
            tok.string = etok.string;
            tok.type = etok.type;
            tok.source = etok.source;
            if (tokSource != null) {
                tok.getBeginSubst().addElement(tokSource.getBegin());
                tok.getEndSubst().addElement(tokSource.getEnd());
            }
            tok.getBeginSubst().addAll(etok.getBeginSubst());
            tok.getEndSubst().addAll(etok.getEndSubst());
        } else {
            int indent = (par ? 1 : 0) + tok.column;
            boolean doInsert = true;
            if (par) {
                tok.string = "(";
                tok.type = 1;
                doInsert = false;
                tok.source = null;
                if (tokSource != null) {
                    tok.getBeginSubst().addElement(tokSource.getBegin());
                }
            }
            int i = 0;
            TLAExpr newExpr = expr.cloneAndNormalize();
            if (!par && tokSource != null) {
                newExpr.firstToken().getBeginSubst().addElement(tokSource.getBegin());
                newExpr.lastToken().getEndSubst().addElement(tokSource.getEnd());
            }
            while (i < newExpr.tokens.size()) {
                Vector<TLAToken> eline = newExpr.tokens.elementAt(i);
                int j = 0;
                while (j < eline.size()) {
                    TLAToken nextTok = eline.elementAt(j);
                    nextTok.column += indent;
                    if (doInsert) {
                        tok.string = nextTok.string;
                        tok.type = nextTok.type;
                        tok.getBeginSubst().addAll(nextTok.getBeginSubst());
                        newExpr.lastToken().getEndSubst().addAll(tok.getEndSubst());
                        tok.setEndSubst(nextTok.getEndSubst());
                        doInsert = false;
                    } else {
                        line.add(nextTok);
                    }
                    ++j;
                }
                if (++i >= newExpr.tokens.size()) continue;
                indent = 0;
                this.tokens.insertElementAt(new Vector(), ++curLine);
                line = this.tokens.elementAt(curLine);
                TLAToken[] aTok = new TLAToken[this.tokens.size()];
                int[] aTCol = new int[this.tokens.size()];
                int k = 0;
                while (k < this.tokens.size()) {
                    if (k < curLine) {
                        aTok[k] = this.anchorTokens[k];
                        aTCol[k] = this.anchorTokCol[k];
                    } else if (k == curLine) {
                        aTok[k] = newExpr.anchorTokens[i];
                        aTCol[k] = newExpr.anchorTokCol[i];
                    } else {
                        aTok[k] = this.anchorTokens[k - 1];
                        aTCol[k] = this.anchorTokCol[k - 1];
                    }
                    ++k;
                }
                this.anchorTokens = aTok;
                this.anchorTokCol = aTCol;
            }
            TLAToken lastTok = line.elementAt(line.size() - 1);
            int nextTokColumn = lastTok.column + lastTok.getWidth();
            if (par) {
                TLAToken rParen = new TLAToken(")", lastTok.column + lastTok.getWidth(), 1);
                rParen.setEndSubst(tok.getEndSubst());
                if (tokSource != null) {
                    rParen.getEndSubst().addElement(tokSource.getEnd());
                }
                tok.setEndSubst(new Vector(2));
                line.add(rParen);
                ++nextTokColumn;
            }
        }
        IntPair result = new IntPair(curLine, line.size() - 1);
        if (restOfLine.size() > 0) {
            TLAToken prevTok = line.elementAt(line.size() - 1);
            TLAToken firstTok = (TLAToken)restOfLine.elementAt(0);
            int indent = prevTok.column + prevTok.getWidth() + spaces - firstTok.column;
            int i = 0;
            while (i < restOfLine.size()) {
                TLAToken oldTok = (TLAToken)restOfLine.elementAt(i);
                oldTok.column += indent;
                line.add(oldTok);
                ++i;
            }
        }
        this.renormalize();
        return this.stepCoord(result, 1);
    }

    public IntPair findNextInstanceIn(String id, IntPair start) {
        IntPair result = new IntPair(start.one, start.two);
        if (this.isEmpty()) {
            result = null;
        }
        while (result != null) {
            TLAToken tok = this.tokenAt(result);
            if (tok.type == 3) {
                result = this.stepCoord(result, 1);
                continue;
            }
            if (tok.string.equals(".")) {
                result = this.stepCoord(result, 2);
                continue;
            }
            if ((tok.string.equals("[") || tok.string.equals(",")) && this.stepCoord(result, 2) != null && this.tokenAt((IntPair)this.stepCoord((IntPair)result, (int)2)).type != 3 && (this.tokenAt((IntPair)this.stepCoord((IntPair)result, (int)2)).string.equals(":") || this.tokenAt((IntPair)this.stepCoord((IntPair)result, (int)2)).string.equals("|->") || this.tokenAt((IntPair)this.stepCoord((IntPair)result, (int)2)).string.equals("\u21a6"))) {
                result = this.stepCoord(result, 3);
                continue;
            }
            if (tok.string.equals(id)) {
                return result;
            }
            result = this.stepCoord(result, 1);
        }
        return null;
    }

    public TLAToken tokenAt(IntPair coord) {
        return this.tokens.elementAt(coord.one).elementAt(coord.two);
    }

    public IntPair stepCoord(IntPair coord, int incr) {
        Vector<TLAToken> line;
        if (this.tokens.size() <= coord.one) {
            PcalDebug.ReportBug("TLAExpr.StepCoord called with line too big");
        }
        if ((line = this.tokens.elementAt(coord.one)).size() <= coord.two) {
            PcalDebug.ReportBug("TLAExpr.StepCoord called with col too big");
        }
        IntPair result = new IntPair(coord.one, coord.two);
        int i = 0;
        while (i < incr) {
            ++result.two;
            if (line.size() == result.two) {
                result.two = 0;
                ++result.one;
                while (result.one < this.tokens.size() && this.tokens.elementAt(result.one).size() == 0) {
                    ++result.one;
                }
                if (result.one == this.tokens.size()) {
                    return null;
                }
                line = this.tokens.elementAt(result.one);
            }
            ++i;
        }
        return result;
    }

    public boolean isEmpty() {
        return this.tokens == null || this.tokens.size() == 0;
    }

    public boolean isOneToken() {
        return !this.isEmpty() && this.tokens.size() == 1 && this.tokens.elementAt(0).size() == 1;
    }

    public TLAToken firstToken() {
        Vector<TLAToken> line = this.tokens.elementAt(0);
        return line.elementAt(0);
    }

    public TLAToken lastToken() {
        Vector<TLAToken> line = this.tokens.elementAt(this.tokens.size() - 1);
        return line.elementAt(line.size() - 1);
    }

    private static String SpacesString(int n) {
        int i = 0;
        Object result = "";
        if (i < 0) {
            PcalDebug.ReportBug("SpacesString called with negative argument");
        }
        while (i < n) {
            result = (String)result + " ";
            ++i;
        }
        return result;
    }

    public void print(String name) {
        PcalDebug.print2DVector(this.tokens, name + ".tokens");
        PcalDebug.printObjectArray(this.anchorTokens, name + ".anchorTokens");
        PcalDebug.printIntArray(this.anchorTokCol, name + ".anchorTokCol");
    }
}

