/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.utilities;

import java.util.Enumeration;
import tla2sany.utilities.VectorEnumeration;

public class Vector<E> {
    static int defaultSize = 10;
    protected Object[] info;
    protected int size = 0;
    protected int capacity;
    protected int increment;

    public Vector() {
        this.info = new Object[defaultSize];
        this.capacity = defaultSize;
        this.increment = defaultSize;
    }

    public Vector(int initialSize) {
        this.info = new Object[initialSize];
        this.capacity = initialSize;
        this.increment = initialSize;
    }

    public final int size() {
        return this.size;
    }

    public final void addElement(E obj) {
        if (this.size == this.capacity) {
            Object[] next = new Object[this.capacity + this.increment];
            System.arraycopy(this.info, 0, next, 0, this.capacity);
            this.capacity += this.increment;
            this.info = next;
        }
        this.info[this.size] = obj;
        ++this.size;
    }

    public final E firstElement() {
        return (E)this.info[0];
    }

    public final E lastElement() {
        return (E)this.info[this.size - 1];
    }

    public final E elementAt(int i) {
        if (i < 0 || i >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (E)this.info[i];
    }

    public final void removeAllElements() {
        int lvi = 0;
        while (lvi < this.size) {
            this.info[lvi] = null;
            ++lvi;
        }
        this.size = 0;
    }

    public final void removeElementAt(int i) {
        if (i < 0 || i >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int lvi = i + 1;
        while (lvi < this.size) {
            this.info[lvi - 1] = this.info[lvi];
            ++lvi;
        }
        --this.size;
        this.info[this.size] = null;
    }

    public final void insertElementAt(E obj, int i) {
        if (i < 0 || i >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.size == this.capacity) {
            Object[] next = new Object[this.capacity + this.increment];
            System.arraycopy(this.info, 0, next, 0, i);
            next[i] = obj;
            System.arraycopy(this.info, i, next, i + 1, this.capacity - i);
            this.capacity += this.increment;
            this.info = next;
        } else {
            int lvi = this.size;
            while (lvi > i) {
                this.info[lvi] = this.info[lvi - 1];
                --lvi;
            }
            this.info[i] = obj;
        }
        ++this.size;
    }

    public final void setElementAt(E obj, int i) {
        if (i < 0 || i >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.info[i] = obj;
    }

    public final boolean contains(E obj) {
        int i = 0;
        while (i < this.size) {
            if (this.info[i] == obj) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final Enumeration<E> elements() {
        return new VectorEnumeration(this.info, this.size);
    }

    public final void append(Vector<E> v) {
        if (v.size + this.size > this.capacity) {
            Object[] neo = new Object[this.capacity + v.capacity];
            this.capacity += v.capacity;
            System.arraycopy(this.info, 0, neo, 0, this.size);
            this.info = neo;
        }
        System.arraycopy(v.info, 0, this.info, this.size, v.size);
        this.size += v.size;
    }

    public final void appendNoRepeats(Vector<E> v) {
        int i = 0;
        while (i < v.size()) {
            if (!this.contains(v.elementAt(i))) {
                this.addElement(v.elementAt(i));
            }
            ++i;
        }
    }

    public final String toString() {
        Object ret = "[ ";
        if (this.size() > 0) {
            ret = (String)ret + this.elementAt(0).toString();
        }
        int i = 1;
        while (i < this.size()) {
            ret = (String)ret + ", " + this.elementAt(i).toString();
            ++i;
        }
        return (String)ret + " ]";
    }
}

