/*
 * Decompiled with CFR 0.152.
 */
package tlc2.util.statistics;

import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.LongAdder;
import tlc2.util.statistics.AbstractBucketStatistics;
import tlc2.util.statistics.IBucketStatistics;

public class FixedSizedConcurrentBucketStatistics
extends AbstractBucketStatistics
implements IBucketStatistics {
    private final LongAdder observations = new LongAdder();
    protected final AtomicLongArray buckets;

    public FixedSizedConcurrentBucketStatistics(String aTitle, int aMaxmimum) {
        super(aTitle);
        this.buckets = new AtomicLongArray(aMaxmimum);
    }

    @Override
    public void addSample(int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Negative amount invalid");
        }
        int idx = Math.min(this.buckets.length() - 1, amount);
        this.buckets.incrementAndGet(idx);
        this.observations.increment();
    }

    @Override
    public long getObservations() {
        return this.observations.sum();
    }

    @Override
    public NavigableMap<Integer, Long> getSamples() {
        TreeMap<Integer, Long> res = new TreeMap<Integer, Long>();
        int i = 0;
        while (i < this.buckets.length()) {
            long value = this.buckets.get(i);
            if (value > 0L) {
                res.put(i, value);
            }
            ++i;
        }
        return res;
    }
}

