/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.st;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pcal.PCalLocation;
import pcal.Region;
import util.Assert;
import util.UniqueString;

public final class Location
implements Comparable<Location> {
    private static final String LINE = "line ";
    private static final String LINE_CAP = "Line ";
    private static final String TO_LINE = " to line ";
    private static final String COL = ", col ";
    private static final String COLUMN = ", column ";
    private static final String OF_MODULE = " of module ";
    private static final String IN_MODULE = "In module ";
    private static final String IN = " in ";
    private static final String UNKNOWN_LOCATION = "Unknown location";
    private static final String NATURAL = "([0-9]+)";
    private static final String MODULE_ID = "([A-Za-z_0-9]+)";
    private static final String CLOSE_ACTION = ">";
    private static final String OPEN_ACTION = "<[A-Za-z_0-9]+ ";
    private static final UniqueString unknown = UniqueString.uniqueStringOf("--unknown--");
    public static final Location nullLoc = new Location(unknown, 0, 0, 0, 0);
    public static final Pattern LOCATION_MATCHER = Pattern.compile("line ([0-9]+), col ([0-9]+) to line ([0-9]+), col ([0-9]+) of module ([A-Za-z_0-9]+)");
    public static final Pattern LOCATION_MATCHER2 = Pattern.compile("In module ([A-Za-z_0-9]+)");
    public static final Pattern LOCATION_MATCHER3 = Pattern.compile("<[A-Za-z_0-9]+ line ([0-9]+), col ([0-9]+) to line ([0-9]+), col ([0-9]+) of module ([A-Za-z_0-9]+)>");
    public static final Pattern LOCATION_MATCHER4 = Pattern.compile("Line ([0-9]+), column ([0-9]+) to line ([0-9]+), column ([0-9]+) in ([A-Za-z_0-9]+)");
    public static final Pattern[] ALL_PATTERNS = new Pattern[]{LOCATION_MATCHER, LOCATION_MATCHER2, LOCATION_MATCHER3, LOCATION_MATCHER4};
    protected UniqueString name;
    protected int bLine;
    protected int bColumn;
    protected int eLine;
    protected int eColumn;

    public Location(String fName, String bl, String bc, String el, String ec) {
        this(UniqueString.uniqueStringOf(fName), (int)Integer.valueOf(bl), (int)Integer.valueOf(bc), (int)Integer.valueOf(el), (int)Integer.valueOf(ec));
    }

    public Location(String fName, int bl, int bc, int el, int ec) {
        this(UniqueString.uniqueStringOf(fName), bl, bc, el, ec);
    }

    public Location(UniqueString fName, int bl, int bc, int el, int ec) {
        this.name = fName;
        this.bLine = bl;
        this.bColumn = bc;
        this.eLine = el;
        this.eColumn = ec;
    }

    public Location(int bl, int bc, int el, int ec) {
        this((UniqueString)null, bl, bc, el, ec);
    }

    public Location(int[] coordinates) {
        Assert.check(coordinates != null && coordinates.length == 4, "Illegal coordinates found.");
        this.bLine = coordinates[0];
        this.bColumn = coordinates[1];
        this.eLine = coordinates[2];
        this.eColumn = coordinates[3];
        if (this.eLine < this.bLine) {
            this.eLine = this.bLine;
        }
        if (this.eColumn < this.bColumn) {
            this.eColumn = this.bColumn;
        }
    }

    public static Location moduleLocation(String moduleName) {
        return new Location(UniqueString.uniqueStringOf(moduleName), 0, 0, 0, 0);
    }

    public static Location parseLocation(String locationString) {
        if (locationString == null || locationString.length() == 0 || UNKNOWN_LOCATION.equals(locationString)) {
            return nullLoc;
        }
        Matcher matcher = LOCATION_MATCHER2.matcher(locationString);
        if (matcher.matches()) {
            return Location.moduleLocation(matcher.group(1));
        }
        matcher = LOCATION_MATCHER.matcher(locationString);
        if (matcher.matches()) {
            try {
                return new Location(UniqueString.uniqueStringOf(matcher.group(5)), Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)));
            }
            catch (NumberFormatException e) {
                return nullLoc;
            }
        }
        matcher = LOCATION_MATCHER3.matcher(locationString.trim());
        if (matcher.matches()) {
            try {
                return new Location(UniqueString.uniqueStringOf(matcher.group(5)), Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)));
            }
            catch (NumberFormatException e) {
                return nullLoc;
            }
        }
        matcher = LOCATION_MATCHER4.matcher(locationString.trim());
        if (matcher.matches()) {
            try {
                return new Location(UniqueString.uniqueStringOf(matcher.group(5)), Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)));
            }
            catch (NumberFormatException e) {
                return nullLoc;
            }
        }
        return nullLoc;
    }

    public static Location parseCoordinates(String source, String coordinates) {
        String[] c = coordinates.split(" ");
        return new Location(source, c[0], c[1], c[2], c[3]);
    }

    public static Location[] getParsedLocations(String input) {
        ArrayList<Location> locations = new ArrayList<Location>();
        int i = 0;
        while (i < ALL_PATTERNS.length) {
            Matcher matcher = ALL_PATTERNS[i].matcher(input);
            while (matcher.find()) {
                String locationString = matcher.group();
                Location location = Location.parseLocation(locationString);
                if (location == null || location.equals(nullLoc)) continue;
                locations.add(location);
            }
            ++i;
        }
        return locations.toArray(new Location[locations.size()]);
    }

    public final int beginLine() {
        return this.bLine;
    }

    public final int beginColumn() {
        return this.bColumn;
    }

    public final int endLine() {
        return this.eLine;
    }

    public final int[] getCoordinates() {
        return new int[]{this.bLine, this.bColumn, this.eLine, this.eColumn};
    }

    public final int endColumn() {
        return this.eColumn;
    }

    public final String source() {
        return this.name != null ? this.name.toString() : null;
    }

    public final UniqueString sourceAsUniqueString() {
        return this.name;
    }

    public final String toString() {
        if (this == nullLoc) {
            return UNKNOWN_LOCATION;
        }
        if (this.name == null) {
            return LINE + this.bLine + COL + this.bColumn + TO_LINE + this.eLine + COL + this.eColumn + " of module null";
        }
        if (!this.name.equals(unknown) && this.bColumn == 0 && this.eColumn == 0 && this.bLine == 0 && this.eLine == 0) {
            return IN_MODULE + String.valueOf(this.name);
        }
        return LINE + this.bLine + COL + this.bColumn + TO_LINE + this.eLine + COL + this.eColumn + OF_MODULE + String.valueOf(this.name);
    }

    public boolean equals(Object object) {
        if (object instanceof Location) {
            Location loc = (Location)object;
            return loc.bLine == this.bLine && loc.bColumn == this.bColumn && loc.eLine == this.eLine && loc.eColumn == this.eColumn && loc.source().equals(this.source());
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bColumn;
        result = 31 * result + this.bLine;
        result = 31 * result + this.eColumn;
        result = 31 * result + this.eLine;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public Region toRegion() {
        return new Region(new PCalLocation(this.bLine - 1, this.bColumn - 1), new PCalLocation(this.eLine - 1, this.eColumn - 1));
    }

    public boolean containsLine(int line) {
        return line >= this.bLine && line <= this.eLine;
    }

    @Override
    public int compareTo(Location other) {
        if (this.equals(other)) {
            return 0;
        }
        if (this.name.compareTo(other.name) != 0) {
            return this.name.compareTo(other.name);
        }
        if (this.bLine > other.bLine) {
            return 1;
        }
        if (this.bLine < other.bLine) {
            return -1;
        }
        if (this.bColumn > other.bColumn) {
            return 1;
        }
        if (this.bColumn < other.bColumn) {
            return -1;
        }
        if (this.eLine > other.eLine) {
            return 1;
        }
        if (this.eLine < other.eLine) {
            return -1;
        }
        if (this.eColumn < other.eColumn) {
            return -1;
        }
        return 1;
    }

    public boolean includes(Location other) {
        if (this.name != other.name) {
            return false;
        }
        if (this.bLine > other.bLine) {
            return false;
        }
        if (this.beginLine() == other.beginLine() && this.beginColumn() > other.beginColumn()) {
            return false;
        }
        if (this.eLine < other.eLine) {
            return false;
        }
        return this.endLine() != other.endLine() || this.endColumn() >= other.endColumn();
    }

    public String linesAndColumns() {
        return this.toString().replaceAll(" of module .*", "");
    }
}

