/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.UIHelper;
import org.lamport.tla.toolbox.util.ZipUtil;
import tlc2.output.SpecWriterUtilities;

public class NewSpecWizardPage
extends WizardPage {
    private Text specNameText;
    private Text fileText;
    private Button importExisting;
    private boolean specNameDirty = false;
    private boolean fileTextDirty = false;
    public static final String[] ACCEPTED_EXTENSIONS = new String[]{"*.tla", "*.zip", "*.*"};
    private String lastBrowsedDirectory;
    private final String absolutePath;

    public NewSpecWizardPage(String absolutePath) {
        super("newSpecWizardPage");
        this.absolutePath = absolutePath;
        this.setTitle("New TLA+ Specification");
        this.setDescription("Creates a new TLA+ specification\nEnter a complete file name like c:\\jones\\specs\\foo.tla or click on Browse.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("&Root-module file:");
        this.fileText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public synchronized void modifyText(ModifyEvent e) {
                NewSpecWizardPage.this.fileTextDirty = true;
                NewSpecWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText("&Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public synchronized void widgetSelected(SelectionEvent e) {
                NewSpecWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText("&Specification name:");
        this.specNameText = new Text(container, 2052);
        gd = new GridData(768);
        this.specNameText.setLayoutData((Object)gd);
        this.specNameText.addModifyListener(new ModifyListener(){

            public synchronized void modifyText(ModifyEvent e) {
                NewSpecWizardPage.this.specNameDirty = true;
                NewSpecWizardPage.this.dialogChanged();
            }
        });
        new Label(container, 0);
        new Label(container, 0);
        this.importExisting = new Button(container, 32);
        this.importExisting.setText("Import existing models");
        this.importExisting.setSelection(true);
        this.importExisting.setEnabled(false);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.importExisting.setLayoutData((Object)gd);
        this.importExisting.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NewSpecWizardPage.this.dialogChanged();
            }
        });
        if (this.absolutePath != null) {
            this.fileText.setText(this.absolutePath);
        } else {
            this.setPageComplete(false);
        }
        UIHelper.setHelp((Control)container, "NewSpecWizard");
        this.setControl((Control)container);
    }

    protected void handleBrowse() {
        Spec mostRecentlyOpenedSpec;
        FileDialog openFileDialog = UIHelper.getFileDialog(this.fileText.getShell());
        openFileDialog.setText("Open root file");
        String rootPath = this.lastBrowsedDirectory;
        if (rootPath == null && Activator.isSpecManagerInstantiated() && (mostRecentlyOpenedSpec = Activator.getSpecManager().getMostRecentlyOpenedSpec()) != null) {
            rootPath = ResourceHelper.getParentDirName((IResource)mostRecentlyOpenedSpec.getRootFile());
        }
        if (rootPath == null) {
            rootPath = System.getProperty("user.home");
        }
        openFileDialog.setFilterPath(rootPath);
        openFileDialog.setFilterExtensions(ACCEPTED_EXTENSIONS);
        openFileDialog.setFilterNames(new String[]{"TLA+ files", "Zip Archive", "All files"});
        String selected = openFileDialog.open();
        if (selected != null) {
            Path path = new Path(selected);
            if (path.getFileExtension() == null) {
                selected = selected.concat(".").concat("tla");
            }
            this.fileText.setText(selected);
        }
    }

    protected synchronized void dialogChanged() {
        Spec existingSpec;
        String rootfilePath = null;
        if (this.fileTextDirty) {
            rootfilePath = this.getRootFilename();
            if ("".equals(rootfilePath)) {
                this.reportError("Root file name should be provided");
                return;
            }
            if (rootfilePath.contains("${rnd.tmp.dir}")) {
                Object tmpdir = System.getProperty("java.io.tmpdir");
                if (Platform.getOS().equals("macosx")) {
                    tmpdir = File.separator + "private" + (String)tmpdir;
                }
                String rndTmpDir = (String)tmpdir + File.separator + UUID.randomUUID().toString();
                System.setProperty("tla.rcptt.spec.dir", rndTmpDir);
                this.fileText.setText(rootfilePath.replace("${rnd.tmp.dir}", rndTmpDir));
                return;
            }
            if (new File(rootfilePath).isDirectory()) {
                this.reportError("Root file should be a TLA file and not a directory");
                return;
            }
            if (ZipUtil.isArchive((String)rootfilePath)) {
                try {
                    File zip = new File(rootfilePath);
                    File destDir = ZipUtil.unzip((File)zip, (File)new File(zip.getAbsolutePath().replaceFirst(".zip$", "")), (boolean)true);
                    this.fileText.setText(destDir.getAbsolutePath() + File.separator + zip.getName().replaceFirst(".zip$", ".tla"));
                    return;
                }
                catch (IOException e) {
                    this.reportError(String.format("Failed to unzip zip archive %s with error %s", rootfilePath, e.getMessage()));
                }
            } else {
                if (!rootfilePath.endsWith(".tla")) {
                    this.reportError("Root file name should have a file-system path and extension .tla");
                    return;
                }
                if (!new File(rootfilePath).isAbsolute()) {
                    this.reportError("Root file name should have a file-system path");
                    return;
                }
                if (!ResourceHelper.isValidSpecName(SpecWriterUtilities.getModuleNameChecked((String)rootfilePath, (boolean)false))) {
                    String moduleNameChecked = SpecWriterUtilities.getModuleNameChecked((String)rootfilePath, (boolean)false);
                    String validIdenfier = ResourceHelper.getIdentifier(moduleNameChecked);
                    if ("".equals(validIdenfier)) {
                        this.reportError("Module name is not valid. The module name '" + SpecWriterUtilities.getModuleNameChecked((String)rootfilePath, (boolean)false) + "' is not a valid identifier.");
                        this.reportError(String.format("Module name is not valid. The module name '%s' is not a valid identifier.", moduleNameChecked));
                    } else {
                        this.reportError(String.format("Module name is not valid. The module name '%s' is not a valid identifier. Did you mean '%s' instead?", moduleNameChecked, validIdenfier));
                    }
                    return;
                }
                File f = new File(rootfilePath);
                if (f.getParentFile() != null && f.getParentFile().exists()) {
                    try {
                        String canonicalPath = f.getCanonicalPath();
                        if (!rootfilePath.equals(canonicalPath)) {
                            rootfilePath = canonicalPath;
                            this.fileText.setText(rootfilePath);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if ((existingSpec = Activator.getSpecManager().getSpecByRootModule(rootfilePath)) != null) {
                    this.reportError("The provided root file is already used in specification " + existingSpec.getName());
                    return;
                }
            }
        }
        if (this.specNameDirty) {
            String specName = this.getSpecName();
            if ("".equals(specName)) {
                this.reportError("Please provide a specification name");
                return;
            }
            if (!ResourceHelper.isValidSpecName(specName)) {
                String validIdenfier = ResourceHelper.getIdentifier(specName);
                if ("".equals(validIdenfier)) {
                    this.reportError(String.format("Specification name is not valid. The specification name '%s' is not a valid identifier.", specName, validIdenfier));
                } else {
                    this.reportError(String.format("Specification name is not valid. The specification name '%s' is not a valid identifier. Did you mean '%s' instead?", specName, validIdenfier));
                }
                return;
            }
            existingSpec = Activator.getSpecManager().getSpecByName(specName);
            if (existingSpec != null) {
                this.reportError("The specification with the provided name already exists \nand uses " + existingSpec.getRootFilename() + " as root module.");
                return;
            }
        } else if (this.fileTextDirty) {
            String moduleName = SpecWriterUtilities.getModuleNameChecked((String)this.getRootFilename(), (boolean)false);
            existingSpec = Activator.getSpecManager().getSpecByName(moduleName);
            if (existingSpec != null) {
                moduleName = Activator.getSpecManager().constructSpecName(moduleName, true);
            }
            this.specNameText.setText(moduleName);
        }
        if (ResourceHelper.peekProject(this.getSpecName(), rootfilePath)) {
            if (!this.importExisting.getSelection()) {
                this.reportError("The " + this.getSpecName() + ".toolbox directory already exists at the provided location.\nPlease select a different specification name or root-module file.");
                return;
            }
            this.importExisting.setEnabled(true);
        } else {
            this.importExisting.setEnabled(false);
        }
        this.setMessage(null);
        if (rootfilePath != null && !new File(rootfilePath).exists()) {
            this.reportWarning("Root file name does not exist. A new file will be created.");
        } else if (rootfilePath != null && !rootfilePath.equals(this.getRootFilename())) {
            this.reportWarning(String.format("Changed your path to its canonical form %s.", this.getRootFilename(), rootfilePath));
        }
        if (!this.fileTextDirty || !this.specNameDirty) {
            return;
        }
        this.setPageComplete(true);
        this.lastBrowsedDirectory = ResourceHelper.getParentDirName(this.getRootFilename());
    }

    private void reportError(String message) {
        this.setPageComplete(false);
        this.setMessage(message, 3);
    }

    private void reportWarning(String message) {
        this.setPageComplete(true);
        this.setMessage(message, 2);
    }

    public boolean isPageComplete() {
        return super.isPageComplete();
    }

    public String getSpecName() {
        return this.specNameText.getText();
    }

    public String getRootFilename() {
        return this.fileText.getText();
    }

    public boolean importExisting() {
        return this.importExisting.getSelection();
    }
}

