/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.spec.nature.ParserHelper;
import org.lamport.tla.toolbox.ui.navigator.ToolboxExplorer;
import org.lamport.tla.toolbox.util.ToolboxJob;
import org.lamport.tla.toolbox.util.UIHelper;

public class OpenSpecHandler
extends AbstractHandler
implements IHandler {
    public static final String TLA_EDITOR_CURRENT = "org.lamport.tla.toolbox.editor.basic.TLAEditorAndPDFViewer";
    public static final String TLA_EDITOR = "org.lamport.tla.toolbox.editor.basic.TLAEditorAndPDFViewer";
    public static final String COMMAND_ID = "toolbox.command.spec.open";
    public static final String PARAM_SPEC = "toolbox.command.spec.open.param";
    public static final String TLC_ERROR_VIEW_ID = "toolbox.tool.tlc.view.TLCErrorView";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object result;
        String specName = event.getParameter(PARAM_SPEC);
        if (specName == null) {
            return null;
        }
        if (Activator.getSpecManager().getSpecLoaded() != null && (result = UIHelper.runCommand("toolbox.command.spec.close", null)) != null && result instanceof Boolean && !((Boolean)result).booleanValue()) {
            return null;
        }
        final Spec spec = Activator.getSpecManager().getSpecByName(specName);
        if (spec == null) {
            throw new RuntimeException("Specification " + specName + "not found");
        }
        UIHelper.switchPerspective("org.lamport.tla.toolbox.ui.perspective.specLoaded");
        UIHelper.closeWindow("org.lamport.tla.toolbox.ui.perspective.initial");
        UIHelper.hideView(TLC_ERROR_VIEW_ID);
        ToolboxJob job = new ToolboxJob("OpenSpecHandler is parsing spec..."){

            protected IStatus run(IProgressMonitor monitor) {
                Activator.getSpecManager().setSpecLoaded(spec);
                ParserHelper.rebuildSpec(monitor);
                UIJob uiJob = new UIJob("Opening editor for spec..."){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        UIHelper.openEditor("org.lamport.tla.toolbox.editor.basic.TLAEditorAndPDFViewer", (IEditorInput)new FileEditorInput(spec.getRootFile()));
                        ToolboxExplorer.getViewer().expandToLevel((Object)spec, 2);
                        return Status.OK_STATUS;
                    }
                };
                uiJob.schedule();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return null;
    }
}

