/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.util.pref;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;

public class ResourceBasedPreferenceStore
implements IPreferenceStore {
    private IResource resource;
    private ListenerList listeners = new ListenerList();

    public ResourceBasedPreferenceStore(IResource resource) {
        this.resource = resource;
    }

    public boolean contains(String name) {
        try {
            return this.resource.getPersistentProperties().containsKey(name);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getString(String name) {
        String value = null;
        try {
            value = this.resource.getPersistentProperty(new QualifiedName("org.lamport.tla.toolbox", name));
            if (value == null) {
                value = "";
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return value;
    }

    public void setValue(String name, String value) {
        try {
            if (value == null) {
                value = "";
            }
            this.resource.setPersistentProperty(new QualifiedName("org.lamport.tla.toolbox", name), value);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public boolean needsSaving() {
        return false;
    }

    public void putValue(String name, String value) {
        this.setValue(name, value);
    }

    public boolean getBoolean(String name) {
        return Boolean.parseBoolean(this.getString(name));
    }

    public double getDouble(String name) {
        return Double.parseDouble(this.getString(name));
    }

    public float getFloat(String name) {
        return Float.parseFloat(this.getString(name));
    }

    public int getInt(String name) {
        return Integer.parseInt(this.getString(name));
    }

    public long getLong(String name) {
        return Long.parseLong(this.getString(name));
    }

    public void setValue(String name, double value) {
        this.setValue(name, new Double(value).toString());
    }

    public void setValue(String name, float value) {
        this.setValue(name, new Float(value).toString());
    }

    public void setValue(String name, int value) {
        this.setValue(name, new Integer(value).toString());
    }

    public void setValue(String name, long value) {
        this.setValue(name, new Long(value).toString());
    }

    public void setValue(String name, boolean value) {
        this.setValue(name, new Boolean(value).toString());
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
    }

    public void setDefault(String name, double value) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setDefault(String name, float value) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setDefault(String name, int value) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setDefault(String name, long value) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setDefault(String name, String value) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setDefault(String name, boolean value) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean getDefaultBoolean(String name) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public double getDefaultDouble(String name) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public float getDefaultFloat(String name) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public int getDefaultInt(String name) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public long getDefaultLong(String name) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public String getDefaultString(String name) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setToDefault(String name) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean isDefault(String name) {
        return false;
    }
}

