/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.spec.nature;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.lamport.tla.toolbox.Activator;

public class TLANature
implements IProjectNature {
    private IProject project;
    public static final String ID = "toolbox.natures.TLANature";

    public void configure() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        boolean tlaBuilderFound = false;
        boolean pcalBuilderFound = false;
        int numberOfBuildersToInstall = 1;
        int i = 0;
        while (i < commands.length) {
            String builderName = commands[i].getBuilderName();
            if (builderName.equals("toolbox.builder.TLAParserBuilder")) {
                tlaBuilderFound = true;
                --numberOfBuildersToInstall;
            }
            if (tlaBuilderFound && pcalBuilderFound) {
                return;
            }
            ++i;
        }
        ICommand[] newCommands = new ICommand[commands.length + numberOfBuildersToInstall];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        int position = commands.length;
        if (!tlaBuilderFound) {
            ICommand command = desc.newCommand();
            command.setBuilderName("toolbox.builder.TLAParserBuilder");
            newCommands[position] = command;
            ++position;
        }
        desc.setBuildSpec(newCommands);
        this.project.setDescription(desc, null);
        Activator.getDefault().logDebug("Nature added");
    }

    public void deconfigure() throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            String builderName = commands[i].getBuilderName();
            if (builderName.equals("toolbox.builder.TLAParserBuilder")) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
            }
            ++i;
        }
        Activator.getDefault().logDebug("Nature removed");
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

