/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox;

import java.io.File;
import java.util.HashMap;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.spec.manager.WorkspaceSpecManager;
import org.lamport.tla.toolbox.util.UIHelper;
import org.osgi.service.event.EventHandler;

public class OpenFileManager
implements Listener {
    @PostContextCreate
    void postContextCreate(final IApplicationContext appContext, final Display display, final IEventBroker broker) {
        broker.subscribe("org/eclipse/e4/ui/LifeCycle/activate", new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                broker.unsubscribe((EventHandler)this);
                UIHelper.runUIAsync(new Runnable(){

                    @Override
                    public void run() {
                        Object argObject = appContext.getArguments().get("application.args");
                        if (argObject != null && argObject instanceof String[]) {
                            String[] args = (String[])argObject;
                            if (args.length > 0) {
                                OpenFileManager.this.openOrCreateSpec(args[0]);
                            }
                        } else if (argObject != null && argObject instanceof String) {
                            OpenFileManager.this.openOrCreateSpec((String)argObject);
                        }
                        display.addListener(46, (Listener)OpenFileManager.this);
                    }
                });
            }
        });
    }

    public void handleEvent(Event event) {
        String absolutePath = event.text;
        if (absolutePath != null) {
            this.openOrCreateSpec(absolutePath);
        }
    }

    private void openOrCreateSpec(String file) {
        File absoluteFile = new File(file);
        if (!absoluteFile.isAbsolute()) {
            String absolutePath = new File(".").getAbsolutePath();
            absoluteFile = new File(absolutePath + File.separator + file);
        }
        if (absoluteFile.exists() && absoluteFile.isFile()) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            WorkspaceSpecManager specManager = Activator.getSpecManager();
            Spec spec = specManager.getSpecByRootModule(absoluteFile.getAbsolutePath());
            if (spec != null) {
                if (!spec.isCurrentSpec()) {
                    parameters.put("toolbox.command.spec.open.param", spec.getName());
                    UIHelper.runCommand("toolbox.command.spec.open", parameters);
                }
            } else {
                parameters.put("toolbox.command.spec.new.param", absoluteFile.getAbsolutePath());
                UIHelper.runCommand("toolbox.command.spec.new", parameters);
            }
        }
    }
}

