/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.ui.preference;

import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.lamport.tla.toolbox.util.UIHelper;
import org.lamport.tla.toolbox.util.pref.PreferenceStoreHelper;

public class ParserPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor parseSpecField;

    public ParserPreferencePage() {
        super(1);
        this.setPreferenceStore(PreferenceStoreHelper.getInstancePreferenceStore());
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.setDescription("TLA+ Parser preferences");
    }

    protected Control createContents(Composite parent) {
        Control pageControl = super.createContents(parent);
        UIHelper.setHelp(pageControl, "ParserPreferencePage");
        return pageControl;
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor("parserPopupErrors", "&Always pop up Parsing Errors view", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("autoParseModule", "&Re-parse module on save", this.getFieldEditorParent()));
        this.parseSpecField = new BooleanFieldEditor("autoParseSpec", "&Re-parse specification on spec module save", this.getFieldEditorParent());
        if (!this.getPreferenceStore().getBoolean("autoParseModule")) {
            this.parseSpecField.setEnabled(false, this.getFieldEditorParent());
        }
        this.addField((FieldEditor)this.parseSpecField);
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        this.getPreferenceStore().setValue("autoParseModule", ResourcesPlugin.getWorkspace().isAutoBuilding());
        super.initialize();
    }

    protected void performApply() {
        super.performApply();
        this.setAutoBuilding();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.setAutoBuilding();
        return result;
    }

    private void setAutoBuilding() {
        boolean autoBuildModule = this.getPreferenceStore().getBoolean("autoParseModule");
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        if (autoBuildModule != ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            try {
                description.setAutoBuilding(autoBuildModule);
                ResourcesPlugin.getWorkspace().setDescription(description);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        BooleanFieldEditor parseModuleOnModifyField;
        if (event.getSource() instanceof BooleanFieldEditor && (parseModuleOnModifyField = (BooleanFieldEditor)event.getSource()).getPreferenceName().equals("autoParseModule")) {
            boolean parseModuleOnModify = parseModuleOnModifyField.getBooleanValue();
            if (parseModuleOnModify) {
                this.parseSpecField.setEnabled(true, this.getFieldEditorParent());
            } else {
                this.parseSpecField.setEnabled(false, this.getFieldEditorParent());
            }
        }
        super.propertyChange(event);
    }
}

