/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.spec.manager;

import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.spec.manager.ISpecManager;
import org.lamport.tla.toolbox.tool.SpecEvent;
import org.lamport.tla.toolbox.tool.SpecLifecycleParticipant;
import org.lamport.tla.toolbox.tool.SpecRenameEvent;
import org.lamport.tla.toolbox.ui.property.GenericSelectionProvider;
import org.lamport.tla.toolbox.util.ResourceHelper;
import org.lamport.tla.toolbox.util.SpecLifecycleManager;
import org.lamport.tla.toolbox.util.compare.SpecComparator;
import org.lamport.tla.toolbox.util.pref.PreferenceStoreHelper;

public class WorkspaceSpecManager
extends GenericSelectionProvider
implements ISpecManager,
IResourceChangeListener,
IAdaptable,
IAdapterFactory {
    private Hashtable<String, Spec> specStorage = new Hashtable(47);
    private Spec loadedSpec = null;
    private SpecLifecycleManager lifecycleManager = new SpecLifecycleManager();

    public WorkspaceSpecManager(IProgressMonitor monitor) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        String specLoadedName = PreferenceStoreHelper.getInstancePreferenceStore().getString("specLoadedName");
        IProject[] projects = ws.getRoot().getProjects();
        try {
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                if (project.isOpen()) {
                    if (project.hasNature("toolbox.natures.TLANature")) {
                        project.refreshLocal(2, monitor);
                        Spec spec = new Spec(project);
                        if (spec.getRootFile() == null) {
                            Activator.getDefault().logError("The bad spec is: `" + project.getName() + "'", null);
                        } else {
                            this.addSpec(spec);
                        }
                        if (spec.getName().equals(specLoadedName)) {
                            this.setSpecLoaded(spec);
                        }
                    }
                } else {
                    project.delete(5, monitor);
                }
                ++i;
            }
            if (specLoadedName != null && !specLoadedName.equals("") && this.loadedSpec == null) {
                this.setSpecLoaded(null);
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error initializing specification workspace", e);
        }
        ws.addResourceChangeListener((IResourceChangeListener)this);
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)this, IProject.class);
    }

    @Override
    public void terminate() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ws.removeResourceChangeListener((IResourceChangeListener)this);
        if (this.loadedSpec != null && PreferenceStoreHelper.getInstancePreferenceStore().getBoolean("restoreLastSpec")) {
            PreferenceStoreHelper.getInstancePreferenceStore().setValue("specLoadedName", this.loadedSpec.getName());
        } else {
            PreferenceStoreHelper.getInstancePreferenceStore().setValue("specLoadedName", "");
        }
    }

    @Override
    public void addSpec(Spec spec) {
        this.specStorage.put(spec.getName(), spec);
        this.lifecycleManager.sendEvent(new SpecEvent(spec, 1));
    }

    @Override
    public Spec getSpecLoaded() {
        return this.loadedSpec;
    }

    @Override
    public Spec[] getRecentlyOpened() {
        Collection<Spec> specs = this.specStorage.values();
        return specs.toArray(new Spec[specs.size()]);
    }

    @Override
    public Spec getSpecByName(String specName) {
        return this.specStorage.get(specName);
    }

    @Override
    public Spec getSpecByRootModule(String rootModulePath) {
        if (rootModulePath != null) {
            for (Spec spec : this.specStorage.values()) {
                try {
                    if (!spec.getRootFilename().equals(rootModulePath)) continue;
                    return spec;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @Override
    public void setSpecLoaded(Spec spec) {
        if (spec == null) {
            if (this.loadedSpec != null) {
                this.lifecycleManager.sendEvent(new SpecEvent(this.loadedSpec, 16));
            }
        } else {
            this.lifecycleManager.sendEvent(new SpecEvent(spec, 8));
        }
        this.loadedSpec = spec;
        if (this.loadedSpec != null) {
            this.loadedSpec.setLastModified();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResource resource = event.getResource();
        if (resource != null && 4 == resource.getType() && 4 == event.getType()) {
            this.specStorage.remove(resource.getName());
        }
    }

    public void renameSpec(Spec oldSpec, String newName, IProgressMonitor aMonitor) {
        this.specStorage.remove(oldSpec.getName());
        IProject project = ResourceHelper.projectRename(oldSpec.getProject(), newName, aMonitor);
        Spec newSpec = new Spec(project);
        newSpec.setLastModified();
        this.addSpec(newSpec);
        this.lifecycleManager.sendEvent(new SpecRenameEvent(oldSpec, newSpec));
        try {
            oldSpec.getProject().delete(0, aMonitor);
        }
        catch (CoreException shouldNotHappen) {
            shouldNotHappen.printStackTrace();
        }
    }

    public void removeSpec(Spec spec, IProgressMonitor aMonitor) {
        this.removeSpec(spec, aMonitor, true);
    }

    public void removeSpec(Spec spec, IProgressMonitor aMonitor, boolean isForget) {
        this.lifecycleManager.sendEvent(new SpecEvent(spec, 2));
        ResourceHelper.deleteProject(spec.getProject(), aMonitor, isForget);
        this.specStorage.remove(spec.getName());
        if (this.loadedSpec == spec) {
            this.loadedSpec = null;
        }
    }

    public void specParsed(Spec spec) {
        this.lifecycleManager.sendEvent(new SpecEvent(spec, 32));
    }

    @Override
    public String constructSpecName(String proposition, boolean firstRun) {
        Spec existingSpec = this.getSpecByName(proposition);
        if (existingSpec != null) {
            if (firstRun) {
                return this.constructSpecName(proposition.concat("_1"), false);
            }
            String oldNumber = proposition.substring(proposition.lastIndexOf("_"));
            int number = Integer.parseInt(oldNumber) + 1;
            proposition = proposition.substring(0, proposition.lastIndexOf("_"));
            return this.constructSpecName(proposition + number, false);
        }
        return proposition;
    }

    @Override
    public ISelection getSelection() {
        if (this.loadedSpec != null) {
            return new StructuredSelection((Object)this.loadedSpec);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setSelection(ISelection selection) {
        if (selection == null) {
            this.setSpecLoaded(null);
            return;
        }
        if (!(selection instanceof IStructuredSelection)) throw new IllegalArgumentException("Workspace specification manager only accepts specification object in a StructuredSelection");
        IStructuredSelection sSelection = (IStructuredSelection)selection;
        if (!(sSelection.toArray() instanceof Spec[])) throw new IllegalArgumentException("Workspace specification manager only accepts specification objects to be selected");
        Spec[] specs = (Spec[])sSelection.toArray();
        if (specs.length == 0) {
            this.setSpecLoaded(null);
            return;
        } else {
            if (specs.length != 1) throw new IllegalArgumentException("Only one specification can be selected");
            this.setSpecLoaded(specs[0]);
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public Collection<Spec> getSpecs() {
        return Collections.unmodifiableCollection(this.specStorage.values());
    }

    public Spec getMostRecentlyOpenedSpec() {
        if (this.loadedSpec != null) {
            return this.loadedSpec;
        }
        SpecComparator comparator = new SpecComparator();
        Spec[] specs = this.getRecentlyOpened();
        Spec mostRecentlyOpened = null;
        int i = 0;
        while (i < specs.length) {
            int compare = comparator.compare(mostRecentlyOpened, specs[i]);
            if (compare > 0) {
                mostRecentlyOpened = specs[i];
            }
            ++i;
        }
        return mostRecentlyOpened;
    }

    public boolean isSpecLoaded(Spec aSpec) {
        return this.getSpecLoaded() == aSpec;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IProject) {
            IProject project = (IProject)adaptableObject;
            String key = project.getName();
            return this.specStorage.get(key);
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{Spec.class};
    }

    public void addSpecLifecycleParticipant(SpecLifecycleParticipant specLifecycleParticipant) {
        this.lifecycleManager.addSpecLifecycleParticipant(specLifecycleParticipant);
    }

    public void removeSpecLifecycleParticipant(SpecLifecycleParticipant specLifecycleParticipant) {
        this.lifecycleManager.removeSpecLifecycleParticipant(specLifecycleParticipant);
    }
}

