/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.job;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.lamport.tla.toolbox.util.ResourceHelper;

public class NewTLAModuleCreationOperation
implements IWorkspaceRunnable {
    private IPath modulePath;

    public NewTLAModuleCreationOperation(IPath module) {
        this.modulePath = module;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        String moduleFileName = this.modulePath.lastSegment();
        byte[] content = ResourceHelper.getEmptyModuleContent(moduleFileName).append((CharSequence)ResourceHelper.getModuleClosingTag()).toString().getBytes();
        try {
            File file;
            if (this.modulePath.segmentCount() > 1) {
                IPath removeLastSegments = this.modulePath.removeLastSegments(1);
                File dir = new File(removeLastSegments.toOSString());
                dir.mkdirs();
            }
            if (!(file = new File(this.modulePath.toOSString())).createNewFile()) {
                throw new RuntimeException("Error creating a file");
            }
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(content);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox", "Error creating TLA+ file", (Throwable)e));
        }
    }

    public static WorkspaceJob NEW_JOB(IPath module) {
        return new WorkspaceJob("Creating TLA+ file", module){
            NewTLAModuleCreationOperation op;
            {
                this.op = new NewTLAModuleCreationOperation(iPath);
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                this.op.run(monitor);
                return Status.OK_STATUS;
            }
        };
    }
}

