/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.spec.parser;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class DoubleHashedTable {
    private static final float DEFALT_THRESHOLD = 0.75f;
    private static final int DEFAULT_SIZE = 11;
    private Hashtable forwardStore = null;
    private Hashtable backwardStore = null;

    public DoubleHashedTable() {
        this(11, 0.75f);
    }

    public DoubleHashedTable(int size) {
        this(size, 0.75f);
    }

    public DoubleHashedTable(int size, float threshold) {
        this.forwardStore = new Hashtable(size, threshold);
        this.backwardStore = new Hashtable(size, threshold);
    }

    public void clear() {
        this.forwardStore.clear();
        this.backwardStore.clear();
    }

    public boolean containsKey(Object key) {
        return this.forwardStore.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.backwardStore.containsKey(value);
    }

    public List getValues(Object key) {
        return (List)this.forwardStore.get(key);
    }

    public List getKeys(Object value) {
        return (List)this.backwardStore.get(value);
    }

    public List put(Object key, List values) {
        if (values == null) {
            values = new Vector(0);
        }
        Vector listWithoutDoublicates = new Vector(values.size());
        int i = 0;
        while (i < values.size()) {
            Vector<Object> keys = (Vector<Object>)this.backwardStore.get(values.get(i));
            if (keys == null) {
                keys = new Vector<Object>();
            }
            if (!keys.contains(key)) {
                keys.add(key);
                listWithoutDoublicates.add(values.get(i));
                this.backwardStore.put(values.get(i), keys);
            }
            ++i;
        }
        return this.forwardStore.put(key, listWithoutDoublicates);
    }

    public List removeKey(Object key) {
        return DoubleHashedTable.universalRemove(key, this.forwardStore, this.backwardStore);
    }

    public List removeValue(Object value) {
        return DoubleHashedTable.universalRemove(value, this.backwardStore, this.forwardStore);
    }

    public int size() {
        return this.forwardStore.size();
    }

    private static List universalRemove(Object toRemove, Hashtable directContainer, Hashtable invertedContainer) {
        List keys = (List)directContainer.remove(toRemove);
        if (keys != null) {
            int i = 0;
            while (i < keys.size()) {
                Object key = keys.get(i);
                List values = (List)invertedContainer.get(key);
                if (values == null || !values.contains(toRemove)) {
                    throw new RuntimeException("DoubleHashtable integrity violated");
                }
                values.remove(toRemove);
                ++i;
            }
        }
        return keys;
    }
}

