/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.tool.tlc.TLCActivator;
import org.lamport.tla.toolbox.tool.tlc.launch.IModelConfigurationConstants;
import org.lamport.tla.toolbox.tool.tlc.launch.IModelConfigurationDefaults;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.util.ResourceHelper;
import tla2sany.modanalyzer.SpecObj;
import tla2sany.semantic.ModuleNode;
import tla2sany.semantic.OpDeclNode;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.Location;
import tlc2.model.Assignment;
import tlc2.output.SpecWriterUtilities;

public class ModelHelper
implements IModelConfigurationConstants,
IModelConfigurationDefaults {
    public static final int[] EMPTY_LOCATION = new int[4];
    public static final String TLC_MODEL_ERROR_MARKER_TLC = "org.lamport.tla.toolbox.tlc.modelErrorTLC";
    public static final String TLC_MODEL_ERROR_MARKER_ATTRIBUTE_NAME = "attributeName";
    public static final String TLC_MODEL_ERROR_MARKER_ATTRIBUTE_IDX = "attributeIndex";
    public static final String TLC_MODEL_ERROR_MARKER_ATTRIBUTE_PAGE = "basicFormPageId";
    private static final String LIST_DELIMITER = ";";
    private static final String PARAM_DELIMITER = ":";
    public static final String TE_MODEL_NAME = "TE";
    public static final String TE_FILE_TLA = "TE.tla";
    public static final String TE_FILE_CFG = "TE.cfg";
    public static final String TE_FILE_OUT = "TE.out";
    public static final String TE_TRACE_SOURCE = "MC_TE.out";

    public static ILaunchConfiguration getModelByFile(IFile modelFile) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        return launchManager.getLaunchConfiguration(modelFile);
    }

    public static void doSaveConfigurationCopy(ILaunchConfigurationWorkingCopy config) {
    }

    public static List<String> serializeAssignmentList(List<Assignment> assignments) {
        Iterator<Assignment> iter = assignments.iterator();
        Vector<String> result = new Vector<String>(assignments.size());
        while (iter.hasNext()) {
            Assignment assign = iter.next();
            StringBuffer buffer = new StringBuffer();
            buffer.append(assign.getLabel()).append(LIST_DELIMITER);
            int j = 0;
            while (j < assign.getParams().length) {
                String param = assign.getParams()[j];
                if (param != null) {
                    buffer.append(param);
                }
                buffer.append(PARAM_DELIMITER);
                ++j;
            }
            buffer.append(LIST_DELIMITER);
            if (assign.getRight() != null) {
                buffer.append(assign.getRight());
            }
            buffer.append(LIST_DELIMITER).append(assign.isModelValue() ? "1" : "0");
            buffer.append(LIST_DELIMITER).append(assign.isSymmetricalSet() ? "1" : "0");
            result.add(buffer.toString());
        }
        return result;
    }

    public static List<Assignment> deserializeAssignmentList(List<String> serializedList) {
        return ModelHelper.deserializeAssignmentList(serializedList, false);
    }

    public static List<Assignment> deserializeAssignmentList(List<String> serializedList, boolean stripSymmetry) {
        Vector<Assignment> result = new Vector<Assignment>(serializedList.size());
        Iterator<String> iter = serializedList.iterator();
        String[] stringArray = new String[5];
        stringArray[1] = "";
        stringArray[2] = "";
        stringArray[3] = "0";
        stringArray[4] = "0";
        String[] fields = stringArray;
        while (iter.hasNext()) {
            String[] serFields = iter.next().split(LIST_DELIMITER);
            System.arraycopy(serFields, 0, fields, 0, serFields.length);
            String[] params = "".equals(fields[1]) ? new String[]{} : fields[1].split(PARAM_DELIMITER);
            Assignment assign = new Assignment(fields[0], params, fields[2]);
            if (fields.length > 3 && fields[3].equals("1")) {
                assign.setModelValue(true);
                if (!stripSymmetry && fields.length > 4 && fields[4].equals("1")) {
                    assign.setSymmetric(true);
                }
            }
            result.add(assign);
        }
        return result;
    }

    public static List<Assignment> createConstantsList(ModuleNode moduleNode) {
        OpDeclNode[] constantDecls = moduleNode.getConstantDecls();
        Vector<Assignment> constants = new Vector<Assignment>(constantDecls.length);
        int i = 0;
        while (i < constantDecls.length) {
            Object[] params = new String[constantDecls[i].getNumberOfArgs()];
            Arrays.fill(params, "");
            Assignment assign = new Assignment(constantDecls[i].getName().toString(), (String[])params, "");
            constants.add(assign);
            ++i;
        }
        return constants;
    }

    public static boolean hasConstant(Assignment assignment, ModuleNode moduleNode) {
        OpDeclNode[] constantDecls = moduleNode.getConstantDecls();
        int i = 0;
        while (i < constantDecls.length) {
            if (assignment.getLabel().equals(constantDecls[i].getName().toString()) && assignment.getParams().length == constantDecls[i].getNumberOfArgs()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String createVariableList(ModuleNode moduleNode) {
        if (moduleNode == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        OpDeclNode[] variableDecls = moduleNode.getVariableDecls();
        int i = 0;
        while (i < variableDecls.length) {
            buffer.append(variableDecls[i].getName().toString());
            if (i != variableDecls.length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String[] createVariableArray(ModuleNode moduleNode) {
        OpDeclNode[] variableDecls = moduleNode.getVariableDecls();
        String[] returnVal = new String[variableDecls.length];
        int i = 0;
        while (i < variableDecls.length) {
            returnVal[i] = variableDecls[i].getName().toString();
            ++i;
        }
        return returnVal;
    }

    public static boolean hasVariables(ModuleNode moduleNode) {
        OpDeclNode[] variableDecls = moduleNode.getVariableDecls();
        return variableDecls.length > 0;
    }

    public static SymbolNode getSymbol(String name, ModuleNode moduleNode) {
        return moduleNode.getContext().getSymbol((Object)name);
    }

    public static List<Assignment> createDefinitionList(ModuleNode moduleNode) {
        OpDefNode[] operatorDefinitions = moduleNode.getOpDefs();
        Vector<Assignment> operations = new Vector<Assignment>(operatorDefinitions.length);
        int i = 0;
        while (i < operatorDefinitions.length) {
            Object[] params = new String[operatorDefinitions[i].getNumberOfArgs()];
            Arrays.fill(params, "");
            Assignment assign = new Assignment(operatorDefinitions[i].getName().toString(), (String[])params, "");
            operations.add(assign);
            ++i;
        }
        return operations;
    }

    public static List<Assignment> mergeConstantLists(List<Assignment> constants, List<Assignment> constantsFromModule) {
        Vector<Assignment> constantsToAdd = new Vector<Assignment>();
        Vector<Assignment> constantsUsed = new Vector<Assignment>();
        Vector<Assignment> constantsToDelete = new Vector<Assignment>();
        int i = 0;
        while (i < constantsFromModule.size()) {
            Assignment fromModule = constantsFromModule.get(i);
            boolean found = false;
            int j = 0;
            while (j < constants.size()) {
                Assignment constant = constants.get(j);
                if (fromModule.equalSignature(constant)) {
                    constantsUsed.add(constant);
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                constantsToAdd.add(fromModule);
            }
            ++i;
        }
        constantsToDelete.addAll(constants);
        constantsToDelete.removeAll(constantsUsed);
        constants.retainAll(constantsUsed);
        constants.addAll(constantsToAdd);
        return constantsToDelete;
    }

    public static int[] calculateCoordinates(IDocument document, FindReplaceDocumentAdapter searchAdapter, String id) throws CoreException {
        try {
            IRegion foundId = searchAdapter.find(0, id, true, true, false, false);
            if (foundId == null) {
                return EMPTY_LOCATION;
            }
            return ModelHelper.regionToLocation(document, foundId, true);
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Error during detection of the id position in MC.tla.", (Throwable)e));
        }
    }

    public static int[] regionToLocation(IDocument document, IRegion region, boolean singleLine) throws BadLocationException {
        if (!singleLine) {
            throw new IllegalArgumentException("Not implemented");
        }
        int[] coordinates = new int[4];
        int offset = region.getOffset();
        int length = region.getLength();
        coordinates[0] = document.getLineOfOffset(offset) + 1;
        coordinates[2] = document.getLineOfOffset(offset) + 1;
        IRegion line = document.getLineInformationOfOffset(offset);
        coordinates[1] = offset - line.getOffset();
        coordinates[3] = coordinates[1] + length;
        return coordinates;
    }

    public static Hashtable<String, Object> createMarkerDescription(String errorMessage, int severity) {
        Hashtable<String, Object> prop = new Hashtable<String, Object>();
        prop.put("severity", new Integer(severity));
        prop.put("message", errorMessage);
        prop.put(TLC_MODEL_ERROR_MARKER_ATTRIBUTE_NAME, "");
        prop.put(TLC_MODEL_ERROR_MARKER_ATTRIBUTE_IDX, new Integer(0));
        prop.put("location", "");
        prop.put("charStart", new Integer(0));
        prop.put("charEnd", new Integer(0));
        return prop;
    }

    public static Hashtable<String, Object> createMarkerDescription(IFile rootModule, IDocument document, FindReplaceDocumentAdapter searchAdapter, String message, int severity, int[] coordinates) throws CoreException {
        String attributeName;
        int attributeIndex;
        Region errorRegion;
        block14: {
            errorRegion = null;
            attributeIndex = -1;
            try {
                IRegion lineRegion = document.getLineInformation(coordinates[0] - 1);
                if (lineRegion != null) {
                    int errorLineOffset = lineRegion.getOffset();
                    IRegion commentRegion = searchAdapter.find(errorLineOffset, "\\* ", false, false, false, false);
                    IRegion separatorRegion = searchAdapter.find(errorLineOffset, "----", true, false, false, false);
                    if (separatorRegion != null && commentRegion != null) {
                        IRegion attributeRegion = searchAdapter.find(commentRegion.getOffset(), "@[a-z]*[A-Z]*", true, false, false, true);
                        if (attributeRegion != null) {
                            String indexString;
                            attributeName = document.get(attributeRegion.getOffset(), attributeRegion.getLength()).substring("@".length());
                            IRegion indexRegion = searchAdapter.find(attributeRegion.getOffset() + attributeRegion.getLength(), ":[0-9]+", true, false, false, true);
                            if (indexRegion != null && indexRegion.getOffset() < separatorRegion.getOffset() && (indexString = document.get(indexRegion.getOffset(), indexRegion.getLength())) != null && indexString.length() > 1) {
                                try {
                                    attributeIndex = Integer.parseInt(indexString.substring(1));
                                }
                                catch (NumberFormatException e) {
                                    throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Error during detection of the error position in MC.tla.Error parsing the attribute index. " + message, (Throwable)e));
                                }
                            }
                            IRegion firstBlockLine = document.getLineInformation(document.getLineOfOffset(commentRegion.getOffset()) + 1);
                            int beginBlockOffset = firstBlockLine.getOffset();
                            if (!attributeName.equals("modelParameterNewDefinitions")) {
                                beginBlockOffset = beginBlockOffset + firstBlockLine.getLength() + 1;
                            }
                            if (coordinates[2] == 0) {
                                errorRegion = new Region(errorLineOffset + coordinates[1] - beginBlockOffset, 1);
                            } else if (coordinates[2] == coordinates[0]) {
                                int length = coordinates[3] - coordinates[1];
                                errorRegion = new Region(errorLineOffset + coordinates[1] - beginBlockOffset, length == 0 ? 1 : length);
                            } else {
                                int summedLength = lineRegion.getLength() - coordinates[1];
                                int l = coordinates[0] + 1;
                                while (l < coordinates[2]) {
                                    IRegion line = document.getLineInformation(l - 1);
                                    summedLength += line.getLength();
                                    ++l;
                                }
                                errorRegion = new Region(errorLineOffset + coordinates[1] - beginBlockOffset, summedLength += coordinates[3]);
                            }
                            break block14;
                        }
                        throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Error during detection of the error position in MC.tla.Could not detect the attribute. " + message));
                    }
                    throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Error during detection of the error position in MC.tla.Could not detect definition block. " + message));
                }
                throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Error during detection of the error position in MC.tla.Could not data on specified location. " + message));
            }
            catch (BadLocationException e) {
                throw new CoreException((IStatus)new Status(4, "org.lamport.tla.toolbox.tool.tlc", "Error during detection of the error position in MC.tla.Accessing MC.tla file failed. " + message, (Throwable)e));
            }
        }
        message = ModelHelper.getMessageWithoutFile(rootModule, message, attributeName, attributeIndex);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("severity", new Integer(severity));
        props.put("message", message);
        props.put(TLC_MODEL_ERROR_MARKER_ATTRIBUTE_NAME, attributeName);
        props.put(TLC_MODEL_ERROR_MARKER_ATTRIBUTE_IDX, new Integer(attributeIndex));
        props.put("location", "");
        props.put("charStart", new Integer(errorRegion.getOffset()));
        props.put("charEnd", new Integer(errorRegion.getOffset() + errorRegion.getLength()));
        return props;
    }

    private static String getMessageWithoutFile(IFile rootModule, String message, String attributeName, int attributeIndex) {
        String module = rootModule.getName().replace(".tla", "");
        if (message.indexOf("in module " + module) != -1 || message.indexOf("of module " + module) != -1) {
            String[] splitMessage = message.split("at line [0-9]{1,}, column [0-9]{1,} in module " + module, 2);
            if (splitMessage.length != 2) {
                splitMessage = message.split("line [0-9]{1,}, col [0-9]{1,} to line [0-9]{1,}, col [0-9]{1,} of module " + module, 2);
            }
            if (splitMessage.length == 2) {
                String toReturn = splitMessage[0] + " in " + ModelHelper.getSectionNameFromAttributeName(attributeName);
                if (attributeIndex != -1) {
                    toReturn = toReturn + " at line " + (attributeIndex + 1);
                }
                return toReturn + splitMessage[1];
            }
            return message;
        }
        return message;
    }

    private static String getSectionNameFromAttributeName(String attributeName) {
        if (attributeName.equals("modelCorrectnessInvariants")) {
            return "Invariants";
        }
        if (attributeName.equals("modelCorrectnessProperties")) {
            return "Properties";
        }
        if (attributeName.equals("modelParameterActionConstraint")) {
            return "Action Contraint";
        }
        if (attributeName.equals("modelParameterContraint")) {
            return "Constraint";
        }
        if (attributeName.equals("modelParameterConstants")) {
            return "What is the model?";
        }
        if (attributeName.equals("modelParameterDefinitions")) {
            return "Definition Override";
        }
        if (attributeName.equals("modelParameterNewDefinitions")) {
            return "Additional Definitions";
        }
        if (attributeName.equals("modelParameterModelValues")) {
            return "Model Values";
        }
        if (attributeName.equals("modelBehaviorSpec")) {
            return "Temporal formula";
        }
        if (attributeName.equals("modelBehaviorInit")) {
            return "Init";
        }
        if (attributeName.equals("modelBehaviorNext")) {
            return "Next";
        }
        if (attributeName.equals("modelParameterView")) {
            return "View";
        }
        if (attributeName.equals("modelParameterPostCondition")) {
            return "Post Condition";
        }
        if (attributeName.equals("modelParameterAlias")) {
            return "Alias Expression";
        }
        if (attributeName.equals("modelExpressionEval")) {
            return "Expression";
        }
        if (attributeName.equals("traceExploreExpressions")) {
            return "Error-Trace Exploration expression";
        }
        return attributeName;
    }

    public static IRegion[] findIds(String text) {
        if (text == null || text.length() == 0) {
            return new IRegion[0];
        }
        Matcher matcher = SpecWriterUtilities.ID_MATCHER.matcher(text);
        ArrayList<Region> regions = new ArrayList<Region>();
        while (matcher.find()) {
            regions.add(new Region(matcher.start(), matcher.end() - matcher.start()));
        }
        return regions.toArray(new IRegion[regions.size()]);
    }

    public static IRegion[] findLocations(String text) {
        if (text == null || text.length() == 0) {
            return new IRegion[0];
        }
        Matcher matcher = Location.LOCATION_MATCHER.matcher(text);
        Vector<Region> regions = new Vector<Region>();
        while (matcher.find()) {
            regions.add(new Region(matcher.start(), matcher.end() - matcher.start()));
        }
        matcher = Location.LOCATION_MATCHER4.matcher(text);
        while (matcher.find()) {
            regions.add(new Region(matcher.start(), matcher.end() - matcher.start()));
        }
        return regions.toArray(new IRegion[regions.size()]);
    }

    public static OpDefNode getOpDefNode(String name) {
        SpecObj specObj = ToolboxHandle.getCurrentSpec().getValidRootModule();
        if (specObj != null) {
            return ModelHelper.getOpDefNode(specObj, name);
        }
        return null;
    }

    public static OpDefNode getOpDefNode(SpecObj specObj, String name) {
        OpDefNode[] opDefNodes = specObj.getExternalModuleTable().getRootModule().getOpDefs();
        int j = 0;
        while (j < opDefNodes.length) {
            if (opDefNodes[j].getName().toString().equals(name)) {
                return opDefNodes[j];
            }
            ++j;
        }
        return null;
    }

    public static boolean isListAttribute(String attributeName) {
        return attributeName != null && (attributeName.equals("modelCorrectnessInvariants") || attributeName.equals("modelCorrectnessProperties") || attributeName.equals("modelParameterConstants") || attributeName.equals("modelParameterDefinitions"));
    }

    public static ModuleNode getRootModuleNode() {
        SpecObj specObj = ToolboxHandle.getSpecObj();
        if (specObj != null) {
            return specObj.getExternalModuleTable().getRootModule();
        }
        return null;
    }

    public static void createOrClearFiles(final IFile[] files, IProgressMonitor monitor) {
        ISchedulingRule fileRule = MultiRule.combine((ISchedulingRule)ResourceHelper.getModifyRule((IResource[])files), (ISchedulingRule)ResourceHelper.getCreateRule((IResource[])files));
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    int i = 0;
                    while (i < files.length) {
                        if (files[i].exists()) {
                            files[i].setContents((InputStream)new ByteArrayInputStream("".getBytes()), 1025, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        } else {
                            files[i].create((InputStream)new ByteArrayInputStream("".getBytes()), 1025, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        ++i;
                    }
                }
            }, fileRule, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        }
        catch (CoreException e) {
            TLCActivator.logError("Error creating files.", e);
        }
    }

    public static void copyExtendedModuleFiles(IFile specRootFile, IPath targetFolderPath, IProgressMonitor monitor, int STEP, IProject project) throws CoreException {
        List extendedModules = ToolboxHandle.getExtendedModules((String)specRootFile.getName());
        ModelHelper.copyModuleFiles(specRootFile, targetFolderPath, monitor, STEP, project, extendedModules, e -> ToolboxHandle.isUserModule((String)e));
    }

    public static void copyModuleFiles(IFile specRootFile, IPath targetFolderPath, IProgressMonitor monitor, int STEP, IProject project, Collection<String> extendedModules, Predicate<String> p) throws CoreException {
        IFile moduleFile = null;
        for (String module : extendedModules) {
            if (!p.test(module) || (moduleFile = ResourceHelper.getLinkedFile((IContainer)project, (String)module, (boolean)false)) == null || !moduleFile.exists()) continue;
            moduleFile.copy(targetFolderPath.append(moduleFile.getProjectRelativePath()), 1025, (IProgressMonitor)new SubProgressMonitor(monitor, STEP / extendedModules.size()));
        }
    }

    public static boolean containsModelCheckingModuleConflict(String rootModuleName) {
        String rootModuleFileName = rootModuleName;
        if (!rootModuleName.endsWith("tla")) {
            rootModuleFileName = ResourceHelper.getModuleFileName((String)rootModuleName);
        }
        List extendedModuleNames = ToolboxHandle.getExtendedModules((String)rootModuleFileName);
        for (String moduleName : extendedModuleNames) {
            if (!moduleName.equals("MC.tla")) continue;
            return true;
        }
        return false;
    }

    public static boolean containsTraceExplorerModuleConflict(String rootModuleName) {
        String rootModuleFileName = rootModuleName;
        if (!rootModuleName.endsWith("tla")) {
            rootModuleFileName = ResourceHelper.getModuleFileName((String)rootModuleName);
        }
        List extendedModuleNames = ToolboxHandle.getExtendedModules((String)rootModuleFileName);
        for (String moduleName : extendedModuleNames) {
            if (!moduleName.equals(TE_FILE_TLA)) continue;
            return true;
        }
        return false;
    }

    public static String prettyPrintConstants(Model model, String delim) throws CoreException {
        return ModelHelper.prettyPrintConstants(model.getLaunchConfiguration(), delim, false);
    }

    public static String prettyPrintConstants(ILaunchConfiguration config, String delim) throws CoreException {
        return ModelHelper.prettyPrintConstants(config, delim, false);
    }

    public static String prettyPrintConstants(Model model, String delim, boolean align) throws CoreException {
        return ModelHelper.prettyPrintConstants(model.getLaunchConfiguration(), delim, align);
    }

    public static String prettyPrintConstants(ILaunchConfiguration config, String delim, boolean align) throws CoreException {
        List<Assignment> assignments = ModelHelper.deserializeAssignmentList(config.getAttribute("modelParameterConstants", new ArrayList()));
        Collections.sort(assignments, new Comparator<Assignment>(){

            @Override
            public int compare(Assignment a1, Assignment a2) {
                if (a1.isSimpleModelValue() && a2.isSimpleModelValue()) {
                    return a1.getLeft().compareTo(a2.getLeft());
                }
                if (a1.isSetOfModelValues() && a2.isSetOfModelValues()) {
                    return a1.getLeft().compareTo(a2.getLeft());
                }
                if (a1.isSimpleModelValue() && !a2.isModelValue()) {
                    return 1;
                }
                if (a1.isSimpleModelValue() && a2.isSetOfModelValues()) {
                    return 1;
                }
                if (a1.isSetOfModelValues() && !a2.isModelValue()) {
                    return 1;
                }
                if (a1.isSetOfModelValues() && a2.isSimpleModelValue()) {
                    return -1;
                }
                if (!a1.isModelValue() && a2.isModelValue()) {
                    return -1;
                }
                return a1.getLeft().compareTo(a2.getLeft());
            }
        });
        int longestLeft = 0;
        int i = 0;
        while (i < assignments.size() && align) {
            Assignment assignment = assignments.get(i);
            if (!assignment.isSimpleModelValue()) {
                longestLeft = Math.max(longestLeft, assignment.getLeft().length());
            }
            ++i;
        }
        StringBuffer buf = new StringBuffer();
        int i2 = 0;
        while (i2 < assignments.size()) {
            Assignment assignment = assignments.get(i2);
            if (assignment.isSimpleModelValue()) {
                buf.append("Model values: ");
                while (i2 < assignments.size()) {
                    buf.append(assignments.get(i2).prettyPrint());
                    if (i2 < assignments.size() - 1) {
                        buf.append(", ");
                    }
                    ++i2;
                }
            } else if (align) {
                int length = longestLeft - assignment.getLeft().length();
                StringBuffer whitespaces = new StringBuffer(length);
                int j = 0;
                while (j < length) {
                    whitespaces.append(" ");
                    ++j;
                }
                buf.append(assignment.prettyPrint(whitespaces.toString()));
                if (i2 < assignments.size() - 1) {
                    buf.append(delim);
                }
            } else {
                buf.append(assignment.prettyPrint());
                if (i2 < assignments.size() - 1) {
                    buf.append(delim);
                }
            }
            ++i2;
        }
        return buf.toString();
    }
}

