/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.lamport.tla.toolbox.editor.basic.TLAEditorReadOnly;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.ToolboxHandle;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.model.TLCSpec;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor;
import org.lamport.tla.toolbox.util.UIHelper;

public class OpenSavedModuleHandler
extends AbstractHandler
implements IHandler {
    public static final String COMMAND_ID = "toolbox.tool.tlc.commands.open.savedModule";
    public static final String PARAM_MODULE_PATH = "toolbox.tool.tlc.commands.open.savedModule.modulePath";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String pathString = event.getParameter(PARAM_MODULE_PATH);
        if (pathString != null) {
            IPath modulePath = Path.fromPortableString((String)pathString);
            IFile module = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(modulePath);
            if (module != null && module.exists()) {
                Spec currentSpec = ToolboxHandle.getCurrentSpec();
                if (module.getProject().equals((Object)currentSpec.getProject())) {
                    Model model = ((TLCSpec)currentSpec.getAdapter(TLCSpec.class)).getModel(module.getParent().getName());
                    ModelEditor modelEditor = (ModelEditor)UIHelper.openEditor((String)"org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor", (IFile)model.getLaunchConfiguration().getFile());
                    if (modelEditor != null) {
                        try {
                            FileEditorInput editorInput = new FileEditorInput(module);
                            IEditorPart[] editors = modelEditor.findEditors((IEditorInput)editorInput);
                            TLAEditorReadOnly moduleEditor = null;
                            int i = 0;
                            while (i < editors.length) {
                                if (editors[i] instanceof TLAEditorReadOnly) {
                                    moduleEditor = (TLAEditorReadOnly)editors[i];
                                    moduleEditor.setInput((IEditorInput)editorInput);
                                    break;
                                }
                                ++i;
                            }
                            if (moduleEditor == null) {
                                moduleEditor = new TLAEditorReadOnly();
                                modelEditor.addPage((IEditorPart)moduleEditor, (IEditorInput)editorInput);
                            }
                            modelEditor.setActiveEditor((IEditorPart)moduleEditor);
                        }
                        catch (PartInitException e) {
                            TLCUIActivator.getDefault().logError("Error adding saved module read-only editor for module " + String.valueOf(modulePath) + " to model " + model.getName(), e);
                        }
                    } else {
                        TLCUIActivator.getDefault().logDebug("Could not open model editor for model " + model.getName());
                    }
                } else {
                    TLCUIActivator.getDefault().logDebug("OpenSavedModuleHandler was passed a module file path that is not part of the currently opened spec.This is a bug. The path is " + String.valueOf(modulePath));
                }
            }
        }
        return null;
    }
}

