/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.output.data;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCError;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCModelLaunchDataProvider;
import org.lamport.tla.toolbox.tool.tlc.output.source.TLCOutputSourceRegistry;
import org.lamport.tla.toolbox.tool.tlc.output.source.TLCRegion;
import org.lamport.tla.toolbox.tool.tlc.output.source.TLCRegionContainer;
import org.lamport.tla.toolbox.tool.tlc.traceexplorer.TraceExplorerHelper;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor;
import org.lamport.tla.toolbox.tool.tlc.ui.view.TLCErrorView;
import org.lamport.tla.toolbox.util.LegacyFileDocumentProvider;
import org.lamport.tla.toolbox.util.UIHelper;
import tlc2.model.TraceExpressionInformationHolder;

public class TraceExplorerDataProvider
extends TLCModelLaunchDataProvider {
    private static String TE_ERROR_HEADER = "Error(s) from running the Trace Explorer:\n";
    private Hashtable<String, TraceExpressionInformationHolder> traceExpressionDataTable;

    public TraceExplorerDataProvider(Model model) {
        super(model);
    }

    @Override
    protected boolean connectToSourceRegistry() {
        return TLCOutputSourceRegistry.getTraceExploreSourceRegistry().connect(this);
    }

    @Override
    public void onDone() {
        ModelEditor activeModelEditor;
        super.onDone();
        this.getTraceExpressionsInformation();
        this.processTraceForTraceExplorer();
        IEditorPart activeEditor = UIHelper.getActiveEditor();
        if (activeEditor != null && activeEditor instanceof ModelEditor && (activeModelEditor = (ModelEditor)activeEditor).getModel() != null) {
            UIHelper.runUIAsync(() -> TLCErrorView.updateErrorView(activeModelEditor));
        }
    }

    private void getTraceExpressionsInformation() {
        if (this.traceExpressionDataTable == null) {
            this.traceExpressionDataTable = new Hashtable();
        }
        this.traceExpressionDataTable.clear();
        IFile teFile = this.getModel().getTraceExplorerTLAFile();
        FileEditorInput teFileEditorInput = new FileEditorInput(teFile);
        LegacyFileDocumentProvider teFileDocumentProvider = new LegacyFileDocumentProvider();
        try {
            try {
                teFileDocumentProvider.connect((Object)teFileEditorInput);
                IDocument teDocument = teFileDocumentProvider.getDocument((Object)teFileEditorInput);
                FindReplaceDocumentAdapter teSearcher = new FindReplaceDocumentAdapter(teDocument);
                String regularExpression = FindReplaceDocumentAdapter.escapeForRegExPattern((String)"\\* ") + ":[0-2]:__trace_var_[0-9]{17,}:[\\s\\S]*?" + Pattern.quote("\"$!@$!@$!@$!@$!\"") + "\n";
                IRegion region = teSearcher.find(0, regularExpression, true, true, false, true);
                while (region != null) {
                    String commentString = teDocument.get(region.getOffset(), region.getLength());
                    String[] stringSections = commentString.split(":", 4);
                    int level = Integer.parseInt(stringSections[1]);
                    String variableName = stringSections[2];
                    String expressionAndDelimiter = stringSections[3];
                    String expression = expressionAndDelimiter.substring(0, expressionAndDelimiter.indexOf("\"$!@$!@$!@$!@$!\""));
                    TraceExpressionInformationHolder expressionData = new TraceExpressionInformationHolder(expression, null, variableName);
                    expressionData.setLevel(level);
                    this.traceExpressionDataTable.put(variableName.trim(), expressionData);
                    region = teSearcher.find(region.getOffset() + region.getLength(), regularExpression, true, true, false, true);
                }
            }
            catch (CoreException e) {
                TLCUIActivator.getDefault().logError("Error finding trace expression information in TE.tla file.", e);
                teFileDocumentProvider.disconnect((Object)teFileEditorInput);
            }
            catch (BadLocationException e) {
                TLCUIActivator.getDefault().logError("Error finding trace expression information in TE.tla file.", e);
                teFileDocumentProvider.disconnect((Object)teFileEditorInput);
            }
        }
        finally {
            teFileDocumentProvider.disconnect((Object)teFileEditorInput);
        }
    }

    private void processTraceForTraceExplorer() {
        TLCError originalErrorWithTrace = TraceExplorerHelper.getErrorOfOriginalTrace(this.getModel());
        if (originalErrorWithTrace == null) {
            this.getErrors().clear();
            return;
        }
        TLCError successfulTEError = null;
        Map traceExplorerExpressions = this.getModel().getNamedTraceExplorerExpressionsAsFormula();
        for (TLCError error : this.getErrors()) {
            if (error.hasTrace()) {
                int errorCode = error.getErrorCode();
                if (errorCode == 2114 || errorCode == 2116 || errorCode == 2110 || errorCode == 2107) {
                    error.setErrorCode(originalErrorWithTrace.getErrorCode());
                    error.setMessage(originalErrorWithTrace.getMessage());
                    error.setCause(originalErrorWithTrace.getCause());
                    successfulTEError = error;
                } else {
                    error.setMessage(TE_ERROR_HEADER + error.getMessage());
                }
                error.applyFrom(originalErrorWithTrace, traceExplorerExpressions, this.traceExpressionDataTable, this.getModel().getName());
                continue;
            }
            error.setMessage(TE_ERROR_HEADER + error.getMessage());
        }
        if (successfulTEError != null) {
            List<TLCError> originalErrors = TLCOutputSourceRegistry.getModelCheckSourceRegistry().getProvider(this.getModel()).getErrors();
            LinkedList<TLCError> newErrors = new LinkedList<TLCError>();
            for (TLCError next : originalErrors) {
                if (next == originalErrorWithTrace) {
                    newErrors.add(successfulTEError);
                    continue;
                }
                newErrors.add(next);
            }
            this.setErrors(newErrors);
        }
    }

    @Override
    protected TLCError createError(TLCRegion tlcRegion, String message) {
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
        boolean stateSortOrder = dialogSettings.getBoolean("STATESORTORDER");
        TLCError topError = new TLCError(TLCError.Order.valueOf(stateSortOrder));
        if (tlcRegion instanceof TLCRegionContainer) {
            TLCRegionContainer container = (TLCRegionContainer)tlcRegion;
            ITypedRegion[] regions = container.getSubRegions();
            Assert.isTrue((regions.length < 3 ? 1 : 0) != 0, (String)"Unexpected error region structure, this is a bug.");
            int i = 0;
            while (i < regions.length) {
                if (regions[i] instanceof TLCRegion) {
                    TLCError cause = this.createError((TLCRegion)regions[i], message);
                    topError.setCause(cause);
                } else {
                    topError.setMessage(message);
                    topError.setErrorCode(tlcRegion.getMessageCode());
                }
                ++i;
            }
        }
        return topError;
    }
}

