/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.view;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.editor.basic.TLAEditorActivator;
import org.lamport.tla.toolbox.tool.tlc.TLCActivator;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCError;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCFcnElementVariableValue;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCFunctionVariableValue;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCMultiVariableValue;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCNamedVariableValue;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCRecordVariableValue;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCSequenceVariableValue;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCSetVariableValue;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCSimpleVariableValue;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCState;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCVariable;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCVariableValue;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.ModelEditor;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.MainModelPage;
import org.lamport.tla.toolbox.tool.tlc.ui.util.RecordToSourceCoupler;
import org.lamport.tla.toolbox.tool.tlc.ui.view.TLCErrorView;
import tla2sany.st.Location;

class ErrorTraceTreeViewer {
    private static final int[] COLUMN_WIDTH = new int[]{200, 200};
    private static final String[] COLUMN_TEXTS = new String[]{"Name", "Value"};
    private static final String LOADER_TOOL_TIP = "Double-click to load more states.\nIf the number of states is large, this might take a few seconds.";
    private final TreeViewer treeViewer;
    private final IPropertyChangeListener errorTraceFontChangeListener;
    private ModelEditor modelEditor;

    ErrorTraceTreeViewer(Tree parent, ModelEditor associatedModelEditor) {
        this.treeViewer = new TreeViewer(parent);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setContentProvider((IContentProvider)new StateContentProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        TraceDisplayResizer resizer = new TraceDisplayResizer(parent);
        StateLabelProvider labelProvider = new StateLabelProvider();
        int i = 0;
        while (i < COLUMN_TEXTS.length) {
            TreeViewerColumn column = new TreeViewerColumn(this.treeViewer, i);
            column.getColumn().setText(COLUMN_TEXTS[i]);
            column.getColumn().setWidth(COLUMN_WIDTH[i]);
            column.setLabelProvider((CellLabelProvider)labelProvider);
            resizer.setColumnForIndex(column, i);
            column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TLCError error = (TLCError)ErrorTraceTreeViewer.this.treeViewer.getInput();
                    error.reverseTrace();
                    ErrorTraceTreeViewer.this.treeViewer.getTree().setSortDirection(error.getOrder() == TLCError.Order.OneToN ? 128 : 1024);
                    ErrorTraceTreeViewer.this.treeViewer.setSelection(new ISelection(){

                        public boolean isEmpty() {
                            return true;
                        }
                    });
                    ErrorTraceTreeViewer.this.treeViewer.refresh(false);
                    IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
                    dialogSettings.put("STATESORTORDER", !dialogSettings.getBoolean("STATESORTORDER"));
                }
            });
            ++i;
        }
        this.treeViewer.getTree().setSortColumn(this.treeViewer.getTree().getColumn(1));
        parent.addControlListener((ControlListener)resizer);
        this.errorTraceFontChangeListener = event -> {
            if (event == null || event.getProperty().equals("org.lamport.tla.toolbox.tool.tlc.ui.tlcErrorTraceFont")) {
                Font f = JFaceResources.getFont((String)"org.lamport.tla.toolbox.tool.tlc.ui.tlcErrorTraceFont");
                JFaceResources.getFontRegistry().put("org.lamport.tla.toolbox.tool.tlc.ui.tlcErrorTraceFont_private", f.getFontData());
                if (this.treeViewer != null) {
                    this.treeViewer.refresh(true);
                }
            }
        };
        this.errorTraceFontChangeListener.propertyChange(null);
        JFaceResources.getFontRegistry().addListener(this.errorTraceFontChangeListener);
        this.createContextMenu();
        this.setModelEditor(associatedModelEditor);
    }

    void dispose() {
        FontRegistry fr = JFaceResources.getFontRegistry();
        fr.removeListener(this.errorTraceFontChangeListener);
    }

    void setModelEditor(ModelEditor associatedModelEditor) {
        this.modelEditor = associatedModelEditor;
    }

    TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    TLCError getCurrentTrace() {
        return (TLCError)this.treeViewer.getInput();
    }

    private void createContextMenu() {
        MenuManager contextMenu = new MenuManager("#ViewerMenu");
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                final Object selection = ((IStructuredSelection)ErrorTraceTreeViewer.this.treeViewer.getSelection()).getFirstElement();
                if (selection instanceof TLCState) {
                    menuManager.add((IAction)new Action("Run model from this point"){

                        public void run() {
                            block7: {
                                if ((this).ErrorTraceTreeViewer.this.modelEditor != null) {
                                    Model m = (this).ErrorTraceTreeViewer.this.modelEditor.getModel();
                                    if (m != null) {
                                        try {
                                            int specType = m.getAttribute("modelBehaviorSpecType", 2);
                                            if (specType == 0) {
                                                return;
                                            }
                                            MainModelPage page = (MainModelPage)(this).ErrorTraceTreeViewer.this.modelEditor.findPage("MainModelPage");
                                            String init = ((TLCState)selection).getConjunctiveDescription(false);
                                            if (specType == 1) {
                                                page.setInitNextBehavior(init, "");
                                                (this).ErrorTraceTreeViewer.this.modelEditor.setActivePage("MainModelPage");
                                                Display.getDefault().asyncExec(() -> MessageDialog.openInformation(null, (String)"Model Reconfigured", (String)"The model has been set up to begin checking from the selected state; please enter the next-state relation (usually Next), review the model parameters and run the checker."));
                                                break block7;
                                            }
                                            page.setInitNextBehavior(init, null);
                                            (this).ErrorTraceTreeViewer.this.modelEditor.setActivePage("MainModelPage");
                                            Display.getDefault().asyncExec(() -> MessageDialog.openInformation(null, (String)"Model Reconfigured", (String)"The model has been set up to begin checking from the selected state; please review the model parameters and run the checker."));
                                        }
                                        catch (CoreException e) {
                                            TLCActivator.logError((String)"Problem encountered attempting to launch checker.", (Throwable)e);
                                        }
                                    }
                                } else {
                                    TLCActivator.logInfo((String)"Were not able to launch ammended model because we have no model editor.");
                                }
                            }
                        }
                    });
                }
            }
        });
        Control c = this.treeViewer.getControl();
        Menu menu = contextMenu.createContextMenu(c);
        c.setMenu(menu);
    }

    private class StateContentProvider
    implements ILazyTreeContentProvider {
        private List<TLCState> states = new ArrayList<TLCState>(0);
        private final int numberOfStatesToShow = TLCUIActivator.getDefault().getPreferenceStore().getInt("traceMaxShowErrors");

        StateContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof TLCError) {
                this.states = ((TLCError)newInput).getStates();
            } else if (newInput == null) {
                this.states = new ArrayList<TLCState>(0);
            } else {
                throw new IllegalArgumentException();
            }
        }

        public void updateElement(Object parent, int viewerIndex) {
            if (parent instanceof TLCError) {
                TLCError error = (TLCError)parent;
                if (error.isTraceRestricted() && viewerIndex == 0) {
                    ErrorTraceTreeViewer.this.treeViewer.replace(parent, viewerIndex, (Object)new RecordToSourceCoupler.LoaderTLCState(ErrorTraceTreeViewer.this.treeViewer, Math.min(this.numberOfStatesToShow, error.getNumberOfRestrictedTraceStates()), error));
                    return;
                }
                int statesIndex = viewerIndex - (error.isTraceRestricted() ? 1 : 0);
                TLCState child = this.states.get(statesIndex);
                if (statesIndex > 0) {
                    if (error.isOrder(TLCError.Order.OneToN)) {
                        TLCState predecessor = this.states.get(statesIndex - 1);
                        predecessor.diff(child);
                    } else {
                        TLCState successor = this.states.get(statesIndex - 1);
                        child.diff(successor);
                    }
                }
                ErrorTraceTreeViewer.this.treeViewer.replace(parent, viewerIndex, (Object)child);
                ErrorTraceTreeViewer.this.treeViewer.setHasChildren((Object)child, child.getVariablesAsList().size() > 0);
                if (child.isExpandable()) {
                    ErrorTraceTreeViewer.this.treeViewer.expandToLevel((Object)child, 1);
                }
            } else if (parent instanceof TLCState) {
                TLCState state = (TLCState)parent;
                if (state.isStuttering() || state.isBackToState()) {
                    ErrorTraceTreeViewer.this.treeViewer.setChildCount((Object)state, 0);
                } else {
                    List<TLCVariable> variablesAsList = state.getVariablesAsList();
                    if (variablesAsList.size() > viewerIndex) {
                        TLCVariable child = variablesAsList.get(viewerIndex);
                        ErrorTraceTreeViewer.this.treeViewer.replace(parent, viewerIndex, (Object)child);
                        ErrorTraceTreeViewer.this.treeViewer.setHasChildren((Object)child, child.getChildCount() > 0);
                    }
                }
            } else if (parent instanceof TLCVariable && ((TLCVariable)parent).getValue() instanceof TLCMultiVariableValue) {
                TLCMultiVariableValue multiValue = (TLCMultiVariableValue)((Object)((TLCVariable)parent).getValue());
                TLCVariableValue child = multiValue.asList().get(viewerIndex);
                ErrorTraceTreeViewer.this.treeViewer.replace(parent, viewerIndex, (Object)child);
                ErrorTraceTreeViewer.this.treeViewer.setHasChildren((Object)child, child.getChildCount() > 0);
            } else if (parent instanceof TLCVariable) {
                TLCVariable variable = (TLCVariable)parent;
                TLCVariableValue child = variable.getValue();
                ErrorTraceTreeViewer.this.treeViewer.replace(parent, viewerIndex, (Object)child);
                ErrorTraceTreeViewer.this.treeViewer.setChildCount((Object)child, child.getChildCount());
            } else if (parent instanceof TLCMultiVariableValue) {
                TLCMultiVariableValue multiValue = (TLCMultiVariableValue)parent;
                TLCVariableValue child = multiValue.asList().get(viewerIndex);
                ErrorTraceTreeViewer.this.treeViewer.replace(parent, viewerIndex, (Object)child);
                ErrorTraceTreeViewer.this.treeViewer.setHasChildren((Object)child, child.getChildCount() > 0);
            } else if (parent instanceof TLCVariableValue && ((TLCVariableValue)parent).getValue() instanceof TLCMultiVariableValue) {
                TLCMultiVariableValue multiValue = (TLCMultiVariableValue)((TLCVariableValue)parent).getValue();
                TLCVariableValue child = multiValue.asList().get(viewerIndex);
                ErrorTraceTreeViewer.this.treeViewer.replace(parent, viewerIndex, (Object)child);
                ErrorTraceTreeViewer.this.treeViewer.setHasChildren((Object)child, child.getChildCount() > 0);
            } else {
                throw new IllegalArgumentException();
            }
        }

        public void updateChildCount(Object element, int currentChildCount) {
            if (element instanceof TLCError) {
                TLCError error = (TLCError)element;
                int traceSize = error.getTraceSize();
                if (traceSize != currentChildCount) {
                    if (error.isTraceRestricted()) {
                        ErrorTraceTreeViewer.this.treeViewer.setChildCount(element, traceSize + 1);
                    } else {
                        ErrorTraceTreeViewer.this.treeViewer.setChildCount(element, traceSize);
                    }
                }
            } else if (element instanceof TLCState) {
                TLCState state = (TLCState)element;
                if ((state.isStuttering() || state.isBackToState()) && currentChildCount != 0) {
                    ErrorTraceTreeViewer.this.treeViewer.setChildCount(element, 0);
                } else if (currentChildCount != state.getVariablesAsList().size()) {
                    ErrorTraceTreeViewer.this.treeViewer.setChildCount(element, state.getVariablesAsList().size());
                }
            } else if (element instanceof TLCVariable) {
                TLCVariable variable = (TLCVariable)element;
                if (currentChildCount != variable.getChildCount()) {
                    ErrorTraceTreeViewer.this.treeViewer.setChildCount(element, variable.getChildCount());
                }
            } else if (element instanceof TLCVariableValue) {
                TLCVariableValue value = (TLCVariableValue)element;
                if (currentChildCount != value.getChildCount()) {
                    ErrorTraceTreeViewer.this.treeViewer.setChildCount(element, value.getChildCount());
                }
            } else {
                throw new IllegalArgumentException();
            }
        }

        public Object getParent(Object element) {
            return null;
        }
    }

    static class StateLabelProvider
    extends CellLabelProvider {
        private static final int NAME_COLUMN_INDEX = 0;
        private static final int VALUE_COLUMN_INDEX = 1;
        private static final Map<String, Color> LOCATION_COLOR_MAP = new ConcurrentHashMap<String, Color>();
        private static final boolean COLORING_SYSTEM_PROPERTY = Boolean.getBoolean(TLCErrorView.class.getName() + ".coloring");
        private final Image stateImage = TLCUIActivator.getImageDescriptor("/icons/full/default_co.gif").createImage();
        private final Image varImage = TLCUIActivator.getImageDescriptor("/icons/full/private_co.gif").createImage();
        private final Image recordImage = TLCUIActivator.getImageDescriptor("/icons/full/brkpi_obj.gif").createImage();
        private final Image setImage = TLCUIActivator.getImageDescriptor("/icons/full/compare_method.gif").createImage();
        private final Image loadMoreImage = TLCUIActivator.getImageDescriptor("/icons/full/add.gif").createImage();

        public void dispose() {
            this.stateImage.dispose();
            this.varImage.dispose();
            this.recordImage.dispose();
            this.setImage.dispose();
            this.loadMoreImage.dispose();
            super.dispose();
        }

        public String getToolTipText(Object element) {
            if (element instanceof RecordToSourceCoupler.LoaderTLCState) {
                return ErrorTraceTreeViewer.LOADER_TOOL_TIP;
            }
            return null;
        }

        public void update(ViewerCell cell) {
            cell.setText(this.getColumnText(cell.getElement(), cell.getColumnIndex()));
            cell.setImage(this.getColumnImage(cell.getElement(), cell.getColumnIndex()));
            cell.setFont(this.getFont(cell.getElement(), cell.getColumnIndex()));
            Color bg = this.getBackground(cell.getElement(), cell.getColumnIndex());
            cell.setBackground(bg);
            if (TLAEditorActivator.getDefault().isCurrentThemeDark()) {
                cell.setForeground(bg == null ? null : Display.getCurrent().getSystemColor(2));
            } else {
                cell.setForeground(null);
            }
        }

        private Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof RecordToSourceCoupler.LoaderTLCState) {
                    return this.loadMoreImage;
                }
                if (element instanceof TLCState) {
                    return this.stateImage;
                }
                if (element instanceof TLCVariable) {
                    return this.varImage;
                }
                if (element instanceof TLCNamedVariableValue) {
                    return this.recordImage;
                }
                if (element instanceof TLCFcnElementVariableValue) {
                    return this.recordImage;
                }
                return this.setImage;
            }
            return null;
        }

        private String getColumnText(Object element, int columnIndex) {
            if (element instanceof TLCState) {
                TLCState state = (TLCState)element;
                switch (columnIndex) {
                    case 0: {
                        if (state.isStuttering()) {
                            return "<Stuttering>";
                        }
                        if (state.isBackToState()) {
                            return "<Back to state " + state.getStateNumber() + ">";
                        }
                        return state.getLabel();
                    }
                    case 1: {
                        if (state instanceof RecordToSourceCoupler.LoaderTLCState) {
                            return "";
                        }
                        return "State (num = " + state.getStateNumber() + ")";
                    }
                }
            } else if (element instanceof TLCVariable) {
                TLCVariable var = (TLCVariable)element;
                switch (columnIndex) {
                    case 0: {
                        if (var.isTraceExplorerVar()) {
                            return var.getSingleLineName();
                        }
                        return var.getName();
                    }
                    case 1: {
                        return var.getValue().toSimpleString();
                    }
                }
            } else if (element instanceof TLCSetVariableValue || element instanceof TLCSequenceVariableValue || element instanceof TLCSimpleVariableValue) {
                TLCVariableValue varValue = (TLCVariableValue)element;
                switch (columnIndex) {
                    case 1: {
                        return varValue.toString();
                    }
                    case 0: {
                        return "";
                    }
                }
            } else if (element instanceof TLCNamedVariableValue) {
                TLCNamedVariableValue namedValue = (TLCNamedVariableValue)element;
                switch (columnIndex) {
                    case 0: {
                        return namedValue.getName();
                    }
                    case 1: {
                        return ((TLCVariableValue)namedValue.getValue()).toSimpleString();
                    }
                }
            } else if (element instanceof TLCFcnElementVariableValue) {
                TLCFcnElementVariableValue fcnElementValue = (TLCFcnElementVariableValue)element;
                switch (columnIndex) {
                    case 0: {
                        return fcnElementValue.getFrom().toSimpleString();
                    }
                    case 1: {
                        return ((TLCVariableValue)fcnElementValue.getValue()).toSimpleString();
                    }
                }
            } else if (element instanceof TLCRecordVariableValue) {
                TLCRecordVariableValue recordValue = (TLCRecordVariableValue)element;
                switch (columnIndex) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return recordValue.toSimpleString();
                    }
                }
            } else if (element instanceof TLCFunctionVariableValue) {
                TLCFunctionVariableValue fcnValue = (TLCFunctionVariableValue)element;
                switch (columnIndex) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return fcnValue.toSimpleString();
                    }
                }
            }
            return null;
        }

        private Color getBackground(Object element, int column) {
            if (element instanceof TLCVariable) {
                TLCVariable var = (TLCVariable)element;
                if (var.isChanged() && column == 1) {
                    return TLCUIActivator.getDefault().getChangedColor();
                }
            } else if (element instanceof TLCVariableValue) {
                TLCVariableValue value = (TLCVariableValue)element;
                if (value.isChanged()) {
                    if (column == 1) {
                        return TLCUIActivator.getDefault().getChangedColor();
                    }
                } else {
                    if (value.isAdded()) {
                        return TLCUIActivator.getDefault().getAddedColor();
                    }
                    if (value.isDeleted()) {
                        return TLCUIActivator.getDefault().getDeletedColor();
                    }
                }
            } else if (COLORING_SYSTEM_PROPERTY && element instanceof TLCState) {
                TLCState state = (TLCState)element;
                Location moduleLocation = state.getModuleLocation();
                if (moduleLocation == null) {
                    return null;
                }
                Color c = LOCATION_COLOR_MAP.get(moduleLocation.toString());
                if (c == null) {
                    int color = 1 + 2 * LOCATION_COLOR_MAP.size();
                    c = TLCUIActivator.getColor(color);
                    LOCATION_COLOR_MAP.put(state.getModuleLocation().toString(), c);
                }
                return c;
            }
            return null;
        }

        private Font getFont(Object element, int columnIndex) {
            boolean returnBoldVersion = false;
            if (element instanceof TLCVariable) {
                if (((TLCVariable)element).isTraceExplorerVar()) {
                    returnBoldVersion = true;
                }
            } else if (element instanceof RecordToSourceCoupler.LoaderTLCState) {
                returnBoldVersion = true;
            }
            FontRegistry fr = JFaceResources.getFontRegistry();
            return returnBoldVersion ? fr.getBold("org.lamport.tla.toolbox.tool.tlc.ui.tlcErrorTraceFont_private") : fr.get("org.lamport.tla.toolbox.tool.tlc.ui.tlcErrorTraceFont_private");
        }
    }

    private static class TraceDisplayResizer
    extends ControlAdapter
    implements Listener {
        private double firstColumnPercentageWidth = 0.5;
        private boolean inControlResized = false;
        private final Tree tree;
        private final TreeColumn[] columns;
        private final Scrollable treeParentComponent;

        TraceDisplayResizer(Tree resizingTree) {
            this.tree = resizingTree;
            this.treeParentComponent = this.tree.getParent();
            this.columns = new TreeColumn[COLUMN_TEXTS.length];
        }

        public void controlResized(ControlEvent e) {
            this.inControlResized = true;
            int treeWidth = this.computeMaximumWidthOfAllColumns();
            int firstColWidth = Math.round(Math.round(this.firstColumnPercentageWidth * (double)treeWidth));
            int secondColWidth = treeWidth - firstColWidth;
            this.columns[0].setWidth(firstColWidth);
            this.columns[1].setWidth(secondColWidth);
            this.inControlResized = false;
        }

        public void handleEvent(Event event) {
            if (this.inControlResized) {
                return;
            }
            int treeWidth = this.computeMaximumWidthOfAllColumns();
            if (treeWidth == 0) {
                return;
            }
            int firstColWidth = this.columns[0].getWidth();
            double tentativefirstColPercentageWidth = (double)firstColWidth / (double)treeWidth;
            this.firstColumnPercentageWidth = tentativefirstColPercentageWidth > 0.1 && tentativefirstColPercentageWidth < 0.9 ? (double)firstColWidth / (double)treeWidth : (tentativefirstColPercentageWidth <= 0.1 ? 0.1 : 0.9);
            firstColWidth = Math.round(Math.round(tentativefirstColPercentageWidth * (double)treeWidth));
            this.columns[1].setWidth(treeWidth - firstColWidth);
        }

        void setColumnForIndex(TreeViewerColumn column, int index) {
            this.columns[index] = column.getColumn();
            if (index == 0) {
                this.columns[0].addListener(11, (Listener)this);
            }
        }

        private int computeMaximumWidthOfAllColumns() {
            ScrollBar vBar = this.tree.getVerticalBar();
            boolean scrollBarShown = vBar.isVisible();
            return this.treeParentComponent.getClientArea().width - this.tree.getBorderWidth() - this.tree.getColumnCount() * this.tree.getGridLineWidth() - (scrollBarShown ? vBar.getSize().x : 0);
        }
    }
}

