/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.editor.page;

import util.TLCRuntime;

public enum TLCConsumptionProfile {
    LOCAL_MOST("Most", 0.7, 0.8, null, "local most"),
    LOCAL_NORMAL("Medium", 0.5, 0.4, null, "local nomal"),
    LOCAL_MINIMAL("Minimal", 0.2, 0.25, null, "local minimal"),
    REMOTE_AD_HOC("Ad Hoc", 0.0, 0.3, "ad hoc", "ad hoc"),
    REMOTE_AZURE("Azure", 0.0, 0.0, "jclouds", "Azure"),
    REMOTE_AWS("Amazon", 0.0, 0.0, "jclouds", "aws-ec2"),
    REMOTE_PACKET_NET("PacketNet", 0.0, 0.0, "jclouds", "PacketNet");

    private final double m_workerThreadPercentage;
    private final double m_memoryPercentage;
    private final String m_displayName;
    private final String m_configurationKey;
    private final String m_preferenceValue;

    public static TLCConsumptionProfile getProfileWithPreferenceValue(String value) {
        TLCConsumptionProfile[] tLCConsumptionProfileArray = TLCConsumptionProfile.values();
        int n = tLCConsumptionProfileArray.length;
        int n2 = 0;
        while (n2 < n) {
            TLCConsumptionProfile profile = tLCConsumptionProfileArray[n2];
            if (value.equals(profile.getPreferenceValue())) {
                return profile;
            }
            ++n2;
        }
        return null;
    }

    public static TLCConsumptionProfile getProfileWithDisplayName(String displayName) {
        TLCConsumptionProfile[] tLCConsumptionProfileArray = TLCConsumptionProfile.values();
        int n = tLCConsumptionProfileArray.length;
        int n2 = 0;
        while (n2 < n) {
            TLCConsumptionProfile profile = tLCConsumptionProfileArray[n2];
            if (displayName.equals(profile.getDisplayName())) {
                return profile;
            }
            ++n2;
        }
        return null;
    }

    private TLCConsumptionProfile(String name, double threadPercentage, double memoryPercentage, String uiConfigurationKey, String preferenceValue) {
        this.m_displayName = name;
        this.m_workerThreadPercentage = threadPercentage;
        this.m_memoryPercentage = memoryPercentage;
        this.m_configurationKey = uiConfigurationKey;
        this.m_preferenceValue = preferenceValue;
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public boolean profileIsForRemoteWorkers() {
        return this.m_configurationKey != null;
    }

    public String getConfigurationKey() {
        return this.m_configurationKey;
    }

    public String getPreferenceValue() {
        return this.m_preferenceValue;
    }

    public int getMemoryPercentage() {
        return (int)(100.0 * this.m_memoryPercentage);
    }

    public long getMemory() {
        return TLCRuntime.getInstance().getAbsolutePhysicalSystemMemory(this.m_memoryPercentage);
    }

    public int getWorkerThreads() {
        return (int)Math.ceil((double)Runtime.getRuntime().availableProcessors() * this.m_workerThreadPercentage);
    }
}

