/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.output.source;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentPartitioningChangedEvent;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.GapTextStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitioningListener;
import org.eclipse.jface.text.IDocumentPartitioningListenerExtension2;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.lamport.tla.toolbox.tool.tlc.model.Model;
import org.lamport.tla.toolbox.tool.tlc.output.source.CachingTLCOutputSource;
import org.lamport.tla.toolbox.tool.tlc.output.source.ITLCOutputSource;
import org.lamport.tla.toolbox.tool.tlc.output.source.TLCOutputSourceRegistry;
import org.lamport.tla.toolbox.tool.tlc.output.source.TLCRegion;
import org.lamport.tla.toolbox.tool.tlc.output.source.TagBasedTLCAnalyzer;
import org.lamport.tla.toolbox.tool.tlc.output.source.TagBasedTLCOutputTokenScanner;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;

public class TagBasedTLCOutputIncrementalParser {
    private int lastPartitionEnd;
    private final TagBasedTLCAnalyzer analyzer;
    private final CachingTLCOutputSource source;
    private final Document document;

    public TagBasedTLCOutputIncrementalParser(Model model, int prio, boolean isTraceExplorer) {
        this(model, prio, isTraceExplorer, Mode.INCREMENTAL, -1L);
    }

    public TagBasedTLCOutputIncrementalParser(Model model, int prio, boolean isTraceExplorer, Mode mode, long size) {
        this.document = new LargeTextStoreDocument(size);
        this.analyzer = new TagBasedTLCAnalyzer((IDocument)this.document);
        this.source = new CachingTLCOutputSource(model, prio);
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new TagBasedTLCOutputTokenScanner(), TagBasedTLCOutputTokenScanner.CONTENT_TYPES);
        partitioner.connect((IDocument)this.document);
        this.document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        this.document.addDocumentPartitioningListener((IDocumentPartitioningListener)new TLCOutputPartitionChangeListener(mode));
        if (isTraceExplorer) {
            TLCOutputSourceRegistry.getTraceExploreSourceRegistry().addTLCOutputSource(this.source);
        } else {
            if (mode == Mode.BATCH) {
                this.document.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
            }
            TLCOutputSourceRegistry.getModelCheckSourceRegistry().addTLCOutputSource(this.source);
        }
    }

    public void addIncrement(String text) throws BadLocationException {
        if (text == null || text.length() == 0 || text.equals("\n")) {
            return;
        }
        if (text.charAt(text.length() - 1) != '\n') {
            throw new BadLocationException("Input does not end with newline: " + text);
        }
        this.document.replace(this.document.getLength(), 0, text);
    }

    public void addLine(String text) throws BadLocationException {
        if (text == null || text.length() == 0 || text.equals("\n")) {
            return;
        }
        this.document.replace(this.document.getLength(), 0, text);
    }

    IDocument getDocument() {
        return this.document;
    }

    TagBasedTLCAnalyzer getTagAnalyzer() {
        return this.analyzer;
    }

    public void done() {
        if (this.document.getActiveRewriteSession() != null) {
            this.document.stopRewriteSession(this.document.getActiveRewriteSession());
        }
        this.source.onDone();
    }

    public ITLCOutputSource getSource() {
        return this.source;
    }

    public void clear() throws BadLocationException {
        this.document.replace(0, this.document.getLength(), "");
        if (this.document.getActiveRewriteSession() != null) {
            this.document.stopRewriteSession(this.document.getActiveRewriteSession());
        }
    }

    private class LargeTextStoreDocument
    extends Document {
        public static final long SIZE_UNKNOWN = -1L;

        public LargeTextStoreDocument(long size) {
            if (size != -1L) {
                Assert.isLegal((size >= 0L ? 1 : 0) != 0, (String)"Negative file size");
                if (size > Integer.MAX_VALUE) {
                    size = 0x7FFFFFFEL;
                }
                this.setTextStore((ITextStore)new GapTextStore((int)size, (int)size + 1, 0.1f));
            }
        }
    }

    public static enum Mode {
        BATCH,
        INCREMENTAL;

    }

    class TLCOutputPartitionChangeListener
    implements IDocumentPartitioningListener,
    IDocumentPartitioningListenerExtension2 {
        private final Mode mode;

        public TLCOutputPartitionChangeListener(Mode mode) {
            this.mode = mode;
        }

        public void documentPartitioningChanged(IDocument document) {
        }

        public void documentPartitioningChanged(DocumentPartitioningChangedEvent event) {
            IDocument document = event.getDocument();
            try {
                IRegion changedRegion = event.getCoverage();
                IDocumentPartitioner partitioner = document.getDocumentPartitioner();
                ITypedRegion[] regions = partitioner.computePartitioning(TagBasedTLCOutputIncrementalParser.this.lastPartitionEnd, changedRegion.getOffset() + changedRegion.getLength() - TagBasedTLCOutputIncrementalParser.this.lastPartitionEnd);
                TagBasedTLCOutputIncrementalParser.this.analyzer.resetUserPartitions();
                int offsetToRemove = 0;
                int i = 0;
                while (i < regions.length) {
                    if (!"__tlc_output".equals(regions[i].getType())) {
                        int currentPartitionEnd = regions[i].getOffset() + regions[i].getLength();
                        if (currentPartitionEnd > TagBasedTLCOutputIncrementalParser.this.lastPartitionEnd) {
                            TagBasedTLCOutputIncrementalParser.this.lastPartitionEnd = currentPartitionEnd;
                        }
                        if ("__tlc_tag_open".equals(regions[i].getType())) {
                            if (TagBasedTLCOutputIncrementalParser.this.analyzer.hasUserPartitions() && !TagBasedTLCOutputIncrementalParser.this.analyzer.inTag()) {
                                ITypedRegion mergedPartition = TagBasedTLCOutputIncrementalParser.this.analyzer.getUserRegion();
                                TagBasedTLCOutputIncrementalParser.this.source.onOutput(mergedPartition, document.get(mergedPartition.getOffset(), mergedPartition.getLength()));
                            }
                            TagBasedTLCOutputIncrementalParser.this.analyzer.addTagStart(regions[i]);
                        } else if ("__tlc_tag_closed".equals(regions[i].getType())) {
                            TagBasedTLCOutputIncrementalParser.this.analyzer.addTagEnd(regions[i]);
                            if (!TagBasedTLCOutputIncrementalParser.this.analyzer.inTag()) {
                                TLCRegion tag = TagBasedTLCOutputIncrementalParser.this.analyzer.getTaggedRegion();
                                TagBasedTLCOutputIncrementalParser.this.source.onOutput(tag, document.get(tag.getOffset(), tag.getLength()));
                            }
                        } else {
                            Assert.isTrue((regions[i].getLength() == 0 ? 1 : 0) != 0, (String)"Parsing bug");
                        }
                    } else {
                        TagBasedTLCOutputIncrementalParser.this.analyzer.addUserRegion(regions[i]);
                    }
                    ++i;
                }
                if (!TagBasedTLCOutputIncrementalParser.this.analyzer.inTag()) {
                    offsetToRemove = TagBasedTLCOutputIncrementalParser.this.lastPartitionEnd;
                    TagBasedTLCOutputIncrementalParser.this.lastPartitionEnd = 0;
                }
                if (this.mode == Mode.INCREMENTAL && offsetToRemove > 0) {
                    document.replace(0, offsetToRemove, "");
                }
            }
            catch (BadLocationException e) {
                TLCUIActivator.getDefault().logError("Error removing text or retrieving text from the parser's document.This is a bug.", e);
            }
        }
    }
}

