/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.output.data;

import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCFcnElementVariableValue;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCFunctionVariableValue;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCNamedVariableValue;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCRecordVariableValue;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCSequenceVariableValue;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCSetVariableValue;
import org.lamport.tla.toolbox.tool.tlc.output.data.TLCSimpleVariableValue;

public abstract class TLCVariableValue {
    private static final char CBRACKET = ']';
    private static final char OBRACKET = '[';
    private static final char OPAREN = '(';
    private static final char CPAREN = ')';
    private static final char LT = '<';
    private static final char GT = '>';
    private static final char OCBRACE = '{';
    private static final char CCBRACE = '}';
    private static final char QUOTE = '\"';
    private static final char ESC = '\\';
    private static final char COMMA = ',';
    private static final char ATSIGN = '@';
    private static final char COLON = ':';
    private static final char PIPE = '|';
    private static final char MINUS = '-';
    private static final char CR = '\n';
    private static final char SPACE = ' ';
    private static final Pattern ATOMIC_PATERN = Pattern.compile("[-.0-9a-zA-Z_]*");
    protected Object value;
    protected String source = null;
    private short diffState = 0;

    public static TLCVariableValue parseValue(String input) {
        TLCVariableValue result;
        Assert.isNotNull((Object)input, (String)"The value must be not null");
        input.trim();
        try {
            InputPair pair = new InputPair(input, 0);
            result = TLCVariableValue.innerParse(pair);
            if (pair.offset != input.length()) {
                throw new VariableValueParseException();
            }
        }
        catch (VariableValueParseException e) {
            result = new TLCSimpleVariableValue(input);
        }
        return result;
    }

    public static StringBuffer arrayToStringBuffer(Object[] elements, String[] delimeters) {
        StringBuffer buffer;
        Assert.isNotNull((Object)delimeters);
        if (elements.length == 0) {
            buffer = new StringBuffer(3);
            buffer.append(delimeters[0]);
            buffer.append(' ');
        } else {
            buffer = new StringBuffer(elements.length * 3 + 2);
            buffer.append(delimeters[0]);
            int i = 0;
            while (i < elements.length) {
                buffer.append(elements[i].toString());
                if (i != elements.length - 1) {
                    buffer.append(delimeters[1]);
                    buffer.append(' ');
                }
                ++i;
            }
        }
        buffer.append(delimeters[2]);
        return buffer;
    }

    public static StringBuffer arrayToSimpleStringBuffer(Object[] elements, String[] delimeters) {
        Assert.isNotNull((Object)delimeters);
        StringBuffer buffer = null;
        if (elements.length == 0) {
            buffer = new StringBuffer(3);
            buffer.append(delimeters[0]);
            buffer.append(' ');
        } else {
            buffer = new StringBuffer(elements.length * 3 + 2);
            buffer.append(delimeters[0]);
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof TLCVariableValue) {
                    buffer.append(((TLCVariableValue)elements[i]).toSimpleString());
                } else {
                    buffer.append(elements[i].toString());
                }
                if (i != elements.length - 1) {
                    buffer.append(delimeters[1]);
                    buffer.append(' ');
                }
                ++i;
            }
        }
        buffer.append(delimeters[2]);
        return buffer;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    static TLCVariableValue innerParse(InputPair input) throws VariableValueParseException {
        void var1_7;
        Object var1_1 = null;
        int initialOffset = input.offset;
        char ch = TLCVariableValue.getNextChar(input);
        switch (ch) {
            case '<': {
                char nextCh = TLCVariableValue.getNextChar(input);
                if (nextCh != '<') {
                    throw new VariableValueParseException();
                }
                Vector<TLCVariableValue> sequenceValues = new Vector<TLCVariableValue>();
                TLCVariableValue innerValue = TLCVariableValue.innerParse(input);
                if (innerValue != null) {
                    sequenceValues.add(innerValue);
                    nextCh = TLCVariableValue.getNextChar(input);
                    while (true) {
                        if (nextCh != ',') {
                            if (nextCh == '>' && TLCVariableValue.getNextChar(input) == '>') break;
                            throw new VariableValueParseException();
                        }
                        sequenceValues.add(TLCVariableValue.innerParse(input));
                        nextCh = TLCVariableValue.getNextChar(input);
                    }
                }
                TLCSequenceVariableValue tLCSequenceVariableValue = new TLCSequenceVariableValue(sequenceValues);
                break;
            }
            case '>': {
                char nextCh = TLCVariableValue.getNextChar(input);
                if (nextCh != '>') {
                    throw new VariableValueParseException();
                }
                return null;
            }
            case '[': {
                TLCVariableValue innerValue2;
                Vector<TLCVariableValue> recordPairs = new Vector<TLCVariableValue>();
                TLCVariableValue innerValue = TLCVariableValue.innerParse(input);
                if (innerValue != null) {
                    if (!(innerValue instanceof TLCSimpleVariableValue)) {
                        throw new VariableValueParseException();
                    }
                    if (TLCVariableValue.getNextChar(input) == '|' && TLCVariableValue.getNextChar(input) == '-' && TLCVariableValue.getNextChar(input) == '>') {
                        innerValue2 = TLCVariableValue.innerParse(input);
                        if (innerValue2 == null) {
                            throw new VariableValueParseException();
                        }
                        recordPairs.add(new TLCNamedVariableValue((String)innerValue.value, innerValue2));
                    } else {
                        throw new VariableValueParseException();
                    }
                }
                char nextCh = TLCVariableValue.getNextChar(input);
                while (true) {
                    if (nextCh != ',') {
                        if (nextCh == ']') break;
                        throw new VariableValueParseException();
                    }
                    innerValue = TLCVariableValue.innerParse(input);
                    if (innerValue != null) {
                        if (!(innerValue instanceof TLCSimpleVariableValue)) {
                            throw new VariableValueParseException();
                        }
                        if (TLCVariableValue.getNextChar(input) == '|' && TLCVariableValue.getNextChar(input) == '-' && TLCVariableValue.getNextChar(input) == '>') {
                            innerValue2 = TLCVariableValue.innerParse(input);
                            if (innerValue2 == null) {
                                throw new VariableValueParseException();
                            }
                            recordPairs.add(new TLCNamedVariableValue((String)innerValue.value, innerValue2));
                        } else {
                            throw new VariableValueParseException();
                        }
                    }
                    nextCh = TLCVariableValue.getNextChar(input);
                }
                TLCRecordVariableValue tLCRecordVariableValue = new TLCRecordVariableValue(recordPairs);
                break;
            }
            case ']': {
                return null;
            }
            case '(': {
                TLCVariableValue innerValue;
                Vector<TLCFcnElementVariableValue> fcnElements = new Vector<TLCFcnElementVariableValue>();
                TLCVariableValue domElement = TLCVariableValue.innerParse(input);
                if (domElement != null) {
                    if (TLCVariableValue.getNextChar(input) == ':' && TLCVariableValue.getNextChar(input) == '>') {
                        innerValue = TLCVariableValue.innerParse(input);
                        if (innerValue == null) {
                            throw new VariableValueParseException();
                        }
                        fcnElements.add(new TLCFcnElementVariableValue(domElement, innerValue));
                    } else {
                        throw new VariableValueParseException();
                    }
                }
                char nextCh = TLCVariableValue.getNextChar(input);
                while (true) {
                    if (nextCh != '@') {
                        if (nextCh == ')') break;
                        throw new VariableValueParseException();
                    }
                    if (TLCVariableValue.getNextChar(input) != '@') {
                        throw new VariableValueParseException();
                    }
                    domElement = TLCVariableValue.innerParse(input);
                    if (domElement != null) {
                        if (TLCVariableValue.getNextChar(input) == ':' && TLCVariableValue.getNextChar(input) == '>') {
                            innerValue = TLCVariableValue.innerParse(input);
                            if (innerValue == null) {
                                throw new VariableValueParseException();
                            }
                            fcnElements.add(new TLCFcnElementVariableValue(domElement, innerValue));
                        } else {
                            throw new VariableValueParseException();
                        }
                    }
                    nextCh = TLCVariableValue.getNextChar(input);
                }
                TLCFunctionVariableValue tLCFunctionVariableValue = new TLCFunctionVariableValue(fcnElements);
                break;
            }
            case ')': {
                throw new VariableValueParseException();
            }
            case '{': {
                Vector<TLCVariableValue> setValues = new Vector<TLCVariableValue>();
                TLCVariableValue innerValue = TLCVariableValue.innerParse(input);
                if (innerValue != null) {
                    setValues.add(innerValue);
                    char nextCh = TLCVariableValue.getNextChar(input);
                    while (true) {
                        if (nextCh != ',') {
                            if (nextCh == '}') break;
                            throw new VariableValueParseException();
                        }
                        setValues.add(TLCVariableValue.innerParse(input));
                        nextCh = TLCVariableValue.getNextChar(input);
                    }
                }
                TLCSetVariableValue tLCSetVariableValue = new TLCSetVariableValue(setValues);
                break;
            }
            case '}': {
                return null;
            }
            default: {
                if (ch != '\"') {
                    Matcher matcher = ATOMIC_PATERN.matcher(input.input.substring(input.offset - 1));
                    if (matcher.find() && matcher.start() == 0) {
                        TLCSimpleVariableValue tLCSimpleVariableValue = new TLCSimpleVariableValue(input.input.substring(input.offset - 1, input.offset + matcher.end() - 1));
                        input.offset = input.offset + matcher.end() - 1;
                        return tLCSimpleVariableValue;
                    }
                    throw new VariableValueParseException();
                }
                int startOfString = input.offset - 1;
                if (input.offset >= input.input.length()) {
                    throw new VariableValueParseException();
                }
                do {
                    if (input.input.charAt(input.offset) == '\"') {
                        ++input.offset;
                        return new TLCSimpleVariableValue(input.input.substring(startOfString, input.offset));
                    }
                    if (input.input.charAt(input.offset) == '\\') {
                        ++input.offset;
                    }
                    ++input.offset;
                } while (input.offset < input.input.length());
                throw new VariableValueParseException();
            }
        }
        var1_7.source = input.input.substring(initialOffset, input.offset).trim();
        return var1_7;
    }

    static char getNextChar(InputPair input) throws VariableValueParseException {
        char ch;
        if (input.offset < 0 || input.offset >= input.input.length()) {
            throw new VariableValueParseException();
        }
        if ((ch = input.input.charAt(input.offset++)) == ' ' || ch == '\n') {
            return TLCVariableValue.getNextChar(input);
        }
        return ch;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return this.source;
    }

    public String toSimpleString() {
        return this.value.toString();
    }

    public int getChildCount() {
        if (this.value instanceof List) {
            return ((List)this.value).size();
        }
        if (this.value instanceof TLCVariableValue) {
            return ((TLCVariableValue)this.value).getChildCount();
        }
        return 0;
    }

    protected void setDeleted() {
        this.diffState = (short)(this.diffState | 4);
    }

    public boolean isDeleted() {
        return (this.diffState >> 2 & 1) != 0;
    }

    protected void setAdded() {
        this.diffState = (short)(this.diffState | 2);
    }

    public boolean isAdded() {
        return (this.diffState >> 1 & 1) != 0;
    }

    protected void setChanged() {
        this.diffState = (short)(this.diffState | 1);
    }

    public boolean isChanged() {
        return (this.diffState >> 0 & 1) != 0;
    }

    public void diff(TLCVariableValue other) {
        if (!this.toSimpleString().equals(other.toSimpleString())) {
            other.setChanged();
            if (this.getClass().equals(other.getClass())) {
                this.innerDiff(other);
            }
        }
    }

    protected void innerDiff(TLCVariableValue other) {
    }

    protected void setElementArrayDiffInfo(TLCVariableValue[] firstElts, String[] firstLHStrings, TLCVariableValue[] secondElts, String[] secondLHStrings) {
        int j;
        boolean notfound;
        int i = 0;
        while (i < firstElts.length) {
            notfound = true;
            j = 0;
            while (notfound && j < secondElts.length) {
                if (firstLHStrings[i].equals(secondLHStrings[j])) {
                    notfound = false;
                    TLCVariableValue first = (TLCVariableValue)firstElts[i].getValue();
                    TLCVariableValue second = (TLCVariableValue)secondElts[j].getValue();
                    if (!first.toSimpleString().equals(second.toSimpleString())) {
                        secondElts[i].setChanged();
                        second.setChanged();
                        if (first.getClass().equals(second.getClass())) {
                            first.innerDiff(second);
                        }
                    }
                }
                ++j;
            }
            if (notfound) {
                firstElts[i].setDeleted();
            }
            ++i;
        }
        i = 0;
        while (i < secondElts.length) {
            notfound = true;
            j = 0;
            while (notfound && j < firstElts.length) {
                if (firstElts[j].toSimpleString().equals(secondElts[i].toSimpleString())) {
                    notfound = false;
                }
                ++j;
            }
            if (notfound) {
                secondElts[i].setAdded();
                ((TLCVariableValue)secondElts[i].getValue()).setAdded();
            }
            ++i;
        }
    }

    protected void setFcnElementArrayDiffInfo(TLCFcnElementVariableValue[] firstElts, TLCFcnElementVariableValue[] secondElts) {
        String[] firstLHStrings = new String[firstElts.length];
        int i = 0;
        while (i < firstElts.length) {
            firstLHStrings[i] = firstElts[i].getFrom().toSimpleString();
            ++i;
        }
        String[] secondLHStrings = new String[secondElts.length];
        int i2 = 0;
        while (i2 < secondElts.length) {
            secondLHStrings[i2] = secondElts[i2].getFrom().toSimpleString();
            ++i2;
        }
        this.setElementArrayDiffInfo(firstElts, firstLHStrings, secondElts, secondLHStrings);
    }

    static class InputPair {
        String input;
        int offset;

        public InputPair(String input, int offset) {
            this.input = input;
            this.offset = offset;
        }
    }

    static class VariableValueParseException
    extends Throwable {
        VariableValueParseException() {
        }
    }
}

