/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.handlers;

import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.lamport.tla.toolbox.spec.Spec;
import org.lamport.tla.toolbox.tool.tlc.ui.modelexplorer.ModelContentProvider;
import org.lamport.tla.toolbox.util.UIHelper;

public class NewModelHandlerSelectedDelegate
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection != null && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object selected = ((IStructuredSelection)selection).getFirstElement();
            if (selected instanceof ModelContentProvider.Group) {
                selected = ((ModelContentProvider.Group)selected).getSpec();
            }
            if (selected instanceof Spec) {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("toolbox.tool.tlc.commands.model.new.param", ((Spec)selected).getName());
                UIHelper.runCommand((String)"toolbox.tool.tlc.commands.model.new", parameters);
            }
        }
        return null;
    }

    public boolean isEnabled() {
        ISelection selection = NewModelHandlerSelectedDelegate.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection iss = (IStructuredSelection)selection;
            Object selected = iss.getFirstElement();
            if (selected instanceof Spec && ((Spec)selected).isCurrentSpec()) {
                return true;
            }
            if (selected instanceof ModelContentProvider.Group) {
                ModelContentProvider.Group group = (ModelContentProvider.Group)selected;
                return group.getSpec().isCurrentSpec();
            }
        }
        return false;
    }

    private static ISelection getSelection() {
        try {
            ISelectionService service;
            IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (ww != null && (service = ww.getSelectionService()) != null) {
                return service.getSelection();
            }
        }
        catch (IllegalStateException e) {
            return null;
        }
        return null;
    }
}

