/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.tlc.ui.editor.page.results;

import java.util.concurrent.TimeUnit;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.lamport.tla.toolbox.tool.tlc.output.data.StateSpaceInformationItem;
import org.lamport.tla.toolbox.tool.tlc.ui.TLCUIActivator;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.results.ResultPage;
import org.lamport.tla.toolbox.tool.tlc.ui.editor.page.results.StateSpaceLabelProvider;
import org.lamport.tla.toolbox.util.UIHelper;

class DataDisplay
implements Runnable {
    private final int m_columnNumber;
    private final ResultPage m_resultPage;
    private final String m_graphTitle;

    public DataDisplay(int columnNumber, ResultPage resultPage) {
        this.m_columnNumber = columnNumber;
        this.m_resultPage = resultPage;
        StateSpaceLabelProvider sslp = (StateSpaceLabelProvider)resultPage.getStateSpaceTableViewer().getLabelProvider();
        this.m_graphTitle = (columnNumber == 0 ? "Number of Progress Reports" : sslp.getColumnTitle(columnNumber)) + " " + ResultPage.getGraphTitleSuffix(resultPage);
    }

    @Override
    public void run() {
        Shell shell;
        Display display = UIHelper.getCurrentDisplay();
        boolean shellExists = false;
        Shell theShell = null;
        Shell[] shellArray = display.getShells();
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            shell = shellArray[n2];
            if (shell.getText().equals(this.m_graphTitle)) {
                theShell = shell;
                shellExists = true;
                break;
            }
            ++n2;
        }
        if (!shellExists) {
            theShell = new Shell(display, 1264);
        }
        shell = theShell;
        shell.setText(this.m_graphTitle);
        shell.setActive();
        if (shellExists) {
            shell.redraw();
            shell.update();
        } else {
            shell.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent event) {
                    long hours;
                    StateSpaceInformationItem[] ssInfo = DataDisplay.this.m_resultPage.getStateSpaceInformation();
                    if (ssInfo.length < 2) {
                        return;
                    }
                    long[] data = new long[ssInfo.length + 1];
                    long[] times = new long[ssInfo.length + 1];
                    data[0] = 0L;
                    times[0] = 0L;
                    long startTime = DataDisplay.this.m_resultPage.getStartTimestamp();
                    TLCUIActivator.getDefault().logDebug("first reported time - starttime = " + (ssInfo[0].getTime().getTime() - startTime));
                    if (startTime > ssInfo[0].getTime().getTime() - 1000L) {
                        startTime = ssInfo[0].getTime().getTime() - 1000L;
                    }
                    int i = 1;
                    while (i < data.length) {
                        switch (DataDisplay.this.m_columnNumber) {
                            case 0: {
                                data[i] = i - 1;
                                break;
                            }
                            case 1: {
                                data[i] = ssInfo[i - 1].getDiameter();
                                break;
                            }
                            case 2: {
                                data[i] = ssInfo[i - 1].getFoundStates();
                                break;
                            }
                            case 3: {
                                data[i] = ssInfo[i - 1].getDistinctStates();
                                break;
                            }
                            case 4: {
                                data[i] = ssInfo[i - 1].getLeftStates();
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        times[i] = ssInfo[i - 1].getTime().getTime() - startTime;
                        ++i;
                    }
                    Rectangle rect = shell.getClientArea();
                    long maxData = 0L;
                    int i2 = 0;
                    while (i2 < data.length) {
                        if (data[i2] > maxData) {
                            maxData = data[i2];
                        }
                        ++i2;
                    }
                    long maxTime = times[times.length - 1];
                    if (maxTime > 0L) {
                        double maxTimeD = maxTime;
                        double maxDataVal = maxData == 0L ? 1L : maxData;
                        double width = rect.width - 6;
                        double height = rect.height - 6;
                        int[] pointArray = new int[2 * data.length];
                        int i3 = 0;
                        while (i3 < data.length) {
                            double tFraction = (double)times[i3] / maxTimeD;
                            double dFraction = (double)data[i3] / maxDataVal;
                            pointArray[2 * i3] = (int)(tFraction * width) + 2;
                            pointArray[2 * i3 + 1] = rect.height - (int)(dFraction * height) + 2;
                            ++i3;
                        }
                        event.gc.drawPolyline(pointArray);
                    }
                    Object stringTime = "Time: ";
                    long unreportedTime = maxTime;
                    long days = TimeUnit.MILLISECONDS.toDays(maxTime);
                    if (days > 0L) {
                        unreportedTime -= TimeUnit.DAYS.toMillis(days);
                        stringTime = (String)stringTime + days + (days == 1L ? " day " : " days  ");
                    }
                    if ((hours = TimeUnit.MILLISECONDS.toHours(unreportedTime)) > 0L) {
                        unreportedTime -= TimeUnit.HOURS.toMillis(hours);
                        stringTime = (String)stringTime + hours + (hours == 1L ? " hour " : " hours  ");
                    }
                    stringTime = (String)stringTime + unreportedTime + ((unreportedTime = (unreportedTime + 26000L) / 60000L) == 1L ? " minute " : " minutes  ");
                    event.gc.drawString((String)stringTime, 0, 0);
                    event.gc.drawString("Current: " + data[data.length - 1], 0, 15);
                    if (maxData != data[data.length - 1]) {
                        event.gc.drawString("Maximum: " + maxData, 0, 30);
                    }
                }
            });
        }
        if (!shellExists) {
            shell.setBounds(100 + 30 * this.m_columnNumber, 100 + 30 * this.m_columnNumber, 400, 300);
        }
        shell.open();
    }
}

