/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.prover.ui.util;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.tool.prover.ui.ProverUIActivator;

public class TLAPMExecutableLocator {
    private static final IPath DEFAULT_NIX_INSTALL_DIRECTORY = new Path("/usr/local/bin");
    private static final String NIX_EXECUTABLE_NAME = "tlapm";
    private static final String WINDOWS_EXECUTABLE_NAME = "tlapm.exe";
    public static final TLAPMExecutableLocator INSTANCE = new TLAPMExecutableLocator();
    private IPath tlapmPath;
    private final IPath cygwinPath;
    private final IPropertyChangeListener preferenceChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("tlapm_filepath".equals(event.getProperty())) {
                String location = (String)event.getNewValue();
                TLAPMExecutableLocator.this.tlapmPath = new Path(location);
            }
        }
    };

    public static boolean pathForExecutableIsUsable(IPath path) {
        if (path == null) {
            return false;
        }
        File f = path.toFile();
        return f != null && f.exists() && f.canExecute();
    }

    private TLAPMExecutableLocator() {
        Path path;
        IPreferenceStore ips = ProverUIActivator.getDefault().getPreferenceStore();
        String existingTLAPMPath = ips.getString("tlapm_filepath");
        Path tlapm = null;
        if (existingTLAPMPath.length() > 0 && TLAPMExecutableLocator.pathForExecutableIsUsable((IPath)(path = new Path(existingTLAPMPath)))) {
            tlapm = path;
        }
        Path cygwin = null;
        if (Platform.getOS().equals("win32")) {
            Path defaultPath = new Path("C:/cygwin/usr/local/bin/tlapm.exe");
            Path defaultPath64 = new Path("C:/cygwin64/usr/local/bin/tlapm.exe");
            if (defaultPath64.toFile().exists()) {
                if (tlapm == null) {
                    tlapm = defaultPath64;
                }
                cygwin = new Path("C:\\cygwin64\\bin");
            } else if (defaultPath.toFile().exists()) {
                if (tlapm == null) {
                    tlapm = defaultPath;
                }
                cygwin = new Path("C:\\cygwin\\bin");
            } else if (tlapm == null) {
                tlapm = new Path(WINDOWS_EXECUTABLE_NAME);
            }
        } else if (tlapm == null) {
            if (Platform.getOS().equals("macosx") || Platform.getOS().equals("linux")) {
                String fullPath;
                Path executable;
                String[] paths = System.getenv("PATH").split(":");
                boolean defaultDirectoryIncluded = false;
                String[] stringArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    IPath executable2;
                    String path2 = stringArray[n2];
                    Path parent = new Path(path2);
                    if (parent.equals((Object)DEFAULT_NIX_INSTALL_DIRECTORY)) {
                        defaultDirectoryIncluded = true;
                    }
                    if (TLAPMExecutableLocator.pathForExecutableIsUsable(executable2 = parent.append(NIX_EXECUTABLE_NAME))) {
                        tlapm = executable2;
                        break;
                    }
                    ++n2;
                }
                if (!defaultDirectoryIncluded && tlapm == null && TLAPMExecutableLocator.pathForExecutableIsUsable((IPath)(executable = new Path(fullPath = DEFAULT_NIX_INSTALL_DIRECTORY.toFile().getAbsolutePath() + File.separatorChar + NIX_EXECUTABLE_NAME)))) {
                    tlapm = executable;
                }
                if (tlapm == null) {
                    tlapm = new Path(NIX_EXECUTABLE_NAME);
                }
            } else {
                Activator.getDefault().logError("Platform [" + Platform.getOS() + "] is not supported.");
            }
        }
        this.tlapmPath = tlapm;
        this.cygwinPath = cygwin;
        ips.addPropertyChangeListener(this.preferenceChangeListener);
    }

    public boolean tlapmDoesExist() {
        return TLAPMExecutableLocator.pathForExecutableIsUsable(this.tlapmPath);
    }

    public IPath getCygwinPath() {
        return this.cygwinPath;
    }

    public IPath getTLAPMPath() {
        return this.tlapmPath;
    }
}

