/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.prover.ui.output.source;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.lamport.tla.toolbox.tool.prover.ui.output.data.TLAPMMessage;
import org.lamport.tla.toolbox.tool.prover.ui.output.source.ITLAPMOutputSource;
import org.lamport.tla.toolbox.tool.prover.ui.output.source.ITLAPMOutputSourceListener;

public class CachingTLAPMOutputSource
implements ITLAPMOutputSource {
    private List outputData;
    private Vector listeners = new Vector();
    private IPath modulePath;
    private boolean done = false;

    public CachingTLAPMOutputSource(IPath modulePath) {
        this.outputData = new LinkedList();
        this.modulePath = modulePath;
    }

    @Override
    public void newData(TLAPMMessage data) {
        this.outputData.add(data);
        for (ITLAPMOutputSourceListener listener : this.listeners) {
            listener.newData(data);
        }
    }

    @Override
    public void addListener(ITLAPMOutputSourceListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
            Iterator it = this.outputData.iterator();
            while (it.hasNext()) {
                listener.newData((TLAPMMessage)it.next());
            }
        }
    }

    @Override
    public IPath getFullModulePath() {
        return this.modulePath;
    }

    @Override
    public ITLAPMOutputSourceListener[] getListeners() {
        return this.listeners.toArray(new ITLAPMOutputSourceListener[this.listeners.size()]);
    }

    @Override
    public void removeListener(ITLAPMOutputSourceListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void onDone() {
        this.done = true;
    }
}

