/*
 * Decompiled with CFR 0.152.
 */
package org.lamport.tla.toolbox.tool.prover.ui.output.data;

import org.lamport.tla.toolbox.Activator;
import org.lamport.tla.toolbox.tool.prover.ui.ProverUIActivator;
import org.lamport.tla.toolbox.tool.prover.ui.preference.AdditionalPreferencesPage;

public class ColorPredicate {
    public boolean isLeaf;
    public boolean isSome;
    public long set;
    public static final int ISABELLE_NUM = 0;
    public static final int OTHER_BACKEND_NUM = 1;
    public static final int TLAPM_NUM = 2;
    public static final String[] PROVER_NAMES = new String[]{"isabelle", "other_backend", "tlapm"};
    public static final String UNTRIED_STATUS = "untried";
    public static final String PROVING_STATUS = "proving";
    public static final String PROVED_STATUS = "proved";
    public static final String FAILED_STATUS = "failed";
    public static final String STOPPED_STATUS = "stopped";
    public static final String[] ISABELLE_STATUSES = new String[]{"untried", "proving", "proved", "failed", "stopped"};
    public static final String[] OTHER_PROVER_STATUSES = ISABELLE_STATUSES;
    public static final String[] TLAPM_STATUSES = new String[]{"untried", "proved"};
    public static final String[][] PROVER_STATUSES = new String[][]{ISABELLE_STATUSES, OTHER_PROVER_STATUSES, TLAPM_STATUSES};
    public static final int NUMBER_OF_PROVERS = PROVER_NAMES.length;
    public static final int TO_BE_PROVED_STATE = ColorPredicate.numberOfState(new String[]{"untried", "untried", "untried"});
    public static final String PREDICATE_NONE = "some";
    public static final String PREDICATE_ALL = "every missing omitted ( , , )";
    public static final String PREDICATE_PROVED = "every (proved, , ) (,proved,) (,,proved)";
    public static final String PREDICATE_PROVED_OR_OMITTED = "every omitted (proved, , ) (,proved,) (,,proved)";
    public static final String PREDICATE_PROVED_OR_OMITTED_OR_MISSING = "every omitted missing (proved, , ) (,proved,) (,,proved)";
    public static final String PREDICATE_UNPROVED = "some (-proved, -proved, -proved)";
    public static final String PREDICATE_FAILED = "some (failed,-proved,-proved) (-proved,failed,-proved)";
    public static final String PREDICATE_FAILED_OR_STOPPED_UNPROVED = "some (failed stopped,-proved,-proved) (-proved,failed stopped,-proved)";
    public static final String PREDICATE_FAILED_SO_FAR = "some (failed,-failed,)";
    public static final String PREDICATE_FAILED_OR_STOPPED = "some (failed stopped,,) (,failed stopped,)";
    public static final String PREDICATE_BEING_PROVED = "some (proving,,) (,proving,)";
    public static final String PREDICATE_MISSING = "some missing";
    public static final String PREDICATE_OMITTED = "some omitted";
    public static final String PREDICATE_MISSING_OR_OMITTED = "some missing omitted";
    public static final String PREDICATE_STOPPED = "some (stopped,,) (,stopped,) (failed, untried,)";
    public static final String PREDICATE_STOPPED_UNPROVED = "some (stopped,-proved,-proved) (-proved,stopped,-proved)";
    public static final String PREDICATE_UNTRIED = "some (untried, untried, untried)";
    public static final String[] USER_DEFINED = new String[]{"userdefinedA", "userdefinedB", "userdefinedC", "userdefinedD", "userdefinedE", "userdefinedF"};
    public static final String[][] PREDEFINED_MACROS = new String[][]{{"none", "some"}, {"all proved", "every (proved, , ) (,proved,) (,,proved)"}, {"all proved or omitted", "every omitted (proved, , ) (,proved,) (,,proved)"}, {"all proved, omitted, or missing", "every omitted missing (proved, , ) (,proved,) (,,proved)"}, {"some not proved", "some (-proved, -proved, -proved)"}, {"some not tried", "some (untried, untried, untried)"}, {"some stopped", "some (stopped,,) (,stopped,) (failed, untried,)"}, {"some stopped and unproven", "some (stopped,-proved,-proved) (-proved,stopped,-proved)"}, {"some failed", "some (failed,-proved,-proved) (-proved,failed,-proved)"}, {"some failed or stopped", "some (failed stopped,,) (,failed stopped,)"}, {"some failed on non-isabelle prover", "some (failed,-failed,)"}, {"some failed or stopped", "some (failed stopped,-proved,-proved) (-proved,failed stopped,-proved)"}, {"some being proved", "some (proving,,) (,proving,)"}, {"some missing", "some missing"}, {"some omitted", "some omitted"}, {"some missing or omitted", "some missing omitted"}, {"all", "every missing omitted ( , , )"}, {"user-defined A", USER_DEFINED[0]}, {"user-defined B", USER_DEFINED[1]}, {"user-defined C", USER_DEFINED[2]}, {"user-defined D", USER_DEFINED[3]}, {"user-defined E", USER_DEFINED[4]}, {"user-defined F", USER_DEFINED[5]}};
    public static final int NUMBER_OF_MISSING_STATE = 0;
    public static final int NUMBER_OF_OMITTED_STATE = 1;

    public static final String getMacro(String macroName) {
        int i = 0;
        while (i < PREDEFINED_MACROS.length) {
            if (macroName.equalsIgnoreCase(PREDEFINED_MACROS[i][0])) {
                return PREDEFINED_MACROS[i][1];
            }
            ++i;
        }
        i = 0;
        while (i < USER_DEFINED.length) {
            if (macroName.equalsIgnoreCase(USER_DEFINED[i])) {
                return ProverUIActivator.getDefault().getPreferenceStore().getString(AdditionalPreferencesPage.USER_DEFINED_PREDICATE[i]);
            }
            ++i;
        }
        return null;
    }

    public static final int numberOfProverStatus(int proverNumber, String statusName) throws IllegalArgumentException {
        if (proverNumber > NUMBER_OF_PROVERS || proverNumber < 0) {
            throw new IllegalArgumentException("No prover number " + proverNumber);
        }
        int i = 0;
        while (i < PROVER_STATUSES[proverNumber].length) {
            if (statusName.equals(PROVER_STATUSES[proverNumber][i])) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Prover " + PROVER_NAMES[proverNumber] + " has no status " + statusName);
    }

    public static final int numberOfState(int[] statuses) throws IllegalArgumentException {
        if (statuses.length != NUMBER_OF_PROVERS) {
            throw new IllegalArgumentException("Wrong number of provers specified");
        }
        int multiplier = 1;
        int result = 2;
        int i = 0;
        while (i < NUMBER_OF_PROVERS) {
            if (statuses[i] >= PROVER_STATUSES[i].length || statuses[i] < 0) {
                throw new IllegalArgumentException("Prover " + PROVER_NAMES[i] + " does not have status number " + statuses[i]);
            }
            result += multiplier * statuses[i];
            multiplier *= PROVER_STATUSES[i].length;
            ++i;
        }
        return result;
    }

    public static final String[] proverStatuses(int stateNum) {
        if (stateNum == 0 || stateNum == 1) {
            return null;
        }
        int[] array = new int[3];
        if (3 != NUMBER_OF_PROVERS) {
            Activator.getDefault().logDebug("Method ColorPredicate.numberToState must be reimplemented when number of provers changes");
        }
        int i = 0;
        while (i < PROVER_STATUSES[0].length) {
            array[0] = i;
            int j = 0;
            while (j < PROVER_STATUSES[1].length) {
                array[1] = j;
                int k = 0;
                while (k < PROVER_STATUSES[2].length) {
                    array[2] = k++;
                    if (ColorPredicate.numberOfState(array) != stateNum) continue;
                    return new String[]{PROVER_STATUSES[0][i], PROVER_STATUSES[1][j], PROVER_STATUSES[2][k]};
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static final int numberOfState(String[] statuses) throws IllegalArgumentException {
        int[] statusNumbers = new int[statuses.length];
        int i = 0;
        while (i < statuses.length) {
            statusNumbers[i] = ColorPredicate.numberOfProverStatus(i, statuses[i]);
            ++i;
        }
        return ColorPredicate.numberOfState(statusNumbers);
    }

    public static final String numberToState(int stateNumber) {
        if (stateNumber == 0) {
            return "Missing";
        }
        if (stateNumber == 1) {
            return "Omitted";
        }
        int[] array = new int[3];
        if (3 != NUMBER_OF_PROVERS) {
            Activator.getDefault().logDebug("Method ColorPredicate.numberToState must be reimplemented when number of provers changes");
        }
        int i = 0;
        while (i < PROVER_STATUSES[0].length) {
            array[0] = i;
            int j = 0;
            while (j < PROVER_STATUSES[1].length) {
                array[1] = j;
                int k = 0;
                while (k < PROVER_STATUSES[2].length) {
                    array[2] = k++;
                    if (ColorPredicate.numberOfState(array) != stateNumber) continue;
                    return PROVER_NAMES[0] + " : " + PROVER_STATUSES[0][i] + ", " + PROVER_NAMES[1] + " : " + PROVER_STATUSES[1][j] + ", " + PROVER_NAMES[2] + " : " + PROVER_STATUSES[2][k];
                }
                ++j;
            }
            ++i;
        }
        return "No state with number " + stateNumber;
    }

    public static final long bitVectorOfStates(int[][] statuses) throws IllegalArgumentException {
        if (statuses.length != NUMBER_OF_PROVERS) {
            Activator.getDefault().logDebug("Method ColorPredicate.bitVectorOfStates must be reimplemented when number of provers changes");
        }
        long result = 0L;
        int[] array = new int[3];
        int i = 0;
        while (i < statuses[0].length) {
            array[0] = statuses[0][i];
            int j = 0;
            while (j < statuses[1].length) {
                array[1] = statuses[1][j];
                int k = 0;
                while (k < statuses[2].length) {
                    array[2] = statuses[2][k];
                    result |= 1L << ColorPredicate.numberOfState(array);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static final long bitVectorOfStates(String[][] statuses) throws IllegalArgumentException {
        int[][] arg = new int[statuses.length][];
        int i = 0;
        while (i < arg.length) {
            arg[i] = new int[statuses[i].length];
            int j = 0;
            while (j < arg[i].length) {
                arg[i][j] = ColorPredicate.numberOfProverStatus(i, statuses[i][j]);
                ++j;
            }
            ++i;
        }
        return ColorPredicate.bitVectorOfStates(arg);
    }

    private static final void printBitVectorOfStates(long vector) {
        System.out.println(ColorPredicate.bitVectorOfStatesToString(vector));
    }

    public static final String bitVectorOfStatesToString(long vector) {
        long rest = vector;
        Object result = "";
        int i = 0;
        while (i < 60) {
            if ((rest & 1L) == 1L) {
                result = (String)result + ColorPredicate.numberToState(i) + "\n";
            }
            rest >>>= 1;
            ++i;
        }
        return result;
    }

    public static final int newStateNumber(int oldStateNumber, int proverNumber, int proverStatus) {
        if (oldStateNumber == 0 || oldStateNumber == 1) {
            return -1;
        }
        int[] array = new int[3];
        if (3 != NUMBER_OF_PROVERS) {
            Activator.getDefault().logDebug("Method ColorPredicate.newStateNumber must be reimplemented when number of provers changes");
        }
        int i = 0;
        while (i < PROVER_STATUSES[0].length) {
            array[0] = i;
            int j = 0;
            while (j < PROVER_STATUSES[1].length) {
                array[1] = j;
                int k = 0;
                while (k < PROVER_STATUSES[2].length) {
                    array[2] = k++;
                    if (ColorPredicate.numberOfState(array) != oldStateNumber) continue;
                    array[proverNumber] = proverStatus;
                    return ColorPredicate.numberOfState(array);
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    public boolean satisfiedByObligations(int[] obligationStateNumbers) {
        boolean[] childValues = new boolean[obligationStateNumbers.length];
        int i = 0;
        while (i < obligationStateNumbers.length) {
            long bit = 1L << obligationStateNumbers[i];
            childValues[i] = (bit & this.set) != 0L;
            ++i;
        }
        return this.satisfiedBasedOnChildrenValues(childValues);
    }

    public boolean satisfiedBasedOnChildren(boolean[] childValues) {
        if (this.isLeaf) {
            return false;
        }
        return this.satisfiedBasedOnChildrenValues(childValues);
    }

    public boolean satisfiedBasedOnChildrenValues(boolean[] childValues) {
        boolean result;
        boolean bl = result = !this.isSome;
        if (this.isSome) {
            int i = 0;
            while (i < childValues.length) {
                result = result || childValues[i];
                ++i;
            }
        } else {
            int i = 0;
            while (i < childValues.length) {
                result = result && childValues[i];
                ++i;
            }
        }
        return result;
    }

    public ColorPredicate(String input) throws IllegalArgumentException {
        String rest = input.trim().toLowerCase();
        if (rest.startsWith("leaf")) {
            this.isLeaf = true;
            rest = rest.substring(4).trim();
        } else {
            this.isLeaf = false;
        }
        int endOfStartToken = 0;
        while (endOfStartToken < rest.length() && Character.isLetter(rest.charAt(endOfStartToken))) {
            ++endOfStartToken;
        }
        String startToken = rest.substring(0, endOfStartToken);
        String macro = ColorPredicate.getMacro(startToken);
        if (macro != null) {
            rest = macro;
        }
        if (rest.startsWith(PREDICATE_NONE)) {
            this.isSome = true;
            rest = rest.substring(4).trim();
        } else if (rest.startsWith("every")) {
            this.isSome = false;
            rest = rest.substring(5).trim();
        } else {
            throw new IllegalArgumentException(" Color predicate must start with the optional keyword `leaf'\n followed by a legal macro name or `every' or `some'.");
        }
        this.set = 0L;
        while (!rest.equals("")) {
            if (rest.startsWith("omitted")) {
                this.set |= 2L;
                rest = rest.substring(7).trim();
                continue;
            }
            if (rest.startsWith("missing")) {
                this.set |= 1L;
                rest = rest.substring(7).trim();
                continue;
            }
            if (rest.startsWith("(")) {
                rest = rest.substring(1).trim();
                int[][] stateSetSpec = new int[NUMBER_OF_PROVERS][];
                int i = 0;
                while (i < NUMBER_OF_PROVERS) {
                    boolean invert = false;
                    if (rest.startsWith("-")) {
                        invert = true;
                        rest = rest.substring(1).trim();
                    }
                    boolean[] appears = new boolean[PROVER_STATUSES[i].length];
                    int j = 0;
                    while (j < appears.length) {
                        appears[j] = invert;
                        ++j;
                    }
                    String endChar = i == NUMBER_OF_PROVERS - 1 ? ")" : ",";
                    while (rest.length() > 0 && !rest.startsWith(endChar)) {
                        int endOfToken = 0;
                        while (endOfToken < rest.length() && Character.isLetter(rest.charAt(endOfToken))) {
                            ++endOfToken;
                        }
                        String token = rest.substring(0, endOfToken);
                        rest = rest.substring(endOfToken).trim();
                        try {
                            int statusNumber = ColorPredicate.numberOfProverStatus(i, token);
                        }
                        catch (IllegalArgumentException e) {
                            String errorMsg = "Was expecting status of prover " + PROVER_NAMES[i] + " but found `" + token + "' followed by: \n `" + rest + "'";
                            throw new IllegalArgumentException(errorMsg);
                        }
                        boolean bl = appears[statusNumber] = !invert;
                    }
                    if (rest.length() == 0) {
                        throw new IllegalArgumentException("Color predicate specifier ended before `(...)' expression complete");
                    }
                    rest = rest.substring(1).trim();
                    int count = 0;
                    int j2 = 0;
                    while (j2 < appears.length) {
                        if (appears[j2]) {
                            ++count;
                        }
                        ++j2;
                    }
                    if (count == 0) {
                        if (invert) {
                            throw new IllegalArgumentException("A `-' must be followed by one or more statuses");
                        }
                        count = appears.length;
                        j2 = 0;
                        while (j2 < count) {
                            appears[j2] = true;
                            ++j2;
                        }
                    }
                    stateSetSpec[i] = new int[count];
                    int k = 0;
                    int j3 = 0;
                    while (j3 < appears.length) {
                        if (appears[j3]) {
                            stateSetSpec[i][k] = j3;
                            ++k;
                        }
                        ++j3;
                    }
                    ++i;
                }
                this.set |= ColorPredicate.bitVectorOfStates(stateSetSpec);
                continue;
            }
            throw new IllegalArgumentException("Unexpected token at: `" + rest + "'");
        }
    }

    public String toString() {
        String result = "leaf: " + this.isLeaf + "\n";
        result = result + "type: " + (this.isSome ? PREDICATE_NONE : "every") + "\n";
        result = result + "set of states:\n";
        try {
            result = result + ColorPredicate.bitVectorOfStatesToString(this.set);
        }
        catch (IllegalArgumentException e) {
            result = result + "Illegal Bit Vector\n";
        }
        return result;
    }
}

